#ifndef INTERRUPT_H
#define INTERRUPT_H

#define Timer1ms 1
#define Timer10ms 10

// <<< Use Configuration Wizard in Context Menu >>>

// <e> Interrupt 0 : External Interrupt 0 Enable/Disable
	#define 	dIE0 	0
// <o> Set External interrupt 0 type control <0=> Low level <1=> Falling edge
	#define 	dIT0 	0
// </e>

// <e> Interrupt 1 : Timer0 Interrupt Enable/Disable
	#define 	dITR0 	1
// </e>

// <e> Interrupt 2 : External Interrupt 1 Enable/Disable
	#define 	dIE1 	0
// <o> Set External interrupt 1 type control <0=> Low level <1=> Falling edge
	#define 	dIT1 	1
// </e>

// <e> Interrupt 3 : Timer1 Interrupt Enable/Disable
	#define 	dITR1 	0
// </e>

// <e> Interrupt 4 : UART Interrupt Enable/Disable
	#define 	dIUR 	1
// </e>

// <e> Interrupt 5 : Timer2 Interrupt Enable/Disable
	#define 	dITR2 	0
// </e>

// <e> Interrupt 7 : Capture Interrupt Enable/Disable
	#define 	dICAP 	0
// </e>

// <e> Interrupt 8 : OCP Short Interrupt Enable/Disable
// <i> It is recommended to enable
	#define 	dIOCPS 	1
// </e>

// <e> Interrupt 9 : Hall Interrupt Enable/Disable
// <i> It is recommended to enable
	#define 	dIHall 	1
// </e>

// <e> Interrupt 10 : PWM_min Interrupt Enable/Disable
	#define 	dIPWM_min 	0
// </e>

// <e> Interrupt 11 : PWM_MAX Interrupt Enable/Disable
// <i> It is recommended to enable
	#define 	dIPWM_MAX 	0
// </e>

// <e> Interrupt 12 : GPWM_MAX Interrupt Enable/Disable
	#define 	dIGPWM_MAX 	0
// </e>

// <e> Interrupt 14 : WDTIF Interrupt Enable/Disable
	#define 	dIWDF 	0
// </e>

// <e> Interrupt 15 : OCP Limit Interrupt Enable/Disable
	#define 	dIOCPL 	0
// </e>


// <<< end of configuration section >>>
extern idata unsigned char AdcCount;
extern unsigned char Hall_Status_ONE_Old;
extern void Interrupt_Init (void);

#endif
