// CGH0X1A SFR byte definitions
#ifndef CGH0X1A_SFR_H
#define CGH0X1A_SFR_H
#define SFR(name, addr) sfr name = addr

SFR(P0          , 0x80); 
SFR(SP          , 0x81); 
SFR(DP0L        , 0x82); 
SFR(DP0H        , 0x83); 
SFR(DP1L        , 0x84); 
SFR(DP1H        , 0x85); 
SFR(RCON        , 0x86); 
SFR(PCON        , 0x87); 

SFR(TCON        , 0x88);
SFR(TMOD        , 0x89);
SFR(TL0         , 0x8A);
SFR(TL1         , 0x8B);
SFR(TH0         , 0x8C);
SFR(TH1         , 0x8D);
SFR(AUX         , 0x8E);
SFR(AS          , 0x8F);
           
SFR(P1          , 0x90);
SFR(HALLSET1    , 0x91);
SFR(HALLSET2    , 0x92);
SFR(HALLSET3    , 0x93);
SFR(HALLST      , 0x94);
SFR(ONE_HALLSET , 0x95);
SFR(ROTORSPEEDL , 0x96);
SFR(ROTORSPEEDH , 0x97);

SFR(SCON        , 0x98);
SFR(SBUF        , 0x99);
SFR(SRELL       , 0x9A);
SFR(SRELH       , 0x9B);
SFR(HALLDBT     , 0x9C);
SFR(MCONT1      , 0x9D);
SFR(AOCPCONT    , 0x9E);
SFR(IMPMISC_KEY , 0x9F);

SFR(P2          , 0xA0);  
SFR(OCPCONT     , 0xA1); 
SFR(MCONT2      , 0xA2); 
SFR(MPWM_CYC_L  , 0xA3); 
SFR(MPWM_CYC_H  , 0xA4); 
SFR(MPWMDYUL    , 0xA5); 
SFR(MPWMDYUH    , 0xA6); 
SFR(MPWMDT      , 0xA7);          

SFR(IEN0        , 0xA8);
SFR(IP0         , 0xA9);
SFR(MPWMDYVL    , 0xAA);
SFR(MPWMDYVH    , 0xAB);
SFR(MCONT3      , 0xAC);   //NEW SFR
SFR(MPWMDYWL    , 0xAD);
SFR(MPWMDYWH    , 0xAE);
SFR(IMPMISC_FUN , 0xAF); 

SFR(P3          , 0xB0);  
SFR(MPWMCONT1   , 0xB1); 
SFR(MPWMCONT2   , 0xB2); 
SFR(MPWMINV     , 0xB3); 
SFR(TL2         , 0xB4); 
SFR(TH2         , 0xB5); 
SFR(WDTC        , 0xB6); 
SFR(WDTK        , 0xB7);            

SFR(IEN1        , 0xB8);
SFR(IP1         , 0xB9);
SFR(GPWMCONT    , 0xBA);
SFR(GPWMMAXL    , 0xBB);
SFR(GPWMMAXH    , 0xBC);
SFR(GPWMDYL     , 0xBD);
SFR(GPWMDYH     , 0xBE);
SFR(MIN_DUTY    , 0xBF);

SFR(IRCON1      , 0xC0);  
SFR(SVPWMANGL   , 0xC1); 
SFR(SVPWMANGH   , 0xC2);
SFR(SVPWMAMPL   , 0xC3); 
SFR(SVPWMAMPH   , 0xC4); 
SFR(FG_CTRL     , 0xC5); 

SFR(T2CON       , 0xC8);
SFR(CAPT_H      , 0xC9);
SFR(CAPT_L      , 0xCA);
SFR(CAPH_H      , 0xCB);
SFR(CAPH_L      , 0xCC);
         
SFR(PSW         , 0xD0);  
SFR(PFCON       , 0xD1); 
SFR(ADCCONT     , 0xD2); 
SFR(ADCSTR      , 0xD3); 
SFR(ADCD1       , 0xD5); 
SFR(ADCD2       , 0xD6); 
SFR(SYNC        , 0xD7);            

SFR(CAPCONT     , 0xD8);
SFR(VRHALL      , 0xD9);
SFR(SVPWMAMPFT  , 0xDA);
SFR(MD_CONT     , 0xDB);
SFR(ASUR1       , 0xDC);
SFR(ASUR2       , 0xDD);
SFR(ASUR3       , 0xDE);
SFR(ASUR4       , 0xDF);

SFR(ACC         , 0xE0);  
SFR(AS_MD_CONT  , 0xE1); 
SFR(MD0         , 0xE2); 
SFR(MD1         , 0xE3); 
SFR(MD2         , 0xE4); 
SFR(MD3         , 0xE5); 
SFR(MD4         , 0xE6); 
SFR(MD5         , 0xE7);            

SFR(ASUD1_1     , 0xE8);
SFR(ASUD1_2     , 0xE9);
SFR(ASUD1_3     , 0xEA);
SFR(ASUD1_4     , 0xEB);
SFR(ASUD2_1     , 0xEC);
SFR(ASUD2_2     , 0xED);
SFR(ASUD2_3     , 0xEE);
SFR(ASUD2_4     , 0xEF);

SFR(B           , 0xF0);  
SFR(PINSET1     , 0xF1); 
SFR(PINSET2     , 0xF2); 
SFR(PINSET3     , 0xF3); 
SFR(PINSET4     , 0xF4); 
SFR(PINSET5     , 0xF5); 
SFR(PINSET6     , 0xF6); 
SFR(PINSET7     , 0xF7); 

SFR(PINCONG1    , 0xF8);
SFR(PINCONG2    , 0xF9);
SFR(PINCONG3    , 0xFA);
SFR(PINCONG4    , 0xFB);
SFR(PINCONG5    , 0xFC);
SFR(PINCONG6    , 0xFD);
SFR(RSTS        , 0xFE);
SFR(TAKEY       , 0xFF);

//MCONT1
// #define MOTOSTOP 		0x80
#define HALLALS			0x08
#define	DMS				0x04
#define	MPWMA			0x02
#define AMDS			0x01

//MCONT2
#define VRHS 			0x04
#define AOCPS 			0x02

//IMPMISC_FUN
#define	UNIPOLAR		0x08
///===========sfr16==============//

sfr16 MPWM_CYC = 0xA3;

//////////////PSW
sbit CY                 = PSW ^ 7;
sbit AC                 = PSW ^ 6;
sbit F0                 = PSW ^ 5;
sbit RS1                = PSW ^ 4;
sbit RS0                = PSW ^ 3;
sbit OV                 = PSW ^ 2;
sbit F1                 = PSW ^ 1;
sbit P                  = PSW ^ 0;

//////////////TCON
sbit TF1                = TCON ^ 7;
sbit TR1                = TCON ^ 6;
sbit TF0                = TCON ^ 5;
sbit TR0                = TCON ^ 4;
sbit IE1           	    = TCON ^ 3;
sbit IT1                = TCON ^ 2;
sbit IE0                = TCON ^ 1;
sbit IT0                = TCON ^ 0;

//////////////IEN0
sbit EA                 = IEN0 ^ 7;
sbit ET2                = IEN0 ^ 5;
sbit ESP                = IEN0 ^ 4;
sbit ET1           	    = IEN0 ^ 3;
sbit EX1                = IEN0 ^ 2;
sbit ET0                = IEN0 ^ 1;
sbit EX0                = IEN0 ^ 0;

//////////////IEN1
sbit OCPLIE             = IEN1 ^ 7;
sbit WDTIE              = IEN1 ^ 6;
sbit GPWMIE             = IEN1 ^ 4;
sbit MPWMMAXIE     	    = IEN1 ^ 3;
sbit MPWMMINIE          = IEN1 ^ 2;
sbit HALLIE             = IEN1 ^ 1;
sbit OCPSIE             = IEN1 ^ 0;

//////////////CAPCONT
sbit CAPIE              = CAPCONT ^ 6;


//////////////IRCON1
sbit OCPLIF             = IRCON1 ^ 7;
sbit WDTIF              = IRCON1 ^ 6;
sbit GPWMIF             = IRCON1 ^ 4;
sbit MPWMMAXIF     	    = IRCON1 ^ 3;
sbit MPWMMINIF          = IRCON1 ^ 2;
sbit HALLIF             = IRCON1 ^ 1;
sbit OCPSIF             = IRCON1 ^ 0;

//////////////SCON
sbit TI                 = SCON ^ 1;
sbit RI                 = SCON ^ 0;

//////////////T2CON
sbit TF2                = T2CON ^ 5;
sbit TR2                = T2CON ^ 4;

//////////////P0
sbit P0_0               = P0 ^ 0;
sbit P0_1               = P0 ^ 1;
sbit P0_2               = P0 ^ 2;
sbit P0_3               = P0 ^ 3;

//////////////P1
sbit P1_0               = P1 ^ 0;
sbit P1_1               = P1 ^ 1;
sbit P1_2               = P1 ^ 2;
sbit P1_3               = P1 ^ 3;
sbit P1_4               = P1 ^ 4;
sbit P1_5               = P1 ^ 5;
sbit P1_6               = P1 ^ 6;

//////////////P2
sbit P2_3               = P2 ^ 3;
sbit P2_4               = P2 ^ 4;
sbit P2_5               = P2 ^ 5;
sbit P2_6               = P2 ^ 6;
sbit P2_7               = P2 ^ 7;

//////////////P3
sbit P3_0               = P3 ^ 0;
sbit P3_1               = P3 ^ 1;
sbit P3_2               = P3 ^ 2;
sbit P3_3               = P3 ^ 3;
sbit P3_4               = P3 ^ 4;
sbit P3_5               = P3 ^ 5;

#endif