/******************************* Initial Condition*****************************

 Crystal input should be force at 12Mhz

*******************************************************************************/
#define    XTAL_12Mhz

#define    SET         1
#define    CLR         0

#define    BIT         bit
#define    BYTE        unsigned char
#define    WORD        unsigned int
#define    DWORD       unsigned long

#define    XBYTE       BYTE volatile xdata


#define    HIBYTE( V1 )     ((BYTE)((V1) >> 8))
#define    LOBYTE( V1 )     ((BYTE)((V1) & 0xFF))

/*********************************** ID ***************************************
 
 USB_VID  -> This VID is registered under Megawin Technology Co., Ltd. at USB-IF.
             Any third party needs the written approval from Megawin in order to
             use this VID.
 
*******************************************************************************/
#define    USB_VID          0xE6A
#define    USB_PID          0x316
#define    USB_DID          0x108


#define    MF_STRING                             // Supported Manufacture String
#define    PD_STRING                             // Supported Product String
//#define    SN_STRING                             // Supported SerialNumber String


typedef struct
   { BYTE Suspend : 1;
     BYTE Reset : 1;
     BYTE WakeUp : 1;
     BYTE EmuOK : 1;
     BYTE Res4 : 1;
     BYTE Res5 : 1;
     BYTE Res6 : 1;
     BYTE Res7 : 1;
   } USBEVENT;


#define    UART_RX_CARRIER          0x01
#define    UART_TX_CARRIER          0x02
#define    UART_BREAK               0x04
#define    UART_RING_SIGNAL         0x08
#define    UART_FRAM_ERROR          0x10
#define    UART_PARITY_ERROR        0x20
#define    UART_OVER_RUN            0x40


union WTYPE
  { BYTE B[2];
    WORD W;
  };
  
union DWTYPE
  { BYTE B[4];
    WORD W[2];
    DWORD DW;
  };


typedef struct
   { BYTE Flag;                                  // Set by Host setting occur
     union DWTYPE BaudRate;
     BYTE StopBit;
     BYTE ParityChk;
     BYTE DataBit;
   } LINECODING;                                 // 


typedef struct
   { BYTE Flag;                                  // Set by Host setting occur
     BYTE State;                                 // D0 for DTR , D1 for RTS
   } LINESTATE;


typedef struct
   { BYTE Flag;                                  // Set by Host setting occur
     union WTYPE Time;                           // 0xFFFF for break forver , 0x0000 for release
   } SENDBREAK;


typedef struct
   { LINECODING LC;
     LINESTATE LS;
     SENDBREAK SB;
     BYTE State;
   } COM;                                        // 