// EasyPOD_IOControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "EasyPOD_IOControl.h"
#include "EasyPOD_IOControlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "EasyPODDLL.h"

#define INPUT_MODE      1
#define OUTPUT_MODE     0
#define TIMER_GET_PIN   1
#define TIMER_RETRY     2
#define TIMER_NULL      0
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

MW_EasyPOD m_EasyPOD;
UCHAR ucBuffer[5];
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEasyPOD_IOControlDlg dialog

CEasyPOD_IOControlDlg::CEasyPOD_IOControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEasyPOD_IOControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEasyPOD_IOControlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CEasyPOD_IOControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEasyPOD_IOControlDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEasyPOD_IOControlDlg, CDialog)
	//{{AFX_MSG_MAP(CEasyPOD_IOControlDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_btnExit, OnbtnExit)
	ON_BN_CLICKED(IDC_radPort0, OnradPort0)
	ON_BN_CLICKED(IDC_radPort1, OnradPort1)
	ON_BN_CLICKED(IDC_radPort2, OnradPort2)
	ON_BN_CLICKED(IDC_radPort3, OnradPort3)
	ON_BN_CLICKED(IDC_radPort4, OnradPort4)
	ON_BN_CLICKED(IDC_radOutput, OnradOutput)
	ON_BN_CLICKED(IDC_radInput, OnradInput)
	ON_BN_CLICKED(IDC_btnPx0, OnbtnPx0)
	ON_BN_CLICKED(IDC_btnPx1, OnbtnPx1)
	ON_BN_CLICKED(IDC_btnPx2, OnbtnPx2)
	ON_BN_CLICKED(IDC_btnPx3, OnbtnPx3)
	ON_BN_CLICKED(IDC_btnPx4, OnbtnPx4)
	ON_BN_CLICKED(IDC_btnPx5, OnbtnPx5)
	ON_BN_CLICKED(IDC_btnPx6, OnbtnPx6)
	ON_BN_CLICKED(IDC_btnPx7, OnbtnPx7)
	ON_WM_DRAWITEM()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEasyPOD_IOControlDlg message handlers

BOOL CEasyPOD_IOControlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_EasyPOD.VID = 0x0E6A;
    m_EasyPOD.PID = 0x0317;
	m_blnError = FALSE;
	DWORD dwResult = ConnectPOD(&m_EasyPOD,1);
	if (dwResult == ERROR_SUCCESS)
	{ 	
		m_EasyPOD.ReadTimeOut = 80;
        m_EasyPOD.WriteTimeOut = 80;
	    ((CButton*)GetDlgItem(IDC_radPort0))->SetCheck(1);
		m_intPortNum = 0;
  	    ((CButton*)GetDlgItem(IDC_radInput))->SetCheck(1);
	    ((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P0.0  P0.1  P0.2  P0.3");
	    ((CEdit*)GetDlgItem(IDC_staLabel2))->SetWindowText("P0.4  P0.5  P0.6  P0.7");
	    ((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(TRUE);
        g_blnIOMode = INPUT_MODE;		
		m_uintTimer = SetTimer(TIMER_GET_PIN, 25, 0);		
	}
	else
	{
		ShowErrorMessage(dwResult);
    }

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEasyPOD_IOControlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEasyPOD_IOControlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEasyPOD_IOControlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEasyPOD_IOControlDlg::OnbtnExit() 
{
	// TODO: Add your control notification handler code here
    OnOK();	
}

void CEasyPOD_IOControlDlg::OnradPort0() 
{
	// TODO: Add your control notification handler code here
	m_intPortNum = 0;
	((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P0.0  P0.1  P0.2  P0.3");
	((CEdit*)GetDlgItem(IDC_staLabel2))->SetWindowText("P0.4  P0.5  P0.6  P0.7");
	((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx4))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx5))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx6))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx7))->ShowWindow(TRUE);
	DWORD dwResult;
    dwResult = GetPortSetting();
	if (dwResult == ERROR_SUCCESS)
	{
        ShowPortSetting(ucBuffer);
	}
	else
        ShowErrorMessage(dwResult);
}

void CEasyPOD_IOControlDlg::OnradPort1() 
{
	// TODO: Add your control notification handler code here
	m_intPortNum = 1;
	((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P1.0  P1.1  P1.2  P1.3");
	((CEdit*)GetDlgItem(IDC_staLabel2))->SetWindowText("P1.4  P1.5  P1.6  P1.7");	
    ((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx4))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx5))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx6))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx7))->ShowWindow(TRUE);
	DWORD dwResult;
    dwResult = GetPortSetting();
	if (dwResult == ERROR_SUCCESS)
	{
        ShowPortSetting(ucBuffer);
	}
	else
        ShowErrorMessage(dwResult);
}

void CEasyPOD_IOControlDlg::OnradPort2() 
{
	// TODO: Add your control notification handler code here
	m_intPortNum = 2;
	((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P2.0  P2.1  P2.2  P2.3");	
	((CEdit*)GetDlgItem(IDC_staLabel2))->SetWindowText("P2.4  P2.5  P2.6  P2.7");	
    ((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx4))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx5))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx6))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx7))->ShowWindow(TRUE);
	DWORD dwResult;
    dwResult = GetPortSetting();
	if (dwResult == ERROR_SUCCESS)
	{
        ShowPortSetting(ucBuffer);
	}
	else
        ShowErrorMessage(dwResult);
}

void CEasyPOD_IOControlDlg::OnradPort3() 
{
	// TODO: Add your control notification handler code here
	m_intPortNum = 3;
	((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P3.0  P3.1  P3.2  P3.3");
	((CEdit*)GetDlgItem(IDC_staLabel2))->SetWindowText("P3.4  P3.5  P3.6  P3.7");	
	((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx4))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx5))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx6))->ShowWindow(TRUE);
	((CButton*)GetDlgItem(IDC_btnPx7))->ShowWindow(TRUE);
	DWORD dwResult;
    dwResult = GetPortSetting();
	if (dwResult == ERROR_SUCCESS)
	{
        ShowPortSetting(ucBuffer);
	}
	else
        ShowErrorMessage(dwResult);

}

void CEasyPOD_IOControlDlg::OnradPort4() 
{
	// TODO: Add your control notification handler code here
	m_intPortNum = 4;
	((CEdit*)GetDlgItem(IDC_staLabel1))->SetWindowText("P4.0  P4.1  P4.2  P4.3");
	((CEdit*)GetDlgItem(IDC_staLabel2))->ShowWindow(FALSE);
	((CButton*)GetDlgItem(IDC_btnPx4))->ShowWindow(FALSE);
	((CButton*)GetDlgItem(IDC_btnPx5))->ShowWindow(FALSE);
	((CButton*)GetDlgItem(IDC_btnPx6))->ShowWindow(FALSE);
	((CButton*)GetDlgItem(IDC_btnPx7))->ShowWindow(FALSE);
	DWORD dwResult;
    dwResult = GetPortSetting();
	if (dwResult == ERROR_SUCCESS)
	{
        ShowPortSetting(ucBuffer);
	}
	else
        ShowErrorMessage(dwResult);
	
}

void CEasyPOD_IOControlDlg::OnradOutput() 
{
	// TODO: Add your control notification handler code here
	g_blnIOMode = OUTPUT_MODE;
	if (m_uintTimer != 0)
	{
		KillTimer(m_uintTimer);
		m_uintTimer = 0;
	}
}

void CEasyPOD_IOControlDlg::OnradInput() 
{
	// TODO: Add your control notification handler code here
	g_blnIOMode = INPUT_MODE;
	if (m_uintTimer == 0)
	{
        m_uintTimer = SetTimer(TIMER_GET_PIN, 3, 0);
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx0() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 1) == 1)
			{
				bytNewValue = bytValue & 0xFE;
				((CButton*)GetDlgItem(IDC_btnPx0))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x01;
				((CButton*)GetDlgItem(IDC_btnPx0))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx1() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 2) == 2)
			{
				bytNewValue = bytValue & 0xFD;
				((CButton*)GetDlgItem(IDC_btnPx1))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x02;
				((CButton*)GetDlgItem(IDC_btnPx1))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx2() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 4) == 4)
			{
				bytNewValue = bytValue & 0xFB;
				((CButton*)GetDlgItem(IDC_btnPx2))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x04;
				((CButton*)GetDlgItem(IDC_btnPx2))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx3() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 8) == 8)
			{
				bytNewValue = bytValue & 0xF7;
				((CButton*)GetDlgItem(IDC_btnPx3))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x08;
				((CButton*)GetDlgItem(IDC_btnPx3))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx4() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 0x10) == 0x10)
			{
				bytNewValue = bytValue & 0xEF;
				((CButton*)GetDlgItem(IDC_btnPx4))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x10;
				((CButton*)GetDlgItem(IDC_btnPx4))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx5() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 0x20) == 0x20)
			{
				bytNewValue = bytValue & 0xDF;
				((CButton*)GetDlgItem(IDC_btnPx5))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x20;
				((CButton*)GetDlgItem(IDC_btnPx5))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx6() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 0x40) == 0x40)
			{
				bytNewValue = bytValue & 0xBF;
				((CButton*)GetDlgItem(IDC_btnPx6))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x40;
				((CButton*)GetDlgItem(IDC_btnPx6))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnbtnPx7() 
{
	// TODO: Add your control notification handler code here
    BYTE bytValue;
    BYTE bytNewValue;
	DWORD dwResult;
	if (g_blnIOMode == OUTPUT_MODE)
	{        
		dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
			bytValue = ucBuffer[m_intPortNum];
			if ((bytValue & 0x80) == 0x80)
			{
				bytNewValue = bytValue & 0x7F;
				((CButton*)GetDlgItem(IDC_btnPx7))->SetWindowText("L");
			}
			else
			{
				bytNewValue = bytValue | 0x80;
				((CButton*)GetDlgItem(IDC_btnPx7))->SetWindowText("H");
			}
			SetPortSetting(bytNewValue);
        }                
	}
}

void CEasyPOD_IOControlDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	static int i,j;
	
	
	if((nIDCtl >=IDC_btnPx0) && (nIDCtl <= IDC_btnPx7))
	{     

		TCHAR buffer[1];
		ZeroMemory(buffer,1 );
		::GetWindowText(lpDrawItemStruct->hwndItem,buffer,MAX_PATH);

		CDC dc;
		dc.Attach(lpDrawItemStruct ->hDC);
		RECT rect;          
		rect= lpDrawItemStruct ->rcItem;		
	
	
		dc.Draw3dRect(&rect,RGB(255,0,0),RGB(0,0,0));
		
		if (buffer[0] == 'L')			
            dc.FillSolidRect(&rect,RGB(255,0,0));			
		else
            dc.FillSolidRect(&rect,RGB(0,255,0));		
		
		UINT state=lpDrawItemStruct->itemState;
 
		if((state & ODS_SELECTED))
		{
			dc.DrawEdge(&rect,EDGE_SUNKEN,BF_RECT);
		}
		else
		{						
			dc.DrawEdge(&rect,EDGE_RAISED,BF_RECT);
		}     
        			
		if (buffer[0] == 'L')
            dc.SetBkColor(RGB(255,0,0));			
		else		
            dc.SetBkColor(RGB(0,255,0)); 	
		
		dc.SetTextColor(RGB(0,0,0));				
		dc.DrawText(buffer,&rect,DT_CENTER|DT_VCENTER|DT_SINGLELINE);					
		dc.Detach();

		return;	

	}			
	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
	
}

void CEasyPOD_IOControlDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	DWORD dwResult;
    if (nIDEvent == TIMER_GET_PIN)
    {
	    dwResult = GetPortSetting();
	    if (dwResult == ERROR_SUCCESS)
	        ShowPortSetting(ucBuffer);		
	    else
		{
			KillTimer(m_uintTimer);
		    ShowErrorMessage(dwResult);
			m_uintRetryTimer = SetTimer(TIMER_RETRY, 1000, 0);
		    m_blnError = TRUE;
		}
	}	
    if (nIDEvent == TIMER_RETRY)
	{
		if (m_blnDone == TRUE)
		{
			DWORD dwResult = ConnectPOD(&m_EasyPOD,1);
			if (dwResult == ERROR_SUCCESS)
			{   
				KillTimer(m_uintRetryTimer);
				m_uintTimer = SetTimer(TIMER_GET_PIN, 1000, 0);
				m_blnError = FALSE;
			}
		}
	}
	CDialog::OnTimer(nIDEvent);
}

void CEasyPOD_IOControlDlg::ShowErrorMessage(DWORD dwResult)
{
	LPVOID lpMsgBuf;	
	CString m_strTitle;
	m_blnDone = FALSE;
	m_strTitle = "MCU SetPin and GetPin Demo Application";
    if (dwResult & 0xE0000000)
    {
		switch (dwResult)
		{
		case INSUFFICIENT_MOMORY_AVAILABLE:
			 MessageBox("INSUFFICIENT_MOMORY_AVAILABLE",m_strTitle,MB_OK);
			 break;
		case HIDD_GETATTRIBUTES_FAIL:
			 MessageBox("HIDD_GETATTRIBUTES_FAIL",m_strTitle,MB_OK);
			 break;
		case CANNOT_FINDE_THE_DEVICE_SPECIFIED:
			 MessageBox("CANNOT_FINDE_THE_DEVICE_SPECIFIED",m_strTitle,MB_OK);
			 break;
		case SEND_DEVICE_CHECKCODE_FAIL:
			 MessageBox("SEND_DEVICE_CHECKCODE_FAIL",m_strTitle,MB_OK);
			 break;
		case GET_DEVICE_CHECKCODE_FAIL:
			 MessageBox("GET_DEVICE_CHECKCODE_FAIL",m_strTitle,MB_OK);
			 break;
		case CHECK_DEVICE_CHECKCODE_FAIL:
			 MessageBox("CHECK_DEVICE_CHECKCODE_FAIL",m_strTitle,MB_OK);
			 break;
		case CALL_WRITE_DATA_TIMEOUT:
			 MessageBox("CALL_WRITE_DATA_TIMEOUT",m_strTitle,MB_OK);
			 break;
		case CALL_READ_DATA_TIMEOUT:
			 MessageBox("CALL_READ_DATA_TIMEOUT",m_strTitle,MB_OK);
			 break;
		case ALLOCATE_DEVICE_QUEUE_FAIL:
			 MessageBox("ALLOCATE_DEVICE_QUEUE_FAIL",m_strTitle,MB_OK);
			 break;
		case GET_INPUT_REPORT_SIZE_FAIL:
			 MessageBox("GET_INPUT_REPORT_SIZE_FAIL",m_strTitle,MB_OK);
			 break;
		case DELETE_INPUT_QUEUE_FAIL:
			 MessageBox("DELETE_INPUT_QUEUE_FAIL",m_strTitle,MB_OK);
			 break;
		}
    }
    else
    {
		FormatMessage( 
						FORMAT_MESSAGE_ALLOCATE_BUFFER | 
						FORMAT_MESSAGE_FROM_SYSTEM | 
						FORMAT_MESSAGE_IGNORE_INSERTS,
						NULL,
						dwResult,
						MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
						(LPTSTR) &lpMsgBuf,
						0,
						NULL 
						);

		MessageBox( (LPCTSTR)lpMsgBuf, m_strTitle, MB_OK | MB_ICONWARNING);
		LocalFree( lpMsgBuf );
    }
	m_blnDone = TRUE;
}

DWORD CEasyPOD_IOControlDlg::ShowPortSetting(BYTE * pBuffer)
{
	int i;
	BYTE bytValue;     
	bytValue = *(pBuffer + m_intPortNum);
	for(i=0;i<8;i++)
	{
	   if (bytValue & ( 1 << i))
		   ((CButton*)GetDlgItem(IDC_btnPx0 + i))->SetWindowText("H");
	   else
		   ((CButton*)GetDlgItem(IDC_btnPx0 + i))->SetWindowText("L");
	}

    return ERROR_SUCCESS;
}

DWORD CEasyPOD_IOControlDlg::GetPortSetting()
{
	DWORD dwByteRead;
	DWORD dwResult = 0;
	memset(ucBuffer,0,5);
	ClearPODBuffer(&m_EasyPOD);
    dwResult = ReadData(&m_EasyPOD, ucBuffer, 5, &dwByteRead);
	return dwResult ;
}

DWORD CEasyPOD_IOControlDlg::SetPortSetting(BYTE bytValue)
{
    DWORD dwResult;
	DWORD dwByteWritten;
	BYTE bytBuffer[2];
	bytBuffer[0] = m_intPortNum;
    bytBuffer[1] = bytValue;
	dwResult = WriteData(&m_EasyPOD, bytBuffer, 2, &dwByteWritten);
	if (dwResult == ERROR_SUCCESS)  
	{
        dwResult = GetPortSetting();
		if (dwResult == ERROR_SUCCESS)
		{
            ShowPortSetting(ucBuffer);
		}
		else
            ShowErrorMessage(dwResult);
	}
	else
	{
	    ShowErrorMessage(dwResult);
	}
	return dwResult;
}
