#include "REG_MG84FG516.H"
#include "Define.H"
#include "Extern.H"
#include "TWSI.H"


extern BYTE OutLen;
extern XBYTE OutBuffer[TWSI_MAX];

extern TWSI Twsi;


void INT_TWSI(void) interrupt 14 using 2
  { switch( SISTA )
      { case 0x08: Twsi.RetryCnt = 0;
      	case 0x10: Twsi.Stage = TWSI_START;      // Repeat Start
                   SICON &= ~STA;
                   SIDAT = Twsi.Dev;             // Assign " SLAVE " address
                   SICON &= ~SI;
                   break;
      	case 0x18:                               // SLA+W has been transmited ( ACK received )
      	case 0x28: if ( Twsi.InIndex != InLen )  // DATA has been transmited ( ACK received )
      	             { SIDAT = InBuffer[Twsi.InIndex];
      	               Twsi.InIndex++;
      	               SICON &= ~SI;
      	             }
      	           else
      	             { SICON |= STO;             // Generate a STOP
      	               SICON &= ~SI;
      	               while( SICON & STO );     // Wait STOP complete
      	               Twsi.Stage = TWSI_STOP;
      	             }
      	           break;
      	case 0x20:                               // SLA+W has been transmited ( Device NO ACK )
      	case 0x30: if ( Twsi.RetryCnt >= RETRY_MAX )
      	             { SICON |= STO;             // DATA has been transmited ( Device NO ACK )
      	               SICON &= ~SI;
      	               while( SICON & STO );     // Wait STOP complete
      	               Twsi.Stage = TWSI_ERROR;
      	             }
      	           else
      	             { SICON |= STA;             // Retry
      	               SICON &= ~SI;
      	               Twsi.RetryCnt++;
      	             }
      	           break;
      	case 0x38: SICON |= STA;                 // Arbitration Error , Generate a START
      	           SICON &= ~SI;
      	           break;
      	case 0x40: if ( Twsi.InIndex == ( InLen - 1 ))
      	             SICON &= ~AA;               // Last DATA ,Will return NO ACK to Device
      	           SICON &= ~SI;                 // SLA+R has been transmited ( ACK received )
      	           break;
      	case 0x50: InBuffer[Twsi.InIndex] = SIDAT;// DATA has been Received ( Return ACK )
      	           Twsi.InIndex++;
      	           if ( Twsi.InIndex == ( InLen - 1 ))
      	             SICON &= ~AA;               // Last DATA ,Will return NO ACK to Device
      	           SICON &= ~SI;
      	           break;
      	case 0x48: if ( Twsi.RetryCnt >= RETRY_MAX )
      	             { SICON |= STO;             // SLA+R has been transmited ( Device NO ACK )
      	               SICON &= ~SI;
      	               while( SICON & STO );
      	               Twsi.Stage = TWSI_ERROR;
      	             }
      	           else
      	             { SICON |= STA;             // Retry
      	               SICON &= ~SI;
      	               Twsi.RetryCnt++;
      	             }
      	           break;
      	case 0x58: InBuffer[Twsi.InIndex] = SIDAT;// DATA has been Received ( Return ACK )
      	           Twsi.InIndex++;
      	           SICON |= AA;                  // DATA has been Received ( Return NO ACK )
      	           SICON |= STO;
      	           SICON &= ~SI;
      	           while( SICON & STO );         // Wait STOP complete
      	           Twsi.Stage = TWSI_STOP;
      	           break;
      	                                         // Slaver Transmitter
      	case 0xB0: SICON |= STA;                 // Arbitation lost " Reset STA "
      	case 0xA8: Twsi.OutIndex = 0;            // Own SLA+R has been Received ( Return ACK )
      	case 0xB8: SIDAT = OutBuffer[Twsi.OutIndex];// DATA has been transmited ( ACK received )
      	           Twsi.OutIndex++;
      	           if ( Twsi.OutIndex == TWSI_MAX )
      	             Twsi.OutIndex = 0;
      	           SICON &= ~SI;
      	           break;
      	case 0xC0: SICON &= ~SI;                 // Enter NAslave
      	           break;
      	                                         // Slaver Receiver
      	case 0x68: SICON |= STA;                 // Arbitation lost " Reset STA "
      	case 0x60: Twsi.OutIndex = 0;            // Own SLA+W has been Received ( Return ACK )
      	           SICON &= ~SI;
      	           break;
      	case 0x80: OutBuffer[Twsi.OutIndex] = SIDAT;// DATA has been Received ( Return ACK )
      	           Twsi.OutIndex++;
      	           if ( Twsi.OutIndex == TWSI_MAX )
      	             Twsi.OutIndex = 0;
      	           SICON &= ~SI;
      	           break;
      	case 0xA0: OutLen = Twsi.OutIndex;
      	           if ( OutLen == 0 )
      	             OutLen = TWSI_MAX;
      	           AUXIE &= ~ETWSI;              // Disable TWSI int for " TWSI_Send_Data_To_PC "
      	           SICON &= ~SI;                 // Enter NAslave
      	           break;
      	
      	default:   SICON |= STO;                 // Bus Error
      	           SICON &= ~SI;
      	           while( SICON & STO );         // Wait STOP complete
      	           Twsi.Stage = TWSI_ERROR;
      	           break;
      }
  }