#ifndef __REG_MG82F6D32_INC
#define __REG_MG82F6D32_INC

GF_7              EQU      080h
GF_6              EQU      040h
GF_5              EQU      020h
GF_4              EQU      010h
GF_3              EQU      008h
GF_2              EQU      004h
GF_1              EQU      002h
GF_0              EQU      001h

P0                DATA     080H     //Port 0
P0_Page           EQU      000h
// (bits in P0)
P07               BIT      P0.7
P06               BIT      P0.6
P05               BIT      P0.5
P04               BIT      P0.4
P03               BIT      P0.3
P02               BIT      P0.2
P01               BIT      P0.1
P00               BIT      P0.0

SP                DATA     081H     //Stack Pointer
SP_Page           EQU      000h

DPL               DATA     082H     //Data Pointer Low
DPL_Page          EQU      000h

DPH               DATA     083H     //Data Pointer High
DPH_Page          EQU      000h

SPSTAT            DATA     084H     //SPI Status Register
SPSTAT_Page       EQU      000h
// (bits in SPSTAT)
SPIF              EQU      080h
WCOL              EQU      040h
THRF              EQU      020h
SPIBSY            EQU      010h
MODF              EQU      008h
QPIEN             EQU      002h
SPR2_QDOE         EQU      001h

SPCON             DATA     085H     //SPI Control Register
SPCON_Page        EQU      000h
// (bits in SPCON)
SSIG              EQU      080h
SPEN              EQU      040h
DORD              EQU      020h
MSTR              EQU      010h
CPOL              EQU      008h
CPHA              EQU      004h
SPR1              EQU      002h
SPR0              EQU      001h

SPDAT             DATA     086H     //SPI Data Register
SPDAT_Page        EQU      000h

PCON0             DATA     087H     //Power Control 0
PCON0_Page        EQU      000h
// (bits in PCON0)
SMOD1             EQU      080h
SMOD0             EQU      040h
POF0              EQU      010h
PD                EQU      002h
IDL               EQU      001h

TCON              DATA     088H     //Timer Control
TCON_Page         EQU      000h
// (bits in TCON)
TF1               BIT      TCON.7
TR1               BIT      TCON.6
TF0               BIT      TCON.5
TR0               BIT      TCON.4
IE1               BIT      TCON.3
IT1               BIT      TCON.2
IE0               BIT      TCON.1
IT0               BIT      TCON.0

TMOD              DATA     089H     //Timer Mode
TMOD_Page         EQU      000h
// (bits in TMOD)
T1GATE            EQU      080h
T1C_T             EQU      040h
T1M1              EQU      020h
T1M0              EQU      010h
T0GATE            EQU      008h
T0C_T             EQU      004h
T0M1              EQU      002h
T0M0              EQU      001h

TL0               DATA     08AH     //Timer Low 0
TL0_Page          EQU      000h

TL1               DATA     08BH     //Timer Low 1
TL1_Page          EQU      000h

TH0               DATA     08CH     //Timer High 0
TH0_Page          EQU      000h

TH1               DATA     08DH     //Timer High 1
TH1_Page          EQU      000h

SFIE              DATA     08EH     //System Flag INT En.
SFIE_Page         EQU      000h
// (bits in SFIE)
SIDFIE            EQU      080h
MCDRE             EQU      040h
MCDFIE            EQU      020h
RTCFIE            EQU      010h
SPWIE             EQU      008h
BOF1IE            EQU      004h
BOF0IE            EQU      002h
WDTFIE            EQU      001h

XRPS              DATA     08FH     //XRAM Page Select
XRPS_Page         EQU      000h

P1                DATA     090H     //Port 1
P1_Page           EQU      000h
// (bits in P1)
P17               BIT      P1.7
P16               BIT      P1.6
P15               BIT      P1.5
P14               BIT      P1.4
P13               BIT      P1.3
P12               BIT      P1.2
P11               BIT      P1.1
P10               BIT      P1.0

P1M0              DATA     091H     //P1 Mode Register 0
P1M0_Page         EQU      000h
// (bits in P1M0)
P1M07             EQU      080h
P1M06             EQU      040h
P1M05             EQU      020h
P1M04             EQU      010h
P1M03             EQU      008h
P1M02             EQU      004h
P1M01             EQU      002h
P1M00             EQU      001h

P1M1              DATA     092H     //P1 Mode Register 1
P1M1_Page         EQU      000h
// (bits in P1M1)
P1M17             EQU      080h
P1M16             EQU      040h
P1M15             EQU      020h
P1M14             EQU      010h
P1M13             EQU      008h
P1M12             EQU      004h
P1M11             EQU      002h
P1M10             EQU      001h

P2M1              DATA     092H     //P2 Mode Register 1
P2M1_Page         EQU      001h
// (bits in P2M1)
P2M17             EQU      080h
P2M16             EQU      040h
P2M15             EQU      020h
P2M14             EQU      010h
P2M13             EQU      008h
P2M12             EQU      004h
P2M11             EQU      002h
P2M10             EQU      001h

P4M1              DATA     092H     //P4 Mode Register 1
P4M1_Page         EQU      002h
// (bits in P4M1)
P4M17             EQU      080h
P4M16             EQU      040h
P4M15             EQU      020h
P4M14             EQU      010h
P4M13             EQU      008h
P4M12             EQU      004h
P4M11             EQU      002h
P4M10             EQU      001h

P6M1              DATA     092H     //P6 Mode Register 1
P6M1_Page         EQU      003h
// (bits in P6M1)
P6M17             EQU      080h
P6M16             EQU      040h
P6M15             EQU      020h
P6M14             EQU      010h
P6M13             EQU      008h
P6M12             EQU      004h
P6M11             EQU      002h
P6M10             EQU      001h

P0M1              DATA     092H     //P0 Mode Register 1
P0M1_Page         EQU      004h
// (bits in P0M1)
P0M17             EQU      080h
P0M16             EQU      040h
P0M15             EQU      020h
P0M14             EQU      010h
P0M13             EQU      008h
P0M12             EQU      004h
P0M11             EQU      002h
P0M10             EQU      001h

P5M1              DATA     092H     //P5 Mode Register 1
P5M1_Page         EQU      005h
// (bits in P5M1)
P5M17             EQU      080h
P5M16             EQU      040h
P5M15             EQU      020h
P5M14             EQU      010h
P5M13             EQU      008h
P5M12             EQU      004h
P5M11             EQU      002h
P5M10             EQU      001h

P7M1              DATA     092H     //P7 Mode Register 1
P7M1_Page         EQU      006h
// (bits in P7M1)
P7M13             EQU      008h
P7M12             EQU      004h
P7M11             EQU      002h
P7M10             EQU      001h

P3FDC             DATA     092H     //P3 Fast Drv. Ctrl.
P3FDC_Page        EQU      007h
// (bits in P3FDC)
P3FDC7            EQU      080h
P3FDC6            EQU      040h
P3FDC5            EQU      020h
P3FDC4            EQU      010h
P3FDC3            EQU      008h
P3FDC2            EQU      004h
P3FDC1            EQU      002h
P3FDC0            EQU      001h

P1FDC             DATA     092H     //P1 Fast Drv. Ctrl.
P1FDC_Page        EQU      008h
// (bits in P1FDC)
P1FDC7            EQU      080h
P1FDC6            EQU      040h
P1FDC5            EQU      020h
P1FDC4            EQU      010h
P1FDC3            EQU      008h
P1FDC2            EQU      004h
P1FDC1            EQU      002h
P1FDC0            EQU      001h

P2FDC             DATA     092H     //P2 Fast Drv. Ctrl.
P2FDC_Page        EQU      009h
// (bits in P2FDC)
P2FDC7            EQU      080h
P2FDC6            EQU      040h
P2FDC5            EQU      020h
P2FDC4            EQU      010h
P2FDC3            EQU      008h
P2FDC2            EQU      004h
P2FDC1            EQU      002h
P2FDC0            EQU      001h

P4FDC             DATA     092H     //P4 Fast Drv. Ctrl.
P4FDC_Page        EQU      00Ah
// (bits in P4FDC)
P4FDC6            EQU      040h
P4FDC5            EQU      020h
P4FDC4            EQU      010h
P4FDC3            EQU      008h
P4FDC2            EQU      004h
P4FDC1            EQU      002h
P4FDC0            EQU      001h

P0FDC             DATA     092H     //P0 Fast Drv. Ctrl.
P0FDC_Page        EQU      00Bh
// (bits in P0FDC)
P0FDC7            EQU      080h
P0FDC6            EQU      040h
P0FDC5            EQU      020h
P0FDC4            EQU      010h
P0FDC3            EQU      008h
P0FDC2            EQU      004h
P0FDC1            EQU      002h
P0FDC0            EQU      001h

P6FDC             DATA     092H     //P6 Fast Drv. Ctrl.
P6FDC_Page        EQU      00Ch
// (bits in P6FDC)
P6FDC7            EQU      080h
P6FDC6            EQU      040h
P6FDC5            EQU      020h
P6FDC4            EQU      010h
P6FDC3            EQU      008h
P6FDC2            EQU      004h

P5FDC             DATA     092H     //P5 Fast Drv. Ctrl.
P5FDC_Page        EQU      00Dh
// (bits in P5FDC)
P5FDC7            EQU      080h
P5FDC6            EQU      040h
P5FDC5            EQU      020h
P5FDC4            EQU      010h
P5FDC3            EQU      008h
P5FDC2            EQU      004h
P5FDC1            EQU      002h
P5FDC0            EQU      001h

P7FDC             DATA     092H     //P7 Fast Drv. Ctrl.
P7FDC_Page        EQU      00Eh
// (bits in P7FDC)
P7FDC3            EQU      008h
P7FDC2            EQU      004h
P7FDC1            EQU      002h
P7FDC0            EQU      001h

P0M0              DATA     093H     //P0 Mode Register 0
P0M0_Page         EQU      000h
// (bits in P0M0)
P0M07             EQU      080h
P0M06             EQU      040h
P0M05             EQU      020h
P0M04             EQU      010h
P0M03             EQU      008h
P0M02             EQU      004h
P0M01             EQU      002h
P0M00             EQU      001h

T2MOD1            DATA     093H     //Timer2 mode 1 Reg.
T2MOD1_Page       EQU      001h
// (bits in T2MOD1)
TL2CS             EQU      080h
TF2IG             EQU      040h
TL2IS             EQU      020h
T2CKS             EQU      010h
T2MS1             EQU      008h
CP2S2             EQU      004h
CP2S1             EQU      002h
CP2S0             EQU      001h

T3MOD1            DATA     093H     //Timer3 mode 1 Reg.
T3MOD1_Page       EQU      002h
// (bits in T3MOD1)
TL3CS             EQU      080h
TF3IG             EQU      040h
TL3IS             EQU      020h
T3CKS             EQU      010h
T3MS1             EQU      008h
CP3S2             EQU      004h
CP3S1             EQU      002h
CP3S0             EQU      001h

T4MOD1            DATA     093H     //Timer4 mode 1 Reg.
T4MOD1_Page       EQU      003h
// (bits in T4MOD1)
TL4CS             EQU      080h
TF4IG             EQU      040h
TL4IS             EQU      020h
T4CKS             EQU      010h
T4MS1             EQU      008h
CP4S2             EQU      004h
CP4S1             EQU      002h
CP4S0             EQU      001h

DMACR0            DATA     094H     //DMA Control Reg. 0
DMACR0_Page       EQU      000h
// (bits in DMACR0)
DMAE0             EQU      008h
DMAS0             EQU      004h
DIE0              EQU      002h
DCF0              EQU      001h

DMACG0            DATA     094H     //DMA Configured Reg. 0
DMACG0_Page       EQU      008h
// (bits in DMACG0)
PDMAH             EQU      080h
PDMAL             EQU      040h
CRCW0             EQU      020h
EXTS10            EQU      008h
EXTS00            EQU      004h
LOOP0             EQU      001h

DMADS0            DATA     094H     //DMA Data path Selection 0
DMADS0_Page       EQU      009h
// (bits in DMADS0)
DSS30             EQU      080h
DSS20             EQU      040h
DSS10             EQU      020h
DSS00             EQU      010h
DDS30             EQU      008h
DDS20             EQU      004h
DDS10             EQU      002h
DDS00             EQU      001h

P2M0              DATA     095H     //P2 Mode Register 0
P2M0_Page         EQU      000h
// (bits in P2M0)
P2M07             EQU      080h
P2M06             EQU      040h
P2M05             EQU      020h
P2M04             EQU      010h
P2M03             EQU      008h
P2M02             EQU      004h
P2M01             EQU      002h
P2M00             EQU      001h

TREN0             DATA     095H     //Timer Run Enable Register 0
TREN0_Page        EQU      001h
// (bits in TREN0)
TR4LE             EQU      080h
TR3LE             EQU      040h
TR2LE             EQU      020h
TR4E              EQU      010h
TR3E              EQU      008h
TR2E              EQU      004h
TR1E              EQU      002h
TR0E              EQU      001h

TRLC0             DATA     095H     //Timer Reload Control Register 0
TRLC0_Page        EQU      002h
// (bits in TRLC0)
TL4RLC            EQU      080h
TL3RLC            EQU      040h
TL2RLC            EQU      020h
T4RLC             EQU      010h
T3RLC             EQU      008h
T2RLC             EQU      004h
T1RLC             EQU      002h
T0RLC             EQU      001h

TSPC0             DATA     095H     //Timer Stop Control Register 0
TSPC0_Page        EQU      003h
// (bits in TSPC0)
TL4SC             EQU      080h
TL3SC             EQU      040h
TL2SC             EQU      020h
T4SC              EQU      010h
T3SC              EQU      008h
T2SC              EQU      004h
T1SC              EQU      002h
T0SC              EQU      001h

BOREV             DATA     096H     //Bit Order Reversed
BOREV_Page        EQU      000h

PCON1             DATA     097H     //Power Control 1
PCON1_Page        EQU      000h
// (bits in PCON1)
SWRF              EQU      080h
EXRF              EQU      040h
MCDF              EQU      020h
RTCF              EQU      010h
SPWF              EQU      008h
BOF1              EQU      004h
BOF0              EQU      002h
WDTF              EQU      001h

S0CON             DATA     098H     //Serial 0 Control
S0CON_Page        EQU      000h
// (bits in S0CON)
SM00_FE           BIT      S0CON.7
SM10              BIT      S0CON.6
SM20              BIT      S0CON.5
REN0              BIT      S0CON.4
TB80              BIT      S0CON.3
RB80              BIT      S0CON.2
TI0               BIT      S0CON.1
RI0               BIT      S0CON.0

S1CON             DATA     098H     //Serial 1 Control
S1CON_Page        EQU      001h
// (bits in S1CON)
SM01              BIT      S1CON.7
SM11              BIT      S1CON.6
SM21              BIT      S1CON.5
REN1              BIT      S1CON.4
TB81              BIT      S1CON.3
RB81              BIT      S1CON.2
TI1               BIT      S1CON.1
RI1               BIT      S1CON.0

S2CON             DATA     098H     //Serial 2 Control
S2CON_Page        EQU      003h
// (bits in S2CON)
SM02              BIT      S2CON.7
SM12              BIT      S2CON.6
SM22              BIT      S2CON.5
REN2              BIT      S2CON.4
TB82              BIT      S2CON.3
RB82              BIT      S2CON.2
TI2               BIT      S2CON.1
RI2               BIT      S2CON.0

S3CON             DATA     098H     //Serial 3 Control
S3CON_Page        EQU      004h
// (bits in S3CON)
SM03              BIT      S3CON.7
SM13              BIT      S3CON.6
SM23              BIT      S3CON.5
REN3              BIT      S3CON.4
TB83              BIT      S3CON.3
RB83              BIT      S3CON.2
TI3               BIT      S3CON.1
RI3               BIT      S3CON.0

S0BUF             DATA     099H     //Serial 0 Buffer
S0BUF_Page        EQU      000h

S1BUF             DATA     099H     //Serial 1 Buffer
S1BUF_Page        EQU      001h

S2BUF             DATA     099H     //Serial 2 Buffer
S2BUF_Page        EQU      003h

S3BUF             DATA     099H     //Serial 3 Buffer
S3BUF_Page        EQU      004h

S0BRT             DATA     09AH     //S0 Baud-Rate Timer
S0BRT_Page        EQU      000h

S1BRT             DATA     09AH     //S1 Baud-Rate Timer
S1BRT_Page        EQU      001h

S2BRT             DATA     09AH     //S2 Baud-Rate Timer
S2BRT_Page        EQU      003h

S3BRT             DATA     09AH     //S3 Baud-Rate Timer
S3BRT_Page        EQU      004h

S0BRC             DATA     09BH     //S0 Baud-Rate Counter
S0BRC_Page        EQU      000h

S1BRC             DATA     09BH     //S1 Baud-Rate Counter
S1BRC_Page        EQU      001h

S2BRC             DATA     09BH     //S2 Baud-Rate Counter
S2BRC_Page        EQU      003h

S3BRC             DATA     09BH     //S3 Baud-Rate Counter
S3BRC_Page        EQU      004h

S0CFG             DATA     09CH     //S0 Configuration
S0CFG_Page        EQU      000h
// (bits in S0CFG)
URTS              EQU      080h
SMOD2             EQU      040h
URM0X3            EQU      020h
SM30              EQU      010h
S0DOR             EQU      008h
BTI               EQU      004h
UTIE              EQU      002h
SMOD3             EQU      001h

S1CFG             DATA     09CH     //S1 Configuration
S1CFG_Page        EQU      001h
// (bits in S1CFG)
SM31              EQU      080h
S1M0X3            EQU      040h
S1DOR             EQU      020h
S1TR              EQU      010h
S1MOD1            EQU      008h
S1TX12            EQU      004h
S1CKOE            EQU      002h
S1TME             EQU      001h

S2CFG             DATA     09CH     //S2 Configuration
S2CFG_Page        EQU      003h
// (bits in S2CFG)
SM32              EQU      080h
S2M0X3            EQU      040h
S2DOR             EQU      020h
S2TR              EQU      010h
S2MOD1            EQU      008h
S2TX12            EQU      004h
S2CKOE            EQU      002h
S2TME             EQU      001h

S3CFG             DATA     09CH     //S3 Configuration
S3CFG_Page        EQU      004h
// (bits in S3CFG)
SM33              EQU      080h
S3M0X3            EQU      040h
S3DOR             EQU      020h
S3TR              EQU      010h
S3MOD1            EQU      008h
S3TX12            EQU      004h
S3CKOE            EQU      002h
S3TME             EQU      001h

S0CFG1            DATA     09DH     //S0 Configuration 1
S0CFG1_Page       EQU      000h
// (bits in S0CFG1)
SBF0              EQU      080h
TXER0             EQU      040h
S0SB16            EQU      020h
ATBR0             EQU      010h
TXRX0             EQU      008h
SYNC0             EQU      004h

LINCFG            DATA     09DH     //LIN Configuration
LINCFG_Page       EQU      000h

AC0CON            DATA     09EH     //AC0 Control Reg.
AC0CON_Page       EQU      000h
// (bits in AC0CON)
AC0LP             EQU      080h
AC0PDX            EQU      040h
AC0OUT            EQU      020h
AC0F              EQU      010h
AC0EN             EQU      008h
AC0INV            EQU      004h
AC0M1             EQU      002h
AC0M0             EQU      001h

AC1CON            DATA     09EH     //AC1 Control Reg.
AC1CON_Page       EQU      001h
// (bits in AC1CON)
AC1LP             EQU      080h
AC1PDX            EQU      040h
AC1OUT            EQU      020h
AC1F              EQU      010h
AC1EN             EQU      008h
AC1INV            EQU      004h
AC1M1             EQU      002h
AC1M0             EQU      001h

AC2CON            DATA     09EH     //AC2 Control Reg.
AC2CON_Page       EQU      002h
// (bits in AC2CON)
AC2LP             EQU      080h
AC2PDX            EQU      040h
AC2OUT            EQU      020h
AC2F              EQU      010h
AC2EN             EQU      008h
AC2INV            EQU      004h
AC2M1             EQU      002h
AC2M0             EQU      001h

AC0MOD            DATA     09FH     //AC0 Mode Reg.
AC0MOD_Page       EQU      000h
// (bits in AC0MOD)
NVRS3             EQU      080h
NVRS2             EQU      040h
NVRS1             EQU      020h
NVRS0             EQU      010h
NVRL              EQU      008h
AC0FLT            EQU      004h
AC0PIS1           EQU      002h
AC0PIS0           EQU      001h

AC1MOD            DATA     09FH     //AC1 Mode Reg.
AC1MOD_Page       EQU      001h
// (bits in AC1MOD)
AC1NIS            EQU      010h
NVRL1             EQU      008h
AC1FLT            EQU      004h

AC2MOD            DATA     09FH     //AC2 Mode Reg.
AC2MOD_Page       EQU      002h
// (bits in AC2MOD)
AC2NIS            EQU      010h
NVRL2             EQU      008h
AC2FLT            EQU      004h

P2                DATA     0A0H     //Port 2
P2_Page           EQU      000h
// (bits in P2)
P27               BIT      P2.7
P26               BIT      P2.6
P25               BIT      P2.5
P24               BIT      P2.4
P23               BIT      P2.3
P22               BIT      P2.2
P21               BIT      P2.1
P20               BIT      P2.0

AUXR0             DATA     0A1H     //Auxiliary Register 0
AUXR0_Page        EQU      000h
// (bits in AUXR0)
P60OC1            EQU      080h
P60OC0            EQU      040h
P60FD             EQU      020h
PBKF              EQU      010h
BM1F              EQU      008h
BM0F              EQU      004h
INT1H             EQU      002h
INT0H             EQU      001h

AUXR1             DATA     0A2H     //Auxiliary Register 1
AUXR1_Page        EQU      000h
// (bits in AUXR1)
CRCDS1            EQU      020h
CRCDS0            EQU      010h
DPS               EQU      001h

AUXR2             DATA     0A3H     //Auxiliary Register 2
AUXR2_Page        EQU      000h
// (bits in AUXR2)
STAF              EQU      080h
STOF              EQU      040h
T1X12             EQU      008h
T0X12             EQU      004h
T1CKOE            EQU      002h
T0CKOE            EQU      001h

AUXR3             DATA     0A4H     //Auxiliary Register 3
AUXR3_Page        EQU      000h
// (bits in AUXR3)
T0PS1             EQU      080h
T0PS0             EQU      040h
BPOC1             EQU      020h
BPOC0             EQU      010h
S0PS0             EQU      008h
TWIPS1            EQU      004h
TWIPS0            EQU      002h
T0XL              EQU      001h

AUXR4             DATA     0A4H     //Auxiliary Register 4
AUXR4_Page        EQU      001h
// (bits in AUXR4)
T2PS1             EQU      080h
T2PS0             EQU      040h
T1PS1             EQU      020h
T1PS0             EQU      010h
AC1OE             EQU      008h
AC1FLT1           EQU      004h
AC0OE             EQU      002h
AC0FLT1           EQU      001h

AUXR5             DATA     0A4H     //Auxiliary Register 5
AUXR5_Page        EQU      002h
// (bits in AUXR5)
C0IC4S0           EQU      080h
C0IC2S0           EQU      040h
C0PPS1            EQU      020h
C0PPS0            EQU      010h
C0PS1             EQU      008h
C0PS0             EQU      004h
ECIPS0            EQU      002h
C0COPS            EQU      001h

AUXR6             DATA     0A4H     //Auxiliary Register 6
AUXR6_Page        EQU      003h
// (bits in AUXR6)
KBIHPS1           EQU      080h
KBIHPS0           EQU      040h
KBILPS1           EQU      020h
KBILPS0           EQU      010h
T3FCS             EQU      008h
T2FCS             EQU      004h
SnMIPS            EQU      002h
S0COPS            EQU      001h

AUXR7             DATA     0A4H     //Auxiliary Register 7
AUXR7_Page        EQU      004h
// (bits in AUXR7)
POE5              EQU      080h
POE4              EQU      040h
C0CKOE            EQU      020h
SPI0M0            EQU      010h
BM1OE1            EQU      008h
BM1OE0            EQU      004h
BM0OE1            EQU      002h
BM0OE0            EQU      001h

AUXR8             DATA     0A4H     //Auxiliary Register 8
AUXR8_Page        EQU      005h
// (bits in AUXR8)
POE7              EQU      080h
POE6              EQU      040h
C0PPS2            EQU      020h
S1COPS            EQU      004h
T3PS1             EQU      002h
T3PS0             EQU      001h

AUXR9             DATA     0A4H     //Auxiliary Register 9
AUXR9_Page        EQU      006h
// (bits in AUXR9)
SIDPS1            EQU      080h
SIDPS0            EQU      040h
T1G1              EQU      020h
T0G1              EQU      010h
C0FDC1            EQU      008h
C0FDC0            EQU      004h
S1PS1             EQU      002h
S1PS0             EQU      001h

AUXR10            DATA     0A4H     //Aux. Register 10
AUXR10_Page       EQU      007h
// (bits in AUXR10)
AC1HC0            EQU      080h
AC0HC0            EQU      040h
SPIPS1            EQU      020h
SPIPS0            EQU      010h
S0PS1             EQU      008h
SPFACE            EQU      004h
TWICF             EQU      002h
PAA               EQU      001h

AUXR11            DATA     0A4H     //Aux. Register 11
AUXR11_Page       EQU      008h
// (bits in AUXR11)
I2C1CF            EQU      080h
PAA1              EQU      040h
I2C1PS1           EQU      020h
I2C1PS0           EQU      010h
POEM0             EQU      004h
C0M0              EQU      002h
C0OFS             EQU      001h

AUXR12            DATA     0A4H     //Aux. Register 12
AUXR12_Page       EQU      009h
// (bits in AUXR12)
T0COBE            EQU      020h
T0COAE            EQU      010h

AUXR13            DATA     0A4H     //Aux. Register 13
AUXR13_Page       EQU      00Ah
// (bits in AUXR13)
S3PS0             EQU      040h
S2PS0             EQU      010h
T4FCS             EQU      004h
T4PS1             EQU      002h
T4PS0             EQU      001h

AUXR14            DATA     0A4H     //Aux. Register 14
AUXR14_Page       EQU      00Bh
// (bits in AUXR14)
ADLPS1            EQU      080h
ADLPS0            EQU      040h
RWPS0             EQU      008h
AC2HC0            EQU      004h
AC2OE             EQU      002h
AC2FLT1           EQU      001h

EIE2              DATA     0A5H     //Extended INT Enable 2
EIE2_Page         EQU      000h
// (bits in EIE2)
EAC2              EQU      080h
ETWI1             EQU      040h
ES3               EQU      010h
ET4               EQU      008h
ES2               EQU      004h
EAC1              EQU      002h
ET3               EQU      001h

EIP2L             DATA     0A6H     //Ext. INT Priority 2 Low
EIP2L_Page        EQU      000h
// (bits in EIP2L)
PAC2L             EQU      080h
PTWI1L            EQU      040h
PS3L              EQU      010h
PT4L              EQU      008h
PS2L              EQU      004h
PAC1L             EQU      002h
PT3L              EQU      001h

EIP2H             DATA     0A7H     //Ext. INT Priority 2 High
EIP2H_Page        EQU      000h
// (bits in EIP2H)
PAC2H             EQU      080h
PTWI1H            EQU      040h
PS3H              EQU      010h
PT4H              EQU      008h
PS2H              EQU      004h
PAC1H             EQU      002h
PT3H              EQU      001h

IE                DATA     0A8H     //Interrupt Enable
IE_Page           EQU      000h
// (bits in IE)
EA                BIT      IE.7
EDMA              BIT      IE.6
ET2               BIT      IE.5
ES0               BIT      IE.4
ET1               BIT      IE.3
EX1               BIT      IE.2
ET0               BIT      IE.1
EX0               BIT      IE.0

SADDR             DATA     0A9H     //Slave Address
SADDR_Page        EQU      000h

SFRPI             DATA     0ACH     //SFR Page Index
SFRPI_Page        EQU      000h
// (bits in SFRPI)
IDX3              EQU      008h
IDX2              EQU      004h
IDX1              EQU      002h
IDX0              EQU      001h

EIE1              DATA     0ADH     //Extended INT Enable 1
EIE1_Page         EQU      000h
// (bits in EIE1)
EAC0              EQU      080h
ETWI0             EQU      040h
EKB               EQU      020h
ES1               EQU      010h
ESF               EQU      008h
EPCA              EQU      004h
EADC              EQU      002h
ESPI              EQU      001h

EIP1L             DATA     0AEH     //Ext. INT Priority 1 Low
EIP1L_Page        EQU      000h
// (bits in EIP1L)
PAC0L             EQU      080h
PTWI0L            EQU      040h
PKBL              EQU      020h
PS1L              EQU      010h
PSFL              EQU      008h
PPCAL             EQU      004h
PADCL             EQU      002h
PSPIL             EQU      001h

EIP1H             DATA     0AFH     //Ext. INT Priority 1 High
EIP1H_Page        EQU      000h
// (bits in EIP1H)
PAC0H             EQU      080h
PTWI0H            EQU      040h
PKBH              EQU      020h
PS1H              EQU      010h
PSFH              EQU      008h
PPCAH             EQU      004h
PADCH             EQU      002h
PSPIH             EQU      001h

P3                DATA     0B0H     //Port 3
P3_Page           EQU      000h
// (bits in P3)
P37               BIT      P3.7
P36               BIT      P3.6
P35               BIT      P3.5
P34               BIT      P3.4
P33               BIT      P3.3
P32               BIT      P3.2
P31               BIT      P3.1
P30               BIT      P3.0

P3M0              DATA     0B1H     //P3 Mode Register 0
P3M0_Page         EQU      000h
// (bits in P3M0)
P3M07             EQU      080h
P3M06             EQU      040h
P3M05             EQU      020h
P3M04             EQU      010h
P3M03             EQU      008h
P3M02             EQU      004h
P3M01             EQU      002h
P3M00             EQU      001h

P3M1              DATA     0B2H     //P3 Mode Register 1
P3M1_Page         EQU      000h
// (bits in P3M1)
P3M17             EQU      080h
P3M16             EQU      040h
P3M15             EQU      020h
P3M14             EQU      010h
P3M13             EQU      008h
P3M12             EQU      004h
P3M11             EQU      002h
P3M10             EQU      001h

P4M0              DATA     0B3H     //P4 Mode Register 0
P4M0_Page         EQU      000h
// (bits in P4M0)
P4M07             EQU      080h
P4M06             EQU      040h
P4M05             EQU      020h
P4M04             EQU      010h
P4M03             EQU      008h
P4M02             EQU      004h
P4M01             EQU      002h
P4M00             EQU      001h

PDRVC0            DATA     0B4H     //Port Driving Control 0
PDRVC0_Page       EQU      002h
// (bits in PDRVC0)
P3DC1             EQU      080h
P3DC0             EQU      040h
P2DC1             EQU      020h
P2DC0             EQU      010h
P1DC1             EQU      008h
P1DC0             EQU      004h
P0DC1             EQU      002h
P0DC0             EQU      001h

PDRVC1            DATA     0B4H     //Port Driving Control 1
PDRVC1_Page       EQU      003h
// (bits in PDRVC1)
P7DC0             EQU      040h
P6DC1             EQU      020h
P6DC0             EQU      010h
P5DC1             EQU      008h
P5DC0             EQU      004h
P4DC1             EQU      002h
P4DC0             EQU      001h

P5M0              DATA     0B5H     //P5 Mode Register 0
P5M0_Page         EQU      000h
// (bits in P5M0)
P5M07             EQU      080h
P5M06             EQU      040h
P5M05             EQU      020h
P5M04             EQU      010h
P5M03             EQU      008h
P5M02             EQU      004h
P5M01             EQU      002h
P5M00             EQU      001h

P6M0              DATA     0B5H     //P6 Mode Register 0
P6M0_Page         EQU      001h
// (bits in P6M0)
P6M07             EQU      080h
P6M06             EQU      040h
P6M05             EQU      020h
P6M04             EQU      010h
P6M03             EQU      008h
P6M02             EQU      004h
P6M01             EQU      002h
P6M00             EQU      001h

P7M0              DATA     0B5H     //P7 Mode Register 0
P7M0_Page         EQU      002h
// (bits in P7M0)
P7M03             EQU      008h
P7M02             EQU      004h
P7M01             EQU      002h
P7M00             EQU      001h

EMBTC             DATA     0B5H     //EMB Timing Control
EMBTC_Page        EQU      003h
// (bits in EMBTC)
RWSH              EQU      008h
RWS2              EQU      004h
RWS1              EQU      002h
RWS0              EQU      001h

RTCTM             DATA     0B6H     //RTC Timer Register
RTCTM_Page        EQU      000h
// (bits in RTCTM)
RTCCS1            EQU      080h
RTCCS0            EQU      040h
RTCCT5            EQU      020h
RTCCT4            EQU      010h
RTCCT3            EQU      008h
RTCCT2            EQU      004h
RTCCT1            EQU      002h
RTCCT0            EQU      001h

IP0H              DATA     0B7H     //Interrupt Priority 0 High
IP0H_Page         EQU      000h
// (bits in IP0H)
PX3H              EQU      080h
PX2H              EQU      040h
PT2H              EQU      020h
PSH               EQU      010h
PT1H              EQU      008h
PX1H              EQU      004h
PT0H              EQU      002h
PX0H              EQU      001h

IP0L              DATA     0B8H     //Interrupt Priority Low
IP0L_Page         EQU      000h
// (bits in IP0L)
PX3L              BIT      IP0L.7
PX2L              BIT      IP0L.6
PT2L              BIT      IP0L.5
PSL               BIT      IP0L.4
PT1L              BIT      IP0L.3
PX1L              BIT      IP0L.2
PT0L              BIT      IP0L.1
PX0L              BIT      IP0L.0

SADEN             DATA     0B9H     //Slave Address Mask
SADEN_Page        EQU      000h
// (bits in SADEN)
SADEN7            EQU      080h
SADEN6            EQU      040h
SADEN5            EQU      020h
SADEN4            EQU      010h
SADEN3            EQU      008h
SADEN2            EQU      004h
SADEN1            EQU      002h
SADEN0            EQU      001h

S0CR1             DATA     0B9H     //S0 Control 1
S0CR1_Page        EQU      000h
// (bits in S0CR1)
S0TR              EQU      080h
S0TX12            EQU      040h
S0TCK             EQU      020h
S0RCK             EQU      010h
S0CKOE            EQU      008h
ARTE              EQU      004h

PWMCR             DATA     0BCH     //PWM Control Reg.
PWMCR_Page        EQU      000h
// (bits in PWMCR)
PCAE              EQU      080h
EXDT              EQU      040h
PBKM              EQU      020h
PBKE11            EQU      010h
PBKE10            EQU      008h
PBKE02            EQU      004h
PBKE01            EQU      002h
PBKE00            EQU      001h

PDTCRA            DATA     0BCH     //PWM Dead-Time Control Reg. -A
PDTCRA_Page       EQU      001h
// (bits in PDTCRA)
DTPS1             EQU      080h
DTPS0             EQU      040h
DT5               EQU      020h
DT4               EQU      010h
DT3               EQU      008h
DT2               EQU      004h
DT1               EQU      002h
DT0               EQU      001h

BM0CR             DATA     0BCH     //OBM0 Control Reg.
BM0CR_Page        EQU      002h
// (bits in BM0CR)
BM0OUT            EQU      080h
BM0SW             EQU      040h
BM0IE             EQU      020h
BM0POL            EQU      010h
M0FLT1            EQU      008h
M0FLT0            EQU      004h
BM0M1             EQU      002h
BM0M0             EQU      001h

BM0SE             DATA     0BCH     //OBM0 Switch Enable Reg.
BM0SE_Page        EQU      003h
// (bits in BM0SE)
BM0E13            EQU      080h
BM0E12            EQU      040h
BM0E11            EQU      020h
BM0E10            EQU      010h
BM0E03            EQU      008h
BM0E02            EQU      004h
BM0E01            EQU      002h
BM0E00            EQU      001h

BM0LCR            DATA     0BCH     //OBM0 Low channel Control Reg.
BM0LCR_Page       EQU      004h
// (bits in BM0LCR)
BM0LCP            EQU      080h
BM0LS3            EQU      008h
BM0LS2            EQU      004h
BM0LS1            EQU      002h
BM0LS0            EQU      001h

BM0HCR            DATA     0BCH     //OBM0 High channel Control Reg.
BM0HCR_Page       EQU      005h
// (bits in BM0HCR)
BM0HCP            EQU      080h
BM0HS3            EQU      008h
BM0HS2            EQU      004h
BM0HS1            EQU      002h
BM0HS0            EQU      001h

BM1CR             DATA     0BCH     //OBM1 Control Reg.
BM1CR_Page        EQU      006h
// (bits in BM1CR)
BM1OUT            EQU      080h
BM1SW             EQU      040h
BM1IE             EQU      020h
BM1POL            EQU      010h
M1FLT1            EQU      008h
M1FLT0            EQU      004h
BM1M1             EQU      002h
BM1M0             EQU      001h

BM1SE             DATA     0BCH     //OBM1 Switch Enable Reg.
BM1SE_Page        EQU      007h
// (bits in BM1SE)
BM1E13            EQU      080h
BM1E12            EQU      040h
BM1E11            EQU      020h
BM1E10            EQU      010h
BM1E03            EQU      008h
BM1E02            EQU      004h
BM1E01            EQU      002h
BM1E00            EQU      001h

BM1LCR            DATA     0BCH     //OBM1 Low channel Control Reg.
BM1LCR_Page       EQU      008h
// (bits in BM1LCR)
BM1LCP            EQU      080h
BM1LS3            EQU      008h
BM1LS2            EQU      004h
BM1LS1            EQU      002h
BM1LS0            EQU      001h

BM1HCR            DATA     0BCH     //OBM1 High channel Control Reg.
BM1HCR_Page       EQU      009h
// (bits in BM1HCR)
BM1HCP            EQU      080h
BM1HS3            EQU      008h
BM1HS2            EQU      004h
BM1HS1            EQU      002h
BM1HS0            EQU      001h

CRC0DA            DATA     0BDH     //CRC0 Data Port
CRC0DA_Page       EQU      000h

RTCCR             DATA     0BEH     //RTC Control Reg.
RTCCR_Page        EQU      000h
// (bits in RTCCR)
RTCE              EQU      080h
RTCO              EQU      040h
RTCRL5            EQU      020h
RTCRL4            EQU      010h
RTCRL3            EQU      008h
RTCRL2            EQU      004h
RTCRL1            EQU      002h
RTCRL0            EQU      001h

CKCON1            DATA     0BFH     //Clock Control 1
CKCON1_Page       EQU      000h
// (bits in CKCON1)
XTOR              EQU      080h
MCKSTA1           EQU      020h
MCKSTA0           EQU      010h
OSCSTA3           EQU      008h
OSCSTA2           EQU      004h
OSCSTA1           EQU      002h
OSCSTA0           EQU      001h

XICON             DATA     0C0H     //External INT Control
XICON_Page        EQU      000h
// (bits in XICON)
INT3H             BIT      XICON.7
EX3               BIT      XICON.6
IE3               BIT      XICON.5
IT3               BIT      XICON.4
INT2H             BIT      XICON.3
EX2               BIT      XICON.2
IE2               BIT      XICON.1
IT2               BIT      XICON.0

XICFG             DATA     0C1H     //Ext. INT. Configured
XICFG_Page        EQU      000h
// (bits in XICFG)
INT1IS1           EQU      080h
INT1IS0           EQU      040h
INT0IS1           EQU      020h
INT0IS0           EQU      010h
X3FLT             EQU      008h
X2FLT             EQU      004h
X1FLT             EQU      002h
X0FLT             EQU      001h

XICFG1            DATA     0C1H     //Ext. INT. Configured 1
XICFG1_Page       EQU      001h
// (bits in XICFG1)
INT1IS2           EQU      080h
INT0IS2           EQU      040h
INT2IS1           EQU      020h
INT2IS0           EQU      010h
X3FLT1            EQU      008h
X2FLT1            EQU      004h
X1FLT1            EQU      002h
X0FLT1            EQU      001h

XICFG2            DATA     0C1H     //Ext. INT. Configured 2
XICFG2_Page       EQU      002h
// (bits in XICFG2)
INT3IS2           EQU      008h
INT3IS1           EQU      004h
INT3IS0           EQU      002h
INT2IS2           EQU      001h

ADCFG0            DATA     0C3H     //ADC Configuration 0
ADCFG0_Page       EQU      000h
// (bits in ADCFG0)
ADCKS2            EQU      080h
ADCKS1            EQU      040h
ADCKS0            EQU      020h
ADRJ              EQU      010h
ACHS              EQU      008h
SMPF              EQU      004h
ADTM1             EQU      002h
ADTM0             EQU      001h

ADCFG1            DATA     0C3H     //ADC Configuration 1
ADCFG1_Page       EQU      001h
// (bits in ADCFG1)
IGADCI            EQU      080h
EADCWI            EQU      040h
SMPFIE            EQU      020h
SIGN              EQU      010h
AOS3              EQU      008h
AOS2              EQU      004h
AOS1              EQU      002h
AOS0              EQU      001h

ADCFG2            DATA     0C3H     //ADC Configuration 2
ADCFG2_Page       EQU      002h
// (bits in ADCFG2)
SHT7              EQU      080h
SHT6              EQU      040h
SHT5              EQU      020h
SHT4              EQU      010h
SHT3              EQU      008h
SHT2              EQU      004h
SHT1              EQU      002h
SHT0              EQU      001h

ADCFG3            DATA     0C3H     //ADC Configuration 3
ADCFG3_Page       EQU      003h
// (bits in ADCFG3)
ADPS1             EQU      080h
ADPS0             EQU      040h
ARES1             EQU      008h
ARES0             EQU      004h
ADES0             EQU      002h

ADCFG4            DATA     0C3H     //ADC Configuration 4
ADCFG4_Page       EQU      004h
// (bits in ADCFG4)
ADWM0             EQU      040h
ADTM3             EQU      020h
ADTM2             EQU      010h
DBSD              EQU      002h
DOSD              EQU      001h

ADCFG5            DATA     0C3H     //ADC Configuration 5
ADCFG5_Page       EQU      005h
// (bits in ADCFG5)
ASCE7             EQU      080h
ASCE6             EQU      040h
ASCE5             EQU      020h
ASCE4             EQU      010h
ASCE3             EQU      008h
ASCE2             EQU      004h
ASCE1             EQU      002h
ASCE0             EQU      001h

ADCFG6            DATA     0C3H     //ADC Configuration 6
ADCFG6_Page       EQU      006h
// (bits in ADCFG6)
ASCE15            EQU      080h
ASCE14            EQU      040h
ASCE13            EQU      020h
ASCE12            EQU      010h
ASCE11            EQU      008h
ASCE10            EQU      004h
ASCE9             EQU      002h
ASCE8             EQU      001h

ADCFG11           DATA     0C3H     //ADC Configuration 11
ADCFG11_Page      EQU      00Bh
// (bits in ADCFG11)
WHB3              EQU      080h
WHB2              EQU      040h
WHB1              EQU      020h
WHB0              EQU      010h

ADCFG12           DATA     0C3H     //ADC Configuration 12
ADCFG12_Page      EQU      00Ch
// (bits in ADCFG12)
WHB11             EQU      080h
WHB10             EQU      040h
WHB9              EQU      020h
WHB8              EQU      010h
WHB7              EQU      008h
WHB6              EQU      004h
WHB5              EQU      002h
WHB4              EQU      001h

ADCFG13           DATA     0C3H     //ADC Configuration 13
ADCFG13_Page      EQU      00Dh
// (bits in ADCFG13)
WLB3              EQU      080h
WLB2              EQU      040h
WLB1              EQU      020h
WLB0              EQU      010h

ADCFG14           DATA     0C3H     //ADC Configuration 14
ADCFG14_Page      EQU      00Eh
// (bits in ADCFG14)
WLB11             EQU      080h
WLB10             EQU      040h
WLB9              EQU      020h
WLB8              EQU      010h
WLB7              EQU      008h
WLB6              EQU      004h
WLB5              EQU      002h
WLB4              EQU      001h

ADCON0            DATA     0C4H     //ADC Control 0
ADCON0_Page       EQU      000h
// (bits in ADCON0)
ADCEN             EQU      080h
ADCWI             EQU      040h
CHS3              EQU      020h
ADCI              EQU      010h
ADCS              EQU      008h
CHS2              EQU      004h
CHS1              EQU      002h
CHS0              EQU      001h

ADCDL             DATA     0C5H     //ADC Data Low
ADCDL_Page        EQU      000h
// (bits in ADCDL)
ADCV3             EQU      080h
ADCV2             EQU      040h
ADCV1             EQU      020h
ADCV0             EQU      010h

ADCDH             DATA     0C6H     //ADC Data High
ADCDH_Page        EQU      000h
// (bits in ADCDH)
ADCV11            EQU      080h
ADCV10            EQU      040h
ADCV9             EQU      020h
ADCV8             EQU      010h
ADCV7             EQU      008h
ADCV6             EQU      004h
ADCV5             EQU      002h
ADCV4             EQU      001h

CKCON0            DATA     0C7H     //Clock Control 0
CKCON0_Page       EQU      000h
// (bits in CKCON0)
AFS               EQU      080h
ENCKM             EQU      040h
CKMIS1            EQU      020h
CKMIS0            EQU      010h
CCKS              EQU      008h
SCKS2             EQU      004h
SCKS1             EQU      002h
SCKS0             EQU      001h

T2CON             DATA     0C8H     //Timer 2 Control Reg.
T2CON_Page        EQU      000h
// (bits in T2CON)
TF2               BIT      T2CON.7
EXF2              BIT      T2CON.6
RCLK_TF2L         BIT      T2CON.5
TCLK_TL2IE        BIT      T2CON.4
EXEN2             BIT      T2CON.3
TR2               BIT      T2CON.2
C_T2              BIT      T2CON.1
CP_RL2            BIT      T2CON.0

T3CON             DATA     0C8H     //Timer 3 Control Reg.
T3CON_Page        EQU      001h
// (bits in T3CON)
TF3               BIT      T3CON.7
EXF3              BIT      T3CON.6
TF3L              BIT      T3CON.5
TL3IE             BIT      T3CON.4
EXEN3             BIT      T3CON.3
TR3               BIT      T3CON.2
C_T3              BIT      T3CON.1
CP_RL3            BIT      T3CON.0

T4CON             DATA     0C8H     //Timer 4 Control Reg.
T4CON_Page        EQU      002h
// (bits in T4CON)
TF4               BIT      T4CON.7
EXF4              BIT      T4CON.6
TF4L              BIT      T4CON.5
TL4IE             BIT      T4CON.4
EXEN4             BIT      T4CON.3
TR4               BIT      T4CON.2
C_T4              BIT      T4CON.1
CP_RL4            BIT      T4CON.0

T5CON             DATA     0C8H     //Timer 5 Control Reg.
T5CON_Page        EQU      003h
// (bits in T5CON)
TF5               BIT      T5CON.7
T5CKS1            BIT      T5CON.5
T5CKS0            BIT      T5CON.4
T5IE              BIT      T5CON.3
TR5               BIT      T5CON.2
T5GAT1            BIT      T5CON.1
T5GAT0            BIT      T5CON.0

T6CON             DATA     0C8H     //Timer 6 Control Reg.
T6CON_Page        EQU      004h
// (bits in T6CON)
TF6               BIT      T6CON.7
T6CKS1            BIT      T6CON.5
T6CKS0            BIT      T6CON.4
T6IE              BIT      T6CON.3
TR6               BIT      T6CON.2
T6GAT1            BIT      T6CON.1
T6GAT0            BIT      T6CON.0

T2MOD             DATA     0C9H     //Timer 2 mode Reg.
T2MOD_Page        EQU      000h
// (bits in T2MOD)
T2SPL             EQU      080h
TL2X12_T2EIP      EQU      040h
T2EXH             EQU      020h
T2X12             EQU      010h
TR2L              EQU      008h
TR2LC             EQU      004h
T2OE              EQU      002h
T2MS0             EQU      001h

T3MOD             DATA     0C9H     //Timer 3 mode Reg.
T3MOD_Page        EQU      001h
// (bits in T3MOD)
T3SPL             EQU      080h
TL3X12_T3EIP      EQU      040h
T3EXH             EQU      020h
T3X12             EQU      010h
TR3L              EQU      008h
TR3LC             EQU      004h
T3OE              EQU      002h
T3MS0             EQU      001h

T4MOD             DATA     0C9H     //Timer 4 mode Reg.
T4MOD_Page        EQU      002h
// (bits in T4MOD)
T4SPL             EQU      080h
TL4X12_T4EIP      EQU      040h
T4EXH             EQU      020h
T4X12             EQU      010h
TR4L              EQU      008h
TR4LC             EQU      004h
T4OE              EQU      002h
T4MS0             EQU      001h

RCAP2L            DATA     0CAH     //Timer2 Capture Low
RCAP2L_Page       EQU      000h

RCAP3L            DATA     0CAH     //Timer3 Capture Low
RCAP3L_Page       EQU      001h

RCAP4L            DATA     0CAH     //Timer4 Capture Low
RCAP4L_Page       EQU      002h

TLR5              DATA     0CAH     //TL5 reload Reg.
TLR5_Page         EQU      003h

TLR6              DATA     0CAH     //TL6 reload Reg.
TLR6_Page         EQU      004h

RCAP2H            DATA     0CBH     //Timer2 Capture High
RCAP2H_Page       EQU      000h

RCAP3H            DATA     0CBH     //Timer3 Capture High
RCAP3H_Page       EQU      001h

RCAP4H            DATA     0CBH     //Timer4 Capture High
RCAP4H_Page       EQU      002h

THR5              DATA     0CBH     //TH5 reload Reg.
THR5_Page         EQU      003h

THR6              DATA     0CBH     //TH6 reload Reg.
THR6_Page         EQU      004h

TL2               DATA     0CCH     //Timer Low 2
TL2_Page          EQU      000h

TL3               DATA     0CCH     //Timer Low 3
TL3_Page          EQU      001h

TL4               DATA     0CCH     //Timer Low 4
TL4_Page          EQU      002h

TL5               DATA     0CCH     //Timer Low 5
TL5_Page          EQU      003h

TL6               DATA     0CCH     //Timer Low 6
TL6_Page          EQU      004h

TH2               DATA     0CDH     //Timer High 2
TH2_Page          EQU      000h

TH3               DATA     0CDH     //Timer High 3
TH3_Page          EQU      001h

TH4               DATA     0CDH     //Timer High 4
TH4_Page          EQU      002h

TH5               DATA     0CDH     //Timer High 5
TH5_Page          EQU      003h

TH6               DATA     0CDH     //Timer High 6
TH6_Page          EQU      004h

CLRL              DATA     0CEH     //CL Reload register
CLRL_Page         EQU      000h

CHRL              DATA     0CFH     //CH Reload register
CHRL_Page         EQU      000h

PSW               DATA     0D0H     //Program Status Word
PSW_Page          EQU      000h
// (bits in PSW)
CY                BIT      PSW.7
AC                BIT      PSW.6
F0                BIT      PSW.5
RS1               BIT      PSW.4
RS0               BIT      PSW.3
OV                BIT      PSW.2
F1                BIT      PSW.1
P                 BIT      PSW.0

SIADR             DATA     0D1H     //TWI0 Address Reg.
SIADR_Page        EQU      000h
// (bits in SIADR)
GC                EQU      001h

SI1ADR            DATA     0D1H     //TWI1 Address Reg.
SI1ADR_Page       EQU      001h
// (bits in SI1ADR)
GC1               EQU      001h

SIA2              DATA     0D1H     //TWI0 2nd Addr Reg.
SIA2_Page         EQU      002h
// (bits in SIA2)
A2E               EQU      001h

SI1A2             DATA     0D1H     //TWI1 2nd Addr Reg.
SI1A2_Page        EQU      003h
// (bits in SI1A2)
A2E1              EQU      001h

SIDAT             DATA     0D2H     //TWI0 Data Reg.
SIDAT_Page        EQU      000h

SI1DAT            DATA     0D2H     //TWI1 Data Reg.
SI1DAT_Page       EQU      001h

SIA2M             DATA     0D2H     //SIA2 Mask Reg.
SIA2M_Page        EQU      002h
// (bits in SIA2M)
SIA2M7            EQU      080h
SIA2M6            EQU      040h
SIA2M5            EQU      020h
SIA2M4            EQU      010h
SIA2M3            EQU      008h
SIA2M2            EQU      004h
SIA2M1            EQU      002h

SI1A2M            DATA     0D2H     //SI1A2 Mask Reg.
SI1A2M_Page       EQU      003h
// (bits in SI1A2M)
SI1A2M7           EQU      080h
SI1A2M6           EQU      040h
SI1A2M5           EQU      020h
SI1A2M4           EQU      010h
SI1A2M3           EQU      008h
SI1A2M2           EQU      004h
SI1A2M1           EQU      002h

SISTA             DATA     0D3H     //TWI0 Status Reg.
SISTA_Page        EQU      000h

SI1STA            DATA     0D3H     //TWI1 Status Reg.
SI1STA_Page       EQU      001h

SICON             DATA     0D4H     //TWI0 Control Reg.
SICON_Page        EQU      000h
// (bits in SICON)
CR2               EQU      080h
ENSI              EQU      040h
STA               EQU      020h
STO               EQU      010h
SI                EQU      008h
AA                EQU      004h
CR1               EQU      002h
CR0               EQU      001h

SI1CON            DATA     0D4H     //TWI1 Control Reg.
SI1CON_Page       EQU      001h
// (bits in SI1CON)
CR21              EQU      080h
ENSI1             EQU      040h
STA1              EQU      020h
STO1              EQU      010h
SI1               EQU      008h
AA1               EQU      004h
CR11              EQU      002h
CR01              EQU      001h

KBPATN            DATA     0D5H     //Keypad Pattern
KBPATN_Page       EQU      000h
// (bits in KBPATN)
KBPATN7           EQU      080h
KBPATN6           EQU      040h
KBPATN5           EQU      020h
KBPATN4           EQU      010h
KBPATN3           EQU      008h
KBPATN2           EQU      004h
KBPATN1           EQU      002h
KBPATN0           EQU      001h

KBCON             DATA     0D6H     //Keypad Control
KBCON_Page        EQU      000h
// (bits in KBCON)
KBCS1             EQU      080h
KBCS0             EQU      040h
KBES              EQU      020h
PATN_SEL          EQU      002h
KBIF              EQU      001h

KBMASK            DATA     0D7H     //Keypad Int. Mask
KBMASK_Page       EQU      000h
// (bits in KBMASK)
KBMASK7           EQU      080h
KBMASK6           EQU      040h
KBMASK5           EQU      020h
KBMASK4           EQU      010h
KBMASK3           EQU      008h
KBMASK2           EQU      004h
KBMASK1           EQU      002h
KBMASK0           EQU      001h

CCON              DATA     0D8H     //PCA Control Reg.
CCON_Page         EQU      000h
// (bits in CCON)
CF                BIT      CCON.7
CR                BIT      CCON.6
CCF5              BIT      CCON.5
CCF4              BIT      CCON.4
CCF3              BIT      CCON.3
CCF2              BIT      CCON.2
CCF1              BIT      CCON.1
CCF0              BIT      CCON.0

CMOD              DATA     0D9H     //PCA Mode Reg.
CMOD_Page         EQU      000h
// (bits in CMOD)
CIDL              EQU      080h
BME4              EQU      040h
BME2              EQU      020h
BME0              EQU      010h
CPS2              EQU      008h
CPS1              EQU      004h
CPS0              EQU      002h
ECF               EQU      001h

CCAPM0            DATA     0DAH     //PCA Module0 Mode
CCAPM0_Page       EQU      000h
// (bits in CCAPM0)
DTE0              EQU      080h
ECOM0             EQU      040h
CAPP0             EQU      020h
CAPN0             EQU      010h
MAT0              EQU      008h
TOG0              EQU      004h
PWM0              EQU      002h
ECCF0             EQU      001h

CCAPM6            DATA     0DAH     //PCA Module6 Mode
CCAPM6_Page       EQU      001h
// (bits in CCAPM6)
BME6              EQU      080h
ECOM6             EQU      040h
CAPN6             EQU      010h
MAT6              EQU      008h
TOG6              EQU      004h
PWM6              EQU      002h
ECCF6             EQU      001h

CCAPM1            DATA     0DBH     //PCA Module1 Mode
CCAPM1_Page       EQU      000h
// (bits in CCAPM1)
ECOM1             EQU      040h
CAPP1             EQU      020h
CAPN1             EQU      010h
MAT1              EQU      008h
TOG1              EQU      004h
PWM1              EQU      002h
ECCF1             EQU      001h

CCAPM7            DATA     0DBH     //PCA Module7 Mode
CCAPM7_Page       EQU      001h
// (bits in CCAPM7)
ECOM7             EQU      040h
CAPN7             EQU      010h
MAT7              EQU      008h
TOG7              EQU      004h
PWM7              EQU      002h
ECCF7             EQU      001h

CCAPM2            DATA     0DCH     //PCA Module2 Mode
CCAPM2_Page       EQU      000h
// (bits in CCAPM2)
DTE2              EQU      080h
ECOM2             EQU      040h
CAPP2             EQU      020h
CAPN2             EQU      010h
MAT2              EQU      008h
TOG2              EQU      004h
PWM2              EQU      002h
ECCF2             EQU      001h

CCAPM3            DATA     0DDH     //PCA Module3 Mode
CCAPM3_Page       EQU      000h
// (bits in CCAPM3)
ECOM3             EQU      040h
CAPP3             EQU      020h
CAPN3             EQU      010h
MAT3              EQU      008h
TOG3              EQU      004h
PWM3              EQU      002h
ECCF3             EQU      001h

CCAPM4            DATA     0DEH     //PCA Module4 Mode
CCAPM4_Page       EQU      000h
// (bits in CCAPM4)
DTE4              EQU      080h
ECOM4             EQU      040h
CAPP4             EQU      020h
CAPN4             EQU      010h
MAT4              EQU      008h
TOG4              EQU      004h
PWM4              EQU      002h
ECCF4             EQU      001h

CCAPM5            DATA     0DFH     //PCA Module5 Mode
CCAPM5_Page       EQU      000h
// (bits in CCAPM5)
ECOM5             EQU      040h
CAPP5             EQU      020h
CAPN5             EQU      010h
MAT5              EQU      008h
TOG5              EQU      004h
PWM5              EQU      002h
ECCF5             EQU      001h

ACC               DATA     0E0H     //Accumulator
ACC_Page          EQU      000h

WDTCR             DATA     0E1H     //WDT Control register
WDTCR_Page        EQU      000h
// (bits in WDTCR)
WREN              EQU      080h
NSW               EQU      040h
ENW               EQU      020h
CLRW              EQU      010h
WIDL              EQU      008h
PS2               EQU      004h
PS1               EQU      002h
PS0               EQU      001h

IFD               DATA     0E2H     //ISP Flash data
IFD_Page          EQU      000h

IFADRH            DATA     0E3H     //ISP Flash Addr. High
IFADRH_Page       EQU      000h

IFADRL            DATA     0E4H     //ISP Flash Addr. Low
IFADRL_Page       EQU      000h

IFMT              DATA     0E5H     //ISP Mode Table
IFMT_Page         EQU      000h
// (bits in IFMT)
MS7               EQU      080h
MS3               EQU      008h
MS2               EQU      004h
MS1               EQU      002h
MS0               EQU      001h

SCMD              DATA     0E6H     //ISP Serial Command
SCMD_Page         EQU      000h

ISPCR             DATA     0E7H     //ISP Control Register
ISPCR_Page        EQU      000h
// (bits in ISPCR)
ISPEN             EQU      080h
SWBS              EQU      040h
SRST              EQU      020h
CFAIL             EQU      010h

P4                DATA     0E8H     //Port 4
P4_Page           EQU      000h
// (bits in P4)
P47               BIT      P4.7
P46               BIT      P4.6
P45               BIT      P4.5
P44               BIT      P4.4
P43               BIT      P4.3
P42               BIT      P4.2
P41               BIT      P4.1
P40               BIT      P4.0

CL                DATA     0E9H     //PCA base timer Low
CL_Page           EQU      000h

CCAP0L            DATA     0EAH     //PCA module0 capture Low
CCAP0L_Page       EQU      000h

CCAP6L            DATA     0EAH     //PCA module6 capture Low
CCAP6L_Page       EQU      001h

CCAP1L            DATA     0EBH     //PCA module1 capture Low
CCAP1L_Page       EQU      000h

CCAP7L            DATA     0EBH     //PCA module7 capture Low
CCAP7L_Page       EQU      001h

CCAP2L            DATA     0ECH     //PCA module2 capture Low
CCAP2L_Page       EQU      000h

CCAP3L            DATA     0EDH     //PCA module3 capture Low
CCAP3L_Page       EQU      000h

CCAP4L            DATA     0EEH     //PCA module4 capture Low
CCAP4L_Page       EQU      000h

CCAP5L            DATA     0EFH     //PCA module5 capture Low
CCAP5L_Page       EQU      000h

B                 DATA     0F0H     //B Register
B_Page            EQU      000h

PAOE              DATA     0F1H     //PWM Additional Output Enable
PAOE_Page         EQU      000h
// (bits in PAOE)
POE3              EQU      080h
POE2B             EQU      040h
POE2A             EQU      020h
POE2              EQU      010h
POE1              EQU      008h
POE0B             EQU      004h
POE0A             EQU      002h
POE0              EQU      001h

PCAPWM0           DATA     0F2H     //PCA PWM0 Mode
PCAPWM0_Page      EQU      000h
// (bits in PCAPWM0)
P0RS1             EQU      080h
P0RS0             EQU      040h
P0INV             EQU      004h
ECAP0H            EQU      002h
ECAP0L            EQU      001h

PCAPWM6           DATA     0F2H     //PCA PWM6 Mode
PCAPWM6_Page      EQU      001h
// (bits in PCAPWM6)
P6RS1             EQU      080h
P6RS0             EQU      040h
CCF6              EQU      008h
P6INV             EQU      004h
ECAP6H            EQU      002h
ECAP6L            EQU      001h

PCAPWM1           DATA     0F3H     //PCA PWM1 Mode
PCAPWM1_Page      EQU      000h
// (bits in PCAPWM1)
P1RS1             EQU      080h
P1RS0             EQU      040h
P1INV             EQU      004h
ECAP1H            EQU      002h
ECAP1L            EQU      001h

PCAPWM7           DATA     0F3H     //PCA PWM7 Mode
PCAPWM7_Page      EQU      001h
// (bits in PCAPWM7)
P7RS1             EQU      080h
P7RS0             EQU      040h
CCF7              EQU      008h
P7INV             EQU      004h
ECAP7H            EQU      002h
ECAP7L            EQU      001h

PCAPWM2           DATA     0F4H     //PCA PWM2 Mode
PCAPWM2_Page      EQU      000h
// (bits in PCAPWM2)
P2RS1             EQU      080h
P2RS0             EQU      040h
P2INV             EQU      004h
ECAP2H            EQU      002h
ECAP2L            EQU      001h

PCAPWM3           DATA     0F5H     //PCA PWM3 Mode
PCAPWM3_Page      EQU      000h
// (bits in PCAPWM3)
P3RS1             EQU      080h
P3RS0             EQU      040h
P3INV             EQU      004h
ECAP3H            EQU      002h
ECAP3L            EQU      001h

PCAPWM4           DATA     0F6H     //PCA PWM4 Mode
PCAPWM4_Page      EQU      000h
// (bits in PCAPWM4)
P4RS1             EQU      080h
P4RS0             EQU      040h
P4INV             EQU      004h
ECAP4H            EQU      002h
ECAP4L            EQU      001h

PCAPWM5           DATA     0F7H     //PCA PWM5 Mode
PCAPWM5_Page      EQU      000h
// (bits in PCAPWM5)
P5RS1             EQU      080h
P5RS0             EQU      040h
P5INV             EQU      004h
ECAP5H            EQU      002h
ECAP5L            EQU      001h

P5                DATA     0F8H     //Port 5
P5_Page           EQU      000h
// (bits in P5)
P57               BIT      P5.7
P56               BIT      P5.6
P55               BIT      P5.5
P54               BIT      P5.4
P53               BIT      P5.3
P52               BIT      P5.2
P51               BIT      P5.1
P50               BIT      P5.0

P6                DATA     0F8H     //Port 6
P6_Page           EQU      001h
// (bits in P6)
P67               BIT      P6.7
P66               BIT      P6.6
P65               BIT      P6.5
P64               BIT      P6.4
P63               BIT      P6.3
P62               BIT      P6.2
P61               BIT      P6.1
P60               BIT      P6.0

P7                DATA     0F8H     //Port 7
P7_Page           EQU      002h
// (bits in P7)
P73               BIT      P7.3
P72               BIT      P7.2
P71               BIT      P7.1
P70               BIT      P7.0

CH                DATA     0F9H     //PCA base timer High
CH_Page           EQU      000h

CCAP0H            DATA     0FAH     //PCA Module0 capture High
CCAP0H_Page       EQU      000h

CCAP6H            DATA     0FAH     //PCA Module6 capture High
CCAP6H_Page       EQU      001h

CCAP1H            DATA     0FBH     //PCA Module1 capture High
CCAP1H_Page       EQU      000h

CCAP7H            DATA     0FBH     //PCA Module7 capture High
CCAP7H_Page       EQU      001h

CCAP2H            DATA     0FCH     //PCA Module2 capture High
CCAP2H_Page       EQU      000h

CCAP3H            DATA     0FDH     //PCA Module3 capture High
CCAP3H_Page       EQU      000h

CCAP4H            DATA     0FEH     //PCA Module4 capture High
CCAP4H_Page       EQU      000h

CCAP5H            DATA     0FFH     //PCA Module5 capture High
CCAP5H_Page       EQU      000h


//===== Page P =====//
IAPLB_P           EQU      003h     //IAP Low Boundary
// (bits in IAPLB)
IAPLB6_P          EQU      080h
IAPLB5_P          EQU      040h
IAPLB4_P          EQU      020h
IAPLB3_P          EQU      010h
IAPLB2_P          EQU      008h
IAPLB1_P          EQU      004h
IAPLB0_P          EQU      002h

CKCON2_P          EQU      040h     //Clock Control 2
// (bits in CKCON2)
XTGS1_P           EQU      080h
XTGS0_P           EQU      040h
XTALE_P           EQU      020h
IHRCOE_P          EQU      010h
MCKS1_P           EQU      008h
MCKS0_P           EQU      004h
OSCS1_P           EQU      002h
OSCS0_P           EQU      001h

CKCON3_P          EQU      041h     //Clock Control 3
// (bits in CKCON3)
WDTCS1_P          EQU      080h
WDTCS0_P          EQU      040h
FWKP_P            EQU      020h
WDTFS_P           EQU      010h
MCKD1_P           EQU      008h
MCKD0_P           EQU      004h
MCDS1_P           EQU      002h
MCDS0_P           EQU      001h

CKCON4_P          EQU      042h     //Clock Control 4
// (bits in CKCON4)
RCSS2_P           EQU      080h
RCSS1_P           EQU      040h
RCSS0_P           EQU      020h
RPSC2_P           EQU      010h
RPSC1_P           EQU      008h
RPSC0_P           EQU      004h
RTCCS3_P          EQU      002h
RTCCS2_P          EQU      001h

CKCON5_P          EQU      043h     //Clock Control 5
// (bits in CKCON5)
CKMS0_P           EQU      001h

PCON2_P           EQU      044h     //Power Control 2
// (bits in PCON2)
AWBOD1_P          EQU      080h
BO1S1_P           EQU      020h
BO1S0_P           EQU      010h
BO1RE_P           EQU      008h
EBOD1_P           EQU      004h
BO0RE_P           EQU      002h

PCON3_P           EQU      045h     //Power Control 3
// (bits in PCON3)
IVREN_P           EQU      080h
SPWRE_P           EQU      010h

SPCON0_P          EQU      048h     //SFR Page Control 0
// (bits in SPCON0)
P6CTL_P           EQU      040h
P4CTL_P           EQU      020h
WRCTL_P           EQU      010h
CKCTL0_P          EQU      004h
PWCTL1_P          EQU      002h
PWCTL0_P          EQU      001h

DCON0_P           EQU      04Ch     //Device Control 0
// (bits in DCON0)
HSE_P             EQU      080h
IAPO_P            EQU      040h
HSE1_P            EQU      020h
IORCTL_P          EQU      004h
RSTIO_P           EQU      002h
OCDE_P            EQU      001h

SPHB_P            EQU      053h     //SP High Boundary
// (bits in SPHB)
SPHB3_P           EQU      008h
SPHB2_P           EQU      004h
SPHB1_P           EQU      002h
SPHB0_P           EQU      001h

RTCCR_P           EQU      054h     //RTC Control Reg.
// (bits in RTCCR)
RTCE_P            EQU      080h
RTCO_P            EQU      040h
RTCRL5_P          EQU      020h
RTCRL4_P          EQU      010h
RTCRL3_P          EQU      008h
RTCRL2_P          EQU      004h
RTCRL1_P          EQU      002h
RTCRL0_P          EQU      001h

RTCTM_P           EQU      055h     //RTC Timer Register
// (bits in RTCTM)
RTCCS1_P          EQU      080h
RTCCS0_P          EQU      040h
RTCCT5_P          EQU      020h
RTCCT4_P          EQU      010h
RTCCT3_P          EQU      008h
RTCCT2_P          EQU      004h
RTCCT1_P          EQU      002h
RTCCT0_P          EQU      001h

PCON0_P           EQU      087h     //Power Control 0
// (bits in PCON0)
SMOD1_P           EQU      080h
SMOD0_P           EQU      040h
POF0_P            EQU      010h
PD_P              EQU      002h
IDL_P             EQU      001h

PCON1_P           EQU      097h     //Power Control 1
// (bits in PCON1)
SWRF_P            EQU      080h
EXRF_P            EQU      040h
MCDF_P            EQU      020h
RTCF_P            EQU      010h
SPWF_P            EQU      008h
BOF1_P            EQU      004h
BOF0_P            EQU      002h
WDTF_P            EQU      001h

CKCON0_P          EQU      0C7h     //Clock Control 0
// (bits in CKCON0)
AFS_P             EQU      080h
ENCKM_P           EQU      040h
CKMIS1_P          EQU      020h
CKMIS0_P          EQU      010h
CCKS_P            EQU      008h
SCKS2_P           EQU      004h
SCKS1_P           EQU      002h
SCKS0_P           EQU      001h

WDTCR_P           EQU      0E1h     //Watch-dog-timer Control register
// (bits in WDTCR)
WREN_P            EQU      080h
NSW_P             EQU      040h
ENW_P             EQU      020h
CLRW_P            EQU      010h
WIDL_P            EQU      008h
PS2_P             EQU      004h
PS1_P             EQU      002h
PS0_P             EQU      001h

P4_P              EQU      0E8h     //Port 4
// (bits in P4)
P47_P             EQU      080h
P46_P             EQU      040h
P45_P             EQU      020h
P44_P             EQU      010h
P43_P             EQU      008h
P42_P             EQU      004h
P41_P             EQU      002h
P40_P             EQU      001h

P6_P              EQU      0F8h     //Port 6
// (bits in P6)
P67_P             EQU      080h
P66_P             EQU      040h
P65_P             EQU      020h
P64_P             EQU      010h
P63_P             EQU      008h
P62_P             EQU      004h
P61_P             EQU      002h
P60_P             EQU      001h

#endif
