/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "RcvBuf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［RcvBuf.c］
//=========================================================================================================
//* File Name    : RcvBuf.c
//* Description  : Receive Buffer
//=========================================================================================================
#ifndef BIT0
    #define BIT0  LSB
    #define BIT1  2
    #define BIT01 3
    #define BIT2  4
    #define BIT3  8
    #define BIT23 12
    #define BIT4  16
    #define BIT5  32
    #define BIT6  64
    #define BIT56 96
    #define BIT7  128
#endif

//已經有定義了;AMO;2018.05.25
/* 
#define DLE 0x10
#define EOT 0x04
#define ENQ 0x05
*/

enum enumRTStatus{
    cNormalRT,cDLERT,cEOTRT,cENQRT
};

uint8_t cStatus = cNormalRT;

// hardware

#define RcvBufSize  16384
#define RcvFullSize (RcvBufSize - 256)
#define CanRcvSize  (RcvBufSize - 256 - 128)

uint32_t  PosHead;    //環形佇列_頭旗標;AMO;2018.05.25
uint32_t  PosTrail;   //環形佇列_尾旗標;AMO;2018.05.25
uint32_t  RemainSize; //串口接收暫存空間剩餘大小;AMO;2018.05.25
uint8_t bRcvBufFull;//串口接收待處理資料已滿旗標;0=未滿/1=已滿;AMO;2018.05.25
uint8_t bitRcvBufHaveData; //串口接收待處理資料筆數;AMO;2018.05.25
uint8_t RcvBuf[RcvBufSize];
uint8_t bOnlyRcvBufFullBusy;
void FillRcvBuf(uint8_t cRvcData);
void RealTimeCommand(uint8_t *cData);
void SerialInt(uint8_t cData);
void ClrSetBusy(void);


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［RcvBuf.c］
//=========================================================================================================
//* Function name:     InitRcvBuf    
//* Descriptions :     接收buffer初始化
//=========================================================================================================
void InitRcvBuf(void)//Check-Ok;AMO;2018.05.25
{
    bitRcvBufHaveData = 0;   //串口接收待處理資料筆數;AMO;2018.05.25
    RemainSize = RcvBufSize; //串口接收暫存空間剩餘大小;AMO;2018.05.25
    PosHead = 0;             //環形佇列_頭旗標;AMO;2018.05.25
    PosTrail = 0;            //環形佇列_尾旗標;AMO;2018.05.25
    bRcvBufFull = 0;         //串口接收待處理資料已滿旗標; 0=未滿 / 1=已滿; AMO; 2018.05.25
}

//=========================================================================================================
//* Function name:     SerialInt    
//* Descriptions :     串口中断接收函数
//=========================================================================================================
void SerialInt(uint8_t cData)   //UART0
{
    //uint8_t cData;
    //cData = URT_data;
    RealTimeCommand(&cData);
    if(bRcvBufFull)             //依旗標指示設定串口接收暫存空間滿了;AMO;2018.05.25
    {
        // set busy 
        // Busy_ON;             //AMO註解;AMO;2018.05.25
    }
    FillRcvBuf(cData);          //把串口接收到的資料放到串口暫存的環狀佇列;AMO;2018.05.25
}

//=========================================================================================================
//* Function name:    FillRcvBuf    
//* Descriptions :    通信接口接收的数据存放到接收Buffer
//=========================================================================================================
void FillRcvBuf(uint8_t cRvcData)//Check-Ok;AMO;2018.05.25
{
    if(RemainSize < 2)  //當保留的串口接收空間小於2時，則代表沒接收空間了;AMO;2018.05.25
    {
        // no space to receive data
    }
    else
    {
        RcvBuf[PosHead++] = cRvcData;  
        bitRcvBufHaveData = 1;   //有待處理的串口資料旗標=1;AMO;2018.05.25
        RemainSize--;            //剩下的空間減1;AMO;2018.05.25
    }
    if(PosHead == RcvBufSize)  //當環狀佇列的頭旗標=佇列空間大小時，則頭旗標要指向0，從頭開始;AMO;2018.05.25
    {
        PosHead = 0;
    }
    //RemainSize=RcvBufSize，串口接收暫存空間剩餘大小;AMO;2018.05.25
    //#define RcvBufSize  4096;AMO;2018.05.25
    //#define RcvFullSize (RcvBufSize-256);AMO;2018.05.25
    //#define CanRcvSize  (RcvBufSize-256-128);AMO;2018.05.25
    if((RcvBufSize - RemainSize) > RcvFullSize)
    {
        bRcvBufFull = 1;  //旗標指示串口接收暫存空間滿了;AMO;2018.05.25
        //Busy_ON; //AMO註解;AMO;2018.05.25
    }
}

//=========================================================================================================
//* Function name:     GetDataFromRcvBuf    
//* Descriptions :     在接收数据buffer读取一个字节
//=========================================================================================================
uint8_t GetDataFromRcvBuf(void)//Check-Ok;AMO;2018.05.25
{
    uint8_t ReturnData;
    
    //IWDG_Reload;    //沒使用，註解;AMO;2018.06.20
    DisplayStatus();//主要是判斷溫錯誤或缺紙錯誤和燈號更新;AMO;2018.06.20
    //SYS_ITEA_Cmd(DISABLE); //CloseAllInt //若串口有資料，則先關閉所有中斷，先收資料; Delete 2022/08/23 PoJen
    CloseAllInt(); //若串口有資料，則先關閉所有中斷，先收資料; Recover 2022/08/23 PoJen
    ReturnData = RcvBuf[PosTrail++];
    RemainSize++;  //剩下的空間+1;AMO;2018.05.25
    // SYS_ITEA_Cmd(ENABLE);//OpenAllInt; Delete 2022/08/23 PoJen
    OpenAllInt(); // Delete 2022/08/23 PoJen

    if(PosTrail == RcvBufSize)
    {
        PosTrail = 0;
    }
    if(RemainSize == RcvBufSize) //若剩下的空間 = 串口緩衝區空間，代表沒資料了;AMO;2018.05.25
    {
        bitRcvBufHaveData = 0;
    }

    //RemainSize=RcvBufSize，串口接收暫存空間剩餘大小;AMO;2018.05.25
    //#define RcvBufSize  4096;AMO;2018.05.25
    //#define RcvFullSize (RcvBufSize - 256);AMO;2018.05.25
    //#define CanRcvSize  (RcvBufSize - 256 - 128);AMO;2018.05.25
    if((RcvBufSize - RemainSize) < CanRcvSize)   //這意思是說,當串口緩衝區處理到還有128byte的空間時,就可通知可以繼續接收資料了;AMO;2018.05.25
    {
        bRcvBufFull = 0;
    }
    return ReturnData;
}

//=========================================================================================================
//* Function name:   ClrSetBusy    
//* Descriptions :   设置BUSY状态
//=========================================================================================================
void ClrSetBusy(void)//Check-Ok;AMO;2018.05.25
{
    if(bOnlyRcvBufFullBusy)
    {
        if(bRcvBufFull)
        {
            //Busy_ON;// set busy//AMO註解;AMO;2018.05.25
        }
        else
        {
            //Busy_OFF;// clear busy//AMO註解;AMO;2018.05.25
        }
    }
    else
    {
        if(bRcvBufFull || bErrTemperature || bErrPE)
        {
            // set busy
            //Busy_ON;//AMO註解;AMO;2018.05.25
        }
        else
        {
            // clear busy
            //Busy_OFF; //AMO註解;AMO;2018.05.25
        }
    }
}

//=========================================================================================================
//RealTimeCommand(uint8_t *cData)
//=========================================================================================================
void RealTimeCommand(uint8_t *cData)
{
    static uint8_t cOutData;    // used only by the function of RealTimecommand
    cOutData = 0x12; // 0001 0010

//方便查看;AMO;2018.05.25
/*
#define EOT     0x04
#define ENQ     0x05
#define GS      0x1d
#define HT      0x09
#define LF      0x0a
#define FF      0x0c
#define CR      0x0d
#define DLE     0x10
#define DC      0x11
#define ESC     0x1b
#define FS      0x1c
#define US      0x1f

enum enumRTStatus
{
    cNormalRT,cDLERT,cEOTRT,cENQRT
};

#define LSB        1
#define BIT0     LSB
#define BIT1       2
#define BIT01      3
#define BIT2       4
#define BIT3       8
#define BIT23     12
#define BIT4      16
#define BIT5      32
#define BIT6      64
#define BIT56     96
#define BIT7     128
*/

    switch(cStatus)
    {
        case cNormalRT://0
            if(*cData == DLE) //0x10
            {
                cStatus = cDLERT;//1
            }
            else
            {
                cStatus = cNormalRT;//0
            }
            break;
        case cDLERT://1
            switch(*cData)
            {
            case EOT: //0x04
                cStatus = cEOTRT;//2
                break;
            case ENQ: //0x05
                cStatus = cENQRT;//3
                break;
            default:
                cStatus = cNormalRT;//0
                break;
            }
            break;
            
        case cEOTRT://2
            cStatus = cNormalRT;//0
            switch(*cData)
            {
                case 1:
                    break;
                case 2:
                    if(bTimer2KeyFeed) //电机在按键下走纸;AMO;2018.05.25
                    {
                        cOutData |= BIT3; //BIT3=8
                    }
                    if(bErrPE)
                    {
                        cOutData |= BIT5; //BIT5=32
                    }
                    if(bErrTemperature)
                    {
                        cOutData |= BIT6; //BIT6=64
                    }
                    SerialSendByte(cOutData);
                    break;
                case 3:
                    if(bErrTemperature) //过温错误;0=正常/1=錯誤;AMO;2018.05.25
                    {
                        cOutData |= BIT6;
                    }
                    SerialSendByte(cOutData);
                    break;
                case 4:
                    if(bErrPE) //缺纸错误;0=正常/1=錯誤;AMO;2018.05.25
                    {
                        cOutData |= BIT56;//BIT56=96
                    }
                    SerialSendByte(cOutData);
                    break;
                default:
                break;
            }
            break;
        case cENQRT://3
            cStatus = cNormalRT; //0
            switch(*cData)
            {
            case 0:
                break;
            case 2:
                break;
            default:
                break;
            }
            break;
        default:
            break;
    }
}

