/**
 * @file    Interface.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the Interface firmware
 *          main code.
 * @Description: 打印机与CPU之间的接口头文件 STM32F10XC8(ARM 32-bit Cortex-M3 CPU)
 */
//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［Interface.h］
/********************************************************************
*File Name  : Interface.h
*CPU        : 
*Description: 打印机与CPU之间的接口头文件
*********************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __INTERFACE_H
#define __INTERFACE_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "mg32f10x.h"
#include "PrtConfig.h"
#include "PrtHead.h"
//#include "RcvBuf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
typedef enum
{
    Thermal_ADC,
    Paper_ADC,
    Power,
    ChipTempture
}Typedef_enumADValue;

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

//【GPIO變數宣告】◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇◇
//[UART]:
// ●PB8腳位(PIN.13)，使用於輸出UART0_TX，並設定腳位為PPO(Output Push-pull)
// ●PB9腳位(PIN.14)，使用於輸出UART0_RX，並設定腳位為ODO(Output Open-Drive)
#define TX0                     PB8        //Check-Ok;AMO;2018.05.25
#define RX0                     PB9        //Check-Ok;AMO;2018.05.25

//[MOTOR]:
// ●PB6腳位(PIN.01)，使用熱敏打印模組馬達控制Motor A+腳，並設定腳位為PPO(Output Push-pull)
// ●PB7腳位(PIN.02)，使用熱敏打印模組馬達控制Motor A-腳，並設定腳位為PPO(Output Push-pull)
// ●PB8腳位(PIN.03)，使用熱敏打印模組馬達控制Motor B+腳，並設定腳位為PPO(Output Push-pull)
// ●PB9腳位(PIN.04)，使用熱敏打印模組馬達控制Motor B-腳，並設定腳位為PPO(Output Push-pull)
#define Motor1_on()             (GPIOB->BSRR = GPIO_BSRR_BS6)  // An
#define Motor1_off()            (GPIOB->BSRR = GPIO_BSRR_BR6)  
#define Motor2_on()             (GPIOB->BSRR = GPIO_BSRR_BS7)  // Ap
#define Motor2_off()            (GPIOB->BSRR = GPIO_BSRR_BR7)
#define Motor3_on()             (GPIOB->BSRR = GPIO_BSRR_BS8)  // Bn
#define Motor3_off()            (GPIOB->BSRR = GPIO_BSRR_BR8)
#define Motor4_on()             (GPIOB->BSRR = GPIO_BSRR_BS9)  // Bp
#define Motor4_off()            (GPIOB->BSRR = GPIO_BSRR_BR9)

//[BUTTON]:
// ●PC13腳位(PIN.2)，使用熱敏打印模組暫停/列印測試按鍵STOP(Pause)_SW腳，並設定腳位為PPO(Output Push-pull)
// ●PB4腳位(PIN.56)，使用熱敏打印模組進紙按鍵Feed_Paper_SW腳，並設定腳位為PPO(Output Push-pull)
// ●PD2腳位(PIN.54)，使用熱敏打印模組暫停/列印測試按鍵LED_KEY1_PD2腳，並設定腳位為PPO(Output Push-pull)
// ●PC9腳位(PIN.40)，使用熱敏打印模組暫停/列印測試按鍵LED_KEY2_PC9腳，並設定腳位為PPO(Output Push-pull)
#define PauseKey                (GPIOC->IDR & GPIO_IDR_IDR13)
#define LFKey                   (GPIOB->IDR & GPIO_IDR_IDR4)
#define PD2Key                  (GPIOD->IDR & GPIO_IDR_IDR2)
#define PC9Key                  (GPIOC->IDR & GPIO_IDR_IDR9)

//[LED]:
// ●PB3腳位(PIN.55)，使用熱敏打印模組Power_LED指示燈腳 ，並設定腳位為PPO(Output Push-pull)
// ●PA15腳位(PIN.50)，使用熱敏打印模組Error_LED指示燈腳 ，並設定腳位為PPO(Output Push-pull)
// ●PB5腳位(PIN.57)，使用熱敏打印模組Paper_LED指示燈腳 ，並設定腳位為PPO(Output Push-pull)
// ●PC9腳位(PIN.40)，使用熱敏打印模組PC9_LED指示燈腳 ，並設定腳位為PPO(Output Push-pull)
// ●PD2腳位(PIN.54)，使用熱敏打印模組PD2_LED指示燈腳 ，並設定腳位為PPO(Output Push-pull)
#define Power_LED_off()         (GPIOB->BSRR = GPIO_BSRR_BS3)
#define Power_LED_on()          (GPIOB->BSRR = GPIO_BSRR_BR3)
#define ErrLED_off()            (GPIOA->BSRR = GPIO_BSRR_BS15)
#define ErrLED_on()             (GPIOA->BSRR = GPIO_BSRR_BR15)
#define Paper_LED_off()         (GPIOB->BSRR = GPIO_BSRR_BS5)
#define Paper_LED_on()          (GPIOB->BSRR = GPIO_BSRR_BR5)
#define PC9_LED_off()           (GPIOC->BSRR = GPIO_BSRR_BS9)
#define PC9_LED_on()            (GPIOC->BSRR = GPIO_BSRR_BR9)
#define PD2_LED_off()           (GPIOD->BSRR = GPIO_BSRR_BS2)
#define PD2_LED_on()            (GPIOD->BSRR = GPIO_BSRR_BR2)

//[FLASH]:
// ●PA4腳位(PIN.20)，使用外部字庫讀取SPI通訊FLASH_SPI_CS腳，並設定腳位為PPO(Output Push-pull)
// ●PA5腳位(PIN.21)，使用外部字庫讀取SPI通訊FLASH_SPI_CLK腳，並設定腳位為PPO(Output Push-pull)
// ●PA7腳位(PIN.23)，使用外部字庫讀取SPI通訊FLASH_SPI_MOSI(IO0)腳，並設定腳位為ODO(Output Open-Drive)
// ●PA6腳位(PIN.22)，使用外部字庫讀取SPI通訊FLASH_SPI_MISO(IO1)腳，並設定腳位為PPO(Output Push-pull)
// ●PB0腳位(PIN.26)，使用外部字庫讀取SPI通訊FLASH_SPI_IO2腳，並設定腳位為PPO(Output Push-pull)
// ●PB1腳位(PIN.27)，使用外部字庫讀取SPI通訊FLASH_SPI_IO3腳，並設定腳位為PPO(Output Push-pull)
#define FLASH_SPI_CS()          (GPIOA->IDR & GPIO_IDR_IDR4) 
#define FLASH_SPI_CS_high()     (GPIOA->BSRR = GPIO_BSRR_BS4)
#define FLASH_SPI_CS_low()      (GPIOA->BSRR = GPIO_BSRR_BR4)

#define FLASH_SPI_SCK()         (GPIOA->IDR & GPIO_IDR_IDR5)
#define FLASH_SPI_SCK_high()    (GPIOA->BSRR = GPIO_BSRR_BS5)
#define FLASH_SPI_SCK_low()     (GPIOA->BSRR = GPIO_BSRR_BR5)

#define FLASH_SPI_MOSI()        (GPIOA->IDR & GPIO_IDR_IDR7)
#define FLASH_SPI_MOSI_high()   (GPIOA->BSRR = GPIO_BSRR_BS7)
#define FLASH_SPI_MOSI_low()    (GPIOA->BSRR = GPIO_BSRR_BR7)
#define FLASH_SPI_IO0()         (GPIOA->IDR & GPIO_IDR_IDR7)
#define FLASH_SPI_IO0_high()    (GPIOA->BSRR = GPIO_BSRR_BS7)
#define FLASH_SPI_IO0_low()     (GPIOA->BSRR = GPIO_BSRR_BR7)

#define FLASH_SPI_MISO()        (GPIOA->IDR & GPIO_IDR_IDR6)
#define FLASH_SPI_MISO_high()   (GPIOA->BSRR = GPIO_BSRR_BS6)
#define FLASH_SPI_MISO_low()    (GPIOA->BSRR = GPIO_BSRR_BR6)
#define FLASH_SPI_IO1()         (GPIOA->IDR & GPIO_IDR_IDR6)
#define FLASH_SPI_IO1_high()    (GPIOA->BSRR = GPIO_BSRR_BS6)
#define FLASH_SPI_IO1_low()     (GPIOA->BSRR = GPIO_BSRR_BR6)

#define FLASH_SPI_IO2()         (GPIOB->IDR & GPIO_IDR_IDR0)
#define FLASH_SPI_IO2_high()    (GPIOB->BSRR = GPIO_BSRR_BS0)
#define FLASH_SPI_IO2_low()     (GPIOB->BSRR = GPIO_BSRR_BR0)
#define FLASH_SPI_nWP()         (GPIOB->IDR & GPIO_IDR_IDR0)
#define FLASH_SPI_nWP_protect() (GPIOB->BSRR = GPIO_BSRR_BS0)
#define FLASH_SPI_nWP_unprotect() (GPIOB->BSRR = GPIO_BSRR_BR0)

#define FLASH_SPI_IO3()         (GPIOB->IDR & GPIO_IDR_IDR1)
#define FLASH_SPI_IO3_high()    (GPIOB->BSRR = GPIO_BSRR_BS1)
#define FLASH_SPI_IO3_low()     (GPIOB->BSRR = GPIO_BSRR_BR1)
#define FLASH_SPI_nRESET()      (GPIOB->IDR & GPIO_IDR_IDR1)
#define FLASH_SPI_nRESET_disable() (GPIOB->BSRR = GPIO_BSRR_BS1)
#define FLASH_SPI_nRESET_enable() (GPIOB->BSRR = GPIO_BSRR_BR1)

// ●PA0腳位(PIN.14)，使用熱敏打印模組進紙偵測PRINT_Thermal_ADC腳，並設定腳位為AIO(Analog input)，使用在ADC讀取
// ●PA1腳位(PIN.15)，使用熱敏打印模組進紙偵測PRINT_Paper_ADC腳，並設定腳位為AIO(Analog input)，使用在ADC讀取
#define PRINT_Thermal_ADC       PA0         //Check-Ok;AMO;2018.05.25
#define PRINT_Paper_ADC         PA1         //Check-Ok;AMO;2018.05.25

// ●PB12腳位(PIN.33)，使用熱敏打印模組資料控制PRINT_LAT腳，並設定腳位為PPO(Output Push-pull)
// ●PB13腳位(PIN.34)，使用熱敏打印模組資料控制PRINT_SPI_CLK腳，並設定腳位為PPO(Output Push-pull)
// ●PB14腳位(PIN.35)，使用熱敏打印模組資料控制PRINT_SPI_MISO腳，並設定腳位為PPO(Output Push-pull)
// ●PB15腳位(PIN.36)，使用熱敏打印模組資料控制PRINT_SPI_MOSI腳，並設定腳位為PPO(Output Push-pull)
#define TPH_LAT_on()            (GPIOB->BSRR = GPIO_BSRR_BS12)
#define TPH_LAT_off()           (GPIOB->BSRR = GPIO_BSRR_BR12)

#define TPH_CLK()               (GPIOB->IDR & GPIO_IDR_IDR13)
#define TPH_CLK_high()          (GPIOB->BSRR = GPIO_BSRR_BS13)
#define TPH_CLK_low()           (GPIOB->BSRR = GPIO_BSRR_BR13)

#define TPH_DO()                (GPIOB->IDR & GPIO_IDR_IDR14)
#define TPH_DO_high()           (GPIOB->BSRR = GPIO_BSRR_BS14)
#define TPH_DO_low()            (GPIOB->BSRR = GPIO_BSRR_BR14)

#define TPH_DI()                (GPIOB->IDR & GPIO_IDR_IDR15)
#define TPH_DI_high()           (GPIOB->BSRR = GPIO_BSRR_BS15)
#define TPH_DI_low()            (GPIOB->BSRR = GPIO_BSRR_BR15)

//[Thermal Print Head,TPH]:
// ●PB10腳位(PIN.30)，使用熱敏打印模組加熱控制STB123腳，並設定腳位為PPO(Output Push-pull)
// ●PB11腳位(PIN.29)，使用熱敏打印模組加熱控制STB456腳，並設定腳位為PPO(Output Push-pull)
// ●PB2腳位(PIN.28)，使用熱敏打印模組加熱控制STB456腳，並設定腳位為PPO(Output Push-pull)
// ●PC6腳位(PIN.37)，使用熱敏打印模組加熱控制STB123腳，並設定腳位為PPO(Output Push-pull)
// ●PC7腳位(PIN.38)，使用熱敏打印模組加熱控制STB456腳，並設定腳位為PPO(Output Push-pull)
// ●PC8腳位(PIN.39)，使用熱敏打印模組加熱控制STB123腳，並設定腳位為PPO(Output Push-pull)
#define PrtStb123()             (GPIOB->IDR & GPIO_IDR_IDR10)
#define PrtStb123_on()          (GPIOB->BSRR = GPIO_BSRR_BS10)
#define PrtStb123_off()         (GPIOB->BSRR = GPIO_BSRR_BR10)

#define PrtStb456()             (GPIOB->IDR & GPIO_IDR_IDR11)
#define PrtStb456_on()          (GPIOB->BSRR = GPIO_BSRR_BS11)
#define PrtStb456_off()         (GPIOB->BSRR = GPIO_BSRR_BR11)

#define PrtStb12()              (GPIOB->IDR & GPIO_IDR_IDR10)
#define PrtStb12_on()           (GPIOB->BSRR = GPIO_BSRR_BS10)
#define PrtStb12_off()          (GPIOB->BSRR = GPIO_BSRR_BR10)

#define PrtStb34()              (GPIOB->IDR & GPIO_IDR_IDR2)
#define PrtStb34_on()           (GPIOB->BSRR = GPIO_BSRR_BS2)
#define PrtStb34_off()          (GPIOB->BSRR = GPIO_BSRR_BR2)

#define PrtStb56()              (GPIOB->IDR & GPIO_IDR_IDR11)
#define PrtStb56_on()           (GPIOB->BSRR = GPIO_BSRR_BS11)
#define PrtStb56_off()          (GPIOB->BSRR = GPIO_BSRR_BR11)

#define PrtStb1()               (GPIOB->IDR & GPIO_IDR_IDR10)
#define PrtStb1_on()            (GPIOB->BSRR = GPIO_BSRR_BS10)
#define PrtStb1_off()           (GPIOB->BSRR = GPIO_BSRR_BR10)

#define PrtStb2()               (GPIOC->IDR & GPIO_IDR_IDR6)
#define PrtStb2_on()            (GPIOC->BSRR = GPIO_BSRR_BS6)
#define PrtStb2_off()           (GPIOC->BSRR = GPIO_BSRR_BR6)

#define PrtStb3()               (GPIOB->IDR & GPIO_IDR_IDR2)
#define PrtStb3_on()            (GPIOB->BSRR = GPIO_BSRR_BS2)
#define PrtStb3_off()           (GPIOB->BSRR = GPIO_BSRR_BR2)

#define PrtStb4()               (GPIOC->IDR & GPIO_IDR_IDR7)
#define PrtStb4_on()            (GPIOC->BSRR = GPIO_BSRR_BS7)
#define PrtStb4_off()           (GPIOC->BSRR = GPIO_BSRR_BR7)

#define PrtStb5()               (GPIOB->IDR & GPIO_IDR_IDR11)
#define PrtStb5_on()            (GPIOB->BSRR = GPIO_BSRR_BS11)
#define PrtStb5_off()           (GPIOB->BSRR = GPIO_BSRR_BR11)

#define PrtStb6()               (GPIOC->IDR & GPIO_IDR_IDR6)
#define PrtStb6_on()            (GPIOC->BSRR = GPIO_BSRR_BS6)
#define PrtStb6_off()           (GPIOC->BSRR = GPIO_BSRR_BR6)

//#include "PrtConfig.h"  //AMO註解;AMO;2018.05.25

//FLASH CS
//#define FLASH_CS_SET        (GPIO_SetBits(GPIOB, GPIO_Pin_12))    //AMO註解;AMO;2018.05.25
//#define FLASH_CS_RESET      (GPIO_ResetBits(GPIOB, GPIO_Pin_12))  //AMO註解;AMO;2018.05.25

//KEY
//#define LFKey               (GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_7)) //AMO註解;AMO;2018.05.25

//ERRLED
//#define ErrLED_OFF          (GPIO_ResetBits(GPIOA, GPIO_Pin_4))           //Check-Ok;AMO;2018.05.25 //AMO註解;AMO;2018.05.25
//#define ErrLED_ON           (GPIO_SetBits(GPIOA, GPIO_Pin_4))             //Check-Ok;AMO;2018.05.25 //AMO註解;AMO;2018.05.25


//CBUSY
//#define USBBusy_ON          (SetEPRxStatus(ENDP3, EP_RX_NAK))             //USB Busy //沒用到;AMO註解;AMO;2018.05.25
//#define USBBusy_OFF         (SetEPRxStatus(ENDP3, EP_RX_VALID))           //USB Free //沒用到;AMO註解;AMO;2018.05.25
//#define USARTBusy_ON        (GPIO_SetBits(GPIOB, GPIO_Pin_5))             //沒用到 ;AMO註解;AMO;2018.05.25
//#define USARTBusy_OFF       (GPIO_ResetBits(GPIOB, GPIO_Pin_5))           //沒用到 ;AMO註解;AMO;2018.05.25
//#define busy                (GPIO_ReadOutputDataBit(GPIOB, GPIO_Pin_5))   //沒用到 ;AMO註解;AMO;2018.05.25
//#define Busy_ON             (PrinterBusy(1))                              //Check-Ok;AMO;2018.05.25 //AMO註解;AMO;2018.05.25
//#define Busy_OFF            (PrinterBusy(0))                              //Check-Ok;AMO;2018.05.25 //AMO註解;AMO;2018.05.25

//USB Connect
//#define USB_Connect         (GPIO_SetBits(GPIOB, GPIO_Pin_8))             //沒用到;AMO註解 ;AMO;2018.05.25
//#define USB_Disconnect      (GPIO_ResetBits(GPIOB, GPIO_Pin_8))           //沒用到;AMO註解 ;AMO;2018.05.25

//LAT
//#define LAT_ON              (GPIO_SetBits(GPIOB, GPIO_Pin_6))             //Check-Ok;AMO;2018.05.25 //沒用到;AMO註解;AMO;2018.05.25
//#define LAT_OFF             (GPIO_ResetBits(GPIOB, GPIO_Pin_6))           //Check-Ok;AMO;2018.05.25 //沒用到;AMO註解;AMO;2018.05.25


//---------------------------------------------------------------------------------------------------------------------------------
//Timer for System
#define Timer_SetCounter(value)         TIM_SetCounter(TIM4, value)     // Recover 2022/08/23 PoJen
#define Timer_Enable()                  TIM_Cmd(TIM4, ENABLE)           // Recover 2022/08/23 PoJen
#define Timer_Disable()                 TIM_Cmd(TIM4, DISABLE)          // Recover 2022/08/23 PoJen

//LF Motor Timer
#define LFTimer_Enable()                TIM_Cmd(TIM3, ENABLE)           // Recover 2022/08/23 PoJen
#define LFTimer_Disable()               TIM_Cmd(TIM3, DISABLE)          // Recover 2022/08/23 PoJen
#define LFTimer_SetCounter(value)       TIM_SetCounter(TIM3, value)     // Recover 2022/08/23 PoJen
//#define LFTimer_SetAutoreload(value)    TIM_SetAutoreload(TIM3, value)  // Delete 2022/08/23 PoJen

//Prt Timer
#define PrtTimer_Enable()               TIM_Cmd(TIM2, ENABLE)           // Recover 2022/08/23 PoJen
//#define PrtTimer_Disable()              TIM_Cmd(TIM2, DISABLE)          //Delete;AMO;2018.05.25
#define PrtTimer_SetCounter(value)      TIM_SetCounter(TIM2, value)     // Recover 2022/08/23 PoJen
//#define PrtTimer_SetAutoreload(value)   TIM_SetAutoreload(TIM2, value)  //Delete;AMO;2018.05.25

//Interrupt Switch
//#define CloseAllInt()                   (__set_PRIMASK(1))              // Recover 2022/08/23 PoJen
//#define OpenAllInt()                    (__set_PRIMASK(0))              // Recover 2022/08/23 PoJen

#define CloseAllInt()                   __NOP()                         // Recover 2022/08/23 PoJen
#define OpenAllInt()                    __NOP()                         // Recover 2022/08/23 PoJen


//SystemReset
//#define SystemReset     (NVIC_SystemReset())                     //沒使用，註解;AMO;2018.06.20

//Load  WDG
//#define IWDG_Reload     (IWDG_ReloadCounter())                   //沒使用，註解;AMO;2018.06.20

//Start ADC
//#define ADC_Conversion  (ADC_SoftwareStartConvCmd(ADC1, ENABLE)) //沒使用，註解;AMO;2018.06.20

//Prt Stb
//#define PrtStb123_ON       (GPIO_SetBits(GPIOB, GPIO_Pin_10))    //註解；AMO;2018.06.20	
//#define PrtStb123_OFF      (GPIO_ResetBits(GPIOB, GPIO_Pin_10))  //註解；AMO;2018.06.20	
//#define PrtStb456_ON       (GPIO_SetBits(GPIOB, GPIO_Pin_11))    //註解；AMO;2018.06.20	
//#define PrtStb456_OFF      (GPIO_ResetBits(GPIOB, GPIO_Pin_11))  //註解；AMO;2018.06.20	

//Cash
//#define bCash_ON           (GPIO_SetBits(GPIOA, GPIO_Pin_8))     //註解；AMO;2018.06.20	
//#define bCash_OFF          (GPIO_ResetBits(GPIOA, GPIO_Pin_8))　 //註解；AMO;2018.06.20	

//Motor
//#define Motor1_on()          (GPIO_SetBits(GPIOA, GPIO_Pin_3))     //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor1_off()         (GPIO_ResetBits(GPIOA, GPIO_Pin_3))   //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor2_on()          (GPIO_SetBits(GPIOA, GPIO_Pin_2))     //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor2_off()         (GPIO_ResetBits(GPIOA, GPIO_Pin_2))   //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor3_on()          (GPIO_SetBits(GPIOA, GPIO_Pin_0))     //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor3_off()         (GPIO_ResetBits(GPIOA, GPIO_Pin_0))   //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor4_on()          (GPIO_SetBits(GPIOA, GPIO_Pin_1))     //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	
//#define Motor4_off()         (GPIO_ResetBits(GPIOA, GPIO_Pin_1))   //Check-Ok;AMO;2018.05.25 //註解；AMO;2018.06.20	

//---------------------------------------------------------------------------------------------------------------------

#if(GB2312 == 1)//2M FLASH
    /*
    25VF016B-75-4I-S2AF
    共2M Byte  
    共32个块（Block）
    每个块大小为 64K 字节，
    每个块又分为 16个扇区（Sector）
    每个扇区 4K 个字节。
    總共有512(32*16)扇区
    */

    /*
    W25Q32；目前使用晶片;AMO;2018.06.20
    共4M Byte  
    共64个块（Block）
    每个块大小为 64K 字节，
    每个块又分为 16个扇区（Sector）
    每个扇区 4K 个字节(byte)。
    總共有1024(128*16)扇区
    */
    
    /*
    W25Q64
    共8M Byte  
    共128个块（Block）
    每个块大小为 64K 字节，
    每个块又分为 16个扇区（Sector）
    每个扇区 4K 个字节(byte)。
    總共有2048(128*16)扇区
    */

    /* 	
    字库存放分为以下6个部分:
    1>Part1 : 0000~EDEF             汉字  A1~A9区 24x24
    2>Part2: EDF0~18C8F              FontB 9x24 (其中EDF0~F80F 为ASCII 0x20~0x7F,其余为代码页)
    代码页为：page0~page 5 , page 16~page19, page 255 .
    3>Part3: 18C90~8FC0F            汉字 B0~F7区  24x24
    4>Part4 : 8FC10~B060F           code  page 0~code   page 32, page 255    12x24
    5>Part3: B0610~E780F            code  page 50~code  page 96              12x24
    6>Part2: E7810~E858F            ASCII 0x20~0x7F                          12X24
    */
    #define BaseAddr1_24x24            0x000000//~0x00EDEF 
    #define BaseAddr_9x24              0x00EDF0//~0x00F80F
    #define ExtendedBaseAddr_9x24      0x00F810//~0x018C8F 
    #define BaseAddr2_24x24            0x018C90//~0x08FC0F
    #define ExtendedBaseAddr1_12x24	   0x08FC10//~0x0B060F
    #define ExtendedBaseAddr2_12x24	   0x0B0610//~0x0E780F
    #define BaseAddr_12x24             0x0E7810//~0x0E858F
    #define UserParameterBaseAddr      0x0E9000//~0x0E9FFF  4Kbyte       //使用者參數設定位址；AMO;2018.06.20	
    #define UserCharAddr_12x24         0x0EA000//~0x149FFF  96*4K
    #define UserCharAddr_9x17          0x0EA000//~0x149FFF  96*4K
    #define UserCharAddr_24x24         0x14A000//~0x1A9FFF  93*4K
    #define NvImageBaseAddr            0x1AA000//~0x1BEFFF  5*16k        //(可放5張圖片，每幅图片最大16Kbyte)  //放置到FLASH 中的位图(logo圖)；AMO;2018.06.20
    #define UndefinedAddr              0x1BF000//~0x1FFFFF

    #define ZKBlockSize_12x24          0x1200
    #define ZKBlockSize_9x24           0x0D80
#endif

#define SerialBauRateAddr           0x00001
#define BlueToothBauRateAddr        0x00002
#define CharacterModeAddr           0x00003
#define DensitySelectAddr           0x00004
#define CodePageAddr                0x00005
#define OnlyRcvBufferFullBusy       0x00006
#define BING5MA                     0x00007

//PC25VF080B 8Mbit SPI Serial Flash op code
#define FLASH_JEDEC_ID              0x9F
#define FLASH_DeviceID              0xAB
#define FLASH_ByteProgram           0x02
#define FLASH_ReadData              0x03
#define FLASH_WriteDisable          0x04
#define FLASH_ReadStatusReg         0x05
#define FLASH_WriteStatusReg        0x01
#define FLASH_ReadStatusReg1        0x05
#define FLASH_WriteStatusReg1       0x01
#define FLASH_ReadStatusReg2        0x35
#define FLASH_WriteStatusReg2       0x31
#define FLASH_ReadStatusReg3        0x15
#define FLASH_WriteStatusReg3       0x11
#define FLASH_WriteEnable           0x06
#define FLASH_FastReadData          0x0B
#define FLASH_4KSectorErase         0x20
#define FLASH_EnWriteSR             0x50
#define FLASH_AAIWordProgram        0xAD
#define FLASH_ChipErase             0xC7

#define DensitySetTimeLevel1        800   //AMO實測修改;AMO;2018.05.25
#define DensitySetTimeLevel2        1400  //AMO實測修改;AMO;2018.05.25
#define DensitySetTimeLevel3        2000  //AMO實測修改;AMO;2018.05.25
#define DensitySetTimeLevel4        2600  //AMO實測修改;AMO;2018.05.25
#define DensitySetTimeLevel5        3000  //AMO實測修改;AMO;2018.05.25

#define BAUDRATE9600                9600
#define BAUDRATE19200               19200
#define BAUDRATE38400               38400
#define BAUDRATE57600               57600
#define BAUDRATE115200              115200

extern uint32_t iBaudRate;

extern __IO uint16_t AD_Value[2];
extern uint8_t  Zimotemp[72]; 

extern void Cpu_Init(void);
extern uint16_t Sample_ADC_Conversion(Typedef_enumADValue DetSource);
extern void Interface_Config(void);     // Reconver 2022/08/30 PoJen
extern void UART_Configuration(void);   // Reconver 2022/08/30 PoJen
extern void SerialSendByte(uint8_t SendByte);
extern void LFMotorPhaseSet(uint8_t Phase);

//extern void SPI_Send_Byte(uint8_t out); //AMO註解;AMO;2018.05.25
extern uint8_t SPI_Read_Byte(uint32_t Dst_Addr);
extern void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte);
extern void SPI_Erase_Sector(uint32_t Dst_Addr);

extern void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
extern void SPI_FastRead_nBytes(uint32_t Dst_Addr,uint8_t *Data , uint32_t nBytes);
extern void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);

extern void PrtStbAllStatus(uint8_t Status);
//extern void PrinterBusy(uint8_t Status); //;AMO註解;AMO;2018.05.25

extern void SendnBytes_To_Head(uint8_t *pData, uint8_t nByte);
extern uint8_t SPI_Read_ID1(void);//;AMO新增;AMO;2018.05.25


//extern void SYS_ITEA_Cmd(uint32_t CMD);
extern void TIM2_Heater_Delay(uint32_t cTime);
extern void TIM3_Motor_Delay(uint32_t cTime);
extern void TIM4_System_Delay(uint32_t cTime);


#ifdef __cplusplus
}
#endif

#endif /* __INTERFACE_H */

