/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "PCconnect.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//[UART]:
// ●PB8腳位(PIN.13)，使用於輸出UART0_TX，並設定腳位為PPO(Output Push-pull)
// ●PB9腳位(PIN.14)，使用於輸出UART0_RX，並設定腳位為ODO(Output Open-Drive)
#define TX0              //PB8        //Check-Ok;AMO;2018.05.25
#define RX0              //PB9        //Check-Ok;AMO;2018.05.25


/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

static UART_InitTypeDef UART_InitStructure;
void PCconnect_Initial(void)
{
  // USB
    // PA11 ANA DM, PA12 ANA DM, PA8 USB Det.
    // GPIO_Init(GPIOA, GPIO_Pin_11, GPIO_MODE_ANA | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOA, GPIO_Pin_12, GPIO_MODE_ANA | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOA, GPIO_Pin_8, GPIO_MODE_IN | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);


  // URT Initial
    /* UART1 115200 to PC */
    // PA9 TX AF7, PA10 RX AF7
    GPIO_Init(GPIOA, GPIO_Pin_9, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    GPIO_Init(GPIOA, GPIO_Pin_10, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);

    /* UART configuration */
    UART_DeInit(UART1);
    UART_InitStructure.UART_BaudRate = 115200;
    UART_InitStructure.UART_WordLength = UART_WordLength_8b;
    UART_InitStructure.UART_StopBits = UART_StopBits_One;
    UART_InitStructure.UART_Parity = UART_Parity_None;
    UART_InitStructure.UART_AutoFlowControl = UART_AutoFlowControl_None;
    UART_Init(UART1, &UART_InitStructure);
    UART_FIFOCmd(UART1, ENABLE);


    /* UART2 for Debug */
    // PA2 TX AF7, PA3 RX AF7
    GPIO_Init(GPIOA, GPIO_Pin_2, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);

    /* UART configuration */
    UART_DeInit(UART2);
    UART_InitStructure.UART_BaudRate = 921600;
    UART_InitStructure.UART_WordLength = UART_WordLength_8b;
    UART_InitStructure.UART_StopBits = UART_StopBits_One;
    UART_InitStructure.UART_Parity = UART_Parity_None;
    UART_InitStructure.UART_AutoFlowControl = UART_AutoFlowControl_None;
    UART_Init(UART2, &UART_InitStructure);
    UART_FIFOCmd(UART2, ENABLE);

    /* UART3 for Ext Connect */
    // PC10 TX AF7, PC11 RX AF7, PC12 CLK or ExInt
    // GPIO_Init(GPIOC, GPIO_Pin_10, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_11, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_12, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_12, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    
}

//=========================================================================================================
//* Function name:  BlueTooth_Configuration    
//* Descriptions :  串口1(蓝牙通信)配置
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void USART_Configuration(void)
{
    USART_InitTypeDef USART_InitStructure;

    USART_InitStructure.USART_BaudRate = iBaudRate;
    USART_InitStructure.USART_WordLength = USART_WordLength_8b;
    USART_InitStructure.USART_StopBits = USART_StopBits_1;
    USART_InitStructure.USART_Parity = USART_Parity_No;
    USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
    USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;

    USART_Init(USART1, &USART_InitStructure);
    USART_ITConfig(USART1,  USART_IT_RXNE, ENABLE);
    USART_Cmd(USART1, ENABLE);
}
*/


//=========================================================================================================
//* Function name:   SerialSendByte
//* Descriptions :    串口发送一个字节
//=========================================================================================================
void SerialSendByte(uint8_t SendByte)
{
    //URT_SetTXData(URT0 , 1 , SendByte); //；AMO;2018.06.20  // from MG32x02z_URT_DRV

    /*//AMO註解;AMO;2018.05.25
    USART_SendData(USART1,SendByte);  //从串口1发送数据
    while(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET)  //等待发送完一个数据
    {
        ;
    }
    */
}


//=========================================================================================================
//* Function name:   Interface_Configuration    
//* Descriptions :   打印机通信接口选择函数
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
void Interface_Config(void)
{
    //USART_Configuration();//Bluetooth and Wifi  Configuration //AMO註解;AMO;2018.05.25
}
*/


//=========================================================================================================
//* Function name:    PrinterBusy    
//* Descriptions :    打印机忙信号控制
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
void PrinterBusy(uint8_t Status)
{
    if(Status)
    {
        //USBBusy_ON;      //Usb   Busy  //AMO註解;AMO;2018.05.25
        //USARTBusy_ON;    //USART    Busy //AMO註解;AMO;2018.05.25
    }
    else
    {
        //USBBusy_OFF;    //Usb   Free  //AMO註解;AMO;2018.05.25
        //USARTBusy_OFF;  //USART    Free //AMO註解;AMO;2018.05.25
    }
}
*/

