




/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "Interface.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/



//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［Interface.c］
//=========================================================================================================
//*File Name      : Interface.c
//*CPU            : STM32F10XVC(ARM 32-bit Cortex-M3 CPU)
//*Description    : 打印机与CPU之间的接口源文件
//=========================================================================================================
#define ADC1_DR_Address    ((uint32_t)0x4001244C)

uint32_t  iBaudRate;

__IO uint16_t AD_Value[2];

uint8_t Zimotemp[72];

//void RCC_Configuration(void);     //AMO註解;AMO;2018.05.25
//void GPIO_Configuration(void);    //AMO註解;AMO;2018.05.25
//void NVIC_Configuration(void);    //AMO註解;AMO;2018.05.25
//void SysTick_Configuration(void); //AMO註解;AMO;2018.05.25
//void Tim_Configuration(void);     //AMO註解;AMO;2018.05.25
//void USART_Configuration(void);   //AMO註解;AMO;2018.05.25
//void ADC_Configuration(void);     //AMO註解;AMO;2018.05.25
//void SPI_Configuration(void);     //AMO註解;AMO;2018.05.25
//void DMA_Configuration(void);     //AMO註解;AMO;2018.05.25
void IWDG_Configuration(void);    //沒使用，註解;AMO;2018.06.20
//void FLASH_ReadProtection(void);  //沒使用，註解;AMO;2018.06.20
void Cpu_Init(void);
//void PrinterBusy(uint8_t Status); //;AMO註解;AMO;2018.05.25
void SerialSendByte(uint8_t SendByte);

//PCT25VF080B
uint8_t SPI_Read_StatusReg(void);
uint8_t SPI_Read_StatusReg1(void);
uint8_t SPI_Read_StatusReg2(void);
uint8_t SPI_Read_StatusReg3(void);
uint32_t SPI_Read_JEDEC_ID(void);
uint8_t SPI_Read_ID1(void);
uint8_t SPI_Read_Byte(uint32_t Dst_Addr);
uint8_t SPI_FastRead_Byte(uint32_t Dst_Addr);
//uint8_t SPI_Get_Byte(void);;AMO註解;AMO;2018.05.25

void SPI_EnWrite_StatusReg(void);
void SPI_Write_StatusReg(uint8_t byte);
void SPI_Write_StatusReg1(uint8_t byte);
void SPI_Write_StatusReg2(uint8_t byte);
void SPI_Write_StatusReg3(uint8_t byte);
void SPI_Write_Enable(void);
void SPI_Write_Disable(void);
void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
void SPI_FastRead_nBytes(uint32_t Dst_Addr,uint8_t *Data , uint32_t nBytes);
void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte);
void SPI_Write_2Bytes(uint32_t Dst_Addr, uint8_t Data1,uint8_t Data2);
void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
//void SPI_Erase_Chip(void);                //沒用到;AMO註解;AMO;2018.05.25
void SPI_Erase_Sector(uint32_t Dst_Addr);
void SPI_Wait_Busy(void);
//void SPI_Send_Byte(uint8_t out);          //;AMO註解;AMO;2018.05.25

//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［Interface.c］
//=========================================================================================================
//* Function name:     RCC_Configuration
//* Descriptions :     系统时钟配置
//=========================================================================================================
void RCC_Configuration(void)//Check-Ok;AMO;2018.05.25
{
//    ErrorStatus HSEStartUpStatus;
//    //RCC system reset(for debug purpose)
//    RCC_DeInit();

//    // Enable HSE
//    RCC_HSEConfig(RCC_HSE_ON); //啟動使用外部OSC，目前外部是裝8MHz晶振;AMO;2018.05.25

//    // Wait till HSE is ready
//    HSEStartUpStatus = RCC_WaitForHSEStartUp();

//    if(HSEStartUpStatus == SUCCESS)
//    {
//        // HCLK = SYSCLK  
//        RCC_HCLKConfig(RCC_SYSCLK_Div1);   //AHB=SYSCLK=72Mhz;AMO;2018.05.25
//        
//        // PCLK2 = HCLK 
//        RCC_PCLK2Config(RCC_HCLK_Div1);    //PCLK2=HCLK=APB2=AHB=SYSCLK=72Mhz;AMO;2018.05.25

//        // PCLK1 = HCLK/2 
//        RCC_PCLK1Config(RCC_HCLK_Div2);    //PCLK1=HCLK/2=72Mhz/2=36Mhz;AMO;2018.05.25

//        // USBCLK = PLLCLK / 1.5 
//        RCC_USBCLKConfig(RCC_USBCLKSource_PLLCLK_1Div5); //USBCLK=PLLCLK/1.5=72Mhz/1.5=48Mhz;AMO;2018.05.25

//        // ADC=HCLK/8 
//        RCC_ADCCLKConfig(RCC_PCLK2_Div8);  //ADCCLK=HCLK/8=9Mhz;AMO;2018.05.25

//        // Flash 2 wait state 
//        FLASH_SetLatency(FLASH_Latency_2); //FLASH时序延迟几个周期，等待总线同步操作。推荐按照单片机系统运行频率，0—24MHz时，取Latency=0；24—48MHz时，取Latency=1；48~72MHz时，取Latency=2。所有程序中必须的;AMO;2018.05.25 

//        // Enable Prefetch Buffer 
//        FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);//开启FLASH预读缓冲功能，加速FLASH的读取。所有程序中必须的 ;AMO;2018.05.25 

//        // PLLCLK = 8MHz * 9 = 72 MHz
//        RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);//PLLCLK = 8MHz(HSE) * 9 = 72 MHz;AMO;2018.05.25 

//        // Enable PLL
//        RCC_PLLCmd(ENABLE);

//        // Wait till PLL is ready 
//        while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET)
//        {
//        }

//        // Select PLL as system clock source 
//        RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);

//        // Wait till PLL is used as system clock source
//        while(RCC_GetSYSCLKSource() != 0x08)
//        {
//        }
//    }

//    // DMA clock enable
//    //RCC_ClocksTypeDef RCC_Clocks;
//    //SystemInit();
//    //RCC_GetClocksFreq(&RCC_Clocks);

//    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE); // // 啟動 DMA1 時脈 ;AMO;2018.05.25 
//    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2 | RCC_APB1Periph_TIM3 | RCC_APB1Periph_TIM4 | RCC_APB1Periph_USB |
//    RCC_APB1Periph_SPI2, ENABLE );
//    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB |RCC_APB2Periph_USART1 |RCC_APB2Periph_AFIO|  //STM32 的所有 GPIO 都引入到 EXTI 外部中断线上，使得所有的 GPIO 都能作为外部中断的输入源。所以如果把 GPIO 用作 EXTI 外部中断时，还需要开启 AFIO 时钟。例如 AFIO_EXTICRX 用于选择 EXTIx 外部中断的输入源。;AMO;2018.05.25  
//    RCC_APB2Periph_ADC1 | RCC_APB2Periph_SPI1, ENABLE);

//=====================================================================================================================
    /* Disable ANCTL register write-protection */
    PWR_UnlockANA();

    /* Enable HSE */
    ANCTL_HSEConfig(ANCTL_HSE_ON);

    /* Wait till HSE is ready */
    if (ANCTL_WaitForHSEStartUp() == ERROR)
    {
        /* HSE failed */
        while (1);
    }

    /* Configure Flash prefetch, Cache and wait state */
    CACHE->CR = (CACHE_CR_CHEEN | CACHE_CR_HIFREQ | CACHE_CR_PREFEN_ON | CACHE_CR_LATENCY_6WS);

    /* AHBCLK = MAINCLK */
    RCC_AHBCLKConfig(RCC_MAINCLK_Div2);

    /* Enable APB1CLK. APB1CLK = MAINCLK */
    RCC_APB1CLKConfig(RCC_MAINCLK_Div1, ENABLE);

    /* Enable APB2CLK. APB2CLK = MAINCLK */
    RCC_APB2CLKConfig(RCC_MAINCLK_Div1, ENABLE);

    /* PLL configuration: PLLCLK = MHSI(8MHz) * 12 = 96 MHz */
    RCC_PLLSourceConfig(RCC_PLLSource_HSE_Div4, ENABLE);

    //RCC_PLLSourceConfig(RCC_PLLSource_MHSI_Div2, ENABLE);
    ANCTL_PLLConfig(ANCTL_PLLMul_24);

    /* Enable PLL */
    ANCTL_PLLCmd(ENABLE);

    /* Wait till PLL is ready */
    while(ANCTL_GetFlagStatus(ANCTL_FLAG_PLLRDY) == RESET);

    ANCTL_SARADCCmd(ENABLE);
    ANCTL->BGCR2 |= 0x02;
  
    /* Enable ANCTL register write-protection */
    PWR_LockANA();

    /* Select PLL as system clock source */
    RCC_MAINCLKConfig(RCC_MAINCLKSource_PLLCLK);

    /* Enable Periph clock */
    RCC_APB1PeriphClockCmd(RCC_APB1Periph_BMX1 | \
                           RCC_APB1Periph_GPIOA | \
                           RCC_APB1Periph_GPIOB | \
                           RCC_APB1Periph_GPIOC | \
                           RCC_APB1Periph_GPIOD | \
                           RCC_APB1Periph_EXTI | \
                           RCC_APB1Periph_AFIO | \
                           RCC_APB1Periph_UART1 | \
                           RCC_APB1Periph_QSPI | \
                           RCC_APB1Periph_ADC | \
                           RCC_APB1Periph_TIM1 | \
                           RCC_APB1Periph_TIM2 | \
                           RCC_APB1Periph_TIM3 | \
                           RCC_APB1Periph_TIM4, ENABLE);

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_WWDG | \
                           RCC_APB2Periph_BMX2 | \
                           RCC_APB2Periph_UART2 | \
                           RCC_APB2Periph_SPIM2, ENABLE);
}

//=========================================================================================================
//* Function name:    GPIO_Configuration
//* Descriptions :    GPIO模式配置
//=========================================================================================================
void GPIO_Configuration(void)//Check-Ok;AMO;2018.05.25
{
/*
    //[GPIOA]
    GPIO_InitTypeDef GPIO_InitStructure;
    //Motor 4 Motor 3 Motor 2 Motor 1
    //PA0, PA1, PA2, PA3 ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 |GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_3;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //PE ErrorLed
    //PA4 ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //SPI1 CLK  DO 
    //PA5=SPI1_CLK;PA7=SPI1_MOSI ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5 |GPIO_Pin_7;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP; //因為該腳位是使用了晶片外設功能，故該腳位需選擇復用推挽輸出，而不是推挽輸出;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //Cash 
    //PA8=Cash; 目前沒有使用開啟零錢櫃功能;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //USART1  TX=>BT TXD 
    //PA9=USART1_TX ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;//因為該腳位是使用了晶片外設功能，故該腳位需選擇復用推挽輸出，而不是推挽輸出;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //USART1 RX=>BTRXD 
    //PA9=USART1_RX ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;//浮空输入，复位后的状态;AMO;2018.05.25
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //USB DP DM 
    //PA11=USB_DM;PA12=USB_DP ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11 |GPIO_Pin_12;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    //[GPIOB]

    //PE  TM 
    //PB0=紙張缺紙偵測;PB1=機芯溫度感測 ;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0|GPIO_Pin_1;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN; //類比輸入;AMO;2018.05.25
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //Busy 
    //PB5=打印裝置透過這根腳位，來通知／指示目前裝置的工作狀態，該腳位會接到RS232的CTS(PIN.8);AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //Print LAT 
    //PB6=打印資料栓鎖腳位，透過這根腳位將資籵栓鎖在模組內;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //LF Key 
    //PB7=紙張進紙按鍵;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_7;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;//上拉输入，这里的上拉是指单片机内部的电阻;AMO;2018.05.25
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //USB Connect 
    //PB8=USB_UP;用來指示電腦有USB裝置掛起通知,這根腳位目前未來不會使用;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //USB VBus 
    //PB9=USB_VBUS;用來指示裝置，目前外部有USB連接線插入;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //STB123 STB456 
    //PB10=STB123;PB11=STB456;打印裝置透過這根腳位，來啟動執行熱敏打印的動作;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 |GPIO_Pin_11; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //FLASH CS 
    //BP12=SPI2_CS;用於FLASH晶片控制;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //SPI2 CLK  DO 
    //BP13=SPI2_CLK;BP15=SPI2_MOSI;用於FLASH晶片控制;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 |GPIO_Pin_15;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //SPI2 DI 
    //BP14=SPI2_MISO;用於FLASH晶片控制;AMO;2018.05.25
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
    //GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

    //USB Vbus
    //PB9 = USB_VBUS;用來指示裝置，目前外部有USB連接線插入;AMO;2018.05.25
    //初始化後，設PB9=0;AMO;2018.05.25
    GPIO_ResetBits(GPIOB,GPIO_Pin_9);
*/
}


//=========================================================================================================
//* Function name:    NVIC_Configuration
//*
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void NVIC_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    NVIC_InitTypeDef NVIC_InitStructure;

    //;AMO;2018.05.25 
    //4.NVIC_SetVectorTable函数的功能是设置向量表的位置和偏移。其中输入参数中，对于32位的OFFSET向量表基地址的偏移量对于FLASH，参数值必须高于0x08000100，对于RAM必须高于0X100.
    //例：对FLASH指定向量表基地址偏移量
    NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x00000);  //设置中断向量表位置;AMO;2018.05.25 

    NVIC_PriorityGroupConfig(NVIC_PriorityGroup_3);//抢占3位(0-7 )，从1位(0 - 1)

    NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 3;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;  
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    NVIC_InitStructure.NVIC_IRQChannel = TIM3_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;  
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;  
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    NVIC_InitStructure.NVIC_IRQChannel = USB_LP_CAN1_RX0_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    NVIC_InitStructure.NVIC_IRQChannel = TIM4_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 4;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;  
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}
*/

//=========================================================================================================
//* Function name:   Tim_Configuration
//* Descriptions :   3个定时器配置
//=========================================================================================================
//沒使用，註解;AMO;2018.06.20
void Tim_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    //;AMO;2018.05.25
    //定时时间计算：
    //TIM_Prescaler=71; TIM_Period=65535;
    //((1+TIM_Prescaler )/72M)*(1+TIM_Period )=((1+71)/72M)*(1+65535)=0.065536秒=15.258Hz 

    static TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
    //static NVIC_InitTypeDef NVIC_InitStructure;

//-----------------------------------------------------------------------------
    /***************************************************************************
    * Timer2，加热定时器
    **************************************************************************/
    TIM_TimeBaseStructure.TIM_Period = 0xFFFF;                  //TIM_Period设置了在下一个更新事件装入活动的自动重装载寄存器周期的值 //设置计数溢出大小，每计65535个数就产生一个更新事件
    TIM_TimeBaseStructure.TIM_Prescaler = 71;                   //根据不同频率调整 //预分频(时钟分频)72M/(71+1)=1MHZ
    TIM_TimeBaseStructure.TIM_ClockDivision = 0x0;              //TIM_CKD_DIV1=0x00 //TIM_ClockDivision的作用是做一段延时，一般在特殊场合的时候会用到，可不关心。
    TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Down; //向下計數

    TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStructure);
    TIM_PrescalerConfig(TIM2, 71, TIM_PSCReloadMode_Immediate); //設定預分頻重載模式，目前設定預分頻值，即時裝入
    TIM_ClearFlag(TIM2, TIM_FLAG_Update);                       //清除溢出中断标志
    TIM_ITConfig(TIM2, TIM_IT_Update, ENABLE);                  //开启TIM2的中断

    /* Enable the TIM2 global Interrupt */
    NVIC_SetPriority(TIM2_IRQn, 3);
    NVIC_EnableIRQ(TIM2_IRQn);

//    NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;
//    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
//    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
//    NVIC_Init(&NVIC_InitStructure);

//-----------------------------------------------------------------------------
    /***************************************************************************
    * Timer3，步进电机定时器
    **************************************************************************/
    TIM_TimeBaseStructure.TIM_Period = 0xFFFF;                  //TIM_Period设置了在下一个更新事件装入活动的自动重装载寄存器周期的值 //设置计数溢出大小，每计65535个数就产生一个更新事件
    TIM_TimeBaseStructure.TIM_Prescaler = 89;                   //根据不同频率调整  //预分频(时钟分频)72M/(71+1)=1MHZ
    TIM_TimeBaseStructure.TIM_ClockDivision = 0x0;              //TIM_CKD_DIV1=0x00 //TIM_ClockDivision的作用是做一段延时，一般在特殊场合的时候会用到，可不关心。
    TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Down; //向下計數

    TIM_TimeBaseInit(TIM3, &TIM_TimeBaseStructure);
    TIM_PrescalerConfig(TIM3, 89, TIM_PSCReloadMode_Immediate); //設定預分頻重載模式，目前設定預分頻值，即時裝入
    TIM_ClearFlag(TIM3, TIM_FLAG_Update);                       //清除溢出中断标志
    TIM_ITConfig(TIM3, TIM_IT_Update, ENABLE);                  //开启TIM2的中断

    /* Enable the TIM3 global Interrupt */
    NVIC_SetPriority(TIM3_IRQn, 2);
    NVIC_EnableIRQ(TIM3_IRQn);

//    NVIC_InitStructure.NVIC_IRQChannel = TIM3_IRQn;
//    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 2;
//    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
//    NVIC_Init(&NVIC_InitStructure);

//-----------------------------------------------------------------------------
    /***************************************************************************
    * Timer4，System Timer
    **************************************************************************/
    TIM_TimeBaseStructure.TIM_Period = 1000;                    //TIM_Period设置了在下一个更新事件装入活动的自动重装载寄存器周期的值 //设置计数溢出大小，每计65535个数就产生一个更新事件
    TIM_TimeBaseStructure.TIM_Prescaler = 71;                   //根据不同频率调整  //预分频(时钟分频)72M/(71+1)=1MHZ
    TIM_TimeBaseStructure.TIM_ClockDivision = 0x0;              //TIM_CKD_DIV1=0x00 //TIM_ClockDivision的作用是做一段延时，一般在特殊场合的时候会用到，可不关心。
    TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Down; //向下計數

    TIM_TimeBaseInit(TIM4, &TIM_TimeBaseStructure);
    TIM_PrescalerConfig(TIM4, 71, TIM_PSCReloadMode_Immediate); //設定預分頻重載模式，目前設定預分頻值，即時裝入
    TIM_ClearFlag(TIM4, TIM_FLAG_Update);                       //清除溢出中断标志
    TIM_ITConfig(TIM4, TIM_IT_Update, ENABLE);                  //开启TIM2的中断

    /* Enable the TIM4 global Interrupt */
    NVIC_SetPriority(TIM4_IRQn, 1);
    NVIC_EnableIRQ(TIM4_IRQn);
//    NVIC_InitStructure.NVIC_IRQChannel = TIM4_IRQn;
//    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 3;
//    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
//    NVIC_Init(&NVIC_InitStructure);
}

//=========================================================================================================
//* Function name:  BlueTooth_Configuration
//* Descriptions :  串口1(蓝牙通信)配置
//=========================================================================================================
//沒使用，註解;AMO;2018.06.20
void UART_Configuration(void)
{
    UART_InitTypeDef UART_InitStructure;

    UART_ITConfig(UART1, UART_IT_RDA, DISABLE);

    /* UART configuration */
    UART_InitStructure.UART_BaudRate = iBaudRate;
    UART_InitStructure.UART_WordLength = UART_WordLength_8b;
    UART_InitStructure.UART_StopBits = UART_StopBits_One;
    UART_InitStructure.UART_Parity = UART_Parity_None;
    UART_InitStructure.UART_AutoFlowControl = UART_AutoFlowControl_None;
    UART_Init(UART1, &UART_InitStructure);
    UART_ITConfig(UART1, UART_IT_RDA, ENABLE);
    UART_FIFOCmd(UART1, ENABLE);

    UART_ITConfig(UART1, UART_IT_RDA, ENABLE);
    // UART_ITConfig(UART1, UART_IT_THRE, ENABLE);
}


//=========================================================================================================
//* Function name:   ADC_Configuration
//* Descriptions :   AD配置
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void ADC_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    ADC_InitTypeDef ADC_InitStructure;

    ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
    ADC_InitStructure.ADC_ScanConvMode = ENABLE;
    ADC_InitStructure.ADC_ContinuousConvMode = DISABLE; //不连续转换
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
    ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
    ADC_InitStructure.ADC_NbrOfChannel = 2;
    ADC_Init(ADC1, &ADC_InitStructure);

    ADC_RegularChannelConfig(ADC1, ADC_Channel_8, 1, ADC_SampleTime_55Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_9, 2, ADC_SampleTime_55Cycles5);
    ADC_Cmd(ADC1, ENABLE);
    ADC_DMACmd(ADC1, ENABLE);
    ADC_ResetCalibration(ADC1);
    while(ADC_GetResetCalibrationStatus(ADC1));
    ADC_StartCalibration(ADC1);
    while(ADC_GetCalibrationStatus(ADC1));

    ADC_SoftwareStartConvCmd(ADC1, ENABLE);
}
*/

//=========================================================================================================
//* Function name:   DMA_Configuration
//* Descriptions :   DMA配置   用于传送AD值
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void DMA_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    DMA_InitTypeDef  DMA_InitStructure;

    DMA_DeInit(DMA1_Channel1);
    DMA_InitStructure.DMA_PeripheralBaseAddr = ADC1_DR_Address;
    DMA_InitStructure.DMA_MemoryBaseAddr = (uint32_t)&AD_Value;
    DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
    DMA_InitStructure.DMA_BufferSize = 2;
    DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
    DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
    DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
    DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
    DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
    DMA_InitStructure.DMA_Priority = DMA_Priority_High;
    DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
    DMA_Init(DMA1_Channel1, &DMA_InitStructure);

    DMA_Cmd(DMA1_Channel1, ENABLE);
}
*/

//=========================================================================================================
//* Function name:   SPI_Configuration
//* Descriptions :   SPI配置 用于读取外部FLASH
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void SPI_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    SPI_InitTypeDef   SPI_InitStructure;
    //用於熱感打印模組資料輸入;AMO;2018.05.25
    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; //SPI1设置为两线全双工;AMO;2018.05.25
    SPI_InitStructure.SPI_Mode = SPI_Mode_Master;                      //设置SPI1为主模式;AMO;2018.05.25
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;                  //SPI发送接收8位帧结构;AMO;2018.05.25
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;                        //串行时钟在不操作时，时钟为高电平;AMO;2018.05.25
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;                       //第二个时钟沿开始采样数据;AMO;2018.05.25
    SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;                          //NSS信号由软件（使用SSI位）管理;AMO;2018.05.25
    SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_8; 
    SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;                 //数据传输从MSB位开始;AMO;2018.05.25
    SPI_InitStructure.SPI_CRCPolynomial = 7;                           //CRC值计算的多项式;AMO;2018.05.25
    SPI_Init(SPI1, &SPI_InitStructure);
    SPI_Cmd(SPI1,ENABLE);

    //用於FLASH晶片讀取;AMO;2018.05.25
    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; //SPI1设置为两线全双工;AMO;2018.05.25
    SPI_InitStructure.SPI_Mode = SPI_Mode_Master;                      //设置SPI1为主模式;AMO;2018.05.25
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;                  //SPI发送接收8位帧结构;AMO;2018.05.25
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;                        //串行时钟在不操作时，时钟为高电平;AMO;2018.05.25
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;                       //第二个时钟沿开始采样数据;AMO;2018.05.25
    SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;                          //NSS信号由软件（使用SSI位）管理;AMO;2018.05.25
    SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2; 
    SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;                 //数据传输从MSB位开始;AMO;2018.05.25
    SPI_InitStructure.SPI_CRCPolynomial = 7;                           //CRC值计算的多项式;AMO;2018.05.25
    SPI_Init(SPI2, &SPI_InitStructure);
    SPI_Cmd(SPI2,ENABLE);

    SPI_EnWrite_StatusReg(); //Enable
    SPI_Write_StatusReg(0x00); //Write 0x00
    SPI_Write_Disable();
}
*/

//=========================================================================================================
//* Function name:   IWDG_Configuration    
//* Descriptions :   看门狗配置 
//=========================================================================================================
//沒使用，註解;AMO;2018.06.20
void IWDG_Configuration(void)
{
//    if(RCC_GetFlagStatus(RCC_FLAG_IWDGRST) != RESET)          // Delete 2022/08/29 PoJen
//    {
//        RCC_ClearFlag();
//    }
//    else
//    {
//    }

    if(RCC_GetResetFlagStatus(RCC_RSTFLAG_IWDGRST) != RESET)    // Adding 2022/08/29 PoJen
    {
        RCC_ClearResetFlags();
    }
    else
    {
    }

    IWDG_WriteAccessCmd(IWDG_WriteAccess_Enable);
    IWDG_SetPrescaler(IWDG_Prescaler_32);
    IWDG_SetReload(1250);//1s
    IWDG_ReloadCounter();
    IWDG_Enable();
}

//=========================================================================================================
//* Function name:    FLASH_ReadProtection
//* Descriptions :    Flsah读保护
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void FLASH_ReadProtection(void)
{
    if(FLASH_GetReadOutProtectionStatus() == RESET)
    {
        FLASH_Unlock();
        FLASH_ReadOutProtection(ENABLE);
        NVIC_SystemReset();
    }
}
*/

//=========================================================================================================
//* Function name:   PowerKey_Configuration
//* Descriptions :   电源按键中断模式
//=========================================================================================================
/*void PowerKey_Configuration(void)
{
    EXTI_InitTypeDef EXTI_InitStructure;
    GPIO_EXTILineConfig(GPIO_PortSourceGPIOC, GPIO_PinSource15);
    EXTI_InitStructure.EXTI_Line = EXTI_Line15;
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;   //先屏蔽掉
    EXTI_Init(&EXTI_InitStructure);
}*/

void Flash25C_Initial(void)
{
    static SPI_InitTypeDef SPI_InitStructure;
    __IO uint32_t tmp;
    __IO uint32_t jedec_id;
    __IO uint16_t mfr_did;

    // SPI Initial
    // S.W SPI
    /* QSPI */
    // PA4 NSS  PA5 CLK  PA6 MOSI IO0  PA7 MISO IO1  PB0 IO2  PB1 IO3
    FLASH_SPI_CS_high();
    GPIO_Init(GPIOA, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);  // Software NSS
    GPIO_Init(GPIOA, GPIO_Pin_5, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOA, GPIO_Pin_6, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_DOWN | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOA, GPIO_Pin_7, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_DOWN | GPIO_SPEED_HIGH | GPIO_AF5);

    FLASH_SPI_nWP_protect();
    FLASH_SPI_nRESET_enable();
    GPIO_Init(GPIOB, GPIO_Pin_1, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5); // nHOLD or nRESET Function
    GPIO_Init(GPIOB, GPIO_Pin_0, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5); // nWP Function

    FLASH_SPI_nRESET_disable();
    __ISB();
//    __NOP(); __NOP(); __NOP(); __NOP(); __NOP();
//    FLASH_SPI_nRESET_disable();
//    __ISB();

    /* QSPI configuration */
    SPI_DeInit(QSPI);
    SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    SPI_InitStructure.SPI_BaudRatePrescaler = 8;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    SPI_Init(QSPI, &SPI_InitStructure);
    SPI_NSSConfig(QSPI, SPI_NSS_0, ENABLE);
    SPI_Cmd(QSPI, ENABLE);

    /* Get SPI Flash ID */
    jedec_id = SPI_Read_JEDEC_ID();
    printf("This flash chip JEDEC ID is 0x%06X\r\n", jedec_id);

//    tmp = SPI_Read_StatusReg1();
//    printf("StatusReg1 = 0x%02X\r\n", tmp);

//    tmp = SPI_Read_StatusReg2();
//    printf("StatusReg2 = 0x%02X\r\n", tmp);

//    tmp = SPI_Read_StatusReg3();
//    printf("StatusReg3 = 0x%02X\r\n", tmp);

//    tmp = SPI_Read_ID1();
//    printf("Read ID1 = 0x%02X\r\n", tmp);

//    GPIO_Init(GPIOA, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

//    /* Enable QE bit */
//    tmp = SpiFlash_ReadStatusReg2();
//    printf("StatusReg2 = 0x%02X\r\n", tmp);
//    if (!(tmp & 0x02)) {
//        printf("QE bit is not set!\r\n");
//        printf("Set QE bit...\r\n");
//        tmp &= ~0x02;
//        SpiFlash_WriteStatusReg2(tmp);
//        tmp = SpiFlash_ReadStatusReg2();
//        printf("StatusReg2 = 0x%02X\r\n", tmp);
//    }

    /* Perform a write in the Flash followed by a read of the written data */
    /* Erase SPI FLASH Sector to write on */
//    SpiFlash_SectorErase(FLASH_SECTOR_TO_ERASE);

//    /* Write WriteData data to SPI FLASH memory through Std I/O */
//    SpiFlash_PageProgram(FLASH_WRITE_ADDRESS, WriteData, sizeof(WriteData));

//    /* Read data from SPI FLASH memory through Std I/O */
    //SpiFlash_ReadData(FLASH_READ_ADDRESS, ReadBuffer, sizeof(ReadBuffer));

//    SPI_FastRead_nBytes(0x1000, ReadBuffer, sizeof(ReadBuffer));

//    /* Check the correctness of written data */
//    if(memcmp(WriteData, ReadBuffer, sizeof(WriteData)) == 0)
//    {
//      printf("Flash progam and read operation ok.\r\n");
//    }
//    else
//    {
//      printf("Flash progam and read operation failed!\r\n");
//    }
}

//=========================================================================================================
//* Function name:   for Prt Head RG6281F
//* Descriptions :   用於RG6281F Print Head
//=========================================================================================================
void RG6281F_Initial(void)
{
    static SPI_InitTypeDef SPI_InitStructure;
    static ADC_InitTypeDef ADC_InitStructure;
    //static DMAC_InitTypeDef  DMA_InitStructure;

    __IO uint32_t lTemp32;

//-----------------------------------------------------------------------------
    // ADC  Tempture Sensor, Paper Detect
    /* PA0 Thermal Sensor,  PA1 Paper Detect */
    GPIO_Init(GPIOA, GPIO_Pin_0, GPIO_MODE_ANA | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOA, GPIO_Pin_1, GPIO_MODE_ANA | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

    // ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
    ADC_InitStructure.ADC_ScanConvMode = DISABLE; // ENABLE;
    ADC_InitStructure.ADC_ContinuousConvMode = DISABLE; //不连续转换
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
    ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
    ADC_InitStructure.ADC_NbrOfChannel = 1;
    ADC_Init(&ADC_InitStructure);

    /* Enable ADC external trigger conversion */
    ADC_ExternalTrigConvCmd(ENABLE);

    /* Enable ADC */
    ADC_Cmd(ENABLE);

    /* Start ADC calibration */
    ADC_ResetCalibration();
    /* Check the end of ADC calibration */
    while(ADC_GetResetCalibrationStatus());

    /* Enable ADC reset calibration register */
    ADC_ResetCalibration();
    /* Check the end of ADC reset calibration register */
    while(ADC_GetResetCalibrationStatus());

////-----------------------------------------------------------------------------
//    DMA_DeInit(DMA1_Channel1);
//    DMA_InitStructure.DMA_PeripheralBaseAddr = ADC1_DR_Address;
//    DMA_InitStructure.DMA_MemoryBaseAddr = (uint32_t)&AD_Value;
//    DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
//    DMA_InitStructure.DMA_BufferSize = 2;
//    DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
//    DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
//    DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
//    DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
//    DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
//    DMA_InitStructure.DMA_Priority = DMA_Priority_High;
//    DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
//    DMA_Init(DMA1_Channel1, &DMA_InitStructure);

//    DMA_Cmd(DMA1_Channel1, ENABLE);

//-----------------------------------------------------------------------------
    // TM Initial for Heater / Moto
    /* Heater, Moto */
//-----------------------------------------------------------------------------
    // Heater
    // PB10 STB 0/1/2  PB11 STB 3/4/5
    // PB10 STB 0/1    PB11 STB 4/5         PB2 STB 2/3 
    // PB10 STB 0, PC6 STB 1, PB2 STB 2, PC7 STB 3, PB11 STB 4, PC8 STB 5
    GPIO_Init(GPIOB, GPIO_Pin_10, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_11, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOB, GPIO_Pin_2, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_7, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_8, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

//-----------------------------------------------------------------------------
    // Moto PB6 A, PB7 nA, PB8 B, PB9 nB
    GPIO_Init(GPIOB, GPIO_Pin_6, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_7, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_8, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_9, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

//-----------------------------------------------------------------------------
    /* SPIM2 to Thermal Print Head */ 
    // PB12 NSS  PB13 CLK  PB14 MISO  PB15 MOSI
    
    TPH_LAT_on();
    GPIO_Init(GPIOB, GPIO_Pin_12, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_13, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_14, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_15, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

    /* SPI configuration */
    SPI_DeInit(SPIM2);
    SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    SPI_InitStructure.SPI_BaudRatePrescaler = 28;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    SPI_Init(SPIM2, &SPI_InitStructure);
    SPI_NSSConfig(SPIM2, SPI_NSS_0, ENABLE);
    SPI_Cmd(SPIM2, ENABLE);

//-----------------------------------------------------------------------------
    /* SPIM2-2 to Ext Connect*/
    // PC0 NSS  PC1 CLK  PC2 MOSI  PC3 MISO
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

    /* SPI configuration */
    // SPI_DeInit(SPIM2);
    // SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    // SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    // SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    // SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    // SPI_InitStructure.SPI_BaudRatePrescaler = 96;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    // SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    // SPI_Init(SPIM2, &SPI_InitStructure);
    // SPI_ITConfig(SPIM2, 0xFF, DISABLE);
    // SPI_TxFIFOThresholdConfig(SPIM2, 2);
    // SPI_RxFIFOThresholdConfig(SPIM2, 1);
    // SPI_NSSConfig(SPIM2, SPI_NSS_0, ENABLE);
}


//=========================================================================================================
//* Function name:   for PC Connect
//* Descriptions :   用於
//=========================================================================================================
void PCconnect_Initial(void)
{
    static UART_InitTypeDef UART_InitStructure;
    //static NVIC_InitTypeDef NVIC_InitStructure;

//-----------------------------------------------------------------------------
    // USB
    // PA11 ANA DM, PA12 ANA DM, PA8 USB Det.
    // GPIO_Init(GPIOA, GPIO_Pin_11, GPIO_MODE_ANA | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOA, GPIO_Pin_12, GPIO_MODE_ANA | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOA, GPIO_Pin_8, GPIO_MODE_IN | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

//-----------------------------------------------------------------------------
  // URT Initial
    /* UART1 115200 to PC */
    // PA9 TX AF7, PA10 RX AF7
    GPIO_Init(GPIOA, GPIO_Pin_9, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    GPIO_Init(GPIOA, GPIO_Pin_10, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);

    /* UART configuration */
    UART_DeInit(UART1);
    UART_InitStructure.UART_BaudRate = 115200;
    UART_InitStructure.UART_WordLength = UART_WordLength_8b;
    UART_InitStructure.UART_StopBits = UART_StopBits_One;
    UART_InitStructure.UART_Parity = UART_Parity_None;
    UART_InitStructure.UART_AutoFlowControl = UART_AutoFlowControl_None;
    UART_Init(UART1, &UART_InitStructure);
    UART_FIFOCmd(UART1, ENABLE);

    /* Enable the UART1 Interrupt Channel */
    NVIC_SetPriority(UART1_IRQn, 0);
    NVIC_EnableIRQ(UART1_IRQn);
//    NVIC_InitStructure.NVIC_IRQChannel = UART1_IRQn;
//    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
//    NVIC_Init(&NVIC_InitStructure);

    UART_ITConfig(UART1, UART_IT_RDA, ENABLE);
    // UART_ITConfig(UART1, UART_IT_THRE, ENABLE);

//-----------------------------------------------------------------------------
    /* UART2 for Debug */
    // PA2 TX AF7, PA3 RX AF7
    GPIO_Init(GPIOA, GPIO_Pin_2, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);

    /* UART configuration */
    UART_DeInit(UART2);
    UART_InitStructure.UART_BaudRate = 921600;
    UART_InitStructure.UART_WordLength = UART_WordLength_8b;
    UART_InitStructure.UART_StopBits = UART_StopBits_One;
    UART_InitStructure.UART_Parity = UART_Parity_None;
    UART_InitStructure.UART_AutoFlowControl = UART_AutoFlowControl_None;
    UART_Init(UART2, &UART_InitStructure);
    UART_FIFOCmd(UART2, ENABLE);

//-----------------------------------------------------------------------------
    /* UART3 for Ext Connect */
    // PC10 TX AF7, PC11 RX AF7, PC12 CLK or ExInt
    // GPIO_Init(GPIOC, GPIO_Pin_10, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_11, GPIO_MODE_AF | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_12, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF7);
    // GPIO_Init(GPIOC, GPIO_Pin_12, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
}


//=========================================================================================================
//* Function name:   for 
//* Descriptions :   用於
//=========================================================================================================
void KEY_LED_Initial(void)
{
  // GPIO Initial
    /* PA15 Error LED, PA3 Power LED, PB5 Peper LED, PC9 Ext LED2, PD2 Ext LED1  */
    GPIO_Init(GPIOA, GPIO_Pin_15, GPIO_MODE_OUT | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_3, GPIO_MODE_OUT | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_5, GPIO_MODE_OUT | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_9, GPIO_MODE_OUT | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_MODE_OUT | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

  // Ext Int Initial
    /* PB4 Feed Paper Key, PC13 STOP,  PD2 Key1,  PC9 KEY2 */
    GPIO_Init(GPIOB, GPIO_Pin_4, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOC, GPIO_Pin_13, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_9, GPIO_MODE_IN | GPIO_OTYPE_OD | GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_AF0);

    GPIO_Init(GPIOC, GPIO_Pin_12, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

    // NVIC

}


//=========================================================================================================
//* Function name:   for 
//* Descriptions :   用於
//=========================================================================================================
void MISC_Initial(void)
{
    // PA8 MCO
    GPIO_Init(GPIOA, GPIO_Pin_8, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

    RCC_MCLKConfig(RCC_MCLKSource_MAINCLK_Div8, ENABLE);
    RCC_MCOConfig(RCC_MCO_MCLK);
}


//=========================================================================================================
//* Function name:   Cpu_Init
//* Descriptions :   CPU初始化函数
//=========================================================================================================
void Cpu_Init(void)             //Check-Ok???
{
    RCC_Configuration();        // 时钟配置                   //AMO註解;AMO;2018.05.25
    //NVIC_Configuration();       // 中断向量控制器配置        // 致能Timer2、Timer3、Timer4、UART1、USB中斷;AMO;2018.05.25//AMO註解;AMO;2018.05.25
    //GPIO_Configuration();       // GPIO配置                   //AMO註解;AMO;2018.05.25
    //USB_Connect;                // AMO註解;AMO;2018.05.25
    //USB_Init();                 // USB初始化配置              //AMO註解;AMO;2018.05.25
    PCconnect_Initial();
    Tim_Configuration();        // 定时器配置                 // Recover 2022/08/29 PoJen
    //DMA_Configuration();        // DMA配置                    // ★有點看不懂@@;AMO;2018.05.25
    //ADC_Configuration();        // ADC配置                    // AMO註解;AMO;2018.05.25
    //SPI_Configuration();        // SPI总线配置                // AMO註解;AMO;2018.05.25
    //FLASH_ReadProtection();     // FLASH读保护配置            // 目前沒設保護;AMO;2018.05.25
    RG6281F_Initial();
    Flash25C_Initial();
    KEY_LED_Initial();
    MISC_Initial();
    //IWDG_Configuration();       // 看门狗配置                 // 目前沒WatchDog;AMO;2018.05.25
    //Busy_on();                  // 先設為系統Busy;AMO;2018.05.25 // AMO註解;AMO;2018.05.25
    ErrLED_off();               // 錯誤指示燈OFF;AMO;2018.05.25
}

//=========================================================================================================
//* Function name:  Sample_ADC_Conversion(Paper_ADC);
//* Descriptions :  
//=========================================================================================================
uint16_t Sample_ADC_Conversion(Typedef_enumADValue DetSource)    // Adding 2022/08/28 PoJen
{
    uint16_t lTemp16;

    switch(DetSource){
        case Thermal_ADC:
            /* ADC regular channel0 configuration */
            ADC_RegularChannelConfig(ADC_Channel_0, 1, ADC_SampleTime_55Cycles5);

            /* Start ADC Software Conversion */
            ADC_SoftwareStartConvCmd(ENABLE);
            while(ADC_GetFlagStatus(ADC_FLAG_EOC) == RESET);
            lTemp16 = ADC_GetADValue(ADC->DR);
            ADC_ClearFlag(ADC_FLAG_EOC);
            break;

        case Paper_ADC:
            /* ADC regular channel1 configuration */
            ADC_RegularChannelConfig(ADC_Channel_1, 1, ADC_SampleTime_55Cycles5);

            /* Start ADC Software Conversion */
            ADC_SoftwareStartConvCmd(ENABLE);
            while(ADC_GetFlagStatus(ADC_FLAG_EOC) == RESET);
            lTemp16 = ADC_GetADValue(ADC->DR);
            ADC_ClearFlag(ADC_FLAG_EOC);
            break;

        case Power:
            /* ADC regular channel16 configuration */
            ADC_RegularChannelConfig(ADC_Channel_16, 1, ADC_SampleTime_55Cycles5);

            /* Start ADC Software Conversion */
            ADC_SoftwareStartConvCmd(ENABLE);
            while(ADC_GetFlagStatus(ADC_FLAG_EOC) == RESET);
            lTemp16 = ADC_GetADValue(ADC->DR);
            ADC_ClearFlag(ADC_FLAG_EOC);
            break;

        case ChipTempture:
            /* ADC regular channel17 configuration */
            ADC_RegularChannelConfig(ADC_Channel_17, 1, ADC_SampleTime_55Cycles5);

            /* Start ADC Software Conversion */
            ADC_SoftwareStartConvCmd(ENABLE);
            while(ADC_GetFlagStatus(ADC_FLAG_EOC) == RESET);
            lTemp16 = ADC_GetADValue(ADC->DR);
            ADC_ClearFlag(ADC_FLAG_EOC);
            break;
    }
    return lTemp16;
}

//=========================================================================================================
//* Function name:   SerialSendByte
//* Descriptions :    串口发送一个字节
//=========================================================================================================
void SerialSendByte(uint8_t SendByte)
{
    //URT_SetTXData(URT0, 1, SendByte);         //；AMO;2018.06.20

    /*//AMO註解;AMO;2018.05.25
    USART_SendData(USART1,SendByte);            //从串口1发送数据
    while(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET)  //等待发送完一个数据
    {
        ;
    }
    */
}

//=========================================================================================================
////FLASH_SPI初始化
////=========================================================================================================
//void FLASH_SPI_Initial(void)                  // Delete 2022/08/26 PoJen
//{
//    FLASH_SPI_CS_high();
//    FLASH_SPI_SCK_high();
//    FLASH_SPI_MOSI_low(); 
//    FLASH_SPI_MISO_high();
//}

////=========================================================================================================
////FLASH_SPI寫入8BIT的資料
////=========================================================================================================
//void FLASH_SPI_WRITE_8BIT(uint8_t Byte_data)  // Delete 2022/08/26 PoJen
//{
//    uint8_t i;
//    FLASH_SPI_SCK_high();
//    for(i = 0; i < 8; i++)
//    {
//        FLASH_SPI_SCK_low();
//        if(Byte_data & 0x80)
//        {
//            FLASH_SPI_MOSI_high();
//        }
//        else
//        {
//            FLASH_SPI_MOSI_low();
//        }
//        __NOP();
//        //Delay(1);
//        FLASH_SPI_SCK_high();
//        __NOP();
//        //Delay(1);
//        Byte_data = Byte_data << 1;
//    }
//    FLASH_SPI_MOSI_high();
//    FLASH_SPI_SCK_high();
//}

////=========================================================================================================
////FLASH_SPI讀取8BIT的資料
////=========================================================================================================
//uint8_t FLASH_SPI_READ_8BIT(void)  // Delete 2022/08/26 PoJen
//{
//    uint8_t i;
//    uint8_t Byte_data;

//    FLASH_SPI_SCK_high();
//    Byte_data = 0;
//    for(i = 0; i < 8; i++)
//    {
//        FLASH_SPI_SCK_low();
//        __NOP();
//        //Delay(1);
//        Byte_data = Byte_data << 1;
//        if((GPIOA->IDR & GPIO_IDR_IDR7) != 0)
//        GPIOA->BSRR = GPIO_BSRR_BS7;
//        GPIOA->BSRR = GPIO_BSRR_BR7;
//        
//        if(FLASH_SPI_MISO() == 1)
//        {
//            Byte_data = Byte_data | 0x01;
//        }
//        FLASH_SPI_SCK_high();
//        __NOP();
//        //Delay(1);
//    }
//    return Byte_data;
//}

//=========================================================================================================
//SPI_FLASH晶片寫/讀 1BYTE的資料
//=========================================================================================================
uint8_t SPI_FLASH_ReadWriteByte(uint8_t Data)
{
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_TFE) == RESET);
    //SPI_WriteData(QSPI, SPI_Data);
    QSPI->DR = Data;
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_RFNE) == RESET);

    //uint16_t SPI_ReadData(SPI_TypeDef* SPIx)
    return ((uint8_t)QSPI->DR);
}

//=========================================================================================================
//SPI_FLASH晶片寫入1BYTE的資料
//=========================================================================================================
void FLASH_SPI_Send_1Byte(uint8_t SPI_Data)
{
    uint8_t Buf_DATA;
    // FLASH_SPI_CS_low();                          // EN=0；OFF=1
    // FLASH_SPI_WRITE_8BIT(SPI_Data);              // Delete 2022/08/25
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_TFE) == RESET);
    // SPI_WriteData(QSPI, SPI_Data);
    QSPI->DR = SPI_Data;
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_RFNE) == RESET);
    // FLASH_SPI_CS_high();                         // EN=0；OFF=1
    Buf_DATA = QSPI->DR;
}

//=========================================================================================================
//SPI_FLASH晶片讀取1BYTE的資料 
//=========================================================================================================
uint8_t FLASH_SPI_Read_1Byte(void)
{
    uint8_t Buf_DATA;

    //FLASH_SPI_MISO_high();
    //FLASH_SPI_CS_low();   //EN=0; OFF=1                       //
    //Buf_DATA = FLASH_SPI_READ_8BIT();                         // Delete 2022/08/25 PoJen
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_TFE) == RESET);
    //SPI_WriteData(QSPI, SPI_Data);
    QSPI->DR = 0xFF;
    while (SPI_GetFlagStatus(QSPI, SPI_FLAG_RFNE) == RESET);
    //FLASH_SPI_CS_high();                                      // EN=0；OFF=1
    //return SPI_ReadData(QSPI);
    return ((uint8_t)QSPI->DR);
}

//=========================================================================================================
//Thermal_PRINT寫入1BYTE的資料
//=========================================================================================================
//void THMPRINT_Send_1Byte(uint8_t Byte_data)
//{
//    uint8_t Buf_DATA;
//    while (SPI_GetFlagStatus(SPIM2, SPI_FLAG_TFE) == RESET);
//    SPI_WriteData(QSPI, Byte_data);
//    while (SPI_GetFlagStatus(SPIM2, SPI_FLAG_RFNE) == RESET);
//    Buf_DATA = QSPI->DR;
//}

//=========================================================================================================
//SPI_EnWrite_StatusReg
//=========================================================================================================
void SPI_EnWrite_StatusReg(void)
{
    SPI_Wait_Busy();
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_EnWriteSR);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
}

//=========================================================================================================
//SPI_Read_StatusReg
//=========================================================================================================
uint8_t SPI_Read_StatusReg(void)
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadStatusReg);
    //SPI_Send_Byte(FLASH_ReadStatusReg);       // AMO註解;AMO;2018.05.25
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//SPI_Write_StatusReg
//=========================================================================================================
void SPI_Write_StatusReg(uint8_t byte)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteStatusReg);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
}

//=========================================================================================================
//SPI_Read_StatusReg
//=========================================================================================================
uint8_t SPI_Read_StatusReg1(void)
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadStatusReg1);
    //SPI_Send_Byte(FLASH_ReadStatusReg);       // AMO註解;AMO;2018.05.25
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//SPI_Write_StatusReg
//=========================================================================================================
void SPI_Write_StatusReg1(uint8_t byte)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteStatusReg1);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
}

//=========================================================================================================
//SPI_Read_StatusReg
//=========================================================================================================
uint8_t SPI_Read_StatusReg2(void)
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadStatusReg2);
    //SPI_Send_Byte(FLASH_ReadStatusReg);       // AMO註解;AMO;2018.05.25
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//SPI_Write_StatusReg
//=========================================================================================================
void SPI_Write_StatusReg2(uint8_t byte)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteStatusReg2);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
}

//=========================================================================================================
//SPI_Read_StatusReg
//=========================================================================================================
uint8_t SPI_Read_StatusReg3(void)
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadStatusReg3);
    //SPI_Send_Byte(FLASH_ReadStatusReg);       // AMO註解;AMO;2018.05.25
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//SPI_Write_StatusReg
//=========================================================================================================
void SPI_Write_StatusReg3(uint8_t byte)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteStatusReg3);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
}

//=========================================================================================================
//SPI_Write_Enable
//=========================================================================================================
void SPI_Write_Enable(void)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteEnable);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
}

//=========================================================================================================
//SPI_Write_Disable
//=========================================================================================================
void SPI_Write_Disable(void)
{
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteDisable);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
}

//=========================================================================================================
//SPI_Read_JEDEC_ID
//=========================================================================================================
uint32_t SPI_Read_JEDEC_ID(void)
{
    uint32_t ljedec_id;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_JEDEC_ID);       // Adding 2022/08/26 PoJen
    ljedec_id = FLASH_SPI_Read_1Byte();         // Modify 2022/08/26 PoJen
    ljedec_id <<= 8;                            // Adding 2022/08/26 PoJen
    ljedec_id |= FLASH_SPI_Read_1Byte();        // Modify 2022/08/26 PoJen
    ljedec_id <<= 8;                            // Adding 2022/08/26 PoJen
    ljedec_id |= FLASH_SPI_Read_1Byte();        // Modify 2022/08/26 PoJen
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return ljedec_id;
}

//=========================================================================================================
//SPI_Read_ID1
//=========================================================================================================
uint8_t SPI_Read_ID1(void)
{
    uint8_t byte;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_DeviceID);
    FLASH_SPI_Send_1Byte(0);
    FLASH_SPI_Send_1Byte(0);
    FLASH_SPI_Send_1Byte(0);
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//从片外读1个字节
//=========================================================================================================
uint8_t SPI_Read_Byte(uint32_t Dst_Addr)        //从片外读1个字节  //Check-Ok;AMO;2018.05.25
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadData);
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte((uint8_t)(Dst_Addr & 0xFF));
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//从片外读n个字节
//=========================================================================================================
void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//从片外读n个字节
{
    int i = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    for (i = 0; i < nBytes; i++)
    {
        Data[i] = FLASH_SPI_Read_1Byte();       // AMO;2018.06.20
    }
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
}

//=========================================================================================================
//从片外读1个字节
//=========================================================================================================
uint8_t SPI_FastRead_Byte(uint32_t Dst_Addr)//从片外读1个字节
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_FastReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(0xFF);                 // dummy byte
    byte = FLASH_SPI_Read_1Byte();              // AMO;2018.06.20
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//从片外读n个字节
//=========================================================================================================
void SPI_FastRead_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//从片外读n个字节  //Check-Ok;AMO;2018.05.25
{
    int i = 0;
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_FastReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(0xFF);                 // dummy byte
    for (i=0; i<nBytes; i++)
    {
        Data[i] = FLASH_SPI_Read_1Byte();       //;AMO;2018.06.20
    }
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
}

//=========================================================================================================
//往片外写1个字节数据
//=========================================================================================================
void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte)//往片外写1个字节数据  //Check-Ok;AMO;2018.05.25
{
    SPI_Wait_Busy();
    SPI_Write_Enable();
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ByteProgram);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//往片外写2个字节数据
//=========================================================================================================
void SPI_Write_2Bytes(uint32_t Dst_Addr, uint8_t Data1, uint8_t Data2)//往片外写2个字节数据
{
    SPI_Wait_Busy();
    SPI_Write_Enable();
    FLASH_SPI_CS_low();                         // EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_AAIWordProgram);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(Data1);
    FLASH_SPI_Send_1Byte(Data2);
    FLASH_SPI_CS_high();                        // EN=0；OFF=1
    SPI_Wait_Busy();
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//往片外写n个字节数据
//=========================================================================================================
void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//往片外写n个字节数据
{
    int i;
    uint8_t byte;
    SPI_Wait_Busy();
    SPI_Write_Enable();
    for(i = 0; i < nBytes; i++)
    {
        FLASH_SPI_CS_low();                     // EN=0；OFF=1
        FLASH_SPI_Send_1Byte(FLASH_AAIWordProgram);
        if(i == 0)
        {
            FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
            FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
            FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
        }
        byte = Data[i];
        FLASH_SPI_Send_1Byte(byte);
        i++;
        byte = Data[i];
        FLASH_SPI_Send_1Byte(byte);
        FLASH_SPI_CS_high();                    // EN=0；OFF=1
        SPI_Wait_Busy();
    }
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//擦除整片
//=========================================================================================================
/*//沒用到;AMO註解;AMO;2018.05.25
void SPI_Erase_Chip(void)//擦除整片
{
    SPI_Write_Enable();                         // set WEL
    SPI_Wait_Busy();
    FLASH_CS_RESET;
    SPI_Send_Byte(FLASH_ChipErase);
    FLASH_CS_SET;
    SPI_Wait_Busy();
}
*/

//=========================================================================================================
//擦除一块的数据 
//=========================================================================================================
void SPI_Erase_Sector(uint32_t Dst_Addr)        //擦除一块的数据  //Check-Ok;AMO;2018.05.25
{
    SPI_Write_Enable();                         // set WEL //下達flash寫入指令;AMO;2018.05.25
    FLASH_SPI_CS_low();                         // EN = 0; OFF = 1
    FLASH_SPI_Send_1Byte(FLASH_4KSectorErase);
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte((uint8_t)Dst_Addr & 0xFF);
    FLASH_SPI_CS_high();                        // EN = 0； OFF = 1
    SPI_Wait_Busy();                            // 0x03，表示正在Erase/Write處理中，處理完則離開繼續;AMO;2018.05.25
}

//=========================================================================================================
//SPI_Wait_Busy 
//=========================================================================================================
void SPI_Wait_Busy(void)
{
    while (SPI_Read_StatusReg() == 0x03);       //0x03，表示正在Erase/Write處理中;AMO;2018.05.25
}

//=========================================================================================================
//SPI_Send_Byte(uint8_t out)
//=========================================================================================================
//AMO註解;AMO;2018.05.25
//void SPI_Send_Byte(uint8_t out)//spi 发送一个字节
//{
//    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);

//    SPI_I2S_SendData(SPI2, out);

//    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) != RESET);

//    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_RXNE) == RESET);
//    SPI_I2S_ReceiveData(SPI2);
//}

//=========================================================================================================
//SPI_Get_Byte(void)
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
uint8_t SPI_Get_Byte(void)//spi 接收一个字节
{
    uint8_t in=0x55;

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);

    SPI_I2S_SendData(SPI2, in);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) != RESET);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_RXNE) == RESET);
    in= SPI_I2S_ReceiveData(SPI2);
    return in;
}
*/

//=========================================================================================================
//* Function name:     SendnBytes_To_Head
//* Descriptions :     向打印头发送一点行的数据
//=========================================================================================================
void SendnBytes_To_Head(uint8_t *pData, uint8_t nByte)
{
    uint8_t i;
    uint8_t Buf_DATA;

    for(i = 0; i < nByte; i++)
    {
        while (SPI_GetFlagStatus(SPIM2, SPI_FLAG_TFE) == RESET);
        SPI_WriteData(SPIM2, *pData);
        while (SPI_GetFlagStatus(SPIM2, SPI_FLAG_RFNE) == RESET);
        Buf_DATA = SPIM2->DR;
        //THMPRINT_Send_1Byte(*pData); Delete 2022/08/29 PoJen
        pData++;
    }
}

//=========================================================================================================
//* Function name:     Motor_Delay
//* Descriptions :     
//=========================================================================================================
void TIM2_Heater_Delay(uint32_t cTime)
{
    
}

//=========================================================================================================
//* Function name:     Motor_Delay
//* Descriptions :     
//=========================================================================================================
void TIM3_Motor_Delay(uint32_t cTime)
{
    
}
//=========================================================================================================
//* Function name:     Motor_Delay
//* Descriptions :     
//=========================================================================================================
void TIM4_System_Delay(uint32_t cTime)
{
    
}

//=========================================================================================================
//* Function name:     LFMotorPhaseSet
//* Descriptions :     电机相位控制函数
//=========================================================================================================
void LFMotorPhaseSet(uint8_t Phase) //Check-Ok;AMO;2018.05.25
{
//          B-  A-  B   A
//   step1  1   1   0   0
//   step2  0   1   1   0
//   step3  0   0   1   1
//   step4  1   0   0   1

//          1A  2A- 3B  4B- 
//   step1  0   1   0   1   
//   step2  0   1   1   0   
//   step3  1   0   1   0   
//   step4  1   0   0   1   

   switch (Phase){
        case 1:// 4
            Motor1_off();
            Motor2_on();
            Motor3_off();
            Motor4_on();
            break; 
        case 2:// 3
            Motor1_off();
            Motor2_on();
            Motor3_on();
            Motor4_off();
            break; 
        case 3:// 2
            Motor1_on();
            Motor2_off();
            Motor3_on();
            Motor4_off();
            break;
        case 4:// 1
            Motor1_on();
            Motor2_off();
            Motor3_off();
            Motor4_on();
            break;
        case 0://Close
        default:
            Motor1_off();
            Motor2_off();
            Motor3_off();
            Motor4_off();
            break;
   }
}


//=========================================================================================================
//* Function name:    PrtStbStatus
//* Descriptions :    STB1--STB6 使能/失能函数
//=========================================================================================================
void PrtStbAllStatus(uint8_t Status)
{
    if(Status == 1)
    {
        PrtStb123_on();//Stb123 on
        PrtStb456_on();//Stb456 on
    }
    else
    {
        PrtStb123_off();//Stb123 off
        PrtStb456_off();//Stb456 off
    }
}


//=========================================================================================================
//* Function name:   Interface_Configuration
//* Descriptions :   打印机通信接口选择函数
//=========================================================================================================
void Interface_Config(void)         // Reconver 2022/08/30 PoJen
{
    UART_Configuration();        // Bluetooth and Wifi  Configuration //AMO註解;AMO;2018.05.25
}


//=========================================================================================================
//* Function name:    PrinterBusy
//* Descriptions :    打印机忙信号控制
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
void PrinterBusy(uint8_t Status)
{
    if(Status)
    {
        //USBBusy_on();      //Usb      Busy        //AMO註解;AMO;2018.05.25
        //UARTBusy_on();     //USART    Busy        /AMO註解;AMO;2018.05.25
    }
    else
    {
        //USBBusy_off();    //Usb       Free        //AMO註解;AMO;2018.05.25
        //UARTBusy_off();   //USART     Free        //AMO註解;AMO;2018.05.25
    }
}
*/


//=========================================================================================================
//* Function name:    PrinterBusy
//* Descriptions :    打印机忙信号控制
//=========================================================================================================
//void SYS_ITEA_Cmd(uint32_t CMD)
//{
//
//}


//=========================================================================================================
//* Function name:    
//* Descriptions :    
//=========================================================================================================
void UART1_IRQHandler(void)
{
    uint8_t rbyte;
    uint8_t int_id;

    int_id = UART_GetIntID(UART1);

    if(int_id == UART_INTID_RDA)
    {
        rbyte = UART_ReadData(UART1);
        SerialInt(rbyte);
    }

    // if (int_id == UART_INTID_THRE)
    // {
    //     if (txIndex < sizeof(txBuffer))
    //     {
    //         UART_WriteData(UART1, txBuffer[txIndex]);
    //         txIndex++;
    //     }
    //     else
    //     {
    //         UART_ITConfig(UART1, UART_IT_THRE, DISABLE);
    //     }
    // }
}



/***************************************************************************
* Timer2，Heater Timer ISR
**************************************************************************/
/**
  * @brief  This function handles TIM2 global interrupt request.
  * @param  None
  * @retval None
  */
void TIM2_IRQHandler(void)
{
    if(TIM_GetITStatus(TIM2, TIM_IT_Update) != RESET)
    {
        TIM_ClearITPendingBit(TIM2, TIM_IT_Update);

        //GPIO_ToggleBits(GPIOB, GPIO_Pin_14);  // Toggle LED1
    }
}



/***************************************************************************
* Timer3，步进电机定时器
**************************************************************************/
/**
  * @brief  This function handles TIM3 global interrupt request.
  * @param  None
  * @retval None
  */
void TIM3_IRQHandler(void)
{
    if(TIM_GetITStatus(TIM3, TIM_IT_Update) != RESET)
    {
        TIM_ClearITPendingBit(TIM3, TIM_IT_Update);

        LFMotorInt();
        // GPIO_ToggleBits(GPIOB, GPIO_Pin_14);  // Toggle LED1
    }
}


/***************************************************************************
* Timer4，System Timer ISR
**************************************************************************/
/**
  * @brief  This function handles TIM4 global interrupt request.
  * @param  None
  * @retval None
  */
void TIM4_IRQHandler(void)
{
    if (TIM_GetITStatus(TIM4, TIM_IT_Update) != RESET)
    {
        TIM_ClearITPendingBit(TIM4, TIM_IT_Update);

        SysTimerInt();
        //GPIO_ToggleBits(GPIOB, GPIO_Pin_14);  // Toggle LED1
    }
}

