/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "CmdSet.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［CmdSet.c］
//=========================================================================================================
//* File         :CmdSet.c
//* Description  :ESC/POS command set program
//=========================================================================================================
//#include "MG32x02z_ChipInit.h" //載入MG32x02z晶片初始化定義檔；AMO;2018.03.10	
//#include "MG32x02z_DRV.h"
//#include "PrtDriver.h"
//#include "Sample.h"            //載入MG32x02z晶片外設基本功能應用API函數檔；AMO;2018.03.10	
//#include "string.h"

uint32_t URT_data;

/*//AMO註解;AMO;2018.05.25
#include "RcvBuf.h"
#include "Interface.h"
#include "PrtBuf.h"
#include "PrtHead.h"
#include "Hw_config.h"
#include "BarCode.h"
#include "CmdSet.h"
#include "BarCode_app.h"
*/

//#define EOT     0x04
//#define ENQ     0x05
//#define GS      0x1d
//#define HT      0x09
//#define LF      0x0a
//#define FF      0x0c
//#define CR      0x0d
//#define DLE     0x10
//#define DC      0x11
//#define ESC     0x1b
//#define FS      0x1c
//#define US      0x1f

//#define LSB     1
//#define BIT0    LSB
//#define BIT1    2
//#define BIT01   3
//#define BIT2    4
//#define BIT3    8
//#define BIT23   12
//#define BIT4    16
//#define BIT5    32
//#define BIT6    64
//#define BIT56   96
//#define BIT7    128

//#define LINE_SPACE  6

uint8_t bOpenCashAfterPrt = 0;
uint8_t cChasNums = 0;
uint32_t iOpenCashTimer = 0;
uint32_t iCloseCashTimer = 0;

uint32_t Test_motor_step = 0;


/***************************************************************************************************/
void HTCmd(void);
void LFCmd(void);
void CRCmd(void);
//void DLECmd(void); //AMO註解;AMO;2018.05.25
void ESCCommand(uint8_t data);
void FSCommand(uint8_t data);
void GSCommand(uint8_t data);
//void USCommand(uint8_t data); //註解;AMO;2018.05.25
/***************************************************************************************************/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［CmdSet.c］
//=========================================================================================================
//void ExecuteCmd(uint8_t data)
//=========================================================================================================
void ExecuteCmd(uint8_t data)
{
//方便查看;;AMO;2018.05.25
/*
#define EOT     0x04
#define ENQ     0x05
#define GS      0x1d
#define HT      0x09
#define LF      0x0a
#define FF      0x0c
#define CR      0x0d
#define DLE     0x10
#define DC      0x11
#define ESC     0x1b
#define FS      0x1c
#define US      0x1f
*/

    switch(data)
    {
        case HT:
            HTCmd();
            break;
        case LF:
            LFCmd();//打印并走纸
            break;
        case CRx:
            CRCmd();//打印并走纸
            break;
        //case DLE:       //AMO註解;AMO;2018.05.25
        //    DLECmd();   //AMO註解;AMO;2018.05.25
        //    break;      //AMO註解;AMO;2018.05.25
        case ESC:
            ESCCommand(GetDataFromRcvBuf());//ESC指令
            break;
        case FS:
            FSCommand(GetDataFromRcvBuf());//FS指令
            break;
        case GS:
            GSCommand(GetDataFromRcvBuf());//GS指令
            break;
        //case US://註解;AMO;2018.05.25
            //USCommand(GetDataFromRcvBuf());//自用调试指令 //註解;AMO;2018.05.25
            //break;//註解;AMO;2018.05.25
        default:
            break;
    }
}

//=========================================================================================================
//void HTCmd(void)
//=========================================================================================================
void HTCmd(void)
{
    uint16_t byts_s = iCurrentFillColumn / 8;  //iCurrentFillColumn=当前填充位置标志位;AMO;2018.05.25
    uint8_t temp_ji;

    byts_s = iCurrentFillColumn / 12;
    
    if(iCurrentFillColumn % 12)
    {
        byts_s++;
    }
    
    for(temp_ji = 0; temp_ji < 16; temp_ji++)
    {
        if(HT_TAB[temp_ji] > byts_s)
        {
            iCurrentFillColumn = (HT_TAB[temp_ji]) * 12;
            break;
        }
        if(HT_TAB[temp_ji] == 0)
        {
            break;
        }
    }
    
    if(iCurrentFillColumn > MaxDotPos)
    {
        iCurrentFillColumn = 384;
    }
}
//=========================================================================================================
//* CR --- 0x0d
//*Only  Print 
//=========================================================================================================
void CRCmd(void)
{
    ;
}


//=========================================================================================================
//* LF --- 0x0a
//* Print and line feed
//=========================================================================================================
void LFCmd(void)
{
    StartupPrint(1);
}
//=========================================================================================================
//* DLE--- 0x10 04/05
//* 
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
void DLECmd(void)
{
    switch(GetDataFromRcvBuf())
    {
        case EOT:
        case ENQ:
            GetDataFromRcvBuf();
            break;
        default:
            break;
    }
}


*/
//=========================================================================================================
//* ESC SP n
//* Set right-side character spacing
//* 0 <= n <= 255 
//=========================================================================================================
void ESC_SP(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    cAsciiRightSpace = cTemp;
}


//=========================================================================================================
//* ESC J n  
//* Print and feed paper 
//* 0 <= n <= 255
//=========================================================================================================
void ESC_J(void)
{
    uint8_t cTemp;
    uint8_t cTempStep;
    cTemp = iLineSpaceNumber;
    cTempStep = GetDataFromRcvBuf();
    if(iCurrentFillColumn)
    {
        if(cTempStep < PRTLINEHIGHT)
        {
            iLineSpaceNumber = 0;
        }
        else
        {
            iLineSpaceNumber = cTempStep - PRTLINEHIGHT;
        }
        StartupPrint(1);
    }
    else
    {
        //SYS_ITEA_Cmd(DISABLE);                        // Delete 2022/08/23 PoJen
        CloseAllInt();                                  // Recover 2022/08/23 PoJen
        // state have not changed
        if(iLFStepNum < LashStop_Nums + 1)//(const hlod stop)
        {
            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
            OpenAllInt();                               // Recover 2022/08/23 PoJen
            FeedPaper(cTempStep * ONEDOTSTEPNUM);
        }
        else
        {
            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
            OpenAllInt();                               // Recover 2022/08/23 PoJen
            // in the period of acceleration of constant speed
            CountinueLineFeed(cTempStep * ONEDOTSTEPNUM);
        }
    }
    iLineSpaceNumber = cTemp;
}
//=========================================================================================================
//* ESC 3 n
//* Set line spacing 
//* 0 <= n <= 255
//=========================================================================================================
void ESC_3(void)
{
    uint8_t cTempStep;
    cTempStep = GetDataFromRcvBuf();
    
    if(cTempStep < PRTLINEHIGHT)
    {
        iLineSpaceNumber = 0;
    }
    else
    {
        iLineSpaceNumber = cTempStep - PRTLINEHIGHT;
    }
}
//=========================================================================================================
//* ESC M
//* Select Font 
//=========================================================================================================
void ESC_M(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    switch(cTemp)
    {
        case 0:
        case 48:
            bFont12x24 = 1;
            break;
        case 1:
        case 49:
            bFont12x24 = 0;
            break;
        default:
            break;
    }
}
//=========================================================================================================
//* ESC R n
//* Select an international character set
//* 0 <= n <= 10
//=========================================================================================================
void ESC_R(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    switch(cTemp)
    {
        case 0:
            cInternationalCharSet = USA;
            break;
        case 1:
            cInternationalCharSet = France;
            break;
        case 2:
            cInternationalCharSet = Germany;
            break;
        case 3:
            cInternationalCharSet = UK;
            break;
        case 4:
            cInternationalCharSet = DenmarkI;
            break;
        case 5:
            cInternationalCharSet = Sweden;
            break;
        case 6:
            cInternationalCharSet = Italy;
            break;
        case 7:
            cInternationalCharSet = SpainI;
            break;
        case 8:
            cInternationalCharSet = Japan;
            break;
        case 9:
            cInternationalCharSet = Norway;
            break;
        case 10:
            cInternationalCharSet = DenmarkII;
            break;
        case 11:
            cInternationalCharSet = SpainII;
            break;
        case 12:
            cInternationalCharSet = Latin;
            break;
        case 13:
            //cInternationalCharSet = Korea;
            break;
        case 14:
            //cInternationalCharSet = Croatia;
            break;
        case 15:
            //cInternationalCharSet = China;
            break;
        default:
            break;
    }
}

//=========================================================================================================
//* ESC 2
//* Select default line spacing
//=========================================================================================================
void ESC_2(void)
{
    iLineSpaceNumber = LINE_SPACE;
}

//=========================================================================================================
//* ESC c
//* print KEY  Enable or Disable
//=========================================================================================================
void ESC_c(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if(cTemp == 0x35)
    {
        switch(GetDataFromRcvBuf() & LSB)
        {
            case 0:
                bDisableButtons = 0;
                break;
            case 1:
                bDisableButtons = 1;
                break;
            default:
                break;
        }
    }
}

//=========================================================================================================
//* ESC d
//* print and feed n line
//=========================================================================================================
void ESC_dcmd(void)
{
    uint8_t cNumOfLine;
    ///uint8_t cLoop;
    uint32_t  iTemp;
    cNumOfLine = GetDataFromRcvBuf();
    if( cNumOfLine == 0)//AMO新增，防止輸入0值，造成錯亂;AMO;2018.05.25
    {
        cNumOfLine = 1;
    }
    
    StartupPrint(0);
    //for(cLoop = 0; cLoop < cNumOfLine; cLoop++)
    //{
        WaitMotorStop();
        //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
        CloseAllInt();                              // Recover 2022/08/23 PoJen
        iTemp = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM * cNumOfLine;
        //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
        OpenAllInt();                               // Recover 2022/08/23 PoJen
        FeedPaper(iTemp);
    //}
}

//=========================================================================================================
//* ESC % n
//* Select / cancel user-defined character set
//=========================================================================================================
void ESC_mod(void)
{
    bUserChar = GetDataFromRcvBuf() & LSB;
}

//=========================================================================================================
//* ESC & y c1 c2 [x1 d1...d(y x x1)]...
//* [xk d1...d(y x xk)]
//* Define user-defined characters
//* y=1 or 2
//* 32<=c1<=c2<=126
//* 0<=x<=12 (when Font A(12 x 24)is selected)
//* 0<=x<=9  (when Font B(9 x 17)is selected)
//* 0<=d1...d(y x xk)<=255
//=========================================================================================================
void ESC_and(void)
{
    uint8_t y;
    uint8_t cUserFirstChar;
    uint8_t cUserLastChar;
    uint32_t cCounter,cLoopi;
    uint32_t cCounterx,cLoopx;
    uint8_t cFirst,cSecond,cThree; 
    uint32_t iAddr;

    y = GetDataFromRcvBuf();
    if(y != 3)
    {
        return;
    }
    cUserFirstChar = GetDataFromRcvBuf(); //Get c1
    cUserLastChar = GetDataFromRcvBuf(); //Get c2
    if((cUserFirstChar >= 32 && cUserFirstChar <= 126) && \
            cUserLastChar >= 32 && cUserLastChar <= 126 && \
            cUserFirstChar <= cUserLastChar)
    {
        for(cLoopi = cUserFirstChar; cLoopi <= cUserLastChar; cLoopi++)
        {
            if(bFont12x24)
            {
                iAddr = UserCharAddr_12x24 | ((cLoopi - 32) << 12);
                SPI_Erase_Sector(iAddr);
                SPI_Write_Byte(iAddr,0x01);
            }
            else
            {
                iAddr = UserCharAddr_9x17 | ((cLoopi-32) << 12);
                SPI_Erase_Sector(iAddr);
                SPI_Write_Byte(iAddr,0x01);
            }
        }
        cCounter = cUserLastChar - 32 + 1;
        for(cLoopi = cUserFirstChar - 32; cLoopi < cCounter; cLoopi++)
        {
            cCounterx = GetDataFromRcvBuf();
            if(bFont12x24)
            {
                if(cCounterx > 12)
                {
                    cCounterx = 12;
                }
            }
            else
            {
                if(cCounterx > 9)
                {
                    cCounterx = 9;
                }
            }
            for(cLoopx = 0; cLoopx < cCounterx; cLoopx++)         // receive y x xi datas
            {
                if(bFont12x24)
                {
                    cFirst = GetDataFromRcvBuf();
                    cSecond = GetDataFromRcvBuf();
                    cThree = GetDataFromRcvBuf();
                    iAddr = UserCharAddr_12x24 | (cLoopi << 12) | (1 + cLoopx);
                    SPI_Write_Byte(iAddr, cFirst);
                    SPI_Write_Byte(iAddr + ASCII_WIDTH, cSecond);
                    SPI_Write_Byte(iAddr + ASCII_WIDTH * 2, cThree);
                }
                else
                {
                    cFirst = GetDataFromRcvBuf();
                    cSecond = GetDataFromRcvBuf();
                    cThree = GetDataFromRcvBuf();
                    iAddr = (UserCharAddr_9x17 | (cLoopi << 12) | (1 + cLoopx));
                    SPI_Write_Byte(iAddr, cFirst);
                    SPI_Write_Byte(iAddr + SFONT_WIDTH, cSecond);
                    SPI_Write_Byte(iAddr + SFONT_WIDTH * 2, cThree);
                }
            }
        }
    }
}


//=========================================================================================================
//* ESC ? n
//* cancel user-defined character
//=========================================================================================================
void ESC_interrogation(void)
{
    uint8_t cByte;
    uint32_t  iAddr;
    cByte = GetDataFromRcvBuf();
    if(cByte >= 32 && cByte <= 127)
    {
        if(bFont12x24)
        {
            iAddr = UserCharAddr_12x24 | ((cByte - 32) << 12);
            SPI_Write_Byte(iAddr, 0x00);
        }
        else
        {
            iAddr = UserCharAddr_9x17 | ((cByte - 32) << 12);
            SPI_Write_Byte(iAddr, 0x00);
        }
    }
}

//=========================================================================================================
//* ESC D [d]k NULL
//* Select HT bits
//=========================================================================================================
uint8_t HT_TAB[16]={3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 35, 38, 41, 44, 48};
void ESC_D(void)
{
    uint8_t temp_ji;
    
    for(temp_ji = 0; temp_ji < 16; temp_ji++)
    {
    HT_TAB[temp_ji] = 0;
    }
    for(temp_ji = 0; temp_ji < 16; temp_ji++)
    {
        HT_TAB[temp_ji] = GetDataFromRcvBuf();
        if(HT_TAB[temp_ji] == 0)
        {
            break;
        }
    }
}

//=========================================================================================================
//* ESC ! n
//* Select print mode(s)
//=========================================================================================================
void ESC_ExcalmatoryMark(void)
{
    uint8_t cTemp;

    cTemp = GetDataFromRcvBuf();

    if(cTemp & LSB)
    {
        bFont12x24 = 0;
    }
    else
    {
        bFont12x24 = 1;
    }
    
    if(cTemp & BIT3)
    {
        bBold = 1;
    }
    else
    {
        bBold = 0;
    }
    
    if(cTemp & BIT4)
    {
        cAsciiHightMultiple = 2;
    }
    else
    {
        cAsciiHightMultiple = 1;
    }
    
    if(cAsciiHightMultiple_Prt < cAsciiHightMultiple)
    {
        cAsciiHightMultiple_Prt = cAsciiHightMultiple;
    }
    
    if(cTemp & BIT5)
    {
        cAsciiWidthMultiple = 2;
    }
    else 
    {
        cAsciiWidthMultiple = 1;
    }
    
    if(cTemp & BIT7)
    {
        bAsciiUnderLine = 1;
    }
    else 
    {
        bAsciiUnderLine = 0;
    }
}

//=========================================================================================================
//* ESC E n
//*bBold mode.
//=========================================================================================================
void ESC_E(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if(cTemp & LSB)
    {
        bBold = 1;
    }
    else
    {
        bBold = 0;
    }
}

//=========================================================================================================
//* ESC G n
//*bBold mode
//=========================================================================================================
void ESC_G(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if(cTemp & LSB)
    {
        bBold = 1;
    }
    else
    {
        bBold = 0;
    }
}

//=========================================================================================================
//* ESC  N  n  t
//*FLASH中的打印机系统参数设置
//=========================================================================================================
void ESC_N(void)
{
    uint8_t cTemp;
    unsigned iLoop;
    for(iLoop = 0; iLoop < 32; iLoop++)
    {
        PrtConfigBuf[iLoop] = SPI_Read_Byte (UserParameterBaseAddr + iLoop);
    }
    switch(GetDataFromRcvBuf())
    {
        case 0x00:
            PrtConfigBuf[0] = 0xff;//恢复出厂设置
            break;
        case 0x01:
            cTemp = GetDataFromRcvBuf();
            if(cTemp > 5)
            {
                return;
            }
            if(cTemp == 1)
            {
                iBaudRate = BAUDRATE9600;
            }
            else if(cTemp == 2)
            {
                iBaudRate = BAUDRATE19200;
            }
            else if(cTemp == 3)
            {
                iBaudRate = BAUDRATE38400;
            }
            else if(cTemp == 4)
            {
                iBaudRate = BAUDRATE57600;
            }
            else if(cTemp == 5)
            {
                iBaudRate = BAUDRATE115200;
            }
            //USART_Configuration();//AMO註解;AMO;2018.05.25
            //PrtConfigBuf[SerialBauRateAddr] = cTemp; //AMO註解，已經不是在這裡設定，要再重寫設定;AMO;2018.05.25
            break;
        case 0x02:
            cTemp = GetDataFromRcvBuf();
            break;
        case 0x03:
            cTemp = GetDataFromRcvBuf();
            if(cTemp & 0x01)
            {
                bChinese = 1;
            }
            else
            {
                bChinese = 0;
            }
            PrtConfigBuf[CharacterModeAddr] = cTemp;
            break;
        case 0x04:
            cTemp = GetDataFromRcvBuf();
            if(cTemp > 4)
            {
                return;
            }
            if(cTemp == 1)
            {
                iDensitySetTime = DensitySetTimeLevel1;
            }
            else if(cTemp == 2)
            {
                iDensitySetTime = DensitySetTimeLevel2;
            }
            else if(cTemp == 3)
            {
                iDensitySetTime = DensitySetTimeLevel3;
            }
            else if(cTemp == 4)
            {
                iDensitySetTime = DensitySetTimeLevel4;
            }
            else if(cTemp == 5)
            {
                iDensitySetTime = DensitySetTimeLevel5;
            }
            //SPI_Write_Byte(UserParameterBaseAddr+DensitySelectAddr,cTemp);
            PrtConfigBuf[DensitySelectAddr] = cTemp;
            //SPI_Read_Byte (UserParameterBaseAddr+DensitySelectAddr);
            //SerialSendByte(SPI_Read_Byte (UserParameterBaseAddr+DensitySelectAddr));
            break;
        case 0x05:
            cTemp = GetDataFromRcvBuf();
            cCodePage = cTemp;
            PrtConfigBuf[CodePageAddr] = cTemp;
            break;
        case 0x06:
            cTemp = GetDataFromRcvBuf();
            if(cTemp&0x01)
            {
                //bOnlyRcvBufFullBusy = 1;
                PrtConfigBuf[OnlyRcvBufferFullBusy] = 1;
            }
            else
            {
                //bOnlyRcvBufFullBusy = 0;
                PrtConfigBuf[OnlyRcvBufferFullBusy] = 0;
            }
            break;
        default:
            cTemp = GetDataFromRcvBuf();
            break;
    }
    SPI_Erase_Sector(UserParameterBaseAddr);
    for(iLoop = 0; iLoop < 32; iLoop++)
    {
        SPI_Write_Byte(UserParameterBaseAddr+iLoop, PrtConfigBuf[iLoop]);
    }
}

//=========================================================================================================
//* ESC B n t
//* 打印机来单打印蜂鸣提示
//* 0 <= n <= 9
//* 0 <= t <= 9
//=========================================================================================================
void ESC_B(void)
{
    GetDataFromRcvBuf();
    GetDataFromRcvBuf();
}

//=========================================================================================================
//* ESC p m t1 t2
//* Generate pulse
//* m =0, 1, 48, 49
//* 0 <= t1 <= 255
//* 0 <= t2 <= 255
//=========================================================================================================
/*//沒用到；註解；AMO;2018.06.20
void ESC_p(void)
{
    uint8_t m;
    uint8_t t1;
    uint8_t t2;
    uint32_t iOnTime;
    uint32_t iOffTime;

    m = GetDataFromRcvBuf();
    t1 = GetDataFromRcvBuf();
    t2 = GetDataFromRcvBuf();
    iOnTime = t1 * 2;
    if(t2 < t1)
    {
        t2 = t1;
    }
    if(t2 < 50)
    {
        t2 = 50;
    }
    iOffTime = t2 * 2;
    WaitMotorStop();
    switch(m)
    {
        case 0:
        case '0':
        case 1:
        case '1':
                //bCash_ON;                 //沒用到；註解；AMO;2018.06.20
                //DelayMs(iOpenCashTimer);  //沒用到；註解；AMO;2018.06.20　
                //DelayMs(iCloseCashTimer); //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //AMO註解;AMO;2018.05.25
                //Delay(iCloseCashTimer);   //ms//新增;AMO;2018.06.20
                //bCash_OFF;                //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //AMO註解;AMO;2018.05.25
                //Delay(iCloseCashTimer);   //ms//新增;AMO;2018.06.20
            break;
        default:
            break;
    }
}
*/

//=========================================================================================================
//* ESC q m t1 t2
//* Generate pulse
//* m=0,1,48,49
//* 0<=t1<=255
//* 0<=t2<=255
//=========================================================================================================
void ESC_q(void)
{
    //uint8_t m;
    uint8_t t1;
    uint8_t t2;
    //uint32_t iOnTime;
    //uint32_t iOffTime;
    cChasNums = GetDataFromRcvBuf();
    t1 = GetDataFromRcvBuf();
    t2 = GetDataFromRcvBuf();
    iOpenCashTimer = t1 * 2;
    if(t2 < t1)
    {
        t2 = t1;
    }
    if(t2 < 50)
    {
        t2 = 50;
    }
    iCloseCashTimer = t2 * 2;
    WaitMotorStop();
    bOpenCashAfterPrt = 1;
}

//=========================================================================================================
//* ESC r
//* open cash after prt
//=========================================================================================================
void ESC_r(void)
{
    if(bOpenCashAfterPrt == 1)
    {
        WaitMotorStop();
        switch(cChasNums)
        {
            case 0:
            case '0':
            case 1:
            case '1':
                //bCash_ON;                 //沒用到；註解；AMO;2018.06.20
                //DelayMs(iOpenCashTimer);  //沒用到；註解；AMO;2018.06.20　
                //DelayMs(iCloseCashTimer); //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //AMO註解;AMO;2018.05.25
                //Delay(iCloseCashTimer);   //ms//新增;AMO;2018.06.20
                //bCash_OFF;                //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //沒用到；註解；AMO;2018.06.20
                //DelayMs(iCloseCashTimer); //AMO註解;AMO;2018.05.25
                //Delay(iCloseCashTimer);   //ms//新增;AMO;2018.06.20
                break;
            default:
                break;
        }
        bOpenCashAfterPrt = 0;
        cChasNums = 0;
        iOpenCashTimer = 0;
        iCloseCashTimer = 0;
    }
}


//=========================================================================================================
//* ESC U n
//*横向放大
//=========================================================================================================
void ESC_U(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if((cTemp > 0) && (cTemp < 5))
    {
        cAsciiWidthMultiple = cTemp;
    }
}


//=========================================================================================================
//* ESC V n
//*顺时针旋转90度
//=========================================================================================================
void ESC_V(void)
{
    GetDataFromRcvBuf();
}


//=========================================================================================================
//* ESC W n (0<n<4)
//*横向纵向放大
//=========================================================================================================
void ESC_W(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if((cTemp > 0) && (cTemp < 5))
    {
        cAsciiHightMultiple = cTemp;
        cAsciiWidthMultiple = cTemp;
    }
}


//=========================================================================================================
//* ESC t n ( 0 <=n <= 10 , 16 <=n <=19)
//*选择字符代码页
//=========================================================================================================
void ESC_t(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    cCodePage = cTemp;
}


//=========================================================================================================
//* ESC - n
//* set ASCII under line
//* ASCII
//*  0  <=n  <=2, 48 <=n <=50
//=========================================================================================================
void ESC_subb(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    switch(cTemp)
    {
        case 0:
        case 48:
            bAsciiUnderLine = 0;//无下划线
            break;
        case 1:
        case 49:
            bAsciiUnderLine = 1;//单点下划线
            break;
        case 2:
        case 50:
            bAsciiUnderLine = 2;//双点下划线
            break;
        default:
            break;
    }
}


//=========================================================================================================
//* Function name:     ByteHightMultiple    
//* Descriptions:      单个字节变3倍高
//=========================================================================================================
void ByteHightMultiple(uint8_t *pBytePattern,uint8_t *pByteHightPattern)
{
    uint32_t  iTemp = 0;
    uint8_t cLoop1;
    uint8_t cLoop2;

    for(cLoop1 = 0; cLoop1 < 8; cLoop1++)
    {
        for(cLoop2 = 0; cLoop2 < 3; cLoop2++)
        {
            iTemp = iTemp << 1;
            iTemp |= (*pBytePattern >> (7 - cLoop1))&0x01;
            //iTemp = iTemp<<1;
        }
    }
    *pByteHightPattern = iTemp >> 16;
    *(pByteHightPattern + 1) = iTemp >> 8;
    *(pByteHightPattern + 2) = iTemp;
}


//=========================================================================================================
//* ESC * m nL nH d1...dk
//* Select bit-image mode
//* m=0,1,32 ,33
//* 0<=nL<=255
//* 0<=nH<=3
//* 0<=d<=255
//=========================================================================================================
void ESC_star(void)
{
    uint8_t m;
    uint8_t nL;
    uint8_t nH;
    uint8_t cWidth;
    uint32_t iCounter;
    uint8_t cTemp[3];
    uint8_t cByte1, cByte2, cByte3;
    uint32_t iLoop;
    uint8_t cLoop;
    uint8_t *p1;
    uint8_t *p2;
    uint8_t *p3;

    m = GetDataFromRcvBuf();
    switch(m)
    {
        case 0:
        case 32:
            cWidth = 2;
            break;
        case 1:
        case 33:
            cWidth = 1;
            break;
        default:
            cWidth = 1;
            m = 0x01;
            break;
    }
    JudgeExceedByteLine(cWidth);
    // nL + 256 * nH
    nL = GetDataFromRcvBuf();
    nH = GetDataFromRcvBuf();
    iCounter = nL + 256 * nH;
    if(iCounter > (iPrtRightMargin - iCurrentFillColumn))
    {
        iCounter = iPrtRightMargin - iCurrentFillColumn;
    }
    
    if((m == 1 ) || (m == 0))
    {
        p1 = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        p2 = &PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn];
        p3 = &PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn];
        for(iLoop = 0; iLoop < iCounter; iLoop++)
        {
            if(iCurrentFillColumn + cWidth >= iPrtRightMargin)
            {
                // exceed the byte line
                while(iLoop < iCounter)
                {
                    GetDataFromRcvBuf();
                    iLoop++;
                }
                return ;
            }
            else
            {
                cByte1 = GetDataFromRcvBuf();
                ByteHightMultiple(&cByte1, cTemp);
                for(cLoop = 0;cLoop < cWidth; cLoop++)
                {
                    //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn]
                    *p3++ = cTemp[0];
                    //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn]
                    *p2++ = cTemp[1];
                    //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn]
                    *p1++ = cTemp[2];
                    iCurrentFillColumn ++;
                }
            }
        }
    }
    else if((m == 32 )||( m == 33))
    {
        p1 = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        p2 = &PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn];
        p3 = &PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn];
        for(iLoop = 0; iLoop < iCounter; iLoop++)
        {
            if(iCurrentFillColumn + cWidth >= iPrtRightMargin)
            {
                // exceed the byte line
                while(iLoop < iCounter)
                {
                    GetDataFromRcvBuf();
                    GetDataFromRcvBuf();
                    GetDataFromRcvBuf();
                    iLoop++;
                }
                return ;
            }
            else
            {
                cByte1 = GetDataFromRcvBuf();
                cByte2 = GetDataFromRcvBuf();
                cByte3 = GetDataFromRcvBuf();
                for(cLoop = 0; cLoop < cWidth; cLoop ++)
                {
                    //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn]
                    *p3++ = cByte1;
                    //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn]
                    *p2++ = cByte2;
                    //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn]
                    *p1++ = cByte3;	
                    iCurrentFillColumn ++;
                }
            }
        }
    }
    bHaveFilledRasterDot = 0;
}


//=========================================================================================================
//* ESC { n
//* bInvert Prt content
//=========================================================================================================
void ESC_Bigbrace(void)
{
    GetDataFromRcvBuf();
}


//=========================================================================================================
//* ESC a n
//* Select justification
//=========================================================================================================
void ESC_acmd(void)
{
    switch(GetDataFromRcvBuf())
    {
        case 0:
        case 48:
            if(iCurrentFillColumn == iPrtLeftMargin)
            {
                bAlign = Align_Left;
            }
            break;
        case 1:
        case 49:
            if(iCurrentFillColumn == iPrtLeftMargin)
            {
                bAlign = Align_Middle;
            }
            break;
        case 2:
        case 50:
            if(iCurrentFillColumn == iPrtLeftMargin)
            {
                bAlign = Align_Right;
            }
            break;
        default:
            //bAlign = Align_Left;
            break;
    }
}


//=========================================================================================================
//* ESC v
//* Printer Status
//=========================================================================================================
void ESC_v(void)
{
    uint8_t cTemp[1];
    if(bErrPE)
    {
        cTemp[0] = 0x00;
        SerialSendByte(cTemp[0]);
        //USB_Send_Data(cTemp,1);
    }
    else
    {
        cTemp[0] = 0x01;
        SerialSendByte(cTemp[0]);
        //USB_Send_Data(cTemp,1);
    }
}


//=========================================================================================================
//* ESC $ nL nH
//* set absolute print  position
//=========================================================================================================
void ESC_$(void)
{
    uint8_t nH;
    uint8_t nL;
    uint32_t iTemp;

    nL = GetDataFromRcvBuf();
    nH = GetDataFromRcvBuf();
    if(iCurrentFillColumn == 0)
    {
        iTemp = nH * 256 + nL;
        if(iTemp > MaxDotPos)
        {
            return;
        }
        else
        {
            iCurrentFillColumn = iTemp;
        }
    }
}

//=========================================================================================================
//* ESC \ nL nH
//* set relative print  position
//=========================================================================================================
void ESC_backslash(void)
{
    uint8_t nH;
    uint8_t nL;
    uint32_t iTemp;

    nL = GetDataFromRcvBuf();
    nH = GetDataFromRcvBuf();
    if(iCurrentFillColumn == iPrtLeftMargin)
    {
        iTemp = nH*256+nL;
        if(iTemp + iCurrentFillColumn > MaxDotPos)
        {
            return;
        }
        else
        {
            iCurrentFillColumn += iTemp;
        }
        
    }
}

//=========================================================================================================
//* FS .
//* Disable Chinese mode
//=========================================================================================================
void FS_dot(void)
{
    bChinese = 0;
}

//=========================================================================================================
//* FS &
//* Enable Chinese mode
//=========================================================================================================
void FS_and(void)
{
    bChinese = 1;
}

//=========================================================================================================
//* FS S n1 n2
//* Set left- and right-side Kanji character spacing
//* 0<=n1<=32
//* 0<=n2<=32
//=========================================================================================================
void FS_S(void)
{
    uint8_t n1;
    uint8_t n2;
    n1 = GetDataFromRcvBuf(); //Get n1
    n2 = GetDataFromRcvBuf(); //Get n2
    cChineseLeftSpace = n1;
    cChineseRightSpace = n2;
}

//=========================================================================================================
//* FS 2   
//* FS 2 c1 c2 d1...dk 定义用户自定义汉字
//* c1 = 0XFE    0XA1 <=c2 <=0XFE  0 <=d <=255  k = 72
//*一个汉字在flash中独占一个扇区
//=========================================================================================================
void FS_2(void)	
{
    uint8_t cLoop;
    uint8_t cFirst;
    uint8_t cSecond;
    uint8_t cThree;
    uint8_t c1;
    uint8_t c2;
    uint32_t  iwc;
    c1 = GetDataFromRcvBuf();
    c2 = GetDataFromRcvBuf();

    if(c1 == 0xfe && c2 >= 0xa1 && c2 <= 0xfe)
    {
        c2 -= 0xa1;
        iwc = c2;
        SPI_Erase_Sector(UserCharAddr_24x24 | (iwc << 12) );
        SPI_Write_Byte(UserCharAddr_24x24 | (iwc << 12), 0x01);
        for(cLoop = 0;cLoop < HZ_WIDTH ; cLoop++)
        {
            cFirst = GetDataFromRcvBuf();
            cSecond = GetDataFromRcvBuf();
            cThree  = GetDataFromRcvBuf();

            iwc = UserCharAddr_24x24 | (c2 << 12) |(1 + cLoop);
            SPI_Write_Byte(iwc, cFirst);
            SPI_Write_Byte(iwc + HZ_WIDTH, cSecond);
            SPI_Write_Byte(iwc + HZ_WIDTH * 2, cThree);
        }
    }
    else
    {
        for(cLoop = 0; cLoop < HZ_WIDTH * 3; cLoop++)
        {
            GetDataFromRcvBuf();
        }
    }
}

//=========================================================================================================
//* FS ! n
//* Set print mode(s) for Kanji characters
//* 0<=n<=255
//=========================================================================================================
void FS_ExcalmatoryMark(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    
    if(cTemp & BIT2)
    {
        cChineseWidthMultiple = 2;
    }
    else
    {
        cChineseWidthMultiple = 1;
    }
    if(cTemp & BIT3)
    {
        cChineseHightMultiple = 2;
    }
    else
    {
        cChineseHightMultiple = 1;
    }
    
    if(cChineseHightMultiple_Prt < cChineseHightMultiple)//新增 ;AMO;2018.05.25
    {
        cChineseHightMultiple_Prt = cChineseHightMultiple;//新增 ;AMO;2018.05.25
    }
    
    if(cTemp & BIT7)
    {
        bChineseUnderLine = 1;
    }
    else
    {
        bChineseUnderLine = 0;
    }
}

//=========================================================================================================
//* FS W n
//* Turn quadruple-size mode on/off for Kanji 
//* characters
//* 0<=n<=255
//=========================================================================================================
void FS_W(void)
{
    if(GetDataFromRcvBuf() & LSB)
    {
        cChineseWidthMultiple = 2;
        cChineseHightMultiple = 2;
        if(cChineseHightMultiple_Prt<cChineseHightMultiple)//新增 ;AMO;2018.05.25
        {
            cChineseHightMultiple_Prt=cChineseHightMultiple;//新增 ;AMO;2018.05.25
        }
    }
    else
    {
        cChineseWidthMultiple = 1;
        cChineseHightMultiple = 1;
        if(cChineseHightMultiple_Prt<cChineseHightMultiple)//新增 ;AMO;2018.05.25
        {
            cChineseHightMultiple_Prt=cChineseHightMultiple;//新增 ;AMO;2018.05.25
        }
    }
}
//=========================================================================================================
//* Function name:     ByteDoubleHightMultiple    
//* Descriptions:  单个字节变2倍高
//=========================================================================================================
void ByteDoubleHightMultiple(uint8_t *pBytePattern,uint8_t *pByteHightPattern)
{
    uint32_t  iTemp = 0;
    uint8_t cLoop1;
    uint8_t cLoop2;
    for(cLoop1 = 0;cLoop1 < 8;cLoop1++)
    {
        for(cLoop2 = 0; cLoop2 < 2; cLoop2++)
        {
            iTemp = iTemp << 1;
            iTemp |= (*pBytePattern >> (7 - cLoop1)) & 0x01;
            //iTemp = iTemp<<1;
        }
    }
    *pByteHightPattern = iTemp >> 8;
    *(pByteHightPattern + 1) = iTemp;
}
#define SectionSize   4096//一个扇区大小(byte)
#define SectionCounts 4//每幅图片扇区数量
/*
W25Q32；目前使用晶片;AMO;2018.06.20
共4M Byte  
共64个块（Block）
每个块大小为 64K 字节，
每个块又分为 16个扇区（Sector）
每个扇区 4K 个字节(byte)。
總共有1024(128*16)扇区
*/

//=========================================================================================================
//* FS p n m
//*  以m指定的模式打印下载到FLASH中的位图
//*1 <= n <= 5 , 0 <= m <= 3 , 48 <= m <=51
//=========================================================================================================
void FS_p(void)
{
    uint8_t n, m, xl, xh, yl, yh;
    uint8_t cWidth, cHight;
    uint8_t cLoop, cLoop1;
    uint32_t iLoop2;
    uint32_t iCount = 0;
    uint8_t cTemp[2];
    uint8_t data;
    uint32_t iTransverse;//横向点数
    uint32_t iLengthways;//纵向字节
    uint32_t iyy;
    uint8_t *p1, *p2;

    if(iCurrentFillColumn != iPrtLeftMargin) //当前填充位置标志位 和 左边距设置 比對;AMO;2018.05.25
    {
        return; //錯誤指令，不執行忽略返回;AMO;2018.05.25
    }
    n = GetDataFromRcvBuf();//Image 图号
    if(n < 1 || n > BIT_IMAGE_SIZE)
    {
        return; //錯誤指令，不執行忽略返回;AMO;2018.05.25
    }
    m = GetDataFromRcvBuf();//打印位图的模式
    switch(m)
    {
        case 0:
        case 48: //'0'
            cWidth = 1;
            cHight = 1;
            break;
        case 1:
        case 49://'1'
            cWidth = 2;
            cHight = 1;
            break;
        case 2:
        case 50://'2'
            cWidth = 1;
            cHight = 2;
            break;
        case 3:
        case 51://'3'
            cWidth = 2;
            cHight = 2;
            break;
        default:
            break;
    }
    if(SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts) == 0x55)//检测是否有图片;0x55代表有圖片;AMO;2018.05.25
    {
        //變數註解放著，方便對應
        /*
        W25Q32；目前使用晶片;AMO;2018.06.20
        共4M Byte  
        共64个块（Block）
        每个块大小为 64K 字节，
        每个块又分为 16个扇区（Sector）
        每个扇区 4K 个字节(byte)。
        總共有1024(128*16)扇区
        */
        //SectionSize        = 一个扇区大小=4096kbyte ;AMO;2018.05.25
        //SectionCounts      =  每幅图片扇区数量=4 ;AMO;2018.05.25
        //NvImageBaseAddr    =  0x1AA000//~0x1BEFFF  5*16k            //(可放5張圖片，每幅图片最大16Kbyte)  //放置到FLASH 中的位图(logo圖)；AMO;2018.06.20			
        //iCurrentFillColumn =  当前填充位置标志位 ;AMO;2018.05.25
        //iPrtLeftMargin     =  左边距设置 ;AMO;2018.05.25
        //BIT_IMAGE_SIZE     = 5 下载logo的数量 ;AMO;2018.05.25
        xl = SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts + 1);//读信息
        xh = SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts + 2);
        yl = SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts + 3);
        yh = SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts + 4);
        iLengthways = yl + yh*256; //縱向btye數;AMO;2018.05.25
        iTransverse = xl + xh*256; //橫向btye數;AMO;2018.05.25
        if(iTransverse > (MaxDotPos / 8)) //若圖片橫向寬度大於(384點/8)的長度，則只列印(384點/8)的長度部份;AMO;2018.05.25
        {
            iTransverse = MaxDotPos/8;
        }
        //if(iLengthways * cHight > PRTBUFHIGHT)//大于一个打印buffer
        //{
        for(cLoop = 0; cLoop < (iLengthways * cHight) / PRTBUFHIGHT + 1; cLoop++) //[iLengthways(縱向btye數) * cHight(倍高)  / PRTBUFHIGHT(=12=打印行高12个字节)]+1 ;AMO;2018.05.25
        {
            /*******************************************************************/
            if(cLoop == (iLengthways * cHight) / PRTBUFHIGHT)//   确定每次打印高度(iyy)
            {
                iyy = (iLengthways * cHight) % PRTBUFHIGHT;
            }
            else
            {
                iyy = PRTBUFHIGHT;
            }
            /*******************************************************************/

            for(cLoop1 = iyy; cLoop1 > 0; cLoop1--)
            {
                for(iLoop2 = 0; iLoop2 < iTransverse * 8 * cWidth; iLoop2++) //iTransverse(橫向btye數) * 8 * cWidth(倍寬) ;AMO;2018.05.25
                {
                    //IWDG_Reload;//沒使用，註解;AMO;2018.06.20
                    data = SPI_Read_Byte(NvImageBaseAddr + (n - 1) * SectionSize * SectionCounts + 5 + iCount); //加5的原因是前面4個是命令数据參數 ;AMO;2018.05.25
                    iCount++; //將指標指到下一筆圖形bytes資料;AMO;2018.05.25
                    
                    //cCurrentFillRow    = 当前默认填充buffer1 ;AMO;2018.05.25
                    //iCurrentFillColumn = 当前填充位置标志位  ;AMO;2018.05.25
                    p1 = &PrtBuf[cCurrentFillRow].ByteLine[cLoop1 - 1].BasePrtLine[iLoop2];//p1和p2=每個pixel點數的值，用1個byte來表示，一排最大點數MaxDotPos=384;AMO;2018.05.25
                    p2 = &PrtBuf[cCurrentFillRow].ByteLine[cLoop1 - 2].BasePrtLine[iLoop2];//表示取得一排高度為12的字的每一橫排的第一(0)個pixel點數的值的位址;AMO;2018.05.25
                    if(cHight == 2)//將打印圖做倍高處理;AMO;2018.05.25
                    {
                        ByteDoubleHightMultiple(&data, cTemp);
                        //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-1].BasePrtLine[iLoop2] = cTemp[0];
                        //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-2].BasePrtLine[iLoop2] = cTemp[1];
                        *p1 = cTemp[0];
                        *p2 = cTemp[1];
                        //cLoop2++;
                        if(cWidth == 2)//將打印圖做倍寬處理;AMO;2018.05.25
                        {
                            //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-1].BasePrtLine[++iLoop2] = cTemp[0];
                            //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-2].BasePrtLine[iLoop2] = cTemp[1];
                            p1++;
                            p2++;
                            *p1 = cTemp[0];
                            *p2 = cTemp[1];
                        }
                        //cLoop1--;//yxm 14.03.13
                    }
                    else
                    {
                        //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-1].BasePrtLine[iLoop2] = data;
                        *p1 = data;
                        //cLoop2++;
                        if(cWidth == 2)
                        {
                            p1++;
                            *p1 = data;
                            //PrtBuf[cCurrentFillRow].ByteLine[cLoop1-1].BasePrtLine[++iLoop2] = data;
                        }
                    }
                    
                    if(iLoop2 >= (MaxDotPos - 1))
                    {
                        for(iLoop2 = iLoop2; iLoop2 < iTransverse * 8 * cWidth; iLoop2++)
                        {
                            iCount++;
                            iLoop2++;
                        }
                        //iLoop2=iTransverse*8*cWidth;
                    }
                    if(cWidth == 2)
                    {
                        iLoop2++;
                    }
                }
                if(cHight == 2)
                {
                    cLoop1--;
                }
            }
            iImageDotHight = iyy*8;//iImageDotHight(位图的縱向點高度);AMO;2018.05.25
            iCurrentFillColumn = iTransverse * 8 * cWidth;//iCurrentFillColumn(位图的橫向點寬度) ;AMO;2018.05.25
            if(iCurrentFillColumn > MaxDotPos) //若點寬度超過384(MaxDotPos),則最大只打印384點 ;AMO;2018.05.25
            {
                iCurrentFillColumn = MaxDotPos;
            }
            bHaveFilledImageDot = 1; //設為1,代表有字符行填充下载位图需打印 ;AMO;2018.05.25
            //if(cLoop == (iLengthways*cHight)/PRTBUFHIGHT)
            {
                ;
            }
            //else
            {
                StartupPrint(0); //打印  //打印NV位圖不需要走行间距//修改;AMO;2018.05.25
            }
        }
        //}
    }
}

//=========================================================================================================
//* FS q
//* FS q n [xL xH yL yH d1...dk]1...[xL xH yL yH d1...dk]n
//* 定义Flash 位图
//* 0<=n<=255
//*0 <= xL ≤ 255
//*1 <= ( xL + xH x 256) <= 1023
//*1 <= ( yL + yH x 256) <= 288
//*0 <= d <= 255
//*k = ( xL + xHx 256) x( yL +yH x 256) x 8
//=========================================================================================================
void FS_q(void)
{
    uint32_t iCount, iCnt;
    uint32_t iLoop, iLoop1;
    uint8_t n, xl, xh, yl, yh;
    uint8_t cLoop;
    uint8_t data;

    //變數註解放著，方便對應
    /*
    W25Q32；目前使用晶片;AMO;2018.06.20
    共4M Byte  
    共64个块（Block）
    每个块大小为 64K 字节，
    每个块又分为 16个扇区（Sector）
    每个扇区 4K 个字节(byte)。
    總共有1024(128*16)扇区
    */
    //SectionSize        = 一个扇区大小 = 4096kbyte;AMO;2018.05.25
    //SectionCounts      = 每幅图片扇区数量 = 4;AMO;2018.05.25
    //NvImageBaseAddr    = 0x1AA000//~0x1BEFFF  5*16k  //(可放5張圖片，每幅图片最大16Kbyte)  //放置到FLASH 中的位图(logo圖)；AMO;2018.06.20
    //iCurrentFillColumn = 当前填充位置标志位
    //iPrtLeftMargin     = 左边距设置
    //BIT_IMAGE_SIZE     = 5 下载logo的数量
    if(iCurrentFillColumn != iPrtLeftMargin) //若目前的位置不是在左邊距設置則，錯誤指令，不執行忽略返回;AMO;2018.05.25
    {
        return;
    }
    n = GetDataFromRcvBuf();
    if(n < 1 || n > BIT_IMAGE_SIZE)
    {
        return;
    }
    for(cLoop = 0; cLoop < n * SectionCounts; cLoop ++)//擦除要重新下载的扇区，每个图片占SectionCounts个扇区
    {
        SPI_Erase_Sector(NvImageBaseAddr + cLoop * SectionSize);
    }
    for(cLoop = 0; cLoop < n; cLoop ++)  //開始處理每張圖存放的位置
    {
        xl = GetDataFromRcvBuf();
        xh = GetDataFromRcvBuf();
        yl = GetDataFromRcvBuf();
        yh = GetDataFromRcvBuf();
        iCount = (xl + xh * 256) * 8 * (yl + yh * 256); //iCount=一張圖片的bytes數
        if(iCount > (SectionSize * SectionCounts - 5))//数据量大于4K*SectionCounts丢掉 //應該不用減5，??;AMO;2018.05.25
        {
            PrintStr((uint8_t *)"buffer overflow to download data ", 1);  //''PrintStr((uint8_t *)"下载数据超出缓冲区 ",1);
            while(iCount--)
            {
                GetDataFromRcvBuf(); //把環狀陣列,關於圖片的資料都清除掉
            }
            return;
        }
        if((xl + xh * 256) * 8 > MaxDotPos) //MaxDotPos=一行384點
        {
            iCnt = MaxDotPos;
        }
        else
        {
            iCnt = (xl + xh * 256) * 8;
        }
        SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts, 0x55);//信息头  //放圖片時,會先放著0x55代表圖片資料表頭,代表後續資料是有意義的//；AMO;2019.04.15
        SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts + 1, (iCnt / 8)); //
        SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts + 2, (iCnt / 8) >> 8);
        SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts + 3, yl);
        SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts + 4, yh);
        /***********************按排列规律写进FLASH中***************************/

        //經讀取flash資料，驗證存入的資料都是對的;AMO;2018.05.25
        for(iLoop = 0; iLoop < (xl + xh * 256) * 8; iLoop++)//横向点数
        {
            for(iLoop1 = 0; iLoop1 < (yl + yh * 256); iLoop1++)//纵向字节
            {
                data = GetDataFromRcvBuf();
                SPI_Write_Byte(NvImageBaseAddr + cLoop * SectionSize * SectionCounts + 5 + iLoop + iLoop1 * iCnt, data);
                if(iLoop1 ==(SectionSize * SectionCounts - 5) / iCnt - 1)//能接收的最大高度
                {
                    while(iLoop1 ++ < (yl + yh * 256))
                    {
                        GetDataFromRcvBuf();
                    }
                }
            }
            if(iLoop == (MaxDotPos - 1))//能接收的最大宽度
            {
                if(iLoop + 1 < (xl + xh * 256) * 8)
                {
                    for(iLoop1 = 0; iLoop1 < (yl + yh * 256); iLoop1++)//纵向字节
                    {
                        GetDataFromRcvBuf();
                    }
                    iLoop++;
                }
            }
        }
    }
}

//=========================================================================================================
//* FS - n
//* set characters under line
//* characters
//*  0  < = n  < = 2, 48 < = n < = 50
//=========================================================================================================
void FS_subb(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    switch(cTemp)
    {
        case 0:
        case 48:
            bChineseUnderLine = 0;
            break;
        case 1:
        case 49:
            bChineseUnderLine = 1;
            break;
        case 2:
        case 50:
            bChineseUnderLine = 2;
            break;
        default:
            break;
    }
}

//=========================================================================================================
//* ESC @
//*Init Printer 
//=========================================================================================================
void ESC_ATInit(void)//Check-Ok;AMO;2018.05.25
{
    WaitMotorStop();//若电机在运行，則等待馬達運行完，再執行按鍵動作;AMO;2018.05.25
    //* GS  ! n
    cAsciiWidthMultiple = 1;//字符倍宽1倍
    cAsciiHightMultiple = 1;//字符倍高1倍
    cAsciiHightMultiple_Prt = 1;
    cChineseHightMultiple_Prt = 1;//新增 ;AMO;2018.05.25

    //* ESC SP n
    cAsciiRightSpace = 0;//字符右边距

    //* ESC 2
    iLineSpaceNumber = LINE_SPACE;//两行之间点行数

    //* FS ! n
    cChineseWidthMultiple = 1;//汉字倍宽1倍
    cChineseHightMultiple = 1;//汉字倍高1倍

    //* FS S n1 n2
    cChineseRightSpace = 0;//汉字右边距
    cChineseLeftSpace = 0;//汉字左边距

    //* FS &
    //bChinese = 1;//汉字模式
    bPESensorEnable = ENABLE;

    //* ESC M n
    bFont12x24 = 1;//初始化默认大字体

    //* ESC a n
    bAlign = Align_Left;//左对齐

    //* GS  B n
    bPrtAdverse = 0;//反白打印

    //* FS - n
    bChineseUnderLine = 0;//汉字下划线

    //* ESC - n
    bAsciiUnderLine = 0;//字符下划线

    //*ESC  E n
    bBold = 0;//粗体模式

    //*ESC  R n
    cInternationalCharSet = USA;//国际字符集

    //*ESC L nL nH
    iPrtLeftMargin = 0;//左边距

    //*ESC W nL nH
    iPrtRightMargin = MaxDotPos;

    //*ESC c 5 n
    bDisableButtons = 0;//按键使能

    //?ESC % n
    bUserChar = 0;

    //memset(&UserDefinedBuf, 0, sizeof(UserDefinedBuf)); //這個原本就註解了;AMO;2018.05.25
    ClrCharPrtBuf(0);//初始化打印buffer1 //Check-Ok;AMO;2018.05.25
    ClrCharPrtBuf(1);//初始化打印buffer2 //Check-Ok;AMO;2018.05.25

    BarCodeInit();   //Check-Ok;AMO;2018.05.25
    cCodePage = SPI_Read_Byte(UserParameterBaseAddr + CodePageAddr);    //读取代码页的值
    bChinese = SPI_Read_Byte(UserParameterBaseAddr + CharacterModeAddr);//读取打印模式参数并设置
}

//=========================================================================================================
//* GS  ! n
//* Select print mode(s)
//=========================================================================================================
void GS_ExcalmatoryMark(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if(((cTemp & 0x0F) > 0x03 )|| ((cTemp & 0xF0) > 0x30))
    {
        return;
    }
    else
    {
        cChineseHightMultiple = (cTemp & 0x0F) + 1;
        cAsciiHightMultiple = (cTemp & 0x0F) + 1;

        cChineseWidthMultiple = ((cTemp >> 4) & 0x0F) + 1;
        cAsciiWidthMultiple = ((cTemp >> 4) & 0x0F) + 1;
        
        if(cAsciiHightMultiple_Prt < cAsciiHightMultiple)
        {
            cAsciiHightMultiple_Prt = cAsciiHightMultiple;
        }
        
        if(cChineseHightMultiple_Prt < cChineseHightMultiple)//新增 ;AMO;2018.05.25
        {
            cChineseHightMultiple_Prt = cChineseHightMultiple;//新增 ;AMO;2018.05.25
        }
    }
}

//=========================================================================================================
//* GS  B n
//* 选择/取消反白打印
//=========================================================================================================
void GS_B(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if(cTemp&LSB)
    {
        bPrtAdverse = 1;
    }
    else
    {
        bPrtAdverse = 0;
    }
}

//=========================================================================================================
//* GS  L  nL nH
//* 设置左边距
//=========================================================================================================
void GS_L(void)
{
    uint8_t nH;
    uint8_t nL;
    nL = GetDataFromRcvBuf();
    nH = GetDataFromRcvBuf();
    if(iCurrentFillColumn == iPrtLeftMargin)
    {
        iPrtLeftMargin = nH * 256 + nL;
        if(iPrtLeftMargin > MaxDotPos)
        {
            iPrtLeftMargin = MaxDotPos;
        }
        iCurrentFillColumn = iPrtLeftMargin;
    }
}

//=========================================================================================================
//* GS * x y d1...d(x × y × 8) 定义下载位图
//*下载位图
//*0<=x<=48 0<=y<=24
//=========================================================================================================
void GS_star(void)
{
    /*uint8_t x;
    uint8_t y;
    uint32_t iLoop;
    uint8_t cLoop;
    x = GetDataFromRcvBuf();
    y = GetDataFromRcvBuf();
        
    for(iLoop = 0; iLoop < x * 8; iLoop++)
    {
        for(cLoop = 0; cLoop < y; cLoop++)
        {
            UserDefinedBuf[iLoop + cLoop * MaxDotPos] = GetDataFromRcvBuf();
            if(cLoop == (PRTBUFHIGHT-1))//超高的丢掉
            {
                while((cLoop + 1) < y)

                {
                    GetDataFromRcvBuf();
                    cLoop++;
                }
            }
        }

        if(iLoop == (MaxDotPos - 1))//超宽的丢掉
        {
            while((iLoop+1)<x*8)

            {
                for(cLoop = 0; cLoop < y; cLoop++)
                {
                    GetDataFromRcvBuf();
                }
                iLoop++;
            }
        }
    }*/
}

//=========================================================================================================
//* GS / m 打印下载位图
//*打印下载位图
//=========================================================================================================
void GS_slash(void)
{
    /*uint8_t m;
    uint8_t cWidth;
    uint8_t cHignt;
    
    m = GetDataFromRcvBuf();
    switch(m)
    {
    case 0:
    case 48:
        cWidth = 1;
        cHignt = 1;
        break;
    case 1:
    case 49:
        cWidth = 2;
        cHignt = 1;
        break;
    case 2:
    case 50:
        cWidth = 1;
        cHignt = 2;
        break;
    case 3:
    case 51:
        cWidth = 2;
        cHignt = 2;
        break;
    default:
        break;
    } */
}

//=========================================================================================================
//* Function name:     ByteWidthMultiple    
//* Descriptions:  单个字节变2倍宽
//=========================================================================================================
void ByteWidthMultiple(uint8_t *pBytePattern, uint8_t *pByteWidthPattern)
{
    uint32_t  iTemp = 0;
    uint8_t cLoop1;
    uint8_t cLoop2;

    for(cLoop1 = 0; cLoop1 < 8; cLoop1++)
    {
        for(cLoop2 = 0; cLoop2 < 2; cLoop2 ++)
        {
            iTemp = iTemp<< 1;
            iTemp |= (*pBytePattern >> (7 - cLoop1)) & 0x01;
        }
    }
    *(pByteWidthPattern) = iTemp >> 8;
    *(pByteWidthPattern + 1) = iTemp;
}

//=========================================================================================================
//* GS v 0 m xL xH yL yH d1...dk
//* 光栅位图打印模式
//=========================================================================================================
#define Min(a,b)   ((a)<(b))?(a):(b)
void GS_v(void)
{
    uint8_t xH,xL,yH,yL;
    uint8_t m;
    uint8_t cWidth;
    uint8_t cHight;
    uint32_t  iTransverse;//横向字节
    uint32_t  iLengthways;//纵向点数
    uint32_t  iTemp;
    uint8_t cLoop,cLoop1,cLoop2;
    uint8_t cTempBuf[2];
    uint8_t Buf[MaxDotPos / 8];
    uint32_t  iMin;
    uint8_t *p1,*p2;
    uint32_t  iyy;
    uint8_t Width_v;

    if(bHaveFilledRasterDot)
    {
        StartupPrint(0);
    }
    if(iCurrentFillColumn != iPrtLeftMargin)
    {
        return;
    }

    if(GetDataFromRcvBuf() == 0x30)//默认
    {
        m = GetDataFromRcvBuf();//判断打印模式倍高倍宽
        switch(m)
        {
            case 0:
            case 48:
                cWidth = 1;
                cHight = 1;
                break;
            case 1:
            case 49:
                cWidth = 2;
                cHight = 1;
                break;
            case 2:
            case 50:
                cWidth = 1;
                cHight = 2;
                break;
            case 3:
            case 51:
                cWidth = 2;
                cHight = 2;
                break;
            default:
                break;
        }
        /*得到横向字节数和纵向点数*/
        xL = GetDataFromRcvBuf();//xl < 48
        xH = GetDataFromRcvBuf();//xh = 0
        yL = GetDataFromRcvBuf();//yl <8*24
        yH = GetDataFromRcvBuf();//yh = 0
        iLengthways = (yL + yH * 256)*cHight;//纵向点数
        iTransverse = xL + xH * 256;//横向字节数
        if(iLengthways == 0 || iTransverse == 0)
        {
            return;
        }
        //if((iLengthways-1)/(PRTBUFHIGHT*8))//数据多出一个打印buf
        //{
        for(cLoop2 = 0; cLoop2 < iLengthways / (PRTBUFHIGHT * 8) + 1; cLoop2 ++)//填充整个打印buf循环n次
        {
            /*******************************************************************/
            if(cLoop2 == iLengthways / (PRTBUFHIGHT*8))//   确定每次打印高度
            {
                iyy = iLengthways % (PRTBUFHIGHT*8);
            }
            else
            {
                iyy = PRTBUFHIGHT * 8;
            }
            /*******************************************************************/
            for(cLoop = iyy;cLoop > 0;cLoop--)//填充(PRTBUFHIGHT*8)点行
            {
                iMin = Min(MaxDotPos / 8, iTransverse);//每点行最少数据
                iTemp = ((cLoop - 1) % 8) * (MaxDotPos / 8);//填充起始位置
                for(cLoop1 = 0; cLoop1 < iTransverse; cLoop1 ++)//收一点行数据，多了丢掉
                {
                    if(cLoop1<MaxDotPos / 8)
                    {
                        Buf[cLoop1] = GetDataFromRcvBuf();
                    }
                    else
                    {
                        GetDataFromRcvBuf();
                    }
                }
                if(cWidth == 2)//倍宽变化
                {
                    uint8_t Buf1[MaxDotPos / 16];
                    for(cLoop1 = 0; cLoop1 < iMin; cLoop1++)
                    {
                        Buf1[cLoop1] = Buf[cLoop1];
                    }
                    for(cLoop1 = 0; cLoop1 < iMin; cLoop1++)
                    {
                        ByteWidthMultiple(&Buf1[cLoop1], cTempBuf);
                        Buf[cLoop1 * 2] = cTempBuf[0];
                        Buf[cLoop1 * 2 + 1] = cTempBuf[1];
                    }
                }
                if(cHight == 1)//普通高度填充数据
                {
                    p1 = &PrtBuf[cCurrentFillRow].ByteLine[(cLoop - 1) / 8].BasePrtLine[iTemp];
                    if(cWidth == 2)
                    {
                        Width_v = iMin * 2;
                            if(Width_v > 48)
                            {
                                Width_v = 48;
                            }
                    
                    }
                    else
                    {
                        Width_v=iMin;
                    }
                    
                    for(cLoop1 = 0; cLoop1 < Width_v; cLoop1 ++)
                    {
                        //PrtBuf[cCurrentFillRow].ByteLine[(cLoop-1)/8].BasePrtLine[iTemp+cLoop1] = Buf[cLoop1];
                        *p1++ = Buf[cLoop1];
                    }
                }
                else//倍高填充数据
                {
            
                    if(cWidth == 2)
                    {
                        Width_v = iMin * 2;
                            if(Width_v > 48)
                            {
                                Width_v = 48;
                            }
                    }
                    else
                    {
                        Width_v = iMin;
                    }

                    p1 = &PrtBuf[cCurrentFillRow].ByteLine[(cLoop - 1) / 8].BasePrtLine[iTemp];
                    p2 = &PrtBuf[cCurrentFillRow].ByteLine[(cLoop - 1) / 8].BasePrtLine[iTemp - (MaxDotPos / 8)];
                    for(cLoop1 = 0; cLoop1 < Width_v; cLoop1++)
                    {
                        //PrtBuf[cCurrentFillRow].ByteLine[(cLoop - 1) / 8].BasePrtLine[iTemp+cLoop1] = Buf[cLoop1];
                        //PrtBuf[cCurrentFillRow].ByteLine[(cLoop - 1) / 8].BasePrtLine[iTemp+cLoop1 - (MaxDotPos / 8)] = Buf[cLoop1];
                        *p1 ++ = Buf[cLoop1];
                        *p2 ++ = Buf[cLoop1];
                    }
                    cLoop--;
                }
            }
            /*******************************************************************/
            iRasterDotHight = iyy;
            iCurrentFillColumn = MaxDotPos;
            bHaveFilledRasterDot = 1;
            if(cLoop2 == iLengthways / (PRTBUFHIGHT * 8))
            {
                ;
            }
            else
            {
                StartupPrint(0);//打印
            }
        }
        //}
    }
}

//=========================================================================================================
//* GS W  nL nH
//* 设置打印区域
//=========================================================================================================
void GS_W(void)
{
    uint8_t nH;
    uint8_t nL;
    uint32_t  iTemp;
    nL = GetDataFromRcvBuf();
    nH = GetDataFromRcvBuf();
    if((iCurrentFillColumn == iPrtLeftMargin)/*||((iCurrentFillColumn == iLeftMargin)&&(!iLeftMargin))*/)
    {
        iTemp = nH*256+nL;
        if( iTemp <= 12 )//AMO新增，限制範圍設在12~384;AMO;2018.05.25
        {
            iTemp=12;
        }
        if( iTemp >= 384 )//AMO新增，限制範圍設在12~384;AMO;2018.05.25
        {
            iTemp=384;
        }

        if(iPrtLeftMargin + iTemp > MaxDotPos)
        {
            iTemp = MaxDotPos - iPrtLeftMargin;
        }
        iPrtRightMargin = iPrtLeftMargin + iTemp;
    }
}

//=========================================================================================================
//* GS H  n
//*0 ≤ n ≤ 3, 48 ≤ n ≤ 51
//* 选择HRI 字符的打印位置
//=========================================================================================================
void GS_H(void)
{
    uint8_t n;
    n = GetDataFromRcvBuf(); 
    n = n & 0x03;
    BarCode.cFontPosition = n;
}

//=========================================================================================================
//* GS f  n
//* n = 0, 1, 48, 49
//*  选择 HRI 使用字体
//=========================================================================================================
void GS_f(void)
{
    uint8_t n;
    n = GetDataFromRcvBuf();
    switch(n)
    {
        case 0:
        case 48:
            BarCode.cFont = 0;
            break;
        case 1:
        case 49:
            BarCode.cFont = 1;
            break;
        default:
            break;
    }
}

//=========================================================================================================
//* GS k  m d1...dk NUL /d1... dn
//* 打印一维条码
//=========================================================================================================
void GS_k(void)
{
    uint8_t m;
    uint8_t n;
    uint8_t cTemp;
    // uint8_t i;
    // uint8_t bHRIOnBarCode = 0;
    // uint8_t bHRIUnderBarCode = 0;
    // uint32_t  iLong; 
    // uint32_t  iAddr;
    uint8_t cTempBuf[256];
    // uint8_t cBarCodeBuf[256];
    // uint8_t bHRIFontSize;
    m = GetDataFromRcvBuf();
    if(iCurrentFillColumn != iPrtLeftMargin)
    {
        return;
    }
    if(m < 7)
    {
        for(cTemp = 0;cTemp <= 255;cTemp ++)
        {
            cTempBuf[cTemp] = GetDataFromRcvBuf();
            if(cTempBuf[cTemp] == 0x00)
            {
                break;
            }
        }
        switch(m)
        {
            case 0://UPC-A
                PrintBarCode_UPCA(cTempBuf,cTemp);
                break;
            case 1://UPC-E
                PrintBarCode_UPCE(cTempBuf,cTemp);
                break;
            case 2://EAN13(JAN13)
                PrintBarCode_EAN13(cTempBuf,cTemp);
                break;
            case 3://JAN8
                PrintBarCode_JAN8(cTempBuf,cTemp);
                break;
            case 4://CODE39
                PrintBarCode_CODE39(cTempBuf,cTemp);
                break;
            case 5://ITF
                PrintBarCode_ITF(cTempBuf,cTemp);
                break;
            case 6://CODEBAR
                PrintBarCode_CODEBAR(cTempBuf,cTemp);
                break;
            default:
                break;
        }
    }
    else if('A'<= m <='I')
    {
        n = GetDataFromRcvBuf();
        for(cTemp = 0;cTemp < n;cTemp ++)
        {
            cTempBuf[cTemp] = GetDataFromRcvBuf();
        }
        switch(m)
        {
            case 'A'://UPC-A
                PrintBarCode_UPCA(cTempBuf,cTemp);
                break;
            case 'B'://UPC-E
                PrintBarCode_UPCE(cTempBuf,cTemp);
                break;
            case 'C'://EAN13
                PrintBarCode_EAN13(cTempBuf,cTemp);
                break;
            case 'D'://EAN8
                PrintBarCode_JAN8(cTempBuf,cTemp);
                break;
            case 'E'://CODE39
                PrintBarCode_CODE39(cTempBuf,cTemp);
                break;
            case 'F'://ITF
                PrintBarCode_ITF(cTempBuf,cTemp);
                break;
            case 'G'://CODEBAR
                PrintBarCode_CODEBAR(cTempBuf,cTemp);
                break;
            case 'H'://CODE93
                PrintBarCode_CODE93(cTempBuf,cTemp);
                break;
            case 'I'://CODE128
                PrintBarCode_CODE128(cTempBuf,cTemp);
                break;
            default:
                break;
        }
    }
}

//=========================================================================================================
//* GS h n
//* 设置一维条码高度
//=========================================================================================================
void GS_h(void)
{
    uint8_t cTemp;
    cTemp = GetDataFromRcvBuf();
    if( cTemp <=8 )
    {
     cTemp=8;//AMO新增，限制從8開始;AMO;2018.05.25
    }
    BarCode.cHight = cTemp;
}

//=========================================================================================================
//* GS w n
//* 设置一维条码宽度
//=========================================================================================================
void GS_w(void)
{
    BarCode.cWidth = GetDataFromRcvBuf();
}

//=========================================================================================================
//* US DC
//* yxm  test   
//void OneByteToHightMultiple(uint8_t ByteData,uint8_t *pByteHightPattern, uint8_t m);
//=========================================================================================================
/*//註解;AMO;2018.05.25
void US_DC(void)
{
    uint8_t cTemp;
  #if(BT2417 == 1)
    uint32_t  iBaudRate;
    uint8_t cLoop;
    uint8_t cBTBuf[32] = {0x00};
    uint8_t m;
    uint8_t cTmpBuf[32];
  #endif
    cTemp = GetDataFromRcvBuf();
    switch(cTemp)
    {
        case 0x01:
        AD_Value[Paper_ADC]=Sample_ADC_Conversion(Paper_ADC); //0=GPIO_PA0=Paper_ADC；1=GPIO_PA4=Thermal_ADC ;AMO;2018.06.20
        AD_Value[Thermal_ADC]=Sample_ADC_Conversion(Thermal_ADC); //0=GPIO_PA0=Paper_ADC；1=GPIO_PA4=Thermal_ADC ;AMO;2018.06.20

            SerialSendByte(AD_Value[Paper_ADC]>>8);
            SerialSendByte(AD_Value[Paper_ADC]);
            SerialSendByte(AD_Value[Thermal_ADC]>>8);
            SerialSendByte(AD_Value[Thermal_ADC]);
            break;
        case 0x02:
            //SPI_Read_nBytes(UserParameterBaseAddr,cBuf,10);
            //SerialSendByte(SPI_Read_Byte(0xc4));
            //SerialSendByte(SPI_Read_Byte(0xc5));
            //SerialSendByte(SPI_Read_Byte(0xc6));
            //SerialSendByte(SPI_Read_Byte(0xc7));
            //SerialSendByte(SPI_Read_Byte(0xc8));
            //SPI_Erase_Sector(0);
            //SPI_Write_Byte(0,0x55);
            //for(i = 0;i<10;i++)
            //SerialSendByte(cBuf[i]);
            //SPI_Write_nBytes(0,cBuf,1024*4);
            break;
        case 0x03:
            HexPrint();//enter hex mode
            break;
        case 0x04:
            SelfTestPrint();//print Selftest
            break;
        case 0x05:
            bFontBig5 = 1;
            break;
        case 0x06:
            bFontBig5 = 0;
            break;
        case 0x07:
        break;
        default:
            break;
    }
}
*/
//=========================================================================================================
//*US ESC m  nL  nH  d1... dn
//* 设置代码页
//=========================================================================================================
/*//註解;AMO;2018.05.25
void US_ESC(void)
{
    uint32_t iLoop;
    uint8_t cTemp;
    if(GetDataFromRcvBuf() == 0x1f)
    {
        cTemp = GetDataFromRcvBuf();
        for(iLoop = 0;iLoop < 32;iLoop++)
        {
            PrtConfigBuf[iLoop] = SPI_Read_Byte (UserParameterBaseAddr+iLoop);
        }
        if(cTemp == 0xff)
        {
            PrtConfigBuf[CodePageAddr] = GetDataFromRcvBuf();
            SPI_Erase_Sector(UserParameterBaseAddr);
            for(iLoop = 0;iLoop < 32;iLoop++)
            {
                SPI_Write_Byte(UserParameterBaseAddr+iLoop,PrtConfigBuf[iLoop]);
            }
            cCodePage = PrtConfigBuf[CodePageAddr];
        }
        else if(cTemp == 0xfd)
        {

            PrtConfigBuf[SerialBauRateAddr] = GetDataFromRcvBuf();
            switch(PrtConfigBuf[SerialBauRateAddr])
            {
                case 0:
                    iBaudRate = 4800;
                    break;
                case 1:
                    iBaudRate = BAUDRATE9600;
                    break;
                case 2:
                    iBaudRate = BAUDRATE19200;
                    break;
                case 3:
                    iBaudRate = BAUDRATE38400;
                    break;
                case 4:
                    iBaudRate = BAUDRATE57600;
                    break;
                case 5:
                    iBaudRate = BAUDRATE115200;
                    break;
                case 6:
                    iBaudRate = 2400;
                    break;
                case 7:
                    iBaudRate = 1200;
                    break;
                default:
                    iBaudRate = BAUDRATE115200;
                    break;
            }

            //USART_Configuration(); //AMO註解;AMO;2018.05.25
            SPI_Erase_Sector(UserParameterBaseAddr);
            for(iLoop = 0;iLoop < 32;iLoop++)
            {
                SPI_Write_Byte(UserParameterBaseAddr+iLoop,PrtConfigBuf[iLoop]);
            }
        }
    }
}
*/

//=========================================================================================================
//*ESCCommand
//* ESC 指令
//=========================================================================================================
void ESCCommand(uint8_t cParameter)
{
    switch(cParameter)
    {
        case ' '://TEST_OK;AMO;2018.05.25
            ESC_SP();               // ESC SP   1B 20
            break;
        case 'J'://TEST_OK;AMO;2018.05.25
            ESC_J();                // ESC J     1B 4A
            break;
        case 'M':
            ESC_M();                // ESC M    1B 4D
            break;
        case '3'://TEST_OK;AMO;2018.05.25
            ESC_3();                // ESC 3    1B 33
            break;
        case '2'://TEST_OK;AMO;2018.05.25
            ESC_2();                // ESC 2     1B  32
            break;
        case 'U':
            ESC_U();                // ESC U     1B 55
            break;
        case 'V':
            ESC_V();                // ESC V     1B 56
            break;
        case 'W':
            ESC_W();                // ESC W    1B 57
            break;
        case 't':
            ESC_t();                // ESC t      1B 74 
            break;
        case 'R':
            ESC_R();                // ESC R      1B 52
            break;
        case '!'://TEST_OK;AMO;2018.05.25
            ESC_ExcalmatoryMark();  // ESC !    1B  21 
            break;
        case '%':
            ESC_mod();              // ESC %       1B  25
            break;
        case '&':
            ESC_and();              // ESC &        1B  26
            break;
        case '*':
            ESC_star();             // ESC *  1B 2A
            break;
        case 'c'://TEST_OK;AMO;2018.05.25
            ESC_c();                // ESC c   1B 63
            break;
        case 'd'://TEST_OK;AMO;2018.05.25
            ESC_dcmd();             // ESC d   1B 64
            break;
        case 'a'://TEST_OK;AMO;2018.05.25
            ESC_acmd();             // ESC a   1B 61
            break;
        case 'e':
            //ESC_ecmd();           // ESC e
            break;
        case '?':
            ESC_interrogation();    // ESC ?   1B  3F
            break;
        case 'D':
            ESC_D();                // ESC D    1b 44
            break;
        case '-'://TEST_OK;AMO;2018.05.25
            ESC_subb();             // ESC -     1B 2D  
            break;
        case '{':
            ESC_Bigbrace();         // ESC {     1B  7B 
            break;
        case '=':
            //ESC_equal();          // ESC =
            break;
        case 'E'://TEST_OK;AMO;2018.05.25
            ESC_E();                // ESC E   1B  45
            break;
        case 'G'://TEST_OK;AMO;2018.05.25
            ESC_G();                // ESC G   1B  47
            break;
        case 'N':
            ESC_N();                // ESC N   1B 4E
            break;
        case 'm':
            //ESC_m();              // ESC m
            break;
        case 'u':
            //ESC_ucmd();           // ESC u
            break;
        case 'v':
            ESC_v();                // ESC v   1B  76
            break;
        case '@'://TEST_OK;AMO;2018.05.25
            ESC_ATInit();           // ESC @  1B 40
            break;
        case 'p'://沒使用，註解;AMO;2018.06.20
            //ESC_p();              // ESC p  1B 70  
            break;
        case 'q':
            ESC_q();                // ESC q  1B 71
            break;
        case 'r':
            ESC_r();                // ESC r   1B 72
            break;
        case '$'://TEST_OK;AMO;2018.05.25
            ESC_$();                // ESC $   1B  24  
            break;
        case '\\'://反斜杠用法，反斜杠不能单独使用
            ESC_backslash();        // ESC  \ 1B  2F
            break;
        case 'B': 
            ESC_B();                // ESC B   1B 42
            break;
        case 'C': 
        //  ESC_C();                // ESC B   1B 43
            break;
        default:
            break;
    }
}

//=========================================================================================================
//*FSCommand
//* FS 指令
//=========================================================================================================
void FSCommand(uint8_t cParameter)
{
    switch(cParameter)
    {
        case '.'://TEST_OK;AMO;2018.05.25
            FS_dot();       // FS  .
            break;
        case '&'://TEST_OK;AMO;2018.05.25
            FS_and();       //FS  &
            break;
        case 'S'://TEST_OK;AMO;2018.05.25
            FS_S();         // FS S
            break;
        case '!'://TEST_OK;AMO;2018.05.25
            FS_ExcalmatoryMark();// FS !
            break;
        case '-'://TEST_OK;AMO;2018.05.25
            FS_subb();              // FS -
            break;
        case '2':
            FS_2();                 // FS 2
            break;
        case '?':
            //FS_interrogation();   // FS ?
            break;
        case 'C':
            //FS_C();               // FS C
            break;
        case 'W'://TEST_OK;AMO;2018.05.25
            FS_W();                 // FS W
            break;
        case 'p':
            StartupPrint(1);
            FS_p();                 // FS p
            break;
        case 'q':
            FS_q();                 // FS q
            break;
        default:
            break;
    }
}

//=========================================================================================================
//*GSCommand
//* GS 指令
//=========================================================================================================
void GSCommand(uint8_t cParameter)
{
    switch(cParameter)
    {
        case 'L'://TEST_OK;AMO;2018.05.25
            GS_L();                 // GS L
            break;
        case 'I':
            //GS_I();               // GS I
            break;
        case 'W'://TEST_OK;AMO;2018.05.25
            GS_W();                 // GS W
            break;
        case 'v':
            GS_v();                 // GS v
            break;
        case '*':
            GS_star();              // GS *
            break;
        case 'r':
            //GS_r();               // GS r
            break;
        case '/':
            GS_slash();             // GS /
            break;
        case 'E':
            //GS_E();               // GS E
            break;
        case 'C':
            //GS_C();               // GS C
            break;
        case '!'://TEST_OK;AMO;2018.05.25
            GS_ExcalmatoryMark();   // GS  !
            break;
        case 'B'://TEST_OK;AMO;2018.05.25
            GS_B();                 // GS B
            break;
        case 'H':
            GS_H();                 // GS H
            break;
        case 'f':
            GS_f();                 // GS f
            break;
        case 'k':
            GS_k();                 // GS k
            break;
        case 'h':
            GS_h();                 //GS h
            break;
        case 'w':
            GS_w();                 //GS w
            break;
        default:
            break;
    }
}

//=========================================================================================================
//*USCommand
//* US 指令
//=========================================================================================================
/*//註解;AMO;2018.05.25
void USCommand(uint8_t cParameter)
{
    switch(cParameter)
    {
        case DC:
            US_DC();
            break;
        case ESC:
            US_ESC();
            break;
        case 0x0E:
            break;
        default:
            break;
    }
}
*/

