/**
 * @file    Flash25C.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the Flash25C firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __FLASH25C_H
#define __FLASH25C_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/
void Flash25C_Initial(void);

void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
void SPI_FastRead_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);

void SPI_EnWrite_StatusReg(void);
void SPI_Write_StatusReg(uint8_t byte);

void SPI_Write_Enable(void);
void SPI_Write_Disable(void);

void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte);
void SPI_Write_2Bytes(uint32_t Dst_Addr, uint8_t Data1, uint8_t Data2);
void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);

//void SPI_Erase_Chip(void);//???;AMO??;AMO;2018.05.25
void SPI_Erase_Sector(uint32_t Dst_Addr);

void SPI_Wait_Busy(void);
//void SPI_Send_Byte(uint8_t out);//;AMO??;AMO;2018.05.25

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/



#ifdef __cplusplus
}
#endif

#endif /* __FLASH25C_H */

