/**
 * @file    RcvBuf.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the RcvBuf firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __RCVBUF_H
#define __RCVBUF_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"
#include "Interface.h"
#include "CmdSet.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/


/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［RcvBuf.h］
/***********************************************************************
* File Name  : RcvBuf.h
* Description: Receive Buffer
*
***********************************************************************/

extern uint8_t bitRcvBufHaveData;

// function

extern void FillRcvBuf(uint8_t cRvcData);
extern uint8_t GetDataFromRcvBuf(void);
extern void InitRcvBuf(void);
extern void ClrSetBusy(void);
void SerialInt(uint8_t cData);
extern void RealTimeCommand(uint8_t *cData);


#ifdef __cplusplus
}
#endif

#endif /* __RCVBUF_H */

