

/**
 * @file    PrtHead.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the PrtHead firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PRTHEDA_H
#define __PRTHEDA_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"
#include "Interface.h"
#include "PrtBuf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtHead.h］

#define LashStop_Nums  2 //hole rush stop 


extern unsigned char bLFMotorMove;
extern unsigned int  iLFStepNum;
extern unsigned char bSysTimer;
extern unsigned int  iNumOfMs;
extern unsigned char bPESensorEnable;
extern unsigned char bErrTemperature;
extern unsigned char bErrPE;
extern unsigned char cLFMotorPhase;
extern unsigned char bLFForward;
extern unsigned char bFlash;
extern unsigned int  iDensitySetTime;
extern unsigned char bDisableButtons;
extern unsigned char bPauseKeyState;        // 用來紀錄暫停鍵的狀態0=沒有暫停;1=暫停;AMO;2019.04.15
extern unsigned char bPauseKeydone;         // 用來紀錄暫停鍵是否有執行0=沒有執行;1 = 己執行;AMO;2019.04.15

extern void ScanLFKey(void);
extern void ScanPauseKey (void);            // AMO;2019.04.15
extern void voidScanPauseKey (void);        // AMO;2019.04.15
extern void WaitMotorStop(void);
extern void CloseAll(void);
extern void StartLFMotor(void);
extern void LFMotorInt(void);
extern void PrtTimerInt(void);
extern void SysTimerInt(void);
extern void CountinueLineFeed(unsigned int iStep);
extern void FeedPaper(unsigned int iStepNum);
extern void StartSysTimer(unsigned char flash);
extern void StopSysTimer(void);
extern void DelayMs(unsigned int iMs);      // Recover 2022/08/23 PoJen
extern unsigned char LFKeyDown(void);
extern unsigned char PauseKeyDown(void);    // AMO 2019.04.15
extern unsigned char TestPE(void);
extern void TestHeadTemperature(void);
extern void DisplayStatus(void);
extern void DensityLevelSelect(void);

#ifdef __cplusplus
}
#endif

#endif /* __PRTHEDA_H */


