





/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "PrtHead.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/



//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtHead.c］
//=========================================================================================================
//* File Name    : PrtHead.c
//* Description  : PrtHead  Operation
//=========================================================================================================
uint8_t bPauseKeyState;      //用來紀錄暫停鍵的狀態0=沒有暫停;1=暫停;AMO;2019.04.15
uint8_t bPauseKeydone;       //用來紀錄暫停鍵是否有執行0=沒有執行;1=己執行;AMO;2019.04.15

uint8_t bLFMotorMove;//电机转动标志位
uint8_t cLFMotorPhase;//电机相位
uint8_t cLFMotorTime;//电机每步时间
uint8_t bLFForward;//电机正转

uint32_t iLFStepNum;//电机运行步数
uint8_t bSysTimer;//启用延时标志位

uint32_t iNumOfMs;//延时计数
uint8_t bPESensorEnable;//缺纸传感器有效
uint8_t bErrTemperature;//过温错误;0=正常/1=錯誤 //Check-Ok;AMO;2018.05.25
uint8_t bErrPE;//缺纸错误;0=正常/1=錯誤 //Check-Ok;AMO;2018.05.25
uint8_t bErrPEFlag;//
uint8_t cLFConstPos;//匀速
uint8_t bFlash;//闪灯标志位

uint32_t iDensitySetTime;//浓度级别对应加热时间
uint8_t bDisableButtons;//key disable //按鍵取消旗標;AMO;2018.05.25


#define  LashStop_Nums  2 //hole rush
#define  DIVTIMES_FLAG  2 //分几段加热
/*
enum enumADValue{
    pe, thermal};
*/

enum enumLFStatus{
    LFsRush,  LFacc1,  LFacc2,  LFacc3,
    LFacc4,   LFacc5,  LFacc6,  LFacc7,
    LFacc8,   LFacc9,  LFacc10, LFacc11,
    LFacc12,  LFacc13, LFacc14, LFacc15,
    LFacc16,  LFacc17, LFacc18, LFacc19,
    LFacc20,  LFacc21, LFacc22, LFacc23,
    LFacc24,  LFacc25, LFacc26, LFacc27,
    LFacc28,  LFacc29, LFacc30, LFconst,
    LFeLash,  LFeStop
};


const uint32_t  LFMotorTime[34]={
//  sRush,  LFacc1, LFacc2, LFacc3,
    5000,   4500,   4000,   3500, 
//  LFacc4, LFacc5, LFacc6, LFacc7,
    3000,   2500,   2100,   2000,
//  LFacc8, LFacc9, LFacc10,LFacc11, 
    1900,   1850,   1800,   1750,
//  LFacc12,LFacc13,LFacc14,LFacc15,
    1700,   1650,   1600,   1550, 
//  LFacc16,LFacc17,LFacc18,LFacc19,
    1500,   1450,   1400,   1350,
//  LFacc20,LFacc21,LFacc22,LFacc23,
    1300,   1250,   1200,   1150,
//  LFacc24,LFacc25,LFacc26, LFacc27,
    1100,   1100,   1100,   1100, //950,
//  LFacc28,LFacc29,LFacc30,LFconst,
    1100,   1100,   1100,   1100,
//  LFeLash,LFeStop
    20000,  5000
};


//改用這份,參考RG6281F文件;AMO;2018.05.25
const uint32_t  Thermistor[20]={
    269, 208, 161, 124, 97, 75, 60, 47, 37, 30, 24, 19,
    16, 13, 11, 9, 7, 6, 5, 4
};
/*//註解;AMO;2018.05.25
const uint32_t  Thermistor[20]={
    269,208,178,124,100,78,60,47,37,30,24,19,
    16 ,13 ,11,9,7,6,5,4
};*/
const signed int  HeadTemp[20]={
    -20,-15,-10,-5,0,5,10,15,20,25,30,35,
    40 ,45 ,50,55,60,65,70,75
};

/********************************************************************************/
void WaitMotorStop(void);
void CloseAll(void);
void LFMotorPhaseAddOne(void);
void LFMotorPhaseSubOne(void);
void StartLFMotor(void);
void StartSysTimer(uint8_t flash);
void StopSysTimer(void);
//void DelayMs(uint32_t iMs);//AMO註解;AMO;2018.05.25
void StartKeyFeedPaper(uint8_t cStepNum,uint8_t cStepTime);
void TestHeadTemperature(void);
void ChangePaperPos(void);
void DisplayStatus(void);
void GetOnedotLineFromRasterBufAndSendToPrtHead(uint32_t iPrtDotLine);
void GetOnedotLineFromPrtBufAndSendToPrtHead(uint32_t iPrtDotLine);
void GetOnedotLineFromBarCodeBufAndSendToPrtHead(void);
uint8_t TestPE(void);
uint8_t LFKeyDown(void);
uint8_t PauseKeyDown(void); //;AMO;2019.04.15
void Print_strobetimeSet(void);


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtHead.c］
//=========================================================================================================
//* Function name:    WaitMotorStop
//* Descriptions :    等待马达停止工作
//=========================================================================================================
void WaitMotorStop(void)  //Check-Ok;AMO;2018.05.25
{
    while(PrtBuf[cCurrentPrtCharLine].Status != Empty)  //等資料都打印完;AMO;2018.05.25
    {
        ;
    }
    while(bLFMotorMove)//等馬達停止;AMO;2018.05.25
    {
        ;   // waiting
    }
}

//=========================================================================================================
//* Function name:    CloseAll
//* Descriptions :    关闭机芯所有使能
//=========================================================================================================
void CloseAll(void)//Check-Ok;AMO;2018.05.25
{
    PrtStbAllStatus(0);//关闭加热使能
}

//=========================================================================================================
//* Function name:     StartLFMotor
//* Descriptions :     启动马达开启中断
//=========================================================================================================
void StartLFMotor(void)
{
    LFTimer_Enable();                                       // Recover 2022/08/23 PoJen
    PrtBuf[cCurrentPrtCharLine].Status = Printing;

    LFTimer_SetCounter(LFMotorTime[LFsRush]);               // 启动定时器 Recover 2022.08.23 PoJen
    // TM10_LFTimer_Counter_value = LFMotorTime[LFsRush];   // Delete 2022/08/22 PoJen
    // TM10_Motor_Delay(LFMotorTime[LFsRush]);              // Delete 2022/08/22 PoJen
    // TM_Timer_Cmd(TM10, ENABLE);                          // Delete 2022/08/22 PoJen

    cLFMotorTime = LFsRush;
    // phase
    LFMotorPhaseSet(cLFMotorPhase);
    bLFMotorMove = 1;
}

//=========================================================================================================
//* Function name:    FeedPaper
//* Descriptions :    进纸一定步数
//=========================================================================================================
void FeedPaper(uint32_t iStepNum)//Check-Ok;AMO;2018.05.25
{
    WaitMotorStop();//若电机在运行，則等待馬達運行完，再執行按鍵動作;AMO;2018.05.25
    iLFStepNum = iStepNum + LashStop_Nums; // 2014.2 yxm add  //LashStop_Nums=2 ;AMO;2018.05.25

    LFTimer_Enable();                                       // Recover 2022/08/23 PoJen
    PrtBuf[cCurrentPrtCharLine].Status = FeedLine;
    LFTimer_SetCounter(LFMotorTime[LFsRush]);               // 启动定时器 Recover 2022/08/23 PoJen
    // TM10_LFTimer_Counter_value = LFMotorTime[LFsRush];   // Delete 2022/08/22 PoJen
    // TM10_Motor_Delay(LFMotorTime[LFsRush]);              // Delete 2022/08/22 PoJen
    // TM_Timer_Cmd(TM10, ENABLE);                          // Delete 2022/08/22 PoJen

    cLFMotorTime = LFsRush;
    // phase
    bTimer2FeedLine = 1;
    LFMotorPhaseSet(cLFMotorPhase);
    bLFMotorMove = 1;
}

//=========================================================================================================
//* Function name:     LFMotorPhaseAddOne
//* Descriptions :     马达前进相位加1
//=========================================================================================================
void LFMotorPhaseAddOne(void)//Check-Ok;AMO;2018.05.25
{
    // forward +1
    if(bLFForward)
    {
        if(cLFMotorPhase == 4)
        {
            cLFMotorPhase = 1;
        }
        else
        {
            cLFMotorPhase += 1;
        }
    }
    else
    {
        // backward -1
        if(cLFMotorPhase == 1)
        {
            cLFMotorPhase = 4;
        }
        else
        {
            cLFMotorPhase -= 1;
        }
    }
}

//=========================================================================================================
//* Function name:     LFMotorPhaseSubOne
//* Descriptions :     马达前进相位减1
//=========================================================================================================
void LFMotorPhaseSubOne(void)//Check-Ok;AMO;2018.05.25
{
    // forward -1
    if(bLFForward)
    {
        if(cLFMotorPhase == 1)
        {
            cLFMotorPhase = 4;
        }
        else
        {
            cLFMotorPhase -= 1;
        }
    }
    else
    {
        if(cLFMotorPhase == 4)
        {
            cLFMotorPhase = 1;
        }
        else
        {
            cLFMotorPhase += 1;
        }
    }
}

//=========================================================================================================
//* Function name:     LFMotorInt
//* Descriptions :     马达中断函数
//=========================================================================================================
void LFMotorInt(void)
{
    uint8_t cTemp;
    uint32_t  iDotNum;

    //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
    if(bLFMotorMove)
    {
        if(bSelfTest == 0) //进入自检打印模式，不判斷按鍵，直到自檢模式結束    //;AMO;2019.04.15
        {
            ScanPauseKey();//在馬達運行中同時檢測按鍵，暫停/測試列印键扫描//;AMO;2019.04.15
        }

        if(cLFMotorTime == LFeStop)
        {
            // TM_Timer_Cmd(TM10, DISABLE);                 //Delete 2022/08/23 PoJen
            LFTimer_Disable();  //disenble timer            //Recover 2022 08 23 PoJen
            bLFMotorMove = 0;   //motor stop
            bTimer2Prt = 0;     //not Prt
            bTimer2FeedLine = 0;//end feedline
            bTimer2KeyFeed = 0; //no key
            LFMotorPhaseSet(0); //关电机
            PrtBuf[cCurrentPrtCharLine].Status = Empty;
            return;
        }
        else
        {
            if(cLFMotorTime == LFeLash )//不换相持续走上一个相位
            {
                LFMotorPhaseSubOne();//相位減1
                LFMotorPhaseSet(cLFMotorPhase);//不换相,给相位
            }
            else if(Test_motor_step == 0xC1 || Test_motor_step == 0xC0 )//不换相持续走上一个相位
            {
                Test_motor_step =  Test_motor_step +1; //TEST;AMO;2018.06.20
                LFMotorPhaseSet(cLFMotorPhase);//不换相,给相位
            }
            else
            {
                Test_motor_step =  Test_motor_step +1; //TEST;AMO;2018.06.20
                LFMotorPhaseAddOne();//相位加1
                LFMotorPhaseSet(cLFMotorPhase);//给相位
            }
            cLFMotorTime++ ; // next value in the time table

            LFTimer_SetCounter(LFMotorTime[cLFMotorTime]);          //启动定时器 Recover 2022/08/23 PoJen
            // TM10_LFTimer_Counter_value = LFMotorTime[LFsRush];   //Delete 2022/08/22 PoJen
            // TM10_Motor_Delay(LFMotorTime[LFsRush]);              //Delete 2022/08/22 PoJen
            // TM_Timer_Cmd(TM10, ENABLE);                          //Delete 2022/08/22 PoJen

            if(bTimer2FeedLine)//feed line
            {
                //Feeding Printline
                PrtBuf[cCurrentPrtCharLine].Status = FeedLine;
                if(iLFStepNum == LashStop_Nums)
                {
                    bTimer2FeedLine = 0;//feed end
                    PrtBuf[cCurrentPrtCharLine].Status = Empty;
                    cTemp = PrtBuf[cCurrentPrtCharLine].cNextCharLine;
                    if(PrtBuf[cTemp].Status == WaitForPrint)//换行重新打印
                    {
                        cCurrentPrtCharLine	= cCurrentFillRow;
                        bTimer2Prt = 1;// Countinue Prt
                        PrtBuf[cCurrentPrtCharLine].Status = Printing;
                        iLFStepNum = PrtBuf[cCurrentPrtCharLine].iPrtStep + PrtBuf[cCurrentPrtCharLine].iFeedStep + LashStop_Nums;
                        if(iLFStepNum%ONEDOTSTEPNUM == 0)
                        {
                            //new PrtLine to Printing 
                            LFMotorPhaseAddOne();//相位加1
                            LFMotorPhaseSet(cLFMotorPhase);//给相位
                            PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot--;
                            iDotNum = PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot;

                            //传送到打印头一点行数据并锁存
                            TPH_LAT_on();//Open Lat
                            if(PrtBuf[cCurrentPrtCharLine].bPrtRaster)//打印光栅模式
                            {
                                GetOnedotLineFromRasterBufAndSendToPrtHead(iDotNum);
                            }
                            else if(PrtBuf[cCurrentPrtCharLine].bPrtBarCode)//打印条码模式
                            {
                                GetOnedotLineFromBarCodeBufAndSendToPrtHead();
                            }
                            else//打印数据模式
                            {
                                GetOnedotLineFromPrtBufAndSendToPrtHead(iDotNum);
                            }

                            TPH_LAT_off();//Close Lat 锁存
                            Print_strobetimeSet();
                            if(PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot == 0)
                            {
                                bTimer2Prt = 0;     //prt over
                                bTimer2FeedLine = 1;//start to feed and not prt
                            }
                            else
                            {
                                ;//do nothing
                            }
                        }
                    }
                    else
                    {
                        ;
                    }
                }
                else
                {
                    ;
                }
            }
            else if(bTimer2Prt)
            {
                //Printing 
                if((iLFStepNum%ONEDOTSTEPNUM) == 0)//余1
                {
                    //Printing 
                    PrtBuf[cCurrentPrtCharLine].Status = Printing;
                    PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot--;
                    iDotNum = PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot;
                    TPH_LAT_on();//Open Lat

                    //传送到打印头一点行数据并锁存
                    if(PrtBuf[cCurrentPrtCharLine].bPrtRaster)//打印光栅模式
                    {
                        GetOnedotLineFromRasterBufAndSendToPrtHead(iDotNum);
                    }
                    else if(PrtBuf[cCurrentPrtCharLine].bPrtBarCode)//打印条码模式
                    {
                        GetOnedotLineFromBarCodeBufAndSendToPrtHead();
                    }
                    else//打印数据模式
                    {
                        GetOnedotLineFromPrtBufAndSendToPrtHead(iDotNum);
                    }
                    TPH_LAT_off();//Close Lat
                    Print_strobetimeSet();

                    if(PrtBuf[cCurrentPrtCharLine].iCurrentPrtDot == 0)//打印完成准备走行间距
                    {
                        bTimer2Prt = 0;//prt over
                        bTimer2FeedLine = 1;//start feed not prt
                        PrtBuf[cCurrentPrtCharLine].Status = FeedLine;
                    }
                    else
                    {
                        ;//do nothing
                    }
                }
            }
        }

        if(bTimer2KeyFeed)
        {
            // feed paper during push down feed key
            if(cLFMotorTime == cLFConstPos)
            {
                // constant speed
                // judge if it is time to stop
                if(iLFStepNum > LashStop_Nums) 
                {
                    // keep constant speed , adjust cLFTime
                    cLFMotorTime--;
                }
                else
                {
                    ;//  do nothing
                }
            }
            else
            {
                // shift motion
            }
        }
        else
        {
            if(cLFMotorTime == LFconst)
            {
                // constant speed
                // judge if it is time to stop
                if(iLFStepNum > LashStop_Nums) 
                {
                    // keep constant speed , adjust cLFTime
                    cLFMotorTime--;
                }
                else
                {
                    ;//  do nothing
                }
            }
            else
            {
                // shift motion
            }
        }

        iLFStepNum --;//新增;AMO;2018.05.25
/*
        //AMO註解，因為ADC讀取太慢會影响馬達運轉，故先不讀電壓;AMO;2018.05.25
        switch(iLFStepNum --)
        {
            case 3:
                LFMotorPhaseSubOne();
                ChangePaperPos();//测试纸状态
                break;
            case 2:
                ChangePaperPos();//测试纸状态
                cLFMotorTime = LFeLash;
                break;
            case 1:
                cLFMotorTime = LFeStop;
                break;
            default:
                if(iLFStepNum%ONEDOTSTEPNUM == 0)
                {
                    ChangePaperPos();//测试纸状态
                }
                break;
        }*/
    }
}

//=========================================================================================================
//* Function name:     GetOnedotLineFromRasterBufAndSendToPrtHead
//* Descriptions :     光栅模式下取一点行打印数据并发送到打印头锁存
//=========================================================================================================
void GetOnedotLineFromRasterBufAndSendToPrtHead(uint32_t iPrtDotLine)
{
    uint8_t *p;
    p = &PrtBuf[cCurrentPrtCharLine].ByteLine[iPrtDotLine / 8].BasePrtLine[(iPrtDotLine % 8) * (MaxDotPos / 8)];
    SendnBytes_To_Head(p, MaxDotPos / 8);
}

//=========================================================================================================
//* Function name:     GetOnedotLineFromBarCodeBufAndSendToPrtHead
//* Descriptions :     从条码Buffer中取一点行打印数据并发送到打印头锁存
//=========================================================================================================
void GetOnedotLineFromBarCodeBufAndSendToPrtHead(void)
{
    uint8_t *p;
    p = &PrtBuf[cCurrentPrtCharLine].ByteLine[0].BasePrtLine[0];
    SendnBytes_To_Head(p, MaxDotPos / 8);
}

//=========================================================================================================
//* Function name:  GetOnedotLineAndSendToPrtHeadFromPrtBuf
//* Descriptions :  从打印Buffer中取一点行打印数据并发送到打印头锁存
//=========================================================================================================
void GetOnedotLineFromPrtBufAndSendToPrtHead(uint32_t iPrtDotLine)
{
    uint8_t *p;
    p = &PrtBuf[cCurrentPrtCharLine].ByteLine[iPrtDotLine / 8].BasePrtLine[MaxDotPos - (iPrtDotLine % 8 + 1) * (MaxDotPos / 8)];
    SendnBytes_To_Head(p, MaxDotPos / 8);
}

//=========================================================================================================
//* Function name:     ChangePaperPos
//* Descriptions :     test paper status
//=========================================================================================================
void ChangePaperPos(void)//Check-Ok;AMO;2018.05.25
{
    static uint8_t cConterPE = 0;

    // check whether the printer has paper or not
    if(bPESensorEnable)
    {

        AD_Value[Paper_ADC] = Sample_ADC_Conversion(Paper_ADC);  //0 = GPIO_PA0 = Paper_ADC； 1 = GPIO_PA4 = Thermal_ADC ; AMO;2018.06.20
        //AD值 = 0x0800 = 2048 = 1.65v;有紙電壓 = H/無紙電壓 = L;AMO;2018.06.20
        //AD值 = 0x04D9 = 1241 = 1.00v;有紙電壓 = H/無紙電壓 = L;AMO;2018.06.20
        if(AD_Value[Paper_ADC] > 0x04d9) //1v/3.3v = AD值/4095 ；
        {
            cConterPE = 0;
            bErrPE = 0;
        }
        else
        {
            cConterPE++;
        }
        if(cConterPE > 5)
        {
            cConterPE = 5;
            bErrPE = 1;
        }
    }
    else
    {
        bErrPE = 0;
    }
}

//=========================================================================================================
//Print_strobetimeSet(void)
//=========================================================================================================
void Print_strobetimeSet(void)
{
    uint32_t iPrtTime = 0;
    unsigned long  E;
    unsigned long  P;
    uint8_t cLoop;
    uint32_t  iThermal = 0;
    uint32_t  R;
    signed int Tx;

//關閉所熱感應頭;AMO;2018.05.25
    PrtStbAllStatus(0);

//讀取所熱感應頭溫度並計算加熱時間;AMO;2018.05.25
    iThermal = AD_Value[Thermal_ADC];

    R = (10 * iThermal) / (4096 - iThermal);//改用這公式;AMO;2018.05.25

    //R = (10*iThermal)/(1024-iThermal);//根据原理图计算热敏阻值//註解;AMO;2018.05.25
    for(cLoop = 0; cLoop < sizeof(Thermistor); cLoop++)//查表
    {
        if(R >= Thermistor[cLoop])//得到对应的机头温度
        {
            Tx = HeadTemp[cLoop];
            break;
        }
        else
        {
            Tx = HeadTemp[9];//改成9才是25度;AMO;2018.05.25
            //Tx = HeadTemp[8];//25度
        }
    }
    if(Tx <= 5)//计算不同温度每个点的能量值微焦。
    {
        E = 13000;//微焦
    }
    else if(Tx <= 15)
    {
        E = 12500;
    }
    else if(Tx <= 25)
    {
        E = 12000;
    }
    else if(Tx <= 35)
    {
        E =11500;
    }
    else if(Tx <= 45)
    {
        E = 11000;
    }
    else if(Tx <= 55)
    {
        E = 10500;
    }
    else if(Tx <= 65)
    {
        E = 10000;
    }
    else if(Tx <= 75)
    {
        E = 9500;
    }
    else
    {
        E = 9000;
    }
    P = 40;//本來是20,改成40;AMO註解;AMO;2018.05.25

    //方便查表;AMO;2018.05.25
    /*
    #define DensitySetTimeLevel1      1500  //AMO實測修改;AMO;2018.05.25
    #define DensitySetTimeLevel2      2500  //AMO實測修改;AMO;2018.05.25
    #define DensitySetTimeLevel3      3500  //AMO實測修改;AMO;2018.05.25
    #define DensitySetTimeLevel4      4500  //AMO實測修改;AMO;2018.05.25
    #define DensitySetTimeLevel5      4500  //AMO實測修改;AMO;2018.05.25
  */

    iPrtTime = (long)(E / P); // ms
    //iPrtTime = iPrtTime + iDensitySetTime;//加上浓度设定的时间 //AMO修改;AMO;2018.05.25

    //這個數值=2500;啟步=600，經測試濃度印都很清楚,但開始出現一條空白線//TEST;AMO;2018.05.25	
    //這個數值=3500;啟步=600，經測試濃度印都很清楚//TEST;AMO;2018.05.25
    //這個數值=4700;啟步=600，經測試濃度印都很清楚,但有點慢//TEST;AMO;2018.05.25

    //這個數值=1500;啟步=150，經測試濃度印還算清楚//TEST;AMO;2018.05.25
    //這個數值=2500;啟步=150，經測試濃度印還算清楚//TEST;AMO;2018.05.25
    //這個數值=3500;啟步=600，經測試濃度印都很清楚//TEST;AMO;2018.05.25
    //這個數值=4500;啟步=600，經測試濃度印都很清楚//TEST;AMO;2018.05.25

    iPrtTime = iPrtTime + iDensitySetTime;  //加上浓度设定的时间 //TEST;AMO;2018.05.25
    //iPrtTime = iPrtTime + 3000 ;          //加上浓度设定的时间 //TEST;AMO;2018.05.25

    //調整啟步打印濃度//AMO修改;AMO;2018.05.25
    if(cLFMotorTime <15)
    {
        iPrtTime = iPrtTime + ((15 - cLFMotorTime) * 30);
        //iPrtTime = iPrtTime + ((15 - cLFMotorTime) * 350);//TEST;AMO;2018.05.25
    }

  /*
    if(iPrtTime > ((LFMotorTime[LFconst]) * ONEDOTSTEPNUM / DIVTIMES_FLAG) - 200)//
    {
        iPrtTime = ((LFMotorTime[LFconst]) * ONEDOTSTEPNUM / DIVTIMES_FLAG) - 200;
    }
    else if(iPrtTime < 500)                 //不能小于450
    {
        iPrtTime = 500;
    }
  */

    PrtStb123_on();                             //AMO修改;原本是打印一半再打印另一半；現在是全部一起打印;AMO;2018.05.25
    PrtStb456_off();

    PrtTimer_SetCounter(iPrtTime);              // Recover 2022/08/23 PoJen
    PrtTimer_Enable();                          // Recover 2022/08/23 PoJen
    DelayMs(1);                                 // Recover 2022/08/23 PoJen
    //TM16_PrtTimer_Counter_value = iPrtTime;   // Delete 2022/08/22 PoJen
    // Sample_TM16_Delay();                     // Delete 2022/08/22 PoJen

    PrtStb123_off();                            // AMO修改;原本是打印一半再打印另一半；現在是全部一起打印;AMO;2018.05.25
    PrtStb456_on();

    PrtTimer_SetCounter(iPrtTime);              // Recover 2022/08/23 PoJen
    PrtTimer_Enable();                          // Recover 2022/08/23 PoJen
    DelayMs(1);                                 // Recover 2022/08/23 PoJen
    //TM16_PrtTimer_Counter_value = iPrtTime;   // Delete 2022/08/22 PoJen
    //Sample_TM16_Delay();                      // Delete 2022/08/22 PoJen

    PrtStbAllStatus(0);
}

//=========================================================================================================
//* Function name:    CountinueLineFeed
//* Descriptions:     连续走纸计算
//=========================================================================================================
void CountinueLineFeed(uint32_t iStep)
{
    //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
    CloseAllInt();                              // Recover 2022/08/23 PoJen
    iLFStepNum += iStep;
    //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
    OpenAllInt();                               // Recover 2022/08/23 PoJen
}

//=========================================================================================================
//* Function name:     StartSysTimer    StoptSysTimer   DelayMs
//* Descriptions :      系统延时函数
//=========================================================================================================
void StartSysTimer(uint8_t flash)//Check-Ok;AMO;2018.05.25
{
    bSysTimer = 1;                          //
    bFlash = flash;                         // 闪灯状态标志位
    iNumOfMs = 0;                           // 计数值

    Timer_SetCounter(1000);                 // Recover 2022/08/23 PoJen952
    Timer_Enable();                         // 启动定时器 Recover 2022/08/23 PoJen

    // TM20_SysTimer_Counter_value = 1000;     // 固定1ms進入中斷一次; Delete 2022/08/23 PoJen
    // Sample_TM20_Delay();                    // Delete 2022/08/23 PoJen
    // TM_Timer_Cmd(TM20, ENABLE);             // Delete 2022/08/23 PoJen
}

//=========================================================================================================
//StopSysTimer
//=========================================================================================================
void StopSysTimer(void)                     //Check-Ok;AMO;2018.05.25
{
    bSysTimer = 0;
    bFlash = 0;                             //燈號閃爍旗標=0;;AMO;2018.06.20

    Timer_Disable();                        // Recover 2022/08/23 PoJen
    // TM_Timer_Cmd(TM20, DISABLE);         // Delete 2022/08/23 PoJen
}


/* DelayMs(20);// Recover 2022/08/23 PoJen */
void DelayMs(uint32_t iMs)                  //延时函数 毫秒级别
{
    GPIOC->BSRR = GPIO_BSRR_BS12;
    StartSysTimer(0);
    while(iNumOfMs < iMs)
    {
        ;   // wait
    }
    StopSysTimer();
    GPIOC->BSRR = GPIO_BSRR_BR12;
}


//=========================================================================================================
//* Function name:     SysTimerInt
//* Descriptions:     闪灯定时和系统延时函数 :缺纸400ms一循环 高温800ms一循环
//=========================================================================================================
void SysTimerInt(void)
{
    static uint32_t iFlashCounter = 0;
    if(bSysTimer)
    {
        //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
        iNumOfMs++;//闪灯标志位，(flash=0)一個是模式設定時，紀錄LFKEY按鍵按下的時間 //;AMO;2019.04.15

        if(bFlash == 1)//闪灯标志位，((flash=1)一個是LED閃爍的計時時間 //;AMO;2019.04.15
        {
            iFlashCounter++;
            switch(iFlashCounter) // iFlashCounter會一直累加，加到200ms時，LED會亮，加到400ms時，LED會滅，以此類推 //;AMO;2019.04.15
            {
                case 100:
                    if(bPauseKeyState)
                    {
                        ErrLED_on();
                    }
                    break;

                case 200:
                    if(bErrPE)
                    {
                        Paper_LED_on();
                    }
                    if(bPauseKeyState)
                    {
                        ErrLED_off();
                    }
                    break;

                case 300:
                    if(bPauseKeyState)
                    {
                        ErrLED_on();
                    }
                    break;

                case 400:
                    if(bErrPE)
                    {
                        Paper_LED_off();
                    }
                    if(bErrTemperature)
                    {
                        ErrLED_on();
                    }
                    if(bPauseKeyState)
                    {
                        ErrLED_off();
                    }
                    break;
    
                case 500:
                    if(bPauseKeyState)
                    {
                        ErrLED_on();
                    }
                    break;

                case 600:
                    if(bErrPE)
                    {
                        Paper_LED_on();
                    }

                    if(bPauseKeyState)
                    {
                        ErrLED_off();
                    }
                    break;

                case 700:
                    if(bPauseKeyState)
                    {
                        ErrLED_on();
                    }
                    break;

                case 800:
                    if(bErrPE)
                    {
                        Paper_LED_off();
                    }
                    if(bErrTemperature)
                    {
                        ErrLED_off();
                    }
                    if(bPauseKeyState)
                    {
                        ErrLED_off();
                    }
                    iFlashCounter = 0;  //重置計數值//;AMO;2019.04.15
                    break;
                default:
                    break;
            }
        }
        //Timer_SetCounter(1000);//AMO註解;AMO;2018.05.25
    }
}

//=========================================================================================================
//* Function name:     LFKeyDown ModeKeyDown PWKeyDown
//* Descriptions :    按键状态检测(防按鍵彈跳檢測)
//=========================================================================================================
enum enumKeyStatus{
    up, down
};

//stm32 test ok
uint8_t LFKeyDown(void)//进纸按键检测函数(防按鍵彈跳檢測) //Check-Ok;AMO;2018.05.25
{
    uint8_t cLoop;
    uint8_t cLastStatus;    // 1--down 0--up
    cLoop = 0;
    cLastStatus = up;
    if(!LFKey)
    {
        while(cLoop < 10)
        {
            //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
            if(LFKey)
            {
                if(cLastStatus == up)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = up;
                    cLoop = 0;
                }
            }
            else
            {
                if(cLastStatus == down)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus=down;
                    cLoop=0;
                }
            }
        }
    }
    return cLastStatus;
}

//=========================================================================================================
//* Function name:     PauseKeyDown
//* Descriptions :    暫停/列印測試按键状态检测(防按鍵彈跳檢測)
//=========================================================================================================
//stm32 test ok
uint8_t PauseKeyDown(void)//暫停/列印測試按键状态检测(防按鍵彈跳檢測) //Check-Ok;AMO;2018.05.25
{
    uint8_t cLoop;
    uint8_t cLastStatus;    // 1--down 0--up
    cLoop = 0;
    cLastStatus = up;
    if(!PauseKey)
    {
        while(cLoop < 10)
        {
            //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
            if(PauseKey)
            {
                if(cLastStatus == up)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = up;
                    cLoop = 0;
                }
            }
            else
            {
                if(cLastStatus == down)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus=down;
                    cLoop=0;
                }
            }
        }
    }
    return cLastStatus;
}

//=========================================================================================================
//* Function name:     ScanLFKey 
//* Descriptions :    走纸键扫描
//=========================================================================================================
void ScanLFKey(void)
{
    static uint8_t cCounterSK;
    uint32_t iStepNum;
    if(!bDisableButtons)  //若按鍵功能沒取消則執行;AMO;2018.05.25
    {
        if(LFKeyDown())//若有按下按鍵則執行;AMO;2018.05.25
        {
            if(bLFMotorMove) //若电机在运行，則等待馬達運行完，再執行按鍵動作;AMO;2018.05.25
            {
                WaitMotorStop();//打印过程中按键失效 //若电机在运行，則等待馬達運行完，再執行按鍵動作;AMO;2018.05.25
            }
            else
            {
                ;
            }
            //SelfTestPrint();
            //bTimer2FeedLine = 1;
            iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;//走一字符行 //ONEDOTSTEPNUM=2 ; PRTLINEHIGHT=24 ; iLineSpaceNumber=LINE_SPACE=6 ;AMO;2018.05.25
            FeedPaper(iStepNum);
            WaitMotorStop();

            // Delay(300); //ms// Delete 2022/08/22 PoJen
            
            DelayMs(300); // Recover 2022/08/23 PoJen
            
            if(!LFKey)//down
            {
                cCounterSK = 0;
                //bTimer2KeyFeed = 1;
                //SerialSendByte(0x12);
                StartKeyFeedPaper((iLineSpaceNumber+PRTLINEHIGHT),LFacc26);
                while(cCounterSK < 10)
                {
                    if(LFKey)//up
                    {
                        // if put up the key
                        cCounterSK++;
                        //SerialSendByte(0x11);
                    }
                    else
                    {
                        cCounterSK = 0;
                    }
                    if(iLFStepNum == LashStop_Nums + 1)
                    {
                        //SerialSendByte(iLFStepNum);
                        //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
                        CloseAllInt();                              // Recover 2022/08/23 PoJen
                        iLFStepNum += (iLineSpaceNumber+PRTLINEHIGHT)*ONEDOTSTEPNUM;
                        //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                        OpenAllInt();                               // Recover 2022/08/23 PoJen
                        //SerialSendByte(iLFStepNum);
                    }
                }
                // key is up
            }
        }
        else
        {
            ;
        }
    }
}


//=========================================================================================================
//* Function name:    ScanPauseKey 
//* Descriptions :    暫停/測試列印键扫描
//=========================================================================================================
void ScanPauseKey (void)//;AMO;2019.04.15
{
    if(!bDisableButtons)  //若按鍵功能沒取消則執行//;AMO;2019.04.15
    {
        if(PauseKeyDown() )  //若有按下按鍵則執行//;AMO;2019.04.15
        {
            if(bPauseKeydone == 0)
            {
                StartSysTimer(0);//开始计时

                while(PauseKeyDown() ) //當Pause按鍵按下時，會一直在while內跑迴圈，依按下時間長短紀錄在iNumOfMs內並執行程式//;AMO;2019.04.15
                {
                    if(bPauseKeyState == 0)    //進入暫停模式，就不進列印測試頁模式//;AMO;2019.04.15
                    {
                        if(iNumOfMs >= 3000)//列印測試頁//;AMO;2019.04.15
                        {
                            bSelfTest = 1;    //进入自检打印模式      //;AMO;2019.04.15
                            ErrLED_on();      //LED亮燈指示操作者，3秒已到  //;AMO;2019.04.15
                        }
                    }
                }
                StopSysTimer();//停止计时//;AMO;2019.04.15
                if(bSelfTest)
                {
                    SelfTestPrint();//进入自检打印模式//;AMO;2019.04.15
                    ErrLED_off();
                }
                if(bSelfTest == 0)
                {
                    if(bPauseKeyState == 0)
                    {
                        bPauseKeyState = 1;
                        bPauseKeydone = 1;
                    }
                    else
                    {
                        bPauseKeyState = 0;
                        bPauseKeydone = 1;
                        ErrLED_off();
                    }
                }
            }
        }
        else
        {
            bPauseKeydone = 0;
        }
    }
}


//=========================================================================================================
//* Function name:     StartKeyFeedPaper
//* Descriptions :    按键启动电机 准备进纸
//=========================================================================================================
void StartKeyFeedPaper(uint8_t cStepNum,uint8_t cStepTime)
{
    bTimer2KeyFeed = 1;
    //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
    CloseAllInt();                              // Recover 2022/08/23 PoJen
    iLFStepNum = cStepNum * ONEDOTSTEPNUM + LashStop_Nums; // 2013.12.25
    //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
    OpenAllInt();                               // Recover 2022/08/23 PoJen

    cLFConstPos = cStepTime;
    // phase
    //cLFMotorPhase = 1;
    //LFMotorCurrentPort(BigC);
    //LFMotorPhaseAddOne();
    LFMotorPhaseSet(cLFMotorPhase);

    //LFMotorPhaseSubOne();

    LFTimer_Enable();                                       // Recover 2022/08/23 PoJen
    LFTimer_SetCounter(LFMotorTime[LFsRush]);               // Recover 2022/08/23 PoJen
    // TM10_LFTimer_Counter_value = LFMotorTime[LFsRush];   // Delete 2022/08/22 PoJen
    //TIM10_Motor_Delay(LFMotorTime[LFsRush]);              // Delete 2022/08/22 PoJen
    //TM_Timer_Cmd(TM10, ENABLE);                           // Delete 2022/08/22 PoJen

    cLFMotorTime = LFsRush;
    bLFMotorMove = 1;
}


//=========================================================================================================
//* Function name:    TestPE
//* Descriptions :    纸状态检测
//*Return        :    Paper Status
//=========================================================================================================
enum enumPaperStatus{
    cNoPaper, cHavePaper
};

uint8_t TestPE(void)            //Check-Ok;AMO;2018.05.25
{
    uint8_t cLoop;
    uint8_t cLastStatus;        // 1=there is paper;0=no paper;AMO;2018.06.20
    cLoop = 0;
    cLastStatus = cHavePaper;   //預設為1=有紙張狀態;AMO;2018.06.20
    
    if(bPESensorEnable)         //若缺纸传感器有效，則執行;AMO;2018.06.20
    {
        while(cLoop < 8)        //連續讀取8次ADC;AMO;2018.06.20
        {
            AD_Value[Thermal_ADC] = Sample_ADC_Conversion(Thermal_ADC);//0=GPIO_PA0 = Paper_ADC；1 = GPIO_PA4 = Thermal_ADC ;AMO;2018.06.20
            AD_Value[Paper_ADC] = Sample_ADC_Conversion(Paper_ADC);//0=GPIO_PA0 = Paper_ADC；1 = GPIO_PA4 = Thermal_ADC ;AMO;2018.06.20
            //AD值 = 0x0800 = 2048 = 1.65v; 有紙電壓 = H/無紙電壓=L; AMO;2018.06.20
            //AD值 = 0x04D9 = 1241 = 1.00v; 有紙電壓 = H/無紙電壓=L; AMO;2018.06.20
            if(AD_Value[Paper_ADC] < 0x04d9)
            {
                if(cLastStatus == cNoPaper)     //若原本就是沒紙狀態，則將沒紙狀態次數+1;AMO;2018.06.20
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = cNoPaper;     //若第一次檢測到沒紙狀態，則將狀態設為沒紙;AMO;2018.06.20
                    cLoop = 0;
                }
            }
            else
            {
                if(cLastStatus == cHavePaper)   //若原本就是有紙狀態，則將有紙狀態次數+1;AMO;2018.06.20
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus	= cHavePaper;    //若第一次檢測到有紙狀態，則將狀態設為有紙;AMO;2018.06.20
                    cLoop = 0;
                }
            }
        }
    }
    if(cLastStatus == cNoPaper)          //若最後檢測8次的結果為沒紙，則錯誤指示燈亮;AMO;2018.06.20
    {
        bErrPE = 1;
        //bERLED_ON;
    }
    else
    {
        bErrPE = 0;
    }
    return cLastStatus;
}


//=========================================================================================================
//* Function name:     TestHeadTemperature 
//* Descriptions :     机芯温度检测
//=========================================================================================================
enum enumTemperature{
    TemperatureOK,HighTemperatureErr
};
// test Print head temperature
void TestHeadTemperature(void)//Check-Ok;AMO;2018.05.25
{
    uint8_t cLoop;
    uint8_t cLastStatus;

    cLastStatus = TemperatureOK;
    cLoop = 0;

    if(bTimer2Prt || bTimer2FeedLine)
    {
        //printing  not to stop
    }

    while(cLoop < 2)    //4
    {
        AD_Value[Thermal_ADC] = Sample_ADC_Conversion(Thermal_ADC);
        AD_Value[Paper_ADC] = Sample_ADC_Conversion(Paper_ADC);
        if(bErrTemperature)//从过温保护中恢复检测部分代码
        {
            //Hi thermal R val (Hi ADC val) is low thermal;and then Lo R val(Lo ADC val) is high theraml 
            // ●60度時查表電阻為7.41k，3.3v * 7.41k/(10k+7.41k) = 1.404v = V(TM)；AD值 = 1742 = 0x06CE ;AMO;2018.05.25
            if(AD_Value[Thermal_ADC] < 1742) //2405)////4096 * 7.4 / (7.4 + 5.2) 60度的电阻值
            {
                // high theraml 
                if(cLastStatus == HighTemperatureErr)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = HighTemperatureErr;
                    cLoop = 0;
                }
            }
            else
            {
                // OK
                if(cLastStatus == TemperatureOK)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = TemperatureOK;
                    cLoop = 0;
                }
            }
        }
        else         //温度正常检测部分代码
        {
            // ●70度時查表電阻為5.21k，3.3v * 5.21k/(10k + 5.21k) = 1.13v = V(TM)；AD值 = 1402 = 0x057A ;AMO;2018.05.25
            if(AD_Value[Thermal_ADC] < 1402)//1589)////4096 * 5.2 / (8.2 + 5.2) 70度的电阻值
            {
                // High
                if(cLastStatus == HighTemperatureErr)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = HighTemperatureErr;
                    cLoop = 0;
                }
            }
            else
            {
                // OK
                if(cLastStatus == TemperatureOK)
                {
                    cLoop++;
                }
                else
                {
                    cLastStatus = TemperatureOK;
                    cLoop = 0;
                }
            }
        }
    }

    if(cLastStatus == HighTemperatureErr)
    {
        bErrTemperature = 1;
    }
    else
    {
        bErrTemperature = 0;
    }
}


//=========================================================================================================
//* Function name:     DisplayStatus 
//* Descriptions :     Printer 状态查询
//=========================================================================================================
void DisplayStatus(void)//Check-Ok;AMO;2018.05.25
{
    if(bSelfTest == 0) //进入自检打印模式，不判斷按鍵，直到自檢模式結束        //;AMO;2019.04.15
    {
        ScanLFKey();     //按键扫描
        ScanPauseKey();  //暫停/列印測試扫描;AMO;2019.04.15
    }

    if(bErrTemperature || bErrPE || bPauseKeyState)//有错误 开始闪灯 //若過溫錯誤或缺紙錯誤，則閃燈;AMO;2018.05.25
    {
        StartSysTimer(1); //啟動Timer20,用於指示燈閃爍;AMO;2018.05.25
        if(bErrPE)
        {
            bErrPEFlag = 1;//若錯誤是缺紙，則bErrPEFlag = 1;AMO;2018.05.25
        }
    }

    while(bErrTemperature || bErrPE || bPauseKeyState) //如果一直有溫度過高和缺紙和暫停的狀態，則一直執行等錯誤狀態結束;AMO;2019.04.15
    {
        CloseAll();      //關閉加熱使能;AMO;2018.05.25
        WaitMotorStop(); //若电机在运行，則等待馬達運行完，再執行按鍵動作;AMO;2018.05.25
        //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
        TestHeadTemperature(); //測試溫度有無過熱;AMO;2018.05.25
        TestPE();       //測試有無紙張;AMO;2018.05.25
        ScanPauseKey(); //再判斷暫停/列印測試扫描;AMO;2019.04.15
        ClrSetBusy();   //更新清除设置BUSY状态;AMO;2018.05.25
    }

    if(bSysTimer)     //沒有溫度過高和缺紙的狀態，關閉指示燈閃爍計時器;AMO;2018.05.25
    {
        StopSysTimer(); 
        if(bErrPEFlag)//纸尽错误已恢复，若原本有纸尽错误則代表已經補紙,要執行進紙動作;AMO;2018.05.25
        {
            // Delay(1000);//ms// Delete 2022/08/22 PoJen
            DelayMs(1000);// Recover 2022/08/23 PoJen
            FeedPaper(240);//等待胶辊完全闭合    走纸48点行 //如同進紙/補紙動作;2018.06.20
            bErrPEFlag = 0;
        }
        ErrLED_off();
    }
    ClrSetBusy();//更新清除设置BUSY状态;AMO;2018.05.25
}


//=========================================================================================================
//* Function name:     DensityLevelSelect 
//* Descriptions :     开机按键选择打印浓度
//=========================================================================================================
void DensityLevelSelect(void)
{
    uint8_t cTemp;
    unsigned iLoop;
    for(iLoop = 0;iLoop < 32;iLoop++)
    {
        PrtConfigBuf[iLoop] = SPI_Read_Byte (UserParameterBaseAddr + iLoop);//读256个字节用户参数到缓冲中
    }
    cTemp = SPI_Read_Byte (UserParameterBaseAddr + DensitySelectAddr);
    cTemp++;
    if(cTemp >= 5)
    {
        cTemp = 1;
    }
    PrtConfigBuf[DensitySelectAddr] = cTemp;//更改用户设置参数
    switch(cTemp)
    {
        case 1:
            iDensitySetTime = DensitySetTimeLevel1;
            PrintStr("you select Density  Level 1", 1);
            break;
        case 2:
            iDensitySetTime = DensitySetTimeLevel2;
            PrintStr("you select Density  Level 2", 1);
            break;
        case 3:
            iDensitySetTime = DensitySetTimeLevel3;
            PrintStr("you select Density  Level 3", 1);
            break;
        case 4:
            iDensitySetTime = DensitySetTimeLevel4;
            PrintStr("you select Density  Level 4", 1);
            break;
        default:
            break;
    }
    SPI_Erase_Sector(UserParameterBaseAddr);//擦除扇区
    for(iLoop = 0; iLoop < 32; iLoop++)//重新写入扇区
    {
        SPI_Write_Byte(UserParameterBaseAddr + iLoop, PrtConfigBuf[iLoop]);
    }
}

