
#define		uCHAR	unsigned char
#define		uINT	unsigned short

#include "REG_MG82G5Exx.H"
#include <stdio.h>

#define CRC0DAisCRC0DI()				AUXR1 |= (CRCDS1 | CRCDS0)
#define CRC0DAisCRC0SL()				AUXR1 &= ~(CRCDS1 | CRCDS0)
#define CRC0DAisCRC0SH()				AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0

#define write_CRC0SL(wData__)			AUXR1 &= ~(CRCDS1 | CRCDS0); CRC0DA = (wData__)
#define write_CRC0SH(wData__)			AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0; CRC0DA = (wData__)
#define write_CRC0DI(wData__)			AUXR1 |= (CRCDS1 | CRCDS0); CRC0DA = (wData__)

#define read_CRC0RL(rVariable__)		AUXR1 &= ~(CRCDS1 | CRCDS0); (rVariable__) = CRC0DA
#define read_CRC0RH(rVariable__)		AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0; (rVariable__) = CRC0DA

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

union WTYPE
  { uCHAR B[2];
    uINT W;
  };

union WTYPE HW_CRC;
union WTYPE FW_CRC;
union WTYPE Calculate_CRC_Boundary_Addr;

uCHAR code *CodePtr;

code unsigned int crc_table[16]={
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
};

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}

uINT SWGPL_CRC16_CCITT_D8(uINT crc, uCHAR cdata)
{
	uINT iCrc;
	uCHAR i;

	iCrc = ((uINT)cdata) << 8;
	iCrc = iCrc ^ crc;

	i = 0;
	do{
		if ((iCrc & 0x8000) != 0)
		{
			iCrc <<= 1;
			iCrc ^= 0x1021;
		}
		else
			iCrc <<= 1;
	}while(++i < 8);

	return iCrc;
}


void Do_CRC(uCHAR Addr_H, uCHAR page)
{
	uCHAR IAPLB_tmp, var;

//==================  H/W Calculate CRC16  =========================
	write_CRC0SL(0);			//CRC seed Low byte
	write_CRC0SH(0);			//CRC seed High byte
	CRC0DAisCRC0DI();
	
	var = (Addr_H + ((page - 1) << 1));
	
	IAPLB_tmp = PageP_Read(IAPLB_P);
	PageP_Write(IAPLB_P, var);
	
	ISPCR = ISP_ENABLE;
	IFADRH = Addr_H;
	IFADRL = 0x00;
	IFMT = 0x80;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR &= ~ISP_ENABLE;
	PageP_Write(IAPLB_P, IAPLB_tmp);
	
	read_CRC0RH(HW_CRC.B[0]);
	read_CRC0RL(HW_CRC.B[1]);

    printf("CCITT16 AP IAP HW_CRC is %X\n\r", HW_CRC.W);

//==================  F/W Calculate CRC16  =========================

	FW_CRC.W = 0;

	Calculate_CRC_Boundary_Addr.W = 0;
	var = (Addr_H + ((page - 1) << 1));
	Calculate_CRC_Boundary_Addr.W = (var + 2) * 256; 

	CodePtr = (uCHAR code *)(Addr_H << 8);

	do{
		FW_CRC.W = SWGPL_CRC16_CCITT_D8(FW_CRC.W, *CodePtr);
		CodePtr ++;
	}while(((uINT)CodePtr) < Calculate_CRC_Boundary_Addr.W);

	printf("CCITT16 AP IAP FW_CRC is %X\n\r", FW_CRC.W);
	
}

void Initial_UART( void )
{
	//Sysclk = 12MHz, S0 Baud Rate Generator for BR=57600bps
	S0CFG |= SMOD3;								//Enable S0CR1 access.
	S0CFG |= SMOD2;								//double baud rate
	S0CR1 = (S0TR | S0TX12 | S0TCK | S0RCK);
	S0CON = 0x50;
	S0BRT = S0BRC = 243;

	TI0=1;				//for printf
}

void main(void)
{
	Initial_UART();
	Do_CRC(0x04, 10);

	while(1);
}
