
#define		uCHAR	unsigned char
#define		uINT	unsigned short

#include "REG_MG82G5Exx.H"


#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00



bit ESF_Flag;

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}

void Initial_XTAL(void)
{
	uCHAR tmp;
	tmp = PageP_Read(CKCON2_P);
	tmp &= ~(XTGS1 | XTGS0);					//gain for 32.768KHz
	tmp |= XTALE;
	PageP_Write(CKCON2_P, tmp);
	while(!(CKCON1 & XTOR));					//wait XTAL ready, Cap = 10pF.
}

void Initial_RTC(void)
{
	Initial_XTAL();
	PageP_Write(RTCTM_P, ( RTCCT5 | RTCCT4 | RTCCT3 | RTCCT2 | RTCCT1 | RTCCT0));				//Min. Step = 1s
	PageP_Write(RTCCR_P, (RTCE | RTCRL5 | RTCRL4 | RTCRL3 | RTCRL2));							//Enable RTC, interrupt in every 4s
	EIE1 |= ESF;																					//enable interrupt
	SFIE |= RTCFIE;
	SFIE &= ~MCDFIE;
}

void INT_SYS(void)	interrupt	11	using	1
{
	PCON1 |= RTCF;			//clear RTCF
	ESF_Flag = 1;			//set RTC even flag
}

void main(void)
{
	Initial_RTC();
	EA = 1;

	P31 = ~P31;
	PCON0 = 0x02;
	while(1){
		if(ESF_Flag)
		{
			ESF_Flag = 0;
			P31 = ~P31;						//toggle IO interval 4s
			PCON0 = 0x02;					//into power down mode
		}
	}
}
