
#define		uCHAR	unsigned char
#define		uINT	unsigned short

#include "REG_MG82G5Exx.H"
#include "delay.H"


union WTYPE
  { uCHAR B[2];
    uINT  W;
  };

float VDD_Volt;
union WTYPE ADC_Value;


#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}

void Initial_IVR(void)
{
	uCHAR tmp;
	tmp = PageP_Read(PCON3_P);
	tmp |= IVREN;
	PageP_Write(PCON3_P, tmp);
	delay_100us();
}

void Disable_IVR(void)
{
	uCHAR tmp;
	tmp = PageP_Read(PCON3_P);
	tmp &= ~IVREN;
	PageP_Write(PCON3_P, tmp);
	delay_10us();
}

void ADC_Start(void)
{
	ADCON0 |= 0x08;						//start AD conversion
	while(!(ADCON0 & 0x10));			//wait AD conversion finish
	ADCON0 &= 0xEF;						//Clear ADC interrupt flag

	ADC_Value.B[0] = ADCDH;					//get ADC value
	ADC_Value.B[1] = ADCDL;
}

void Initial_ADC(void)
{
	ADCON0 = (ADCEN | CHS3 | CHS2 | CHS1 | CHS0);		//ADCJ]Int LDO 1.4V
	ADCFG0 = (ADRJ | ADCKS1);	//SYSCLK / 4
	delay_50us();
	ADC_Start();
}

void main(void)
{
	Initial_IVR();
	Initial_ADC();

	ADC_Start();

	VDD_Volt = 1.4*1023 / ADC_Value.W;				//ϺXVDDq

	Disable_IVR();
	while(1);
}
