//********************************************************************************
//								     Include
//********************************************************************************
#include "ET1202_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								      MEMO
//********************************************************************************
/*-RF遙控器解碼
起頭碼 : High(5ms) + Low(7.8ms) 
Stop   : Low(150ms)

330us,780us
1 = High(780us) + Low(330us)
0 = High(330us) + Low(780us)

First remote control:
				      地址碼 20bits          數據碼 12bits
	"1" 	=	1111 1110 0010 1011 1111 	1000 0111 1100 
	"2"		=	1111 1110 0010 1011 1111 	1001 0110 1100
	"3"		=	1111 1110 0010 1011 1111 	0101 1010 1100
	"4"		=	1111 1110 0010 1011 1111 	1100 0011 1100
	"OFF"	=	1111 1110 0010 1011 1111 	1101 0010 1100
	"SMART" =	1111 1110 0010 1011 1111 	0011 1100 1100
	"3H"	=	1111 1110 0010 1011 1111 	0010 1101 1100
	"6H"	=	1111 1110 0010 1011 1111 	0001 1110 1100
	"9H"	=	1111 1110 0010 1011 1111 	0100 1011 1100
	
Sec remote control:
				      地址碼 20bits          數據碼 12bits
	"1" 	=	1111 0111 0011 0000 0111 	1000 0111 1100 
	"2"		=	1111 0111 0011 0000 0111 	1001 0110 1100
	"3"		=	1111 0111 0011 0000 0111 	0101 1010 1100
	"4"		=	1111 0111 0011 0000 0111 	1100 0011 1100
	"OFF"	=	1111 0111 0011 0000 0111 	1101 0010 1100		
	"SMART" =	1111 0111 0011 0000 0111 	0011 1100 1100
	"3H"	=	1111 0111 0011 0000 0111 	0010 1101 1100
	"6H"	=	1111 0111 0011 0000 0111 	0001 1110 1100
	"9H"	=	1111 0111 0011 0000 0111 	0100 1011 1100
*/
#if (Remote_control_type == 1)
	USER_RF_Decode	idata	RF_Decode;
#endif	
//********************************************************************************
//								  RFDecode_Init
//********************************************************************************
#if (Remote_control_type == 1)
void RFDecode_Init (void){
	uint8	dRF_CLK_DIV_SEL;
	uint16	dRF_STOP_TIME;
	uint16	dRF_HEADER1_TIME,dRF_HEADER2_TIME;
	
	IR_DEC_SET = IR_DEC_SET_REGS;
	
	#if((IR_DEC_SET_REGS&0x07)==0x00)
		#define 	CLK_DIV_SEL		24
	#elif((IR_DEC_SET_REGS&0x07)==0x01)
		#define 	CLK_DIV_SEL		16
	#elif((IR_DEC_SET_REGS&0x07)==0x02)
		#define 	CLK_DIV_SEL		8
	#elif((IR_DEC_SET_REGS&0x07)==0x03)
		#define 	CLK_DIV_SEL		6
	#elif((IR_DEC_SET_REGS&0x07)==0x04)
		#define 	CLK_DIV_SEL		3
	#elif((IR_DEC_SET_REGS&0x07)==0x05)
		#define 	CLK_DIV_SEL		2
	#endif
	
	dRF_CLK_DIV_SEL = CLK_DIV_SEL;
	dRF_HEADER1_TIME = RF_HEADER1_TIME - (RF_HEADER1_TIME * 0.02);//誤差設定2%(MCU內部Clock誤差為+/-1%)
	dRF_HEADER2_TIME = RF_HEADER2_TIME - (RF_HEADER2_TIME * 0.02);//誤差設定2%(MCU內部Clock誤差為+/-1%)
	dRF_STOP_TIME = RF_STOP_TIME - (RF_STOP_TIME * 0.02);		  //誤差設定2%(MCU內部Clock誤差為+/-1%)
	
	IR_HEADER_Z1_H = ((dRF_HEADER1_TIME * dRF_CLK_DIV_SEL)>>8);		
	IR_HEADER_Z1_L = (dRF_HEADER1_TIME * dRF_CLK_DIV_SEL);
	
	IR_HEADER_Z2_H = ((dRF_HEADER2_TIME * dRF_CLK_DIV_SEL)>>8);		
	IR_HEADER_Z2_L = (dRF_HEADER2_TIME * dRF_CLK_DIV_SEL);
		
	IR_STOP_Z_H = ((dRF_STOP_TIME * dRF_CLK_DIV_SEL)>>8);			
	IR_STOP_Z_L = (dRF_STOP_TIME * dRF_CLK_DIV_SEL);
	
	IR_DEC_CTRL = IR_DEC_CTRL_REGS;
}
#endif
//********************************************************************************
//								RF_Decode_Read
//********************************************************************************
#if (Remote_control_type == dRF_Control)
void RFDecode_Read(void){
	if((IR_DEC_CTRL & 0x10) == 0x10){
		IR_DEC_CTRL |= 0x01;
		
		RF_Decode.RF_address = IR_DOUT0;
		RF_Decode.RF_address += (IR_DOUT1 * 256);
		RF_Decode.RF_data = IR_DOUT2;
		RF_Decode.RF_data += (IR_DOUT3 * 256);
		
		#if (RF_decoding_UR_Enable == 1)
			RF_Decode.RF_address_ur = RF_Decode.RF_address;
			RF_Decode.RF_data_ur = RF_Decode.RF_data;
		#endif
		
		#if (Remote_control_learning_function == Enable)
			if(FLAG.RF_Learning_sw==0)
				RFLearning_mode();					//遙控器學習模式
			if(RF_Decode.RF_address==RF_Decode.RF_Learning_Address[0]+(RF_Decode.RF_Learning_Address[1]*256)){
		#else
			if(RF_Decode.RF_address==RF_address_value){	
		#endif
			switch(RF_Decode.RF_data){
				#if(e_RF_OFF == Enable)
					case RF_DATA_OFF:	 IRF_Channel = R_OFF;									break;
				#endif
				
				#if(e_RF_SPEED1 == Enable)
					case RF_DATA_SPEED1: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_1_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED2 == Enable)
					case RF_DATA_SPEED2: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_2_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED3 == Enable)
					case RF_DATA_SPEED3: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_3_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED4 == Enable)
					case RF_DATA_SPEED4: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_4_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED5 == Enable)
					case RF_DATA_SPEED5: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_5_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED6 == Enable)
					case RF_DATA_SPEED6: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_6_SPEED;	break;
				#endif
				
				#if(e_RF_SPEED7 == Enable)
					case RF_DATA_SPEED7: IRF_Channel = R_SPEED; IRF_SPEED_Level = R_7_SPEED;	break;
				#endif
				
				#if(e_RF_SMART == Enable)
					case RF_DATA_SMART:	 IRF_Channel = R_SMART;									break;
				#endif
				
				#if(e_RF_1H == Enable)
					case RF_DATA_1H:	 IRF_Channel = R_TIMER; IRF_TIMER_Level = R_1H;			break;
				#endif
				
				#if(e_RF_2H == Enable)
					case RF_DATA_2H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_2H;			break;
				#endif
				
				#if(e_RF_3H == Enable)
					case RF_DATA_3H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_3H;			break;
				#endif
				
				#if(e_RF_4H == Enable)
					case RF_DATA_4H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_4H;			break;
				#endif
				
				#if(e_RF_6H == Enable)
					case RF_DATA_6H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_6H;			break;
				#endif
				
				#if(e_RF_8H == Enable)
					case RF_DATA_8H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_8H;			break;	
				#endif
				
				#if(e_RF_9H == Enable)
					case RF_DATA_9H:	 IRF_Channel = R_TIMER;	IRF_TIMER_Level = R_9H;			break;	
				#endif
			}
		}
	}
	if(IRF_Channel!=R_INIT){					//執行遙控器按鍵
		#if (dIPWM_MODE == 1)
			if(FLAG.Buzzer_SW==0){
				FLAG.Buzzer_SW = 1;
				Ipwm.IPWM_Counter_temp = 0;
			}
		#endif
		IRF_Fun();
	}
	RF_Decode.RF_address = 0;
	RF_Decode.RF_data = 0;
}
#endif
//********************************************************************************
//								  RF_Learning_mode
//********************************************************************************
#if (Remote_control_type == dRF_Control)	
	#if (Remote_control_learning_function == Enable)
		void RFLearning_mode(void){
			if(RF_Decode.RF_data == RF_DATA_LEARNING){
				RF_Decode.RF_learning_times++;
				if(RF_Decode.RF_learning_times>=Successful_Learning_TIMES){	
					RF_Decode.RF_learning_times = 0;
					// IPWM_CTRL = IPWM_EN;
					RF_Decode.RF_Learning_Address[0] = IR_DOUT0;
					RF_Decode.RF_Learning_Address[1] = IR_DOUT1;

					EEP_Erase();
					EEP_Write(0x00,SpeedNum);		//記憶斷電後的遙控器速度段數
					EEP_Write(0x01,RF_Decode.RF_Learning_Address[0]);
					EEP_Write(0x02,RF_Decode.RF_Learning_Address[1]);

					FLAG.RF_Learning_sw = 1;
				}
			}
			else if(RF_Decode.RF_data == 0){	//按鍵放開
				RF_Decode.RF_learning_times = 0;
			}
		}
	#endif
#endif