#ifndef GPIO_H
#define GPIO_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> PINCONG1
// <o.0..1> CH7/P3.3/INT1N/IR2
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> CH6/P3.2/INT0N
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> CH5/P0.7/CAP2 
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> CH4/P0.6/CAP1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG1_REGS 0xAA

// <h> PINCONG2
// <o.0..1> CH3/P0.5/IR1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> CH2/P0.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> CH1/P0.2/OP1P
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> CH0/P0.0/OP0P
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG2_REGS 0xAA

// <h> PINCONG3
// <o.0..1> XTALI/P3.5/T1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> XTALO/P3.4/T0
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> PWM_U
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> PWM_X
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG3_REGS 0x5A

// <h> PINCONG4
// <o.0..1> PWM_V
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> PWM_Y
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> PWM_W
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> PWM_Z
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG4_REGS 0x55

// <h> PINCONG5
// <o.0..1> AOCP/P1.6
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> OP0N/P0.1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> OP1N/P0.3
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> DOCPN/P1.7
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG5_REGS 0xAA

// <h> PINCONG6
// <o.0..1> TX/P3.1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> RX/P3.0
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> IIC_SDA/P2.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> IIC_SCL/P2.5
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG6_REGS 0x58

// <h> PINCONG7
// <o.0..1> IPWM/P2.6
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> FG/P2.7
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG7_REGS 0x06

// <h> PINSET1
// <o.0..1> CH7/P3.3/INT1N/IR2
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> CH6/P3.2/INT0N
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> CH5/P0.7/CAP2 
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> CH4/P0.6/CAP1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET1_REGS 0x50

// <h> PINSET2
// <o.0..1> CH3/P0.5/IR1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> CH2/P0.4
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> CH1/P0.2/OP1P
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> CH0/P0.0/OP0P
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET2_REGS 0x01

// <h> PINSET3
// <o.0..1> XTALI/P3.5/T1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> XTALO/P3.4/T0
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> PWM_U
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> PWM_X
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET3_REGS 0x08

// <h> PINSET4
// <o.0..1> PWM_V 
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> PWM_Y
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> PWM_W
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> PWM_Z
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET4_REGS 0x00

// <h> PINSET5
// <o.0..1> AOCP/P1.6
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> OP0N/P0.1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> OP1N/P0.3
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> DOCPN/P1.7
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET5_REGS 0x80

// <h> PINSET6
// <o.0..1> TX/P3.1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> RX/P3.0
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> IIC_SDA/P2.4
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> IIC_SCL/P2.5
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET6_REGS 0x0A

// <h> PINSET7 
// <o.0..1> IPWM/P2.6
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> FG/P2.7
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> DOCPDB 
// <0=> 0ns
// <1=> 250ns
// <2=> 500ns
// <3=> 1000ns
// <o.7> MOC
// <0=> U V W X Y Z is GPIO Mode 
// <1=> U V W X Y Z is SVPWM Mode 
// <i> MOCS = 1, Pin set must to Push-pull output mode. (PINSET3 [7:4] and PINSET4 [7:0])
// </h>
#define PINSET7_REGS 0xB0
// <<< end of configuration section >>>

extern void GPIO_Init (void);
#endif
