#ifndef FOCPARACAL_H
#define FOCPARACAL_H

#define SMO_KSLF_MAX 	24000
#define SMO_KSLF_MIN 	4000

#if(1)
#define SMO_KSLIDE_MAX 	32767
#define SMO_KSLIDE_MIN 	16383

typedef struct{
	uint8		opa_gain;
	int16		SPEED_TEMP;
	uint16 	PWM_F;
	uint16 	RATED_SPEED_MAX;
	uint16 	RATED_VOLTAGE;
	uint16	KSLF_MIN;
	uint16	KSLF_MAX;
	uint16	KSLIDE_MIN;
	uint16	KSLIDE_MAX;
	float 	RS_Ohm;
	float 	LS_H;
	float 	SHUNT_R;
} MotorParam_t;

extern  xdata MotorParam_t motorParam;
#endif
extern float FS;
extern float GS;
extern float SMO_Kslide;
extern float SMO_Kslf;
extern float Spd_cyc;
extern float AS_temp;

extern float Pll_Kp;
extern float Pll_Ki;
extern float Cur_Kp;
extern float Cur_Ki;

extern void InitMotorParam(void);
extern void FOCParaCal_Fun(MotorParam_t *param);
extern void FOCPara_Limit(void);
extern void SMOPara_Cal_Fun (MotorParam_t *param);
#endif
