/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			CMP, P10Ϊ룬P11Ϊ
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26


/***********************************************************************************
* :   void INT_AC0(void)
*:AC0 жϷ
		 
*:   
*ز:     
*************************************************************************************/
void INT_AC0(void) interrupt INT_VECTOR_AC0
{
	if((AC0CON&AC0F)==AC0F)
	{
		LED_R=!LED_R;
		AC0CON=AC0CON&(~AC0F);		//AC0F־
	}
}

/*************************************************
* : char putchar (char c)   
*: printf Ĵ
*:     char c
*ز:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}


/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}


/***********************************************************************************
* :   void InitUart0_S0BRG(void)
*:   Uart0ʼ ,ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART0
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

    // ò
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_12000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}


/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);			//  P22,P24,P26 Ϊ LED
	PORT_SetP1AInputOnly(BIT0|BIT1);  			//  P10,P11ģ룬CMPͨ
}

/***********************************************************************************
* :   void InitCMP(void)
*:   CMPʼ
*:   
*ز:     
*************************************************************************************/
void InitCMP(void)
{
	AC0_Enable();										// ʹCMP0
	AC0_SetInterruptMode_Rising();						// жģʽж
	AC0_SetPosInputP10();								// CMP0P10
	AC0_SetNegaReferenceVoltage_AC0NI();				// CMP0P11
}

/***********************************************************************************
* :   void InitInterrupt(void)
*:   жϳʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnAC0();										// ʹCMP0ж
}	


/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{

	InitPort();
	InitUart0_S0BRG();
	InitCMP();
	InitInterrupt();
}



void main()
{
    InitSystem();
	
	printf("\nHello");
	
	LED_G_1=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;LED_G_0=1;

	INT_EnAll();									// ʹȫж
    while(1)
    {
		DelayXms(200);
		LED_G_0=!LED_G_0;
    }
}


