/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			BOD0, BOD1;
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26


bit bBOD1Flag;

/***********************************************************************************
* :   void INT_SF(void)
*:SF жϷ
*:   
*ز:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1 & BOF0)!=0)
	{ // BOD0 ж, 1.7V
		
	}

	if((PCON1 & BOF1)!=0)
	{ // BOD1 ж, 4.2V/3.7V/2.4V/2.0V
		bBOD1Flag = 1;
		LED_R=0;
		// To do......

		INT_DisSF_BOD1();			// ֹBOD1ж
	}

	if((PCON1 & WDTF)!=0)
	{ // WDT ж

	}

	if((PCON1 & RTCF)!=0)
	{ // RTC ж

	}

	PCON1 = (BOF0|BOF1|WDTF|RTCF);	// BOD0,BOD1,WDT,RTCжϱ־

}


/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
* :   u8 IAP_ReadPPage(u8 PsfrAddr)
*:ȡPҳ⹦
*:   
*		 u8 PsfrAddr: Pҳַ
*ز:     
*		 u8: Pҳ
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;			//
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//              
	return IFD;
}

/***********************************************************************************
* :   void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:ȡPҳ⹦
*:   
*		 u8 PsfrAddr: Pҳַ, u8 PsfrDat: Pҳ
*ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;			//
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}

/***********************************************************************************
* :   void InitInterrupt(void)
*:   жϳʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_BOD1();			// ʹBOD1ж
	INT_EnSF();					// ʹSFж
	
}	

/***********************************************************************************
* :   void InitBOD(void)
*:   BODʼ
*:   
*ز:     
*************************************************************************************/
void InitBOD(void)
{
	u8 x;
	x=BIT0;

	//x=x|POW_BOD1_Set42V;	// 4.2V
	x=x|POW_BOD1_Set37V;	// 3.7V
	//x=x|POW_BOD1_Set24V;	// 2.4V
	//x=x|POW_BOD1_Set20V;	// 2.0V

	//ѹ
	IAP_WritePPage(PCON2_P, x);	
	PCON1=BOF0|BOF1;

	x=x|POW_BOD1_Enable;	// ʹBOD1
	//x=x|POW_BOD1_Disable;	// ֹBOD1
	
	//x=x|POW_BOD1_Enable_OnPD;	// ʹBOD1PDģʽ
	x=x|POW_BOD1_Disable_OnPD;	// ֹBOD1PDģʽ

	//x=x|POW_BOD1_EnReset;	// ʹBOD1⸴λоƬ
	x=x|POW_BOD1_DisReset;	// ֹBOD1⸴λоƬ

	x=x|POW_BOD0_EnReset;	// ʹBOD0⸴λоƬ
	//x=x|POW_BOD0_DisReset;	// ֹBOD0⸴λоƬ
	
	IAP_WritePPage(PCON2_P, x);	
	
}	



/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1);				//  P30,P31Ϊ˫ڣ UART
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);			//  P22,P24,P26 Ϊ LED
}




/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{

	InitPort();
	InitBOD();
	InitInterrupt();

	INT_EnAll();  // ʹȫж
}



void main()
{
    InitSystem();

	bBOD1Flag=0;
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

    while(1)
    {
		DelayXms(200);
		LED_G_0=!LED_G_0;
		if(bBOD1Flag)
		{
			if((PCON1 & BOF1)!=0)
			{// BOF1λVDD<3.7V
				PCON1 = BOF1;				// ־
			}
			else
			{// VDD>3.7V
				// Դѹָ,ʹBOD1ж
				LED_R=1;
				bBOD1Flag = FALSE;
				INT_EnSF_BOD1();			// Դѹָ,ʹBOD1ж, BOD1
			}
		}
    }
}

