#ifndef _USERDEFINE_H

#define _USERDEFINE_H

#if defined(MG32F02A132) || defined(MG32F02A072) || defined(MA862)
/*! @enum   PINX_AF_TypeDef
    @brief  Pin IO AF control options for MG32F02A132/MG32F02A072/MA862
*/ 
typedef enum
{
	PA0_AF_GPA0	= 0,
	PA1_AF_GPA1	= 0,
	PA2_AF_GPA2	= 0,
	PA3_AF_GPA3	= 0,
	PA4_AF_GPA4	= 0,
	PA5_AF_GPA5	= 0,
	PA6_AF_GPA6	= 0,
	PA7_AF_GPA7	= 0,
	PA8_AF_GPA8	= 0,
	PA9_AF_GPA9	= 0,
	PA10_AF_GPA10	= 0,
	PA11_AF_GPA11	= 0,
	PA12_AF_GPA12	= 0,
	PA13_AF_GPA13	= 0,
	PA14_AF_GPA14	= 0,
	PA15_AF_GPA15	= 0,
	PA0_AF_MA0	= 8,
	PA1_AF_MA1	= 8,
	PA2_AF_MA2	= 8,
	PA3_AF_MA3	= 8,
	PA4_AF_MA4	= 8,
	PA5_AF_MA5	= 8,
	PA6_AF_MA6	= 8,
	PA7_AF_MA7	= 8,
	PA8_AF_MA8	= 8,
	PA9_AF_MA9	= 8,
	PA10_AF_MA10	= 8,
	PA11_AF_MA11	= 8,
	PA12_AF_MA12	= 8,
	PA13_AF_MA13	= 8,
	PA14_AF_MA14	= 8,
	PA15_AF_MA15	= 8,
	PB0_AF_GPB0	= 0,
	PB1_AF_GPB1	= 0,
	PB2_AF_GPB2	= 0,
	PB3_AF_GPB3	= 0,
	PB4_AF_GPB4	= 0,
	PB5_AF_GPB5	= 0,
	PB6_AF_GPB6	= 0,
	PB7_AF_GPB7	= 0,
	PB8_AF_GPB8	= 0,
	PB9_AF_GPB9	= 0,
	PB10_AF_GPB10	= 0,
	PB11_AF_GPB11	= 0,
	PB12_AF_GPB12	= 0,
	PB13_AF_GPB13	= 0,
	PB14_AF_GPB14	= 0,
	PB15_AF_GPB15	= 0,
	PB0_AF_I2C1_SCL	= 1,
	PB1_AF_I2C1_SDA	= 1,
	PB2_AF_ADC0_TRG	= 1,
	PB3_AF_ADC0_OUT	= 1,
	PB4_AF_TM01_CKO	= 1,
	PB5_AF_TM16_CKO	= 1,
	PB6_AF_CPU_RXEV	= 1,
	PB7_AF_CPU_TXEV	= 1,
	PB8_AF_CMP0_P0	= 1,
	PB9_AF_CMP1_P0	= 1,
	PB10_AF_CMP2_P0	= 1,
	PB11_AF_CMP3_P0	= 1,
	PB12_AF_DMA_TRG0	= 1,
	PB13_AF_DAC_TRG0	= 1,
	PB15_AF_IR_OUT	= 1,
	PB0_AF_SPI0_NSS	= 2,
	PB1_AF_SPI0_MISO	= 2,
	PB2_AF_SPI0_CLK	= 2,
	PB3_AF_SPI0_MOSI	= 2,
	PB4_AF_SPI0_D3	= 2,
	PB5_AF_SPI0_D2	= 2,
	PB6_AF_SPI0_NSSI	= 2,
	PB8_AF_RTC_OUT	= 2,
	PB9_AF_RTC_TS	= 2,
	PB10_AF_I2C0_SCL	= 2,
	PB11_AF_I2C0_SDA	= 2,
	PB13_AF_TM00_ETR	= 2,
	PB14_AF_TM00_TRGO	= 2,
	PB0_AF_TM01_ETR	= 3,
	PB1_AF_TM01_TRGO	= 3,
	PB2_AF_TM01_CKO	= 3,
	PB4_AF_TM26_TRGO	= 3,
	PB5_AF_TM26_ETR	= 3,
	PB6_AF_URT0_BRO	= 3,
	PB7_AF_URT0_TMO	= 3,
	PB8_AF_URT0_TX	= 3,
	PB9_AF_URT0_RX	= 3,
	PB10_AF_URT0_NSS	= 3,
	PB11_AF_URT0_DE	= 3,
	PB13_AF_URT0_CTS	= 3,
	PB14_AF_URT0_RTS	= 3,
	PB0_AF_TM00_CKO	= 4,
	PB1_AF_TM10_CKO	= 4,
	PB2_AF_URT2_TX	= 4,
	PB3_AF_URT2_RX	= 4,
	PB4_AF_URT2_CLK	= 4,
	PB5_AF_URT2_NSS	= 4,
	PB6_AF_URT2_CTS	= 4,
	PB7_AF_URT2_RTS	= 4,
	PB8_AF_URT2_BRO	= 4,
	PB9_AF_URT2_TMO	= 4,
	PB10_AF_URT2_DE	= 4,
	PB13_AF_URT3_RX	= 4,
	PB14_AF_URT3_TX	= 4,
	PB0_AF_TM16_ETR	= 5,
	PB1_AF_TM16_TRGO	= 5,
	PB2_AF_TM16_CKO	= 5,
	PB4_AF_TM20_IC0	= 5,
	PB5_AF_TM20_IC1	= 5,
	PB6_AF_TM20_ETR	= 5,
	PB7_AF_TM20_TRGO	= 5,
	PB8_AF_TM20_OC01	= 5,
	PB9_AF_TM20_OC02	= 5,
	PB10_AF_TM20_OC11	= 5,
	PB11_AF_TM20_OC12	= 5,
	PB13_AF_TM20_ETR	= 5,
	PB14_AF_TM20_TRGO	= 5,
	PB0_AF_TM26_IC0	= 6,
	PB1_AF_TM26_IC1	= 6,
	PB2_AF_TM26_OC0H	= 6,
	PB3_AF_TM26_OC1H	= 6,
	PB4_AF_TM36_IC0	= 6,
	PB5_AF_TM36_IC1	= 6,
	PB6_AF_TM36_IC2	= 6,
	PB7_AF_TM36_IC3	= 6,
	PB8_AF_TM36_OC01	= 6,
	PB9_AF_TM36_OC02	= 6,
	PB10_AF_TM36_OC11	= 6,
	PB11_AF_TM36_OC12	= 6,
	PB13_AF_TM36_ETR	= 6,
	PB14_AF_TM36_BK0	= 6,
	PB0_AF_MA15	= 8,
	PB4_AF_MALE	= 8,
	PB5_AF_MOE	= 8,
	PB6_AF_MWE	= 8,
	PB7_AF_MCE	= 8,
	PB8_AF_MAD0	= 8,
	PB9_AF_MAD1	= 8,
	PB10_AF_MAD2	= 8,
	PB11_AF_MAD3	= 8,
	PB12_AF_MAD4	= 8,
	PB13_AF_MAD5	= 8,
	PB14_AF_MAD6	= 8,
	PB15_AF_MAD7	= 8,
	PB4_AF_MAD8	= 9,
	PB5_AF_MAD9	= 9,
	PB6_AF_MAD10	= 9,
	PB7_AF_MALE2	= 9,
	PB9_AF_MAD8	= 9,
	PB10_AF_MAD1	= 9,
	PB11_AF_MAD9	= 9,
	PB12_AF_MAD2	= 9,
	PB13_AF_MAD10	= 9,
	PB14_AF_MAD3	= 9,
	PB15_AF_MAD11	= 9,
	PC0_AF_GPC0	= 0,
	PC1_AF_GPC1	= 0,
	PC2_AF_GPC2	= 0,
	PC3_AF_GPC3	= 0,
	PC4_AF_GPC4	= 0,
	PC5_AF_GPC5	= 0,
	PC6_AF_GPC6	= 0,
	PC7_AF_GPC7	= 0,
	PC8_AF_GPC8	= 0,
	PC9_AF_GPC9	= 0,
	PC10_AF_GPC10	= 0,
	PC11_AF_GPC11	= 0,
	PC12_AF_GPC12	= 0,
	PC13_AF_GPC13	= 0,
	PC14_AF_GPC14	= 0,
	PC0_AF_ICKO	= 1,
	PC1_AF_ADC0_TRG	= 1,
	PC2_AF_ADC0_OUT	= 1,
	PC3_AF_OBM_P1	= 1,
	PC4_AF_SWCLK	= 1,
	PC5_AF_SWDIO	= 1,
	PC6_AF_RSTN	= 1,
	PC7_AF_ADC0_TRG	= 1,
	PC8_AF_ADC0_OUT	= 1,
	PC9_AF_CMP0_P0	= 1,
	PC10_AF_CMP1_P0	= 1,
	PC11_AF_CMP2_P0	= 1,
	PC12_AF_CMP3_P0	= 1,
	PC13_AF_XIN	= 1,
	PC14_AF_XOUT	= 1,
	PC0_AF_TM00_CKO	= 2,
	PC1_AF_TM01_CKO	= 2,
	PC2_AF_TM10_CKO	= 2,
	PC3_AF_TM16_CKO	= 2,
	PC4_AF_I2C0_SCL	= 2,
	PC5_AF_I2C0_SDA	= 2,
	PC6_AF_RTC_TS	= 2,
	PC7_AF_RTC_OUT	= 2,
	PC8_AF_I2C0_SCL	= 2,
	PC9_AF_I2C0_SDA	= 2,
	PC10_AF_I2C1_SCL	= 2,
	PC11_AF_I2C1_SDA	= 2,
	PC12_AF_IR_OUT	= 2,
	PC0_AF_URT0_CLK	= 3,
	PC3_AF_URT0_CLK	= 3,
	PC4_AF_URT0_RX	= 3,
	PC5_AF_URT0_TX	= 3,
	PC6_AF_URT0_NSS	= 3,
	PC7_AF_URT0_DE	= 3,
	PC8_AF_URT0_BRO	= 3,
	PC9_AF_URT0_TMO	= 3,
	PC10_AF_URT0_TX	= 3,
	PC11_AF_URT0_RX	= 3,
	PC12_AF_DAC_TRG0	= 3,
	PC13_AF_URT0_CTS	= 3,
	PC14_AF_URT0_RTS	= 3,
	PC0_AF_URT2_CLK	= 4,
	PC1_AF_URT1_CLK	= 4,
	PC2_AF_URT2_CLK	= 4,
	PC3_AF_URT1_CLK	= 4,
	PC4_AF_URT1_RX	= 4,
	PC5_AF_URT1_TX	= 4,
	PC8_AF_URT1_TX	= 4,
	PC9_AF_URT1_RX	= 4,
	PC10_AF_URT2_TX	= 4,
	PC11_AF_URT2_RX	= 4,
	PC12_AF_	= 4,
	PC13_AF_URT2_RX	= 4,
	PC14_AF_URT2_TX	= 4,
	PC0_AF_TM20_OC00	= 5,
	PC1_AF_TM20_OC0N	= 5,
	PC2_AF_TM20_OC10	= 5,
	PC3_AF_TM20_OC1N	= 5,
	PC6_AF_TM20_ETR	= 5,
	PC8_AF_TM20_OC0H	= 5,
	PC9_AF_TM20_OC1H	= 5,
	PC12_AF_TM10_TRGO	= 5,
	PC13_AF_TM10_ETR	= 5,
	PC14_AF_TM10_CKO	= 5,
	PC0_AF_TM36_OC00	= 6,
	PC1_AF_TM36_OC0N	= 6,
	PC2_AF_TM36_OC10	= 6,
	PC3_AF_TM36_OC1N	= 6,
	PC6_AF_TM26_ETR	= 6,
	PC7_AF_TM36_TRGO	= 6,
	PC8_AF_TM36_OC0H	= 6,
	PC9_AF_TM36_OC1H	= 6,
	PC10_AF_TM36_OC2H	= 6,
	PC11_AF_TM36_OC3H	= 6,
	PC12_AF_TM36_OC3	= 6,
	PC13_AF_TM26_ETR	= 6,
	PC14_AF_TM26_TRGO	= 6,
	PC0_AF_MCLK	= 8,
	PC1_AF_MAD8	= 8,
	PC2_AF_MAD9	= 8,
	PC3_AF_MAD10	= 8,
	PC6_AF_MBW1	= 8,
	PC7_AF_MBW0	= 8,
	PC8_AF_MAD11	= 8,
	PC9_AF_MAD12	= 8,
	PC10_AF_MAD13	= 8,
	PC11_AF_MAD14	= 8,
	PC12_AF_MAD15	= 8,
	PC0_AF_MWE	= 9,
	PC1_AF_MAD4	= 9,
	PC2_AF_MAD12	= 9,
	PC3_AF_MAD5	= 9,
	PC6_AF_MALE	= 9,
	PC7_AF_MCE	= 9,
	PC8_AF_MAD13	= 9,
	PC9_AF_MAD6	= 9,
	PC10_AF_MAD14	= 9,
	PC11_AF_MAD7	= 9,
	PD0_AF_GPD0	= 0,
	PD1_AF_GPD1	= 0,
	PD2_AF_GPD2	= 0,
	PD3_AF_GPD3	= 0,
	PD4_AF_GPD4	= 0,
	PD5_AF_GPD5	= 0,
	PD6_AF_GPD6	= 0,
	PD7_AF_GPD7	= 0,
	PD8_AF_GPD8	= 0,
	PD9_AF_GPD9	= 0,
	PD10_AF_GPD10	= 0,
	PD11_AF_GPD11	= 0,
	PD12_AF_GPD12	= 0,
	PD13_AF_GPD13	= 0,
	PD14_AF_GPD14	= 0,
	PD15_AF_GPD15	= 0,
	PD0_AF_OBM_I0	= 1,
	PD1_AF_OBM_I1	= 1,
	PD4_AF_TM00_TRGO	= 1,
	PD5_AF_TM00_ETR	= 1,
	PD6_AF_CPU_NMI	= 1,
	PD7_AF_TM00_CKO	= 1,
	PD11_AF_CPU_NMI	= 1,
	PD12_AF_CMP0_P0	= 1,
	PD13_AF_CMP1_P0	= 1,
	PD14_AF_CMP2_P0	= 1,
	PD15_AF_CMP3_P0	= 1,
	PD0_AF_TM10_CKO	= 2,
	PD1_AF_TM16_CKO	= 2,
	PD2_AF_TM00_CKO	= 2,
	PD3_AF_TM01_CKO	= 2,
	PD4_AF_TM01_TRGO	= 2,
	PD7_AF_TM01_ETR	= 2,
	PD11_AF_DMA_TRG1	= 2,
	PD0_AF_URT0_CLK	= 3,
	PD1_AF_URT0_CLK	= 3,
	PD2_AF_URT1_CLK	= 3,
	PD3_AF_URT1_CLK	= 3,
	PD4_AF_URT1_TX	= 3,
	PD5_AF_URT1_RX	= 3,
	PD6_AF_URT1_NSS	= 3,
	PD7_AF_URT1_DE	= 3,
	PD8_AF_URT1_RTS	= 3,
	PD9_AF_URT1_CTS	= 3,
	PD10_AF_URT1_BRO	= 3,
	PD11_AF_URT1_TMO	= 3,
	PD13_AF_OBM_P1	= 3,
	PD14_AF_DAC_TRG0	= 3,
	PD15_AF_IR_OUT	= 3,
	PD2_AF_TM26_OC00	= 4,
	PD3_AF_URT3_CLK	= 4,
	PD4_AF_URT3_RTS	= 4,
	PD5_AF_URT3_CTS	= 4,
	PD6_AF_URT3_DE	= 4,
	PD7_AF_URT3_NSS	= 4,
	PD8_AF_URT3_TX	= 4,
	PD9_AF_URT3_RX	= 4,
	PD10_AF_URT3_BRO	= 4,
	PD11_AF_URT3_TMO	= 4,
	PD12_AF_TM00_CKO	= 4,
	PD13_AF_TM00_TRGO	= 4,
	PD14_AF_TM00_ETR	= 4,
	PD15_AF_DMA_TRG0	= 4,
	PD0_AF_TM20_CKO	= 5,
	PD1_AF_TM26_CKO	= 5,
	PD2_AF_TM20_CKO	= 5,
	PD6_AF_SPI0_NSSI	= 5,
	PD12_AF_SPI0_CLK	= 5,
	PD0_AF_TM36_OC2	= 6,
	PD1_AF_TM36_OC2N	= 6,
	PD2_AF_TM36_CKO	= 6,
	PD3_AF_TM26_CKO	= 6,
	PD4_AF_TM26_OC00	= 6,
	PD5_AF_TM26_OC01	= 6,
	PD6_AF_TM26_OC02	= 6,
	PD7_AF_TM26_OC0N	= 6,
	PD8_AF_TM26_OC10	= 6,
	PD9_AF_TM26_OC11	= 6,
	PD10_AF_TM26_OC12	= 6,
	PD11_AF_TM26_OC1N	= 6,
	PD12_AF_TM20_OC0H	= 6,
	PD13_AF_TM20_OC1H	= 6,
	PD14_AF_TM20_IC0	= 6,
	PD15_AF_TM20_IC1	= 6,
	PD1_AF_SPI0_CLK	= 7,
	PD2_AF_SPI0_MOSI	= 7,
	PD3_AF_SPI0_D3	= 7,
	PD4_AF_SPI0_D2	= 7,
	PD5_AF_SPI0_MISO	= 7,
	PD6_AF_SPI0_NSS	= 7,
	PD7_AF_SPI0_D4	= 7,
	PD8_AF_SPI0_D7	= 7,
	PD9_AF_SPI0_D6	= 7,
	PD10_AF_SPI0_D5	= 7,
	PD11_AF_SPI0_NSS	= 7,
	PD12_AF_TM26_OC0H	= 7,
	PD13_AF_TM26_OC1H	= 7,
	PD14_AF_TM26_IC0	= 7,
	PD15_AF_TM26_IC1	= 7,
	PD0_AF_MCLK	= 9,
	PD2_AF_MAD4	= 9,
	PD3_AF_MAD7	= 9,
	PD4_AF_MAD6	= 9,
	PD5_AF_MAD5	= 9,
	PD7_AF_MAD0	= 9,
	PD8_AF_MAD3	= 9,
	PD9_AF_MAD2	= 9,
	PD10_AF_MAD1	= 9,
	PD11_AF_MWE	= 9,
	PD12_AF_MALE2	= 9,
	PD13_AF_MCE	= 9,
	PD14_AF_MOE	= 9,
	PE0_AF_GPE0	= 0,
	PE1_AF_GPE1	= 0,
	PE2_AF_GPE2	= 0,
	PE3_AF_GPE3	= 0,
	PE8_AF_GPE8	= 0,
	PE9_AF_GPE9	= 0,
	PE12_AF_GPE12	= 0,
	PE13_AF_GPE13	= 0,
	PE14_AF_GPE14	= 0,
	PE15_AF_GPE15	= 0,
	PE0_AF_OBM_I0	= 1,
	PE1_AF_OBM_I1	= 1,
	PE3_AF_OBM_P1	= 1,
	PE8_AF_CPU_TXEV	= 1,
	PE9_AF_CPU_RXEV	= 1,
	PE12_AF_ADC0_TRG	= 1,
	PE13_AF_ADC0_OUT	= 1,
	PE14_AF_RTC_OUT	= 1,
	PE15_AF_RTC_TS	= 1,
	PE8_AF_OBM_I0	= 2,
	PE9_AF_OBM_I1	= 2,
	PE0_AF_URT0_TX	= 3,
	PE1_AF_URT0_RX	= 3,
	PE2_AF_URT1_TX	= 3,
	PE3_AF_URT1_RX	= 3,
	PE8_AF_URT2_TX	= 3,
	PE9_AF_URT2_RX	= 3,
	PE12_AF_URT3_TX	= 3,
	PE13_AF_URT3_RX	= 3,
	PE1_AF_DMA_TRG1	= 4,
	PE12_AF_TM01_CKO	= 4,
	PE13_AF_TM01_TRGO	= 4,
	PE14_AF_TM01_ETR	= 4,
	PE8_AF_TM36_CKO	= 5,
	PE9_AF_TM36_TRGO	= 5,
	PE12_AF_TM16_CKO	= 5,
	PE13_AF_TM16_TRGO	= 5,
	PE14_AF_TM16_ETR	= 5,
	PE15_AF_TM36_ETR	= 5,
	PE0_AF_TM20_OC00	= 6,
	PE1_AF_TM20_OC01	= 6,
	PE2_AF_TM20_OC02	= 6,
	PE3_AF_TM20_OC0N	= 6,
	PE8_AF_TM20_CKO	= 6,
	PE9_AF_TM20_TRGO	= 6,
	PE12_AF_TM20_OC10	= 6,
	PE13_AF_TM20_OC11	= 6,
	PE14_AF_TM20_OC12	= 6,
	PE15_AF_TM20_OC1N	= 6,
	PE0_AF_TM26_OC00	= 7,
	PE1_AF_TM26_OC01	= 7,
	PE2_AF_TM26_OC02	= 7,
	PE3_AF_TM26_OC0N	= 7,
	PE8_AF_TM26_CKO	= 7,
	PE9_AF_TM26_TRGO	= 7,
	PE12_AF_TM26_OC10	= 7,
	PE13_AF_TM26_OC11	= 7,
	PE14_AF_TM26_OC12	= 7,
	PE15_AF_TM26_OC1N	= 7,
	PE0_AF_MALE	= 8,
	PE1_AF_MOE	= 8,
	PE2_AF_MWE	= 8,
	PE3_AF_MCE	= 8,
	PE12_AF_MBW0	= 8,
	PE13_AF_MBW1	= 8,
	PE14_AF_MALE2	= 8,
	PE15_AF_MALE	= 8,
	PE3_AF_MALE2	= 9,
	PE9_AF_MOE	= 9,

	ADC0_OUT_AF_PB3	= 1,
	ADC0_OUT_AF_PC2	= 1,
	ADC0_OUT_AF_PC8	= 1,
	ADC0_OUT_AF_PE13	= 1,
	ADC0_TRG_AF_PB2	= 1,
	ADC0_TRG_AF_PC1	= 1,
	ADC0_TRG_AF_PC7	= 1,
	ADC0_TRG_AF_PE12	= 1,
	CMP0_P0_AF_PB8	= 1,
	CMP0_P0_AF_PC9	= 1,
	CMP0_P0_AF_PD12	= 1,
	CMP1_P0_AF_PB9	= 1,
	CMP1_P0_AF_PC10	= 1,
	CMP1_P0_AF_PD13	= 1,
	CMP2_P0_AF_PB10	= 1,
	CMP2_P0_AF_PC11	= 1,
	CMP2_P0_AF_PD14	= 1,
	CMP3_P0_AF_PB11	= 1,
	CMP3_P0_AF_PC12	= 1,
	CMP3_P0_AF_PD15	= 1,
	CPU_NMI_AF_PD11	= 1,
	CPU_NMI_AF_PD6	= 1,
	CPU_RXEV_AF_PB6	= 1,
	CPU_RXEV_AF_PE9	= 1,
	CPU_TXEV_AF_PB7	= 1,
	CPU_TXEV_AF_PE8	= 1,
	DAC_TRG0_AF_PB13	= 1,
	DAC_TRG0_AF_PC12	= 3,
	DAC_TRG0_AF_PD14	= 3,
	DMA_TRG0_AF_PB12	= 1,
	DMA_TRG0_AF_PD15	= 4,
	DMA_TRG1_AF_PD11	= 2,
	DMA_TRG1_AF_PE1	= 4,
	GPA0_AF_PA0	= 0,
	GPA1_AF_PA1	= 0,
	GPA10_AF_PA10	= 0,
	GPA11_AF_PA11	= 0,
	GPA12_AF_PA12	= 0,
	GPA13_AF_PA13	= 0,
	GPA14_AF_PA14	= 0,
	GPA15_AF_PA15	= 0,
	GPA2_AF_PA2	= 0,
	GPA3_AF_PA3	= 0,
	GPA4_AF_PA4	= 0,
	GPA5_AF_PA5	= 0,
	GPA6_AF_PA6	= 0,
	GPA7_AF_PA7	= 0,
	GPA8_AF_PA8	= 0,
	GPA9_AF_PA9	= 0,
	GPB0_AF_PB0	= 0,
	GPB1_AF_PB1	= 0,
	GPB10_AF_PB10	= 0,
	GPB11_AF_PB11	= 0,
	GPB12_AF_PB12	= 0,
	GPB13_AF_PB13	= 0,
	GPB14_AF_PB14	= 0,
	GPB15_AF_PB15	= 0,
	GPB2_AF_PB2	= 0,
	GPB3_AF_PB3	= 0,
	GPB4_AF_PB4	= 0,
	GPB5_AF_PB5	= 0,
	GPB6_AF_PB6	= 0,
	GPB7_AF_PB7	= 0,
	GPB8_AF_PB8	= 0,
	GPB9_AF_PB9	= 0,
	GPC0_AF_PC0	= 0,
	GPC1_AF_PC1	= 0,
	GPC10_AF_PC10	= 0,
	GPC11_AF_PC11	= 0,
	GPC12_AF_PC12	= 0,
	GPC13_AF_PC13	= 0,
	GPC14_AF_PC14	= 0,
	GPC2_AF_PC2	= 0,
	GPC3_AF_PC3	= 0,
	GPC4_AF_PC4	= 0,
	GPC5_AF_PC5	= 0,
	GPC6_AF_PC6	= 0,
	GPC7_AF_PC7	= 0,
	GPC8_AF_PC8	= 0,
	GPC9_AF_PC9	= 0,
	GPD0_AF_PD0	= 0,
	GPD1_AF_PD1	= 0,
	GPD10_AF_PD10	= 0,
	GPD11_AF_PD11	= 0,
	GPD12_AF_PD12	= 0,
	GPD13_AF_PD13	= 0,
	GPD14_AF_PD14	= 0,
	GPD15_AF_PD15	= 0,
	GPD2_AF_PD2	= 0,
	GPD3_AF_PD3	= 0,
	GPD4_AF_PD4	= 0,
	GPD5_AF_PD5	= 0,
	GPD6_AF_PD6	= 0,
	GPD7_AF_PD7	= 0,
	GPD8_AF_PD8	= 0,
	GPD9_AF_PD9	= 0,
	GPE0_AF_PE0	= 0,
	GPE1_AF_PE1	= 0,
	GPE12_AF_PE12	= 0,
	GPE13_AF_PE13	= 0,
	GPE14_AF_PE14	= 0,
	GPE15_AF_PE15	= 0,
	GPE2_AF_PE2	= 0,
	GPE3_AF_PE3	= 0,
	GPE8_AF_PE8	= 0,
	GPE9_AF_PE9	= 0,
	I2C0_SCL_AF_PB10	= 2,
	I2C0_SCL_AF_PC4	= 2,
	I2C0_SCL_AF_PC8	= 2,
	I2C0_SDA_AF_PB11	= 2,
	I2C0_SDA_AF_PC5	= 2,
	I2C0_SDA_AF_PC9	= 2,
	I2C1_SCL_AF_PB0	= 1,
	I2C1_SCL_AF_PC10	= 2,
	I2C1_SDA_AF_PB1	= 1,
	I2C1_SDA_AF_PC11	= 2,
	ICKO_AF_PC0	= 1,
	IR_OUT_AF_PB15	= 1,
	IR_OUT_AF_PC12	= 2,
	IR_OUT_AF_PD15	= 3,
	MA0_AF_PA0	= 8,
	MA1_AF_PA1	= 8,
	MA10_AF_PA10	= 8,
	MA11_AF_PA11	= 8,
	MA12_AF_PA12	= 8,
	MA13_AF_PA13	= 8,
	MA14_AF_PA14	= 8,
	MA15_AF_PA15	= 8,
	MA15_AF_PB0	= 8,
	MA2_AF_PA2	= 8,
	MA3_AF_PA3	= 8,
	MA4_AF_PA4	= 8,
	MA5_AF_PA5	= 8,
	MA6_AF_PA6	= 8,
	MA7_AF_PA7	= 8,
	MA8_AF_PA8	= 8,
	MA9_AF_PA9	= 8,
	MAD0_AF_PB8	= 8,
	MAD0_AF_PD7	= 9,
	MAD1_AF_PB10	= 9,
	MAD1_AF_PB9	= 8,
	MAD1_AF_PD10	= 9,
	MAD10_AF_PB13	= 9,
	MAD10_AF_PB6	= 9,
	MAD10_AF_PC3	= 8,
	MAD11_AF_PB15	= 9,
	MAD11_AF_PC8	= 8,
	MAD12_AF_PC2	= 9,
	MAD12_AF_PC9	= 8,
	MAD13_AF_PC10	= 8,
	MAD13_AF_PC8	= 9,
	MAD14_AF_PC10	= 9,
	MAD14_AF_PC11	= 8,
	MAD15_AF_PC12	= 8,
	MAD2_AF_PB10	= 8,
	MAD2_AF_PB12	= 9,
	MAD2_AF_PD9	= 9,
	MAD3_AF_PB11	= 8,
	MAD3_AF_PB14	= 9,
	MAD3_AF_PD8	= 9,
	MAD4_AF_PB12	= 8,
	MAD4_AF_PC1	= 9,
	MAD4_AF_PD2	= 9,
	MAD5_AF_PB13	= 8,
	MAD5_AF_PC3	= 9,
	MAD5_AF_PD5	= 9,
	MAD6_AF_PB14	= 8,
	MAD6_AF_PC9	= 9,
	MAD6_AF_PD4	= 9,
	MAD7_AF_PB15	= 8,
	MAD7_AF_PC11	= 9,
	MAD7_AF_PD3	= 9,
	MAD8_AF_PB4	= 9,
	MAD8_AF_PB9	= 9,
	MAD8_AF_PC1	= 8,
	MAD9_AF_PB11	= 9,
	MAD9_AF_PB5	= 9,
	MAD9_AF_PC2	= 8,
	MALE_AF_PB4	= 8,
	MALE_AF_PC6	= 9,
	MALE_AF_PE0	= 8,
	MALE_AF_PE15	= 8,
	MALE2_AF_PB7	= 9,
	MALE2_AF_PD12	= 9,
	MALE2_AF_PE14	= 8,
	MALE2_AF_PE3	= 9,
	MBW0_AF_PC7	= 8,
	MBW0_AF_PE12	= 8,
	MBW1_AF_PC6	= 8,
	MBW1_AF_PE13	= 8,
	MCE_AF_PB7	= 8,
	MCE_AF_PC7	= 9,
	MCE_AF_PD13	= 9,
	MCE_AF_PE3	= 8,
	MCLK_AF_PC0	= 8,
	MCLK_AF_PD0	= 9,
	MOE_AF_PB5	= 8,
	MOE_AF_PD14	= 9,
	MOE_AF_PE1	= 8,
	MOE_AF_PE9	= 9,
	MWE_AF_PB6	= 8,
	MWE_AF_PC0	= 9,
	MWE_AF_PD11	= 9,
	MWE_AF_PE2	= 8,
	OBM_I0_AF_PD0	= 1,
	OBM_I0_AF_PE0	= 1,
	OBM_I0_AF_PE8	= 2,
	OBM_I1_AF_PD1	= 1,
	OBM_I1_AF_PE1	= 1,
	OBM_I1_AF_PE9	= 2,
	OBM_P1_AF_PC3	= 1,
	OBM_P1_AF_PD13	= 3,
	OBM_P1_AF_PE3	= 1,
	RSTN_AF_PC6	= 1,
	RTC_OUT_AF_PB8	= 2,
	RTC_OUT_AF_PC7	= 2,
	RTC_OUT_AF_PE14	= 1,
	RTC_TS_AF_PB9	= 2,
	RTC_TS_AF_PC6	= 2,
	RTC_TS_AF_PE15	= 1,
	SPI0_CLK_AF_PB2	= 2,
	SPI0_CLK_AF_PD1	= 7,
	SPI0_CLK_AF_PD12	= 5,
	SPI0_D2_AF_PB5	= 2,
	SPI0_D2_AF_PD4	= 7,
	SPI0_D3_AF_PB4	= 2,
	SPI0_D3_AF_PD3	= 7,
	SPI0_D4_AF_PD7	= 7,
	SPI0_D5_AF_PD10	= 7,
	SPI0_D6_AF_PD9	= 7,
	SPI0_D7_AF_PD8	= 7,
	SPI0_MISO_AF_PB1	= 2,
	SPI0_MISO_AF_PD5	= 7,
	SPI0_MOSI_AF_PB3	= 2,
	SPI0_MOSI_AF_PD2	= 7,
	SPI0_NSS_AF_PB0	= 2,
	SPI0_NSS_AF_PD11	= 7,
	SPI0_NSS_AF_PD6	= 7,
	SPI0_NSSI_AF_PB6	= 2,
	SPI0_NSSI_AF_PD6	= 5,
	SWCLK_AF_PC4	= 1,
	SWDIO_AF_PC5	= 1,
	TM00_CKO_AF_PB0	= 4,
	TM00_CKO_AF_PC0	= 2,
	TM00_CKO_AF_PD12	= 4,
	TM00_CKO_AF_PD2	= 2,
	TM00_CKO_AF_PD7	= 1,
	TM00_ETR_AF_PB13	= 2,
	TM00_ETR_AF_PD14	= 4,
	TM00_ETR_AF_PD5	= 1,
	TM00_TRGO_AF_PB14	= 2,
	TM00_TRGO_AF_PD13	= 4,
	TM00_TRGO_AF_PD4	= 1,
	TM01_CKO_AF_PB2	= 3,
	TM01_CKO_AF_PB4	= 1,
	TM01_CKO_AF_PC1	= 2,
	TM01_CKO_AF_PD3	= 2,
	TM01_CKO_AF_PE12	= 4,
	TM01_ETR_AF_PB0	= 3,
	TM01_ETR_AF_PD7	= 2,
	TM01_ETR_AF_PE14	= 4,
	TM01_TRGO_AF_PB1	= 3,
	TM01_TRGO_AF_PD4	= 2,
	TM01_TRGO_AF_PE13	= 4,
	TM10_CKO_AF_PB1	= 4,
	TM10_CKO_AF_PC14	= 5,
	TM10_CKO_AF_PC2	= 2,
	TM10_CKO_AF_PD0	= 2,
	TM10_ETR_AF_PC13	= 5,
	TM10_TRGO_AF_PC12	= 5,
	TM16_CKO_AF_PB2	= 5,
	TM16_CKO_AF_PB5	= 1,
	TM16_CKO_AF_PC3	= 2,
	TM16_CKO_AF_PD1	= 2,
	TM16_CKO_AF_PE12	= 5,
	TM16_ETR_AF_PB0	= 5,
	TM16_ETR_AF_PE14	= 5,
	TM16_TRGO_AF_PB1	= 5,
	TM16_TRGO_AF_PE13	= 5,
	TM20_CKO_AF_PD0	= 5,
	TM20_CKO_AF_PD2	= 5,
	TM20_CKO_AF_PE8	= 6,
	TM20_ETR_AF_PB13	= 5,
	TM20_ETR_AF_PB6	= 5,
	TM20_ETR_AF_PC6	= 5,
	TM20_IC0_AF_PB4	= 5,
	TM20_IC0_AF_PD14	= 6,
	TM20_IC1_AF_PB5	= 5,
	TM20_IC1_AF_PD15	= 6,
	TM20_OC00_AF_PC0	= 5,
	TM20_OC00_AF_PE0	= 6,
	TM20_OC01_AF_PB8	= 5,
	TM20_OC01_AF_PE1	= 6,
	TM20_OC02_AF_PB9	= 5,
	TM20_OC02_AF_PE2	= 6,
	TM20_OC0H_AF_PC8	= 5,
	TM20_OC0H_AF_PD12	= 6,
	TM20_OC0N_AF_PC1	= 5,
	TM20_OC0N_AF_PE3	= 6,
	TM20_OC10_AF_PC2	= 5,
	TM20_OC10_AF_PE12	= 6,
	TM20_OC11_AF_PB10	= 5,
	TM20_OC11_AF_PE13	= 6,
	TM20_OC12_AF_PB11	= 5,
	TM20_OC12_AF_PE14	= 6,
	TM20_OC1H_AF_PC9	= 5,
	TM20_OC1H_AF_PD13	= 6,
	TM20_OC1N_AF_PC3	= 5,
	TM20_OC1N_AF_PE15	= 6,
	TM20_TRGO_AF_PB14	= 5,
	TM20_TRGO_AF_PB7	= 5,
	TM20_TRGO_AF_PE9	= 6,
	TM26_CKO_AF_PD1	= 5,
	TM26_CKO_AF_PD3	= 6,
	TM26_CKO_AF_PE8	= 7,
	TM26_ETR_AF_PB5	= 3,
	TM26_ETR_AF_PC13	= 6,
	TM26_ETR_AF_PC6	= 6,
	TM26_IC0_AF_PB0	= 6,
	TM26_IC0_AF_PD14	= 7,
	TM26_IC1_AF_PB1	= 6,
	TM26_IC1_AF_PD15	= 7,
	TM26_OC00_AF_PD2	= 4,
	TM26_OC00_AF_PD4	= 6,
	TM26_OC00_AF_PE0	= 7,
	TM26_OC01_AF_PD5	= 6,
	TM26_OC01_AF_PE1	= 7,
	TM26_OC02_AF_PD6	= 6,
	TM26_OC02_AF_PE2	= 7,
	TM26_OC0H_AF_PB2	= 6,
	TM26_OC0H_AF_PD12	= 7,
	TM26_OC0N_AF_PD7	= 6,
	TM26_OC0N_AF_PE3	= 7,
	TM26_OC10_AF_PD8	= 6,
	TM26_OC10_AF_PE12	= 7,
	TM26_OC11_AF_PD9	= 6,
	TM26_OC11_AF_PE13	= 7,
	TM26_OC12_AF_PD10	= 6,
	TM26_OC12_AF_PE14	= 7,
	TM26_OC1H_AF_PB3	= 6,
	TM26_OC1H_AF_PD13	= 7,
	TM26_OC1N_AF_PD11	= 6,
	TM26_OC1N_AF_PE15	= 7,
	TM26_TRGO_AF_PB4	= 3,
	TM26_TRGO_AF_PC14	= 6,
	TM26_TRGO_AF_PE9	= 7,
	TM36_BK0_AF_PB14	= 6,
	TM36_CKO_AF_PD2	= 6,
	TM36_CKO_AF_PE8	= 5,
	TM36_ETR_AF_PB13	= 6,
	TM36_ETR_AF_PE15	= 5,
	TM36_IC0_AF_PB4	= 6,
	TM36_IC1_AF_PB5	= 6,
	TM36_IC2_AF_PB6	= 6,
	TM36_IC3_AF_PB7	= 6,
	TM36_OC00_AF_PC0	= 6,
	TM36_OC01_AF_PB8	= 6,
	TM36_OC02_AF_PB9	= 6,
	TM36_OC0H_AF_PC8	= 6,
	TM36_OC0N_AF_PC1	= 6,
	TM36_OC10_AF_PC2	= 6,
	TM36_OC11_AF_PB10	= 6,
	TM36_OC12_AF_PB11	= 6,
	TM36_OC1H_AF_PC9	= 6,
	TM36_OC1N_AF_PC3	= 6,
	TM36_OC2_AF_PD0	= 6,
	TM36_OC2H_AF_PC10	= 6,
	TM36_OC2N_AF_PD1	= 6,
	TM36_OC3_AF_PC12	= 6,
	TM36_OC3H_AF_PC11	= 6,
	TM36_TRGO_AF_PC7	= 6,
	TM36_TRGO_AF_PE9	= 5,
	URT0_BRO_AF_PB6	= 3,
	URT0_BRO_AF_PC8	= 3,
	URT0_CLK_AF_PC0	= 3,
	URT0_CLK_AF_PC3	= 3,
	URT0_CLK_AF_PD0	= 3,
	URT0_CLK_AF_PD1	= 3,
	URT0_CTS_AF_PB13	= 3,
	URT0_CTS_AF_PC13	= 3,
	URT0_DE_AF_PB11	= 3,
	URT0_DE_AF_PC7	= 3,
	URT0_NSS_AF_PB10	= 3,
	URT0_NSS_AF_PC6	= 3,
	URT0_RTS_AF_PB14	= 3,
	URT0_RTS_AF_PC14	= 3,
	URT0_RX_AF_PB9	= 3,
	URT0_RX_AF_PC11	= 3,
	URT0_RX_AF_PC4	= 3,
	URT0_RX_AF_PE1	= 3,
	URT0_TMO_AF_PB7	= 3,
	URT0_TMO_AF_PC9	= 3,
	URT0_TX_AF_PB8	= 3,
	URT0_TX_AF_PC10	= 3,
	URT0_TX_AF_PC5	= 3,
	URT0_TX_AF_PE0	= 3,
	URT1_BRO_AF_PD10	= 3,
	URT1_CLK_AF_PC1	= 4,
	URT1_CLK_AF_PC3	= 4,
	URT1_CLK_AF_PD2	= 3,
	URT1_CLK_AF_PD3	= 3,
	URT1_CTS_AF_PD9	= 3,
	URT1_DE_AF_PD7	= 3,
	URT1_NSS_AF_PD6	= 3,
	URT1_RTS_AF_PD8	= 3,
	URT1_RX_AF_PC4	= 4,
	URT1_RX_AF_PC9	= 4,
	URT1_RX_AF_PD5	= 3,
	URT1_RX_AF_PE3	= 3,
	URT1_TMO_AF_PD11	= 3,
	URT1_TX_AF_PC5	= 4,
	URT1_TX_AF_PC8	= 4,
	URT1_TX_AF_PD4	= 3,
	URT1_TX_AF_PE2	= 3,
	URT2_BRO_AF_PB8	= 4,
	URT2_CLK_AF_PB4	= 4,
	URT2_CLK_AF_PC0	= 4,
	URT2_CLK_AF_PC2	= 4,
	URT2_CTS_AF_PB6	= 4,
	URT2_DE_AF_PB10	= 4,
	URT2_NSS_AF_PB5	= 4,
	URT2_RTS_AF_PB7	= 4,
	URT2_RX_AF_PB3	= 4,
	URT2_RX_AF_PC11	= 4,
	URT2_RX_AF_PC13	= 4,
	URT2_RX_AF_PE9	= 3,
	URT2_TMO_AF_PB9	= 4,
	URT2_TX_AF_PB2	= 4,
	URT2_TX_AF_PC10	= 4,
	URT2_TX_AF_PC14	= 4,
	URT2_TX_AF_PE8	= 3,
	URT3_BRO_AF_PD10	= 4,
	URT3_CLK_AF_PD3	= 4,
	URT3_CTS_AF_PD5	= 4,
	URT3_DE_AF_PD6	= 4,
	URT3_NSS_AF_PD7	= 4,
	URT3_RTS_AF_PD4	= 4,
	URT3_RX_AF_PB13	= 4,
	URT3_RX_AF_PD9	= 4,
	URT3_RX_AF_PE13	= 3,
	URT3_TMO_AF_PD11	= 4,
	URT3_TX_AF_PB14	= 4,
	URT3_TX_AF_PD8	= 4,
	URT3_TX_AF_PE12	= 3,
	XIN_AF_PC13	= 1,
	XOUT_AF_PC14	= 1,

}PINX_AF_TypeDef;
#endif


#if defined(MG32F02A032)
/*! @enum   PINX_AF_TypeDef
    @brief  Pin IO AF control options for MG32F02A032
*/ 
typedef enum
{
	PA0_AF_GPA0	= 0,
	PA1_AF_GPA1	= 0,
	PA2_AF_GPA2	= 0,
	PA3_AF_GPA3	= 0,
	PA8_AF_GPA8	= 0,
	PA9_AF_GPA9	= 0,
	PA10_AF_GPA10	= 0,
	PA11_AF_GPA11	= 0,
	PA12_AF_GPA12	= 0,
	PA13_AF_GPA13	= 0,
	PA14_AF_GPA14	= 0,
	PA15_AF_GPA15	= 0,
	PA13_AF_CPU_TXEV	= 1,
	PA14_AF_CPU_RXEV	= 1,
	PA15_AF_CPU_NMI	= 1,
	PA14_AF_OBM_I0	= 2,
	PA15_AF_OBM_I1	= 2,
	PA13_AF_URT0_BRO	= 3,
	PA14_AF_URT0_TMO	= 3,
	PA15_AF_URT0_DE	= 3,
	PA12_AF_URT1_BRO	= 4,
	PA13_AF_URT1_TMO	= 4,
	PA14_AF_URT1_CTS	= 4,
	PA15_AF_URT1_RTS	= 4,
	PA12_AF_TM10_ETR	= 5,
	PA13_AF_TM10_TRGO	= 5,
	PA14_AF_TM16_ETR	= 5,
	PA15_AF_TM16_TRGO	= 5,
	PA12_AF_TM36_IC0	= 6,
	PA13_AF_TM36_IC1	= 6,
	PA14_AF_TM36_IC2	= 6,
	PA15_AF_TM36_IC3	= 6,
	PB0_AF_GPB0	= 0,
	PB1_AF_GPB1	= 0,
	PB2_AF_GPB2	= 0,
	PB3_AF_GPB3	= 0,
	PB8_AF_GPB8	= 0,
	PB9_AF_GPB9	= 0,
	PB10_AF_GPB10	= 0,
	PB11_AF_GPB11	= 0,
	PB13_AF_GPB13	= 0,
	PB14_AF_GPB14	= 0,
	PB2_AF_ADC0_TRG	= 1,
	PB3_AF_ADC0_OUT	= 1,
	PB8_AF_CMP0_P0	= 1,
	PB9_AF_CMP1_P0	= 1,
	PB14_AF_DMA_TRG0	= 1,
	PB0_AF_SPI0_NSS	= 2,
	PB1_AF_SPI0_MISO	= 2,
	PB2_AF_SPI0_CLK	= 2,
	PB3_AF_SPI0_MOSI	= 2,
	PB8_AF_RTC_OUT	= 2,
	PB9_AF_RTC_TS	= 2,
	PB10_AF_I2C0_SCL	= 2,
	PB11_AF_I2C0_SDA	= 2,
	PB13_AF_TM00_ETR	= 2,
	PB14_AF_TM00_TRGO	= 2,
	PB0_AF_TM01_ETR	= 3,
	PB1_AF_TM01_TRGO	= 3,
	PB2_AF_TM01_CKO	= 3,
	PB8_AF_URT0_TX	= 3,
	PB9_AF_URT0_RX	= 3,
	PB10_AF_URT0_NSS	= 3,
	PB11_AF_URT0_DE	= 3,
	PB13_AF_URT0_CTS	= 3,
	PB14_AF_URT0_RTS	= 3,
	PB0_AF_TM00_CKO	= 4,
	PB1_AF_TM10_CKO	= 4,
	PB11_AF_IR_OUT	= 4,
	PB0_AF_TM16_ETR	= 5,
	PB1_AF_TM16_TRGO	= 5,
	PB2_AF_TM16_CKO	= 5,
	PB3_AF_TM36_CKO	= 5,
	PB8_AF_TM36_OC01	= 6,
	PB9_AF_TM36_OC02	= 6,
	PB10_AF_TM36_OC11	= 6,
	PB11_AF_TM36_OC12	= 6,
	PB13_AF_TM36_ETR	= 6,
	PB14_AF_TM36_BK0	= 6,
	PB0_AF_TM36_ETR	= 7,
	PB1_AF_TM36_TRGO	= 7,
	PB2_AF_I2C0_SDA	= 7,
	PB3_AF_I2C0_SCL	= 7,
	PB8_AF_SPI0_D3	= 7,
	PB9_AF_SPI0_D2	= 7,
	PB10_AF_URT1_TX	= 7,
	PB11_AF_URT1_RX	= 7,
	PB2_AF_URT0_TX	= 10,
	PB3_AF_URT0_RX	= 10,
	PB8_AF_OBM_P0	= 10,
	PB9_AF_OBM_P1	= 10,
	PB10_AF_SPI0_NSSI	= 10,
	PB11_AF_DMA_TRG0	= 10,
	PC0_AF_GPC0	= 0,
	PC1_AF_GPC1	= 0,
	PC2_AF_GPC2	= 0,
	PC3_AF_GPC3	= 0,
	PC4_AF_GPC4	= 0,
	PC5_AF_GPC5	= 0,
	PC6_AF_GPC6	= 0,
	PC8_AF_GPC8	= 0,
	PC9_AF_GPC9	= 0,
	PC10_AF_GPC10	= 0,
	PC11_AF_GPC11	= 0,
	PC12_AF_GPC12	= 0,
	PC13_AF_GPC13	= 0,
	PC14_AF_GPC14	= 0,
	PC0_AF_ICKO	= 1,
	PC1_AF_ADC0_TRG	= 1,
	PC2_AF_ADC0_OUT	= 1,
	PC3_AF_OBM_P1	= 1,
	PC4_AF_SWCLK	= 1,
	PC5_AF_SWDIO	= 1,
	PC6_AF_RSTN	= 1,
	PC8_AF_ADC0_OUT	= 1,
	PC9_AF_CMP0_P0	= 1,
	PC10_AF_CMP1_P0	= 1,
	PC13_AF_XIN	= 1,
	PC14_AF_XOUT	= 1,
	PC0_AF_TM00_CKO	= 2,
	PC1_AF_TM01_CKO	= 2,
	PC2_AF_TM10_CKO	= 2,
	PC3_AF_TM16_CKO	= 2,
	PC4_AF_I2C0_SCL	= 2,
	PC5_AF_I2C0_SDA	= 2,
	PC6_AF_RTC_TS	= 2,
	PC8_AF_I2C0_SCL	= 2,
	PC9_AF_I2C0_SDA	= 2,
	PC12_AF_IR_OUT	= 2,
	PC13_AF_URT1_NSS	= 2,
	PC14_AF_URT1_TMO	= 2,
	PC0_AF_URT0_CLK	= 3,
	PC1_AF_TM36_IC0	= 3,
	PC2_AF_OBM_P0	= 3,
	PC3_AF_URT0_CLK	= 3,
	PC4_AF_URT0_RX	= 3,
	PC5_AF_URT0_TX	= 3,
	PC6_AF_URT0_NSS	= 3,
	PC8_AF_URT0_BRO	= 3,
	PC9_AF_URT0_TMO	= 3,
	PC10_AF_URT0_TX	= 3,
	PC11_AF_URT0_RX	= 3,
	PC13_AF_URT0_CTS	= 3,
	PC14_AF_URT0_RTS	= 3,
	PC1_AF_URT1_CLK	= 4,
	PC3_AF_URT1_CLK	= 4,
	PC4_AF_URT1_RX	= 4,
	PC5_AF_URT1_TX	= 4,
	PC6_AF_URT1_NSS	= 4,
	PC8_AF_URT1_TX	= 4,
	PC9_AF_URT1_RX	= 4,
	PC12_AF_URT1_DE	= 4,
	PC10_AF_URT1_TX	= 5,
	PC11_AF_URT1_RX	= 5,
	PC12_AF_TM10_TRGO	= 5,
	PC13_AF_TM10_ETR	= 5,
	PC14_AF_TM10_CKO	= 5,
	PC0_AF_TM36_OC00	= 6,
	PC1_AF_TM36_OC0N	= 6,
	PC2_AF_TM36_OC10	= 6,
	PC3_AF_TM36_OC1N	= 6,
	PC4_AF_TM36_OC2	= 6,
	PC5_AF_TM36_OC3	= 6,
	PC8_AF_TM36_OC0H	= 6,
	PC9_AF_TM36_OC1H	= 6,
	PC10_AF_TM36_OC2H	= 6,
	PC11_AF_TM36_OC3H	= 6,
	PC12_AF_TM36_OC3	= 6,
	PC0_AF_I2C0_SCL	= 7,
	PC1_AF_I2C0_SDA	= 7,
	PC8_AF_TM36_OC0N	= 7,
	PC9_AF_TM36_OC1N	= 7,
	PC10_AF_TM36_OC2N	= 7,
	PC13_AF_TM36_OC00	= 7,
	PC14_AF_TM36_OC10	= 7,
	PC0_AF_URT0_TX	= 10,
	PC1_AF_URT0_RX	= 10,
	PD0_AF_GPD0	= 0,
	PD1_AF_GPD1	= 0,
	PD2_AF_GPD2	= 0,
	PD3_AF_GPD3	= 0,
	PD7_AF_GPD7	= 0,
	PD8_AF_GPD8	= 0,
	PD9_AF_GPD9	= 0,
	PD10_AF_GPD10	= 0,
	PD0_AF_OBM_I0	= 1,
	PD1_AF_OBM_I1	= 1,
	PD7_AF_TM00_CKO	= 1,
	PD8_AF_CPU_TXEV	= 1,
	PD9_AF_CPU_RXEV	= 1,
	PD10_AF_CPU_NMI	= 1,
	PD0_AF_TM10_CKO	= 2,
	PD1_AF_TM16_CKO	= 2,
	PD2_AF_TM00_CKO	= 2,
	PD3_AF_TM01_CKO	= 2,
	PD7_AF_TM01_ETR	= 2,
	PD8_AF_TM01_TRGO	= 2,
	PD9_AF_TM00_TRGO	= 2,
	PD10_AF_TM00_ETR	= 2,
	PD0_AF_URT0_CLK	= 3,
	PD1_AF_URT0_CLK	= 3,
	PD2_AF_URT1_CLK	= 3,
	PD3_AF_URT1_CLK	= 3,
	PD7_AF_URT1_DE	= 3,
	PD8_AF_URT1_RTS	= 3,
	PD9_AF_URT1_CTS	= 3,
	PD10_AF_URT1_BRO	= 3,
	PD7_AF_SPI0_MISO	= 5,
	PD8_AF_SPI0_D2	= 5,
	PD9_AF_SPI0_NSSI	= 5,
	PD10_AF_RTC_OUT	= 5,
	PD0_AF_TM36_OC2	= 6,
	PD1_AF_TM36_OC2N	= 6,
	PD2_AF_TM36_CKO	= 6,
	PD0_AF_SPI0_NSS	= 7,
	PD1_AF_SPI0_CLK	= 7,
	PD2_AF_SPI0_MOSI	= 7,
	PD3_AF_SPI0_D3	= 7,
	PD3_AF_TM36_TRGO	= 10,
	PD7_AF_TM36_IC0	= 10,
	PD8_AF_TM36_IC1	= 10,
	PD9_AF_TM36_IC2	= 10,
	PD10_AF_TM36_IC3	= 10,

	ADC0_OUT_AF_PB3	= 1,
	ADC0_OUT_AF_PC2	= 1,
	ADC0_OUT_AF_PC8	= 1,
	ADC0_TRG_AF_PB2	= 1,
	ADC0_TRG_AF_PC1	= 1,
	CMP0_P0_AF_PB8	= 1,
	CMP0_P0_AF_PC9	= 1,
	CMP1_P0_AF_PB9	= 1,
	CMP1_P0_AF_PC10	= 1,
	CPU_NMI_AF_PA15	= 1,
	CPU_NMI_AF_PD10	= 1,
	CPU_RXEV_AF_PA14	= 1,
	CPU_RXEV_AF_PD9	= 1,
	CPU_TXEV_AF_PA13	= 1,
	CPU_TXEV_AF_PD8	= 1,
	DMA_TRG0_AF_PB11	= 10,
	DMA_TRG0_AF_PB14	= 1,
	GPA0_AF_PA0	= 0,
	GPA1_AF_PA1	= 0,
	GPA10_AF_PA10	= 0,
	GPA11_AF_PA11	= 0,
	GPA12_AF_PA12	= 0,
	GPA13_AF_PA13	= 0,
	GPA14_AF_PA14	= 0,
	GPA15_AF_PA15	= 0,
	GPA2_AF_PA2	= 0,
	GPA3_AF_PA3	= 0,
	GPA8_AF_PA8	= 0,
	GPA9_AF_PA9	= 0,
	GPB0_AF_PB0	= 0,
	GPB1_AF_PB1	= 0,
	GPB10_AF_PB10	= 0,
	GPB11_AF_PB11	= 0,
	GPB13_AF_PB13	= 0,
	GPB14_AF_PB14	= 0,
	GPB2_AF_PB2	= 0,
	GPB3_AF_PB3	= 0,
	GPB8_AF_PB8	= 0,
	GPB9_AF_PB9	= 0,
	GPC0_AF_PC0	= 0,
	GPC1_AF_PC1	= 0,
	GPC10_AF_PC10	= 0,
	GPC11_AF_PC11	= 0,
	GPC12_AF_PC12	= 0,
	GPC13_AF_PC13	= 0,
	GPC14_AF_PC14	= 0,
	GPC2_AF_PC2	= 0,
	GPC3_AF_PC3	= 0,
	GPC4_AF_PC4	= 0,
	GPC5_AF_PC5	= 0,
	GPC6_AF_PC6	= 0,
	GPC8_AF_PC8	= 0,
	GPC9_AF_PC9	= 0,
	GPD0_AF_PD0	= 0,
	GPD1_AF_PD1	= 0,
	GPD10_AF_PD10	= 0,
	GPD2_AF_PD2	= 0,
	GPD3_AF_PD3	= 0,
	GPD7_AF_PD7	= 0,
	GPD8_AF_PD8	= 0,
	GPD9_AF_PD9	= 0,
	I2C0_SCL_AF_PB10	= 2,
	I2C0_SCL_AF_PB3	= 7,
	I2C0_SCL_AF_PC0	= 7,
	I2C0_SCL_AF_PC4	= 2,
	I2C0_SCL_AF_PC8	= 2,
	I2C0_SDA_AF_PB11	= 2,
	I2C0_SDA_AF_PB2	= 7,
	I2C0_SDA_AF_PC1	= 7,
	I2C0_SDA_AF_PC5	= 2,
	I2C0_SDA_AF_PC9	= 2,
	ICKO_AF_PC0	= 1,
	IR_OUT_AF_PB11	= 4,
	IR_OUT_AF_PC12	= 2,
	OBM_I0_AF_PA14	= 2,
	OBM_I0_AF_PD0	= 1,
	OBM_I1_AF_PA15	= 2,
	OBM_I1_AF_PD1	= 1,
	OBM_P0_AF_PB8	= 10,
	OBM_P0_AF_PC2	= 3,
	OBM_P1_AF_PB9	= 10,
	OBM_P1_AF_PC3	= 1,
	RSTN_AF_PC6	= 1,
	RTC_OUT_AF_PB8	= 2,
	RTC_OUT_AF_PD10	= 5,
	RTC_TS_AF_PB9	= 2,
	RTC_TS_AF_PC6	= 2,
	SPI0_CLK_AF_PB2	= 2,
	SPI0_CLK_AF_PD1	= 7,
	SPI0_D2_AF_PB9	= 7,
	SPI0_D2_AF_PD8	= 5,
	SPI0_D3_AF_PB8	= 7,
	SPI0_D3_AF_PD3	= 7,
	SPI0_MISO_AF_PB1	= 2,
	SPI0_MISO_AF_PD7	= 5,
	SPI0_MOSI_AF_PB3	= 2,
	SPI0_MOSI_AF_PD2	= 7,
	SPI0_NSS_AF_PB0	= 2,
	SPI0_NSS_AF_PD0	= 7,
	SPI0_NSSI_AF_PB10	= 10,
	SPI0_NSSI_AF_PD9	= 5,
	SWCLK_AF_PC4	= 1,
	SWDIO_AF_PC5	= 1,
	TM00_CKO_AF_PB0	= 4,
	TM00_CKO_AF_PC0	= 2,
	TM00_CKO_AF_PD2	= 2,
	TM00_CKO_AF_PD7	= 1,
	TM00_ETR_AF_PB13	= 2,
	TM00_ETR_AF_PD10	= 2,
	TM00_TRGO_AF_PB14	= 2,
	TM00_TRGO_AF_PD9	= 2,
	TM01_CKO_AF_PB2	= 3,
	TM01_CKO_AF_PC1	= 2,
	TM01_CKO_AF_PD3	= 2,
	TM01_ETR_AF_PB0	= 3,
	TM01_ETR_AF_PD7	= 2,
	TM01_TRGO_AF_PB1	= 3,
	TM01_TRGO_AF_PD8	= 2,
	TM10_CKO_AF_PB1	= 4,
	TM10_CKO_AF_PC14	= 5,
	TM10_CKO_AF_PC2	= 2,
	TM10_CKO_AF_PD0	= 2,
	TM10_ETR_AF_PA12	= 5,
	TM10_ETR_AF_PC13	= 5,
	TM10_TRGO_AF_PA13	= 5,
	TM10_TRGO_AF_PC12	= 5,
	TM16_CKO_AF_PB2	= 5,
	TM16_CKO_AF_PC3	= 2,
	TM16_CKO_AF_PD1	= 2,
	TM16_ETR_AF_PA14	= 5,
	TM16_ETR_AF_PB0	= 5,
	TM16_TRGO_AF_PA15	= 5,
	TM16_TRGO_AF_PB1	= 5,
	TM36_BK0_AF_PB14	= 6,
	TM36_CKO_AF_PB3	= 5,
	TM36_CKO_AF_PD2	= 6,
	TM36_ETR_AF_PB0	= 7,
	TM36_ETR_AF_PB13	= 6,
	TM36_IC0_AF_PA12	= 6,
	TM36_IC0_AF_PC1	= 3,
	TM36_IC0_AF_PD7	= 10,
	TM36_IC1_AF_PA13	= 6,
	TM36_IC1_AF_PD8	= 10,
	TM36_IC2_AF_PA14	= 6,
	TM36_IC2_AF_PD9	= 10,
	TM36_IC3_AF_PA15	= 6,
	TM36_IC3_AF_PD10	= 10,
	TM36_OC00_AF_PC0	= 6,
	TM36_OC00_AF_PC13	= 7,
	TM36_OC00_AF_PD0	= 7,
	TM36_OC01_AF_PB8	= 6,
	TM36_OC02_AF_PB9	= 6,
	TM36_OC0H_AF_PC8	= 6,
	TM36_OC0N_AF_PC1	= 6,
	TM36_OC0N_AF_PC8	= 7,
	TM36_OC10_AF_PC14	= 7,
	TM36_OC10_AF_PC2	= 6,
	TM36_OC10_AF_PD1	= 7,
	TM36_OC11_AF_PB10	= 6,
	TM36_OC12_AF_PB11	= 6,
	TM36_OC1H_AF_PC9	= 6,
	TM36_OC1N_AF_PC3	= 6,
	TM36_OC1N_AF_PC9	= 7,
	TM36_OC2_AF_PC4	= 6,
	TM36_OC2_AF_PD0	= 6,
	TM36_OC2H_AF_PC10	= 6,
	TM36_OC2N_AF_PC10	= 7,
	TM36_OC2N_AF_PD1	= 6,
	TM36_OC3_AF_PC12	= 6,
	TM36_OC3_AF_PC5	= 6,
	TM36_OC3H_AF_PC11	= 6,
	TM36_TRGO_AF_PB1	= 7,
	TM36_TRGO_AF_PD3	= 10,
	URT0_BRO_AF_PA13	= 3,
	URT0_BRO_AF_PC8	= 3,
	URT0_CLK_AF_PC0	= 3,
	URT0_CLK_AF_PC3	= 3,
	URT0_CLK_AF_PD0	= 3,
	URT0_CLK_AF_PD1	= 3,
	URT0_CTS_AF_PB13	= 3,
	URT0_CTS_AF_PC13	= 3,
	URT0_DE_AF_PA15	= 3,
	URT0_DE_AF_PB11	= 3,
	URT0_NSS_AF_PB10	= 3,
	URT0_NSS_AF_PC6	= 3,
	URT0_RTS_AF_PB14	= 3,
	URT0_RTS_AF_PC14	= 3,
	URT0_RX_AF_PB3	= 10,
	URT0_RX_AF_PB9	= 3,
	URT0_RX_AF_PC1	= 10,
	URT0_RX_AF_PC11	= 3,
	URT0_RX_AF_PC4	= 3,
	URT0_TMO_AF_PA14	= 3,
	URT0_TMO_AF_PC9	= 3,
	URT0_TX_AF_PB2	= 10,
	URT0_TX_AF_PB8	= 3,
	URT0_TX_AF_PC0	= 10,
	URT0_TX_AF_PC10	= 3,
	URT0_TX_AF_PC5	= 3,
	URT1_BRO_AF_PA12	= 4,
	URT1_BRO_AF_PD10	= 3,
	URT1_CLK_AF_PC1	= 4,
	URT1_CLK_AF_PC3	= 4,
	URT1_CLK_AF_PD2	= 3,
	URT1_CLK_AF_PD3	= 3,
	URT1_CTS_AF_PA14	= 4,
	URT1_CTS_AF_PD9	= 3,
	URT1_DE_AF_PC12	= 4,
	URT1_DE_AF_PD7	= 3,
	URT1_NSS_AF_PC13	= 2,
	URT1_NSS_AF_PC6	= 4,
	URT1_RTS_AF_PA15	= 4,
	URT1_RTS_AF_PD8	= 3,
	URT1_RX_AF_PB11	= 7,
	URT1_RX_AF_PC11	= 5,
	URT1_RX_AF_PC4	= 4,
	URT1_RX_AF_PC9	= 4,
	URT1_TMO_AF_PA13	= 4,
	URT1_TMO_AF_PC14	= 2,
	URT1_TX_AF_PB10	= 7,
	URT1_TX_AF_PC10	= 5,
	URT1_TX_AF_PC5	= 4,
	URT1_TX_AF_PC8	= 4,
	XIN_AF_PC13	= 1,
	XOUT_AF_PC14	= 1,

}PINX_AF_TypeDef;
#endif

#if defined(MG32F02A128) || defined(MG32F02U128) || defined(MG32F02A064) || defined(MG32F02U064)
/*! @enum   PINX_AF_TypeDef
    @brief  Pin IO AF control options for MG32F02U064/128.
*/ 
typedef enum
{
	// PORTA AF 	
	PA0_AF_GPA0				=	0,
	PA1_AF_GPA1				=	0,
	PA2_AF_GPA2				=	0,
	PA3_AF_GPA3				=	0,
	PA4_AF_GPA4				=	0,
	PA5_AF_GPA5				=	0,
	PA6_AF_GPA6				=	0,
	PA7_AF_GPA7				=	0,
	PA8_AF_GPA8				=	0,
	PA9_AF_GPA9				=	0,
	PA10_AF_GPA10			=	0,
	PA11_AF_GPA11			=	0,
	PA12_AF_GPA12			=	0,
	PA13_AF_GPA13			=	0,
	PA14_AF_GPA14			=	0,
	PA15_AF_GPA15			=	0,

	PA8_AF_DMA_TRG0			=	1,
	PA9_AF_DMA_TRG1			=	1,
	PA10_AF_TM36_BK0		=	1,
	PA11_AF_DAC_TRG0		=	1,
	PA13_AF_CPU_TXEV		=	1,
	PA14_AF_CPU_RXEV		=	1,
	PA15_AF_CPU_NMI			=	1,

	PA10_AF_SPI0_D2			=	2,
	PA11_AF_SPI0_D3			=	2,
	PA12_AF_USB_S0			=	2,
	PA13_AF_USB_S1			=	2,
	PA14_AF_OBM_I0			=	2,
	PA15_AF_OBM_I1			=	2,

	PA8_AF_I2C0_SCL			=	3,
	PA9_AF_I2C1_SCL			=	3,
	PA10_AF_I2C0_SDA		=	3,
	PA11_AF_I2C1_SDA		=	3,
	PA13_AF_URT0_BRO		=	3,
	PA14_AF_URT0_TMO		=	3,
	PA15_AF_URT0_DE			=	3,
	
	PA8_AF_URT2_BRO			=	4,
	PA9_AF_URT2_TMO			=	4,
	PA10_AF_URT2_CTS		=	4,
	PA11_AF_URT2_RTS		=	4,
	PA12_AF_URT1_BRO		=	4,
	PA13_AF_URT1_TMO		=	4,
	PA14_AF_URT1_CTS		=	4,
	PA15_AF_URT1_RTS		=	4,

	PA8_AF_SDT_I0			=	5,
	PA10_AF_SDT_I1			=	5,
	PA12_AF_TM10_ETR		=	5,
	PA13_AF_TM10_TRGO		=	5,
	PA14_AF_TM16_ETR		=	5,
	PA15_AF_TM16_TRGO		=	5,

	PA0_AF_SDT_P0			=	6,
	PA2_AF_SDT_I0			=	6,
	PA3_AF_SDT_I1			=	6,
	PA8_AF_TM20_IC0			=	6,
	PA9_AF_TM20_IC1			=	6,
	PA10_AF_TM26_IC0		=	6,
	PA11_AF_TM26_IC1		=	6,
	PA12_AF_TM36_IC0		=	6,
	PA13_AF_TM36_IC1		=	6,
	PA14_AF_TM36_IC2		=	6,
	PA15_AF_TM36_IC3		=	6,

	PA0_AF_CCL_P0			=	7,
	PA1_AF_CCL_P1			=	7,
	PA6_AF_SPI0_D3			=	7,
	PA7_AF_SPI0_D2			=	7,
	PA8_AF_SPI0_NSS			=	7,
	PA9_AF_SPI0_MISO		=	7,
	PA10_AF_SPI0_CLK		=	7,
	PA11_AF_SPI0_MOSI		=	7,
	PA12_AF_SPI0_D5			=	7,
	PA13_AF_SPI0_D6			=	7,
	PA14_AF_SPI0_D7			=	7,
	PA15_AF_SPI0_D4			=	7,

	PA0_AF_MA0				=	8,
	PA1_AF_MA1				=	8,
	PA2_AF_MA2				=	8,
	PA3_AF_MA3				=	8,
	PA4_AF_MA4				=	8,
	PA5_AF_MA5				=	8,
	PA6_AF_MA6				=	8,
	PA7_AF_MA7				=	8,
	PA8_AF_MA8				=	8,
	PA9_AF_MA9				=	8,
	PA10_AF_MA10			=	8,
	PA11_AF_MA11			=	8,
	PA12_AF_MA12			=	8,
	PA13_AF_MA13			=	8,
	PA14_AF_MA14			=	8,
	PA15_AF_MA15			=	8,

	PA0_AF_MAD0				=	9,
	PA1_AF_MAD1				=	9,
	PA2_AF_MAD2				=	9,
	PA3_AF_MAD3				=	9,
	PA4_AF_MAD4				=	9,
	PA5_AF_MAD5				=	9,
	PA6_AF_MAD6				=	9,
	PA7_AF_MAD7				=	9,
	PA8_AF_MAD0				=	9,
	PA9_AF_MAD1				=	9,
	PA10_AF_MAD2			=	9,
	PA11_AF_MAD3			=	9,
	PA12_AF_MAD4			=	9,
	PA13_AF_MAD5			=	9,
	PA14_AF_MAD6			=	9,
	PA15_AF_MAD7			=	9,
	
	PA0_AF_TM36_OC00		=	10,
	PA1_AF_TM36_OC10		=	10,
	PA2_AF_TM36_OC2			=	10,
	PA3_AF_TM36_OC2N		=	10,
	PA4_AF_TM20_OC00		=	10,
	PA5_AF_TM20_OC10		=	10,
	PA6_AF_TM20_OC0H		=	10,
	PA7_AF_TM20_OC1H		=	10,
	PA8_AF_TM36_OC0H		=	10,
	PA9_AF_TM36_OC1H		=	10,
	PA10_AF_TM36_OC2H		=	10,
	PA11_AF_TM36_OC3H		=	10,
	PA12_AF_TM26_OC00		=	10,
	PA13_AF_TM26_OC10		=	10,
	PA14_AF_TM26_OC0H		=	10,
	PA15_AF_TM26_OC1H		=	10,
	
	PA0_AF_URT4_TX 			=	11,
	PA1_AF_URT4_RX			=	11,
	PA2_AF_URT5_TX			=	11,
	PA3_AF_URT5_RX			=	11,
	PA4_AF_URT0_TX			=	11,
	PA5_AF_URT0_RX			=	11,
	PA6_AF_URT0_CLK			=	11,
	PA7_AF_URT0_NSS			=	11,
	PA8_AF_URT4_TX			=	11,
	PA9_AF_URT5_TX			=	11,
	PA10_AF_URT4_RX			=	11,
	PA11_AF_URT5_RX			=	11,
	PA12_AF_URT6_TX			=	11,
	PA13_AF_URT6_RX			=	11,
	PA14_AF_URT7_TX			=	11,
	PA15_AF_URT7_RX			=	11,
	
	// PORTB AF 	
	PB0_AF_GPB0				=	0,
	PB1_AF_GPB1				=	0,
	PB2_AF_GPB2				=	0,
	PB3_AF_GPB3				=	0,
	PB4_AF_GPB4				=	0,
	PB5_AF_GPB5				=	0,
	PB6_AF_GPB6				=	0,
	PB7_AF_GPB7				=	0,
	PB8_AF_GPB8				=	0,
	PB9_AF_GPB9				=	0,
	PB10_AF_GPB10			=	0,
	PB11_AF_GPB11			=	0,
	PB12_AF_GPB12			=	0,
	PB13_AF_GPB13			=	0,
	PB14_AF_GPB14			=	0,
	PB15_AF_GPB15			=	0,
	
	PB0_AF_I2C1_SCL			=	1,
	PB1_AF_I2C1_SDA			=	1,
	PB2_AF_ADC0_TRG			=	1,
	PB3_AF_ADC0_OUT			=	1,
	PB4_AF_TM01_CKO			=	1,
	PB5_AF_TM16_CKO			=	1,
	PB6_AF_CPU_RXEV			=	1,
	PB7_AF_CPU_TXEV			=	1,
	PB8_AF_CMP0_P0			=	1,
	PB9_AF_CMP1_P0			=	1,
	PB12_AF_DMA_TRG0		=	1,
	PB13_AF_DAC_TRG0		=	1,
	PB14_AF_DMA_TRG0		=	1,
	PB15_AF_IR_OUT			=	1,
	
	PB0_AF_SPI0_NSS				=	2,
	PB1_AF_SPI0_MISO			=	2,
	PB2_AF_SPI0_CLK				=	2,
	PB3_AF_SPI0_MOSI			=	2,
	PB4_AF_SPI0_D3				=	2,
	PB5_AF_SPI0_D2				=	2,
	PB6_AF_SPI0_NSSI			=	2,
	PB8_AF_RTC_OUT				=	2,
	PB9_AF_RTC_TS				=	2,
	PB10_AF_I2C0_SCL			=	2,
	PB11_AF_I2C0_SDA			=	2,
	PB12_AF_NCO_P0				=	2,
	PB13_AF_TM00_ETR			=	2,
	PB14_AF_TM00_TRGO			=	2,
	
	PB0_AF_TM01_ETR				=	3,
	PB1_AF_TM01_TRGO			=	3,
	PB2_AF_TM01_CKO				=	3,
	PB3_AF_NCO_P0				=	3,
	PB4_AF_TM26_TRGO			=	3,
	PB5_AF_TM26_ETR				=	3,
	PB6_AF_URT0_BRO				=	3,
	PB7_AF_URT0_TMO				=	3,
	PB8_AF_URT0_TX				=	3,
	PB9_AF_URT0_RX				=	3,
	PB10_AF_URT0_NSS			=	3,
	PB11_AF_URT0_DE				=	3,
	PB12_AF_USB_S0				=	3,
	PB13_AF_URT0_CTS			=	3,
	PB14_AF_URT0_RTS			=	3,
	PB15_AF_USB_S1				=	3,
	
	PB0_AF_TM00_CKO				=	4,
	PB1_AF_TM10_CKO				=	4,
	PB2_AF_URT2_TX				=	4,
	PB3_AF_URT2_RX				=	4,
	PB4_AF_URT2_CLK				=	4,
	PB5_AF_URT2_NSS				=	4,
	PB6_AF_URT2_CTS				=	4,
	PB7_AF_URT2_RTS				=	4,
	PB8_AF_URT2_BRO				=	4,
	PB9_AF_URT2_TMO				=	4,
	PB10_AF_URT2_DE				=	4,
	PB11_AF_IR_OUT				=	4,
	
	PB0_AF_TM16_ETR				=	5,
	PB1_AF_TM16_TRGO			=	5,
	PB2_AF_TM16_CKO				=	5,
	PB2_AF_TM36_CKO				=	5,
	PB4_AF_TM20_IC0				=	5,
	PB5_AF_TM20_IC1				=	5,
	PB6_AF_TM20_ETR				=	5,
	PB7_AF_TM20_TRGO			=	5,
	PB8_AF_TM20_OC01			=	5,
	PB9_AF_TM20_OC02			=	5,
	PB10_AF_TM20_OC11			=	5,
	PB11_AF_TM20_OC12			=	5,
	PB13_AF_TM20_ETR			=	5,
	PB14_AF_TM20_TRGO			=	5,
	
	PB0_AF_TM26_IC0				=	6,
	PB1_AF_TM26_IC1				=	6,
	PB2_AF_TM26_OC0H			=	6,
	PB3_AF_TM26_OC1H			=	6,
	PB4_AF_TM36_IC0				=	6,
	PB5_AF_TM36_IC1				=	6,
	PB6_AF_TM36_IC2				=	6,
	PB7_AF_TM36_IC3				=	6,
	PB8_AF_TM36_OC01			=	6,
	PB9_AF_TM36_OC02			=	6,
	PB10_AF_TM36_OC11			=	6,
	PB11_AF_TM36_OC12			=	6,
	PB13_AF_TM36_ETR			=	6,
	PB14_AF_TM36_BK0			=	6,

	PB0_AF_TM36_ETR				=	7,
	PB1_AF_TM36_TRGO			=	7,
	PB2_AF_I2C0_SDA				=	7,
	PB3_AF_I2C0_SCL				=	7,
	PB8_AF_SPI0_D3				=	7,
	PB9_AF_SPI0_D2				=	7,
	PB10_AF_URT1_TX				=	7,
	PB11_AF_URT1_RX				=	7,
	PB12_AF_URT1_CLK			=	7,
	PB13_AF_URT0_CLK			=	7,
	PB14_AF_URT0_NSS			=	7,
	PB15_AF_URT1_NSS			=	7,
	
	PB0_AF_MA15				=	8,
	PB4_AF_MALE				=	8,
	PB5_AF_MOE				=	8,
	PB6_AF_MWE				=	8,
	PB7_AF_MCE				=	8,
	PB8_AF_MAD0				=	8,
	PB9_AF_MAD1				=	8,
	PB10_AF_MAD2			=	8,
	PB11_AF_MAD3			=	8,
	PB12_AF_MAD4			=	8,
	PB13_AF_MAD5			=	8,
	PB14_AF_MAD6			=	8,
	PB15_AF_MAD7			=	8,
	
	PB4_AF_MAD8				=	9,
	PB5_AF_MAD9				=	9,
	PB6_AF_MAD10			=	9,
	PB7_AF_MALE2			=	9,
	PB9_AF_MAD8				=	9,
	PB10_AF_MAD1			=	9,
	PB11_AF_MAD9			=	9,
	PB12_AF_MAD2			=	9,
	PB13_AF_MAD10			=	9,
	PB14_AF_MAD3			=	9,
	PB15_AF_MAD11			=	9,

	PB2_AF_URT0_TX			=	10,
	PB3_AF_URT0_RX			=	10,
	PB8_AF_OBM_P0			=	10,
	PB9_AF_OBM_P1			=	10,
	PB10_AF_SPI0_NSSI		=	10,
	PB11_AF_DMA_TRG0		=	10,
	PB13_AF_CCL_P0			=	10,
	PB14_AF_CCL_P1			=	10,
	
	PB0_AF_URT6_TX			=	11,
	PB1_AF_URT6_RX			=	11,
	PB2_AF_URT7_TX			=	11,
	PB3_AF_URT7_RX			=	11,
	PB6_AF_URT2_TX			=	11,
	PB7_AF_URT2_RX			=	11,
	PB8_AF_URT4_TX			=	11,
	PB9_AF_URT4_RX			=	11,
	PB11_AF_URT0_CLK		=	11,
	PB12_AF_URT5_TX			=	11,
	PB13_AF_URT4_RX			=	11,
	PB14_AF_URT4_TX			=	11,
	PB15_AF_URT5_RX			=	11,
	
	// PORTC AF 	
	PC0_AF_GPC0				=	0,
	PC1_AF_GPC1				=	0,
	PC2_AF_GPC2				=	0,
	PC3_AF_GPC3				=	0,
	PC4_AF_GPC4				=	0,
	PC5_AF_GPC5				=	0,
	PC6_AF_GPC6				=	0,
	PC7_AF_GPC7				=	0,
	PC8_AF_GPC8				=	0,
	PC9_AF_GPC9				=	0,
	PC10_AF_GPC10			=	0,
	PC11_AF_GPC11			=	0,
	PC12_AF_GPC12			=	0,
	PC13_AF_GPC13			=	0,
	PC14_AF_GPC14			=	0,
	PC15_AF_GPC15			=	0,
	
	PC0_AF_ICKO			=	1,
	PC1_AF_ADC0_TRG		=	1,
	PC2_AF_ADC0_OUT		=	1,
	PC3_AF_OBM_P1		=	1,
	PC4_AF_SWCLK		=	1,
	PC5_AF_SWDIO		=	1,
	PC6_AF_RSTN			=	1,
	PC7_AF_ADC0_TRG		=	1,
	PC8_AF_ADC0_OUT		=	1,
	PC9_AF_CMP0_P0		=	1,
	PC10_AF_CMP1_P0		=	1,
	PC13_AF_XIN			=	1,
	PC14_AF_XOUT		=	1,
	
	PC0_AF_TM00_CKO		=	2,
	PC1_AF_TM01_CKO		=	2,
	PC2_AF_TM10_CKO		=	2,
	PC3_AF_TM16_CKO		=	2,
	PC4_AF_I2C0_SCL		=	2,
	PC5_AF_I2C0_SDA		=	2,
	PC6_AF_RTC_TS		=	2,
	PC7_AF_RTC_OUT		=	2,
	PC8_AF_I2C0_SCL		=	2,
	PC9_AF_I2C0_SDA		=	2,
	PC10_AF_I2C1_SCL	=	2,
	PC11_AF_I2C_SDA		=	2,
	PC12_AF_IR_OUT		=	2,
	PC13_AF_URT1_NSS	=	2,
	PC14_AF_URT1_TMO	=	2,

	PC0_AF_URT0_CLK		=	3,
	PC1_AF_TM36_CLK		=	3,
	PC2_AF_OBM_P0		=	3,
	PC3_AF_URT0_CLK		=	3,
	PC4_AF_URT0_RX		=	3,
	PC5_AF_URT0_TX		=	3,
	PC6_AF_URT0_NSS		=	3,
	PC7_AF_URT0_DE		=	3,
	PC8_AF_URT0_BRO		=	3,
	PC9_AF_URT0_TMO		=	3,
	PC10_AF_URT0_TX		=	3,
	PC11_AF_URT0_RX		=	3,
	PC12_AF_DAC_TRG0	=	3,
	PC13_AF_URT0_CTS	=	3,
	PC14_AF_URT0_RTS	=	3,
	
	PC0_AF_URT2_CLK		=	4,
	PC1_AF_URT1_CLK		=	4,
	PC2_AF_URT2_CLK		=	4,
	PC3_AF_URT1_CLK		=	4,
	PC4_AF_URT1_RX		=	4,
	PC5_AF_URT1_TX		=	4,
	PC8_AF_URT1_TX		=	4,
	PC9_AF_URT1_RX		=	4,
	PC10_AF_URT2_TX		=	4,
	PC11_AF_URT2_RX		=	4,
	PC13_AF_URT2_RX		=	4,
	PC14_AF_URT2_TX		=	4,

	PC0_AF_TM20_OC00	=	5,
	PC1_AF_TM20_OC0N	=	5,
	PC2_AF_TM20_OC10	=	5,
	PC3_AF_TM20_OC1N	=	5,
	PC6_AF_TM20_ETR		=	5,
	PC8_AF_TM20_OC0H	=	5,
	PC9_AF_TM20_OC1H	=	5,
	PC10_AF_URT1_TX		=	5,
	PC11_AF_URT1_RX		=	5,
	PC12_AF_TM10_TRGO	=	5,
	PC13_AF_TM10_ETR	=	5,
	PC14_AF_TM10_CKO	=	5,

	PC0_AF_TM36_OC00	=	6,
	PC1_AF_TM36_OC0N	=	6,
	PC2_AF_TM36_OC10	=	6,
	PC3_AF_TM36_OC1N	=	6,
	PC4_AF_TM36_OC2		=	6,
	PC5_AF_TM36_OC3		=	6,
	PC6_AF_TM26_ETR		=	6,
	PC7_AF_TM36_TRGO	=	6,
	PC8_AF_TM36_OC0H	=	6,
	PC9_AF_TM36_OC1H	=	6,
	PC10_AF_TM36_OC2H	=	6,
	PC11_AF_TM36_OC3H	=	6,
	PC12_AF_TM36_OC3	=	6,
	PC13_AF_TM26_ETR	=	6,
	PC14_AF_TM26_TRGO	=	6,

	PC0_AF_MCLK			=	8,
	PC1_AF_MAD8			=	8,
	PC2_AF_MAD9			=	8,
	PC3_AF_MAD10		=	8,
	PC6_AF_MBW1			=	8,
	PC7_AF_MBW0			=	8,
	PC8_AF_MAD11		=	8,
	PC9_AF_MAD12		=	8,
	PC10_AF_MAD13		=	8,
	PC11_AF_MAD14		=	8,
	PC12_AF_MAD15		=	8,
	PC13_AF_TM20_IC0	=	8,
	PC14_AF_TM20_IC1	=	8,

	PC0_AF_MWE			=	9,
	PC1_AF_MAD4			=	9,
	PC2_AF_MAD12		=	9,
	PC3_AF_MAD5			=	9,
	PC6_AF_MALE			=	9,
	PC7_AF_MCE			=	9,
	PC8_AF_MAD13		=	9,
	PC9_AF_MAD6			=	9,
	PC10_AF_MAD14		=	9,
	PC11_AF_MAD7		=	9,
	PC12_SDT_I0			=	9,
	PC13_SDT_I1			=	9,
	
	PC0_AF_URT0_TX		=	10,
	PC1_AF_URT0_RX		=	10,
	PC8_AF_CCL_P0		=	10,
	PC9_AF_CCL_P1		=	10,

	PC0_AF_URT5_TX		=	11,
	PC1_AF_URT5_RX		=	11,
	PC4_AF_URT6_RX		=	11,
	PC5_AF_URT6_TX		=	11,
	PC8_AF_URT6_TX		=	11,
	PC9_AF_URT6_RX		=	11,
	PC10_AF_URT7_TX		=	11,
	PC11_AF_URT7_RX		=	11,
	PC13_AF_URT6_RX		=	11,
	PC14_AF_URT6_TX		=	11,

	// PORTD AF 	
	PD0_AF_GPD0				=	0,
	PD1_AF_GPD1				=	0,
	PD2_AF_GPD2				=	0,
	PD3_AF_GPD3				=	0,
	PD4_AF_GPD4				=	0,
	PD5_AF_GPD5				=	0,
	PD6_AF_GPD6				=	0,
	PD7_AF_GPD7				=	0,
	PD8_AF_GPD8				=	0,
	PD9_AF_GPD9				=	0,
	PD10_AF_GPD10			=	0,
	PD11_AF_GPD11			=	0,
	PD12_AF_GPD12			=	0,
	PD13_AF_GPD13			=	0,
	PD14_AF_GPD14			=	0,
	PD15_AF_GPD15			=	0,
	
	PD0_AF_OBM_I0		=	1,
	PD1_AF_OBM_I1		=	1,
	PD2_AF_USB_S0		=	1,
	PD3_AF_USB_S1		=	1,
	PD4_AF_TM00_TRGO	=	1,
	PD5_AF_TM00_ETR		=	1,
	PD6_AF_CPU_NMI		=	1,
	PD7_AF_TM00_CKO		=	1,
	PD8_AF_CPU_TXEV		=	1,
	PD9_AF_CPU_RXEV		=	1,
	PD10_AF_CPU_NMI		=	1,
	PD11_AF_CPU_NMI		=	1,
	PD12_AF_CMP0_P0		=	1,
	PD13_AF_CMP1_P0		=	1,

	PD0_AF_TM10_CKO		=	2,
	PD1_AF_TM16_CKO		=	2,
	PD2_AF_TM00_CKO		=	2,
	PD3_AF_TM01_CKO		=	2,
	PD4_AF_TM01_TRGO	=	2,
	PD5_AF_I2C0_SCL		=	2,
	PD6_AF_I2C0_SDA		=	2,
	PD7_AF_TM01_ETR		=	2,
	PD8_AF_TM01_TRGO	=	2,
	PD9_AF_TM00_TRGO	=	2,
	PD10_AF_TM00_ETR	=	2,
	PD11_AF_DMA_TRG1	=	2,
	PD12_AF_TM10_CKO	=	2,
	PD13_AF_TM10_TRGO	=	2,
	PD14_AF_TM10_ETR	=	2,
	PD15_AF_NCO_P0		=	2,
	
	PD0_AF_URT0_CLK		=	3,
	PD1_AF_URT0_CLK		=	3,
	PD2_AF_URT1_CLK		=	3,
	PD3_AF_URT1_CLK		=	3,
	PD4_AF_URT1_TX		=	3,
	PD5_AF_URT1_RX		=	3,
	PD6_AF_URT1_NSS		=	3,
	PD7_AF_URT1_DE		=	3,
	PD8_AF_URT1_RTS		=	3,
	PD9_AF_URT1_CTS		=	3,
	PD10_AF_URT1_BRO	=	3,
	PD11_AF_URT1_TMO	=	3,
	PD12_AF_OBM_P0		=	3,
	PD13_AF_OBM_P1		=	3,
	PD14_AF_DAC_TRG0	=	3,
	PD15_AF_IR_OUT		=	3,

	PD0_AF_TM26_OC1N	=	4,
	PD1_AF_NCO_CK0		=	4,
	PD2_AF_TM26_OC00	=	4,
	PD12_AF_TM00_CKO	=	4,
	PD13_AF_TM00_TRGO	=	4,
	PD14_AF_TM00_ETR	=	4,
	PD15_AF_DMA_TRG0	=	4,

	PD0_AF_TM20_CKO		=	5,
	PD1_AF_TM26_CKO		=	5,
	PD2_AF_TM20_CKO		=	5,
	PD3_AF_SPI0_MISO	=	5,
	PD6_AF_SPI0_NSSI	=	5,
	PD7_AF_SPI0_MISO	=	5,
	PD8_AF_SPI0_D2		=	5,
	PD9_AF_SPI0_NSSI	=	5,
	PD10_AF_RTC_OUT		=	5,
	PD11_AF_SPI0_D3		=	5,
	PD12_AF_SPI0_CLK	=	5,
	PD13_AF_NCO_CK0		=	5,

	PD0_AF_TM36_OC2		=	6,
	PD1_AF_TM36_OC2N	=	6,
	PD2_AF_TM36_CKO		=	6,
	PD3_AF_TM26_CKO		=	6,
	PD4_AF_TM26_OC00	=	6,
	PD5_AF_TM26_OC01	=	6,
	PD6_AF_TM26_OC02	=	6,
	PD7_AF_TM26_OC0N	=	6,
	PD8_AF_TM26_OC10	=	6,
	PD9_AF_TM26_OC11	=	6,
	PD10_AF_TM26_OC12	=	6,
	PD11_AF_TM26_OC1N	=	6,
	PD12_AF_TM20_OC0H	=	6,
	PD13_AF_TM20_OC1H	=	6,
	PD14_AF_TM20_IC0	=	6,
	PD15_AF_TM20_IC1	=	6,

	PD0_AF_SPI0_NSS		=	7,
	PD1_AF_SPI0_CLK		=	7,
	PD2_AF_SPI0_MOSI	=	7,
	PD3_AF_SPI0_D3		=	7,
	PD4_AF_SPI0_D2		=	7,
	PD5_AF_SPI0_MISO	=	7,
	PD6_AF_SPI0_NSS		=	7,
	PD7_AF_SPI0_D4		=	7,
	PD8_AF_SPI0_D7		=	7,
	PD9_AF_SPI0_D6		=	7,
	PD10_AF_SPI0_D5		=	7,
	PD11_AF_SPI0_NSS	=	7,
	PD12_AF_TM26_OC0H	=	7,
	PD13_AF_TM26_OC1H	=	7,
	PD14_AF_TM26_IC0	=	7,
	PD15_AF_TM26_IC1	=	7,

	PD0_AF_MA0			=	8,
	PD1_AF_MA1			=	8,
	PD2_AF_MA2			=	8,
	PD3_AF_MA3			=	8,
	PD4_AF_MA4			=	8,
	PD5_AF_MA5			=	8,
	PD6_AF_MA6			=	8,
	PD7_AF_MA7			=	8,
	PD8_AF_MA8			=	8,
	PD9_AF_MA9			=	8,
	PD10_AF_MA10		=	8,
	PD11_AF_MA11		=	8,
	PD12_AF_MA12		=	8,
	PD13_AF_MA13		=	8,
	PD14_AF_MA14		=	8,
	PD15_AF_MA15		=	8,

	PD0_AF_MCLK			=	9,
	PD2_AF_MAD4			=	9,
	PD3_AF_MAD7			=	9,
	PD4_AF_MAD6			=	9,
	PD5_AF_MAD5			=	9,
	PD6_AF_SDT_P0		=	9,
	PD7_AF_MAD0			=	9,
	PD8_AF_MAD3			=	9,
	PD9_AF_MAD2			=	9,
	PD10_AF_MAD1		=	9,
	PD11_AF_MWE			=	9,
	PD12_AF_MALE2		=	9,
	PD13_AF_MCE			=	9,
	PD14_AF_MOE			=	9,
	
	PD3_AF_TM36_TRGO	=	10,
	PD7_AF_TM36_IC0		=	10,
	PD8_AF_TM36_IC1		=	10,
	PD9_AF_TM36_IC2		=	10,
	PD10_AF_TM36_IC3	=	10,
	PD14_AF_CCL_P0		=	10,
	PD15_AF_CCL_P1		=	10,

	PD0_AF_URT2_NSS		=	11,
	PD1_AF_URT2_CLK		=	11,
	PD2_AF_URT2_TX		=	11,
	PD3_AF_URT2_RX		=	11,
	PD4_AF_URT2_TX		=	11,
	PD5_AF_URT2_RX		=	11,
	PD6_AF_URT2_NSS		=	11,
	PD8_AF_SPI0_CLK		=	11,
	PD9_AF_SPI0_NSS		=	11,
	PD10_AF_SPI0_MOSI	=	11,
	PD14_AF_URT5_TX		=	11,
	PD15_AF_URT5_RX		=	11,

	// PORTE AF 	
	PE0_AF_GPE0			=	0,
	PE1_AF_GPE1			=	0,
	PE2_AF_GPE2			=	0,
	PE3_AF_GPE3			=	0,
	PE8_AF_GPE8			=	0,
	PE9_AF_GPE9			=	0,
	PE10_AF_GPE10		=	0,
	PE11_AF_GPE11		=	0,
	PE12_AF_GPE12		=	0,
	PE13_AF_GPE13		=	0,
	PE14_AF_GPE14		=	0,
	PE15_AF_GPE15		=	0,
	
	PE0_AF_OBM_I0		=	1,
	PE1_AF_OBM_I1		=	1,
	PE2_AF_OBM_P0		=	1,
	PE3_AF_OBM_P1		=	1,
	PE8_AF_CPU_TXEV		=	1,
	PE9_AF_CPU_RXEV		=	1,
	PE10_AF_I2C0_SCL	=	1,
	PE11_AF_I2C0_SDA	=	1,
	PE12_AF_ADC0_TRG	=	1,
	PE13_AF_ADC0_OUT	=	1,
	PE14_AF_RTC_OUT		=	1,
	PE15_AF_RTC_TS		=	1,

	PE2_AF_I2C1_SCL		=	2,
	PE3_AF_I2C1_SDA		=	2,
	PE8_AF_OBM_I0		=	2,
	PE9_AF_OBM_I1		=	2,
	PE10_AF_I2C1_SCL	=	2,
	PE11_AF_I2C1_SDA	=	2,
	PE12_AF_USB_S0		=	2,
	PE13_AF_USB_S1		=	2,
	PE14_AF_I2C1_SCL	=	2,
	PE15_AF_I2C1_SDA	=	2,

	PE0_AF_URT0_TX		=	3,
	PE1_AF_URT0_RX		=	3,
	PE2_AF_URT1_TX		=	3,
	PE3_AF_URT1_RX		=	3,
	PE8_AF_URT2_TX		=	3,
	PE9_AF_URT2_RX		=	3,
	PE10_AF_URT0_TX		=	3,
	PE11_AF_URT0_RX		=	3,

	PE0_AF_DAC_TRG0		=	4,
	PE1_AF_DMA_TRG1		=	4,
	PE2_AF_NCO_P0		=	4,
	PE3_AF_NCO_CK0		=	4,
	PE8_AF_SDT_I0		=	4,
	PE9_AF_SDT_I1		=	4,
	PE10_AF_URT4_TX		=	4,
	PE11_AF_URT4_RX		=	4,
	PE12_AF_TM01_CKO	=	4,
	PE13_AF_TM01_TRGO	=	4,
	PE14_AF_TM01_ETR	=	4,
	PE15_AF_TM36_BK0	=	4,

	PE0_AF_SPI0_NSS		=	5,
	PE1_AF_SPI0_MISO	=	5,
	PE2_AF_SPI0_MOSI	=	5,
	PE3_AF_SPI0_CLK		=	5,
	PE8_AF_TM36_CKO		=	5,
	PE9_AF_TM36_TRGO	=	5,
	PE12_AF_TM16_CKO	=	5,
	PE13_AF_TM16_TRGO	=	5,
	PE14_AF_TM16_ETR	=	5,
	PE15_AF_TM36_ETR	=	5,

	PE0_AF_TM20_OC00	=	6,
	PE1_AF_TM20_OC01	=	6,
	PE2_AF_TM20_OC02	=	6,
	PE3_AF_TM20_OC0N	=	6,
	PE8_AF_TM20_CKO		=	6,
	PE9_AF_TM20_TRGO	=	6,
	PE12_AF_TM20_OC10	=	6,
	PE13_AF_TM20_OC11	=	6,
	PE14_AF_TM20_OC12	=	6,
	PE15_AF_TM20_OC1N	=	6,

	PE0_AF_TM26_OC00	=	7,
	PE1_AF_TM26_OC01	=	7,
	PE2_AF_TM26_OC02	=	7,
	PE3_AF_TM26_OC0N	=	7,
	PE8_AF_TM26_CKO		=	7,
	PE9_AF_TM26_TRGO	=	7,
	PE12_AF_TM26_OC10   =	7,
	PE13_AF_TM26_OC11   =	7,
	PE14_AF_TM26_OC12   =	7,
	PE15_AF_TM26_OC1N   =	7,

	PE0_AF_MALE			=	8,
	PE1_AF_MOE			=	8,
	PE2_AF_MWE			=	8,
	PE3_AF_MCE			=	8,
	PE12_AF_MBW0		=	8,
	PE13_AF_MBW1		=	8,
	PE14_AF_MALE2		=	8,
	PE15_AF_MALE		=	8,

	PE0_AF_MAD8			=	9,
	PE1_AF_MAD9			=	9,
	PE2_AF_MAD10		=	9,
	PE3_AF_MALE2		=	9,
	PE8_AF_MAD11		=	9,
	PE9_AF_MOE			=	9,
	PE10_AF_SDT_I0		=	9,
	PE11_AF_SDT_I1		=	9,
	PE14_AF_CCL_P0		=	9,
	PE15_AF_CCL_P1		=	9,
	
	PE1_AF_TM36_OC0H	=	10,
	PE2_AF_TM36_OC1H	=	10,
	PE13_AF_TM36_OC2H	=	10,
	PE14_AF_TM36_OC3H	=	10,
	
	PE0_AF_URT4_TX		=	11,
	PE1_AF_URT4_RX		=	11,
	PE2_AF_URT5_TX		=	11,
	PE3_AF_URT5_RX		=	11,
	PE8_AF_URT4_TX		=	11,
	PE9_AF_URT4_RX		=	11,
	PE12_AF_URT6_TX		=	11,
	PE13_AF_URT6_RX		=	11,
	PE14_AF_URT7_TX		=	11,
	PE15_AF_URT7_RX		=	11,


	ADC0_OUT_AF_PB3  		=	1, 
	ADC0_OUT_AF_PC2         =	1, 
	ADC0_OUT_AF_PC8         =	1, 
	ADC0_OUT_AF_PE13        =	1, 
	ADC0_TRG_AF_PB2         =	1, 
	ADC0_TRG_AF_PC1         =	1, 
	ADC0_TRG_AF_PC7         =	1, 
	ADC0_TRG_AF_PE12        =	1, 

	CCL_P0_AF_PA0           =	7, 
	CCL_P0_AF_PB13          =	10,
	CCL_P0_AF_PC8           =	10,
	CCL_P0_AF_PD14          =	10,
	CCL_P0_AF_PE14          =	9, 
	CCL_P1_AF_PA1           =	7, 
	CCL_P1_AF_PB14          =	10,
	CCL_P1_AF_PC9           =	10,
	CCL_P1_AF_PD15          =	10,
	CCL_P1_AF_PE15          =	9, 

	CMP0_P0_AF_PB8          =	1, 
	CMP0_P0_AF_PC9          =	1, 
	CMP0_P0_AF_PD12         =	1, 
	CMP1_P0_AF_PB9          =	1, 
	CMP1_P0_AF_PC10         =	1, 
	CMP1_P0_AF_PD13         =	1, 

	CPU_NMI_AF_PA15         =	1, 
	CPU_NMI_AF_PD6          =	1, 
	CPU_NMI_AF_PD10         =	1, 
	CPU_NMI_AF_PD11         =	1, 
	CPU_RXEV_AF_PA14        =	1, 
	CPU_RXEV_AF_PB6         =	1, 
	CPU_RXEV_AF_PD9         =	1, 
	CPU_RXEV_AF_PE9         =	1, 
	CPU_TXEV_AF_PA13        =	1, 
	CPU_TXEV_AF_PB7         =	1, 
	CPU_TXEV_AF_PD8         =	1, 
	CPU_TXEV_AF_PE8         =	1, 

	DAC_TRG0_AF_PA11        =	1, 
	DAC_TRG0_AF_PB13        =	1, 
	DAC_TRG0_AF_PC12        =	3, 
	DAC_TRG0_AF_PD14        =	3, 
	DAC_TRG0_AF_PE0         =	4, 
	DMA_TRG0_AF_PA8         =	1, 
	DMA_TRG0_AF_PB12        =	1, 
	DMA_TRG0_AF_PB14        =	1, 
	DMA_TRG0_AF_PB11        =	10,
	DMA_TRG0_AF_PD15        =	4, 
	DMA_TRG1_AF_PA9         =	1, 
	DMA_TRG1_AF_PD11        =	2, 
	DMA_TRG1_AF_PE1         =	4, 

	GPA0_AF_PA0             =	0, 
	GPA1_AF_PA1             =	0, 
	GPA10_AF_PA10           =	0, 
	GPA11_AF_PA11           =	0, 
	GPA12_AF_PA12           =	0, 
	GPA13_AF_PA13           =	0, 
	GPA14_AF_PA14           =	0, 
	GPA15_AF_PA15           =	0, 
	GPA2_AF_PA2             =	0, 
	GPA3_AF_PA3             =	0, 
	GPA4_AF_PA4             =	0, 
	GPA5_AF_PA5             =	0, 
	GPA6_AF_PA6             =	0, 
	GPA7_AF_PA7             =	0, 
	GPA8_AF_PA8             =	0, 
	GPA9_AF_PA9             =	0, 
	GPB0_AF_PB0             =	0, 
	GPB1_AF_PB1             =	0, 
	GPB10_AF_PB10           =	0, 
	GPB11_AF_PB11           =	0, 
	GPB12_AF_PB12           =	0, 
	GPB13_AF_PB13           =	0, 
	GPB14_AF_PB14           =	0, 
	GPB15_AF_PB15           =	0, 
	GPB2_AF_PB2             =	0, 
	GPB3_AF_PB3             =	0, 
	GPB4_AF_PB4             =	0, 
	GPB5_AF_PB5             =	0, 
	GPB6_AF_PB6             =	0, 
	GPB7_AF_PB7             =	0, 
	GPB8_AF_PB8             =	0, 
	GPB9_AF_PB9             =	0, 
	GPC0_AF_PC0             =	0, 
	GPC1_AF_PC1             =	0, 
	GPC10_AF_PC10           =	0, 
	GPC11_AF_PC11           =	0, 
	GPC12_AF_PC12           =	0, 
	GPC13_AF_PC13           =	0, 
	GPC14_AF_PC14           =	0, 
	GPC15_AF_PC15           =	0, 
	GPC2_AF_PC2             =	0, 
	GPC3_AF_PC3             =	0, 
	GPC4_AF_PC4             =	0, 
	GPC5_AF_PC5             =	0, 
	GPC6_AF_PC6             =	0, 
	GPC7_AF_PC7             =	0, 
	GPC8_AF_PC8             =	0, 
	GPC9_AF_PC9             =	0, 
	GPD0_AF_PD0             =	0, 
	GPD1_AF_PD1             =	0, 
	GPD10_AF_PD10           =	0, 
	GPD11_AF_PD11           =	0, 
	GPD12_AF_PD12           =	0, 
	GPD13_AF_PD13           =	0, 
	GPD14_AF_PD14           =	0, 
	GPD15_AF_PD15           =	0, 
	GPD2_AF_PD2             =	0, 
	GPD3_AF_PD3             =	0, 
	GPD4_AF_PD4             =	0, 
	GPD5_AF_PD5             =	0, 
	GPD6_AF_PD6             =	0, 
	GPD7_AF_PD7             =	0, 
	GPD8_AF_PD8             =	0, 
	GPD9_AF_PD9             =	0, 
	GPE0_AF_PE0             =	0, 
	GPE1_AF_PE1             =	0, 
	GPE10_AF_PE10           =	0, 
	GPE11_AF_PE11           =	0, 
	GPE12_AF_PE12           =	0, 
	GPE13_AF_PE13           =	0, 
	GPE14_AF_PE14           =	0, 
	GPE15_AF_PE15           =	0, 
	GPE2_AF_PE2             =	0, 
	GPE3_AF_PE3             =	0, 
	GPE8_AF_PE8             =	0, 
	GPE9_AF_PE9             =	0, 

	I2C0_SCL_AF_PA8         =	3, 
	I2C0_SCL_AF_PB10        =	2, 
	I2C0_SCL_AF_PB3         =	7, 
	I2C0_SCL_AF_PC4         =	2, 
	I2C0_SCL_AF_PC8         =	2, 
	I2C0_SCL_AF_PD5         =	2, 
	I2C0_SCL_AF_PE10        =	1, 
	I2C0_SDA_AF_PA10        =	3, 
	I2C0_SDA_AF_PB11        =	2, 
	I2C0_SDA_AF_PB2         =	7, 
	I2C0_SDA_AF_PC5         =	2, 
	I2C0_SDA_AF_PC9         =	2, 
	I2C0_SDA_AF_PD6         =	2, 
	I2C0_SDA_AF_PE11        =	1, 
	I2C1_SCL_AF_PA9         =	3, 
	I2C1_SCL_AF_PB0         =	1, 
	I2C1_SCL_AF_PC10        =	2, 
	I2C1_SCL_AF_PE2         =	2, 
	I2C1_SCL_AF_PE10        =	2, 
	I2C1_SCL_AF_PE14        =	2, 
	I2C1_SDA_AF_PA11        =	3, 
	I2C1_SDA_AF_PB1         =	1, 
	I2C1_SDA_AF_PC11        =	2, 
	I2C1_SDA_AF_PE3         =	2, 
	I2C1_SDA_AF_PE11        =	2, 
	I2C1_SDA_AF_PE15        =	2, 

	ICKO_AF_PC0             =	1, 

	IR_OUT_AF_PB15          =	1, 
	IR_OUT_AF_PB11          =	4, 
	IR_OUT_AF_PC12          =	2, 
	IR_OUT_AF_PD15          =	3, 

	MA0_AF_PA0              =	8, 
	MA0_AF_PD0              =	8, 
	MA1_AF_PA1              =	8, 
	MA1_AF_PD1              =	8, 
	MA10_AF_PA10            =	8, 
	MA10_AF_PD10            =	8, 
	MA11_AF_PA11            =	8, 
	MA11_AF_PD11            =	8, 
	MA12_AF_PA12            =	8, 
	MA12_AF_PD12            =	8, 
	MA13_AF_PA13            =	8, 
	MA13_AF_PD13            =	8, 
	MA14_AF_PA14            =	8, 
	MA14_AF_PD14            =	8, 
	MA15_AF_PA15            =	8, 
	MA15_AF_PB0             =	8, 
	MA15_AF_PD15            =	8, 
	MA2_AF_PA2              =	8, 
	MA2_AF_PD2              =	8, 
	MA3_AF_PA3              =	8, 
	MA3_AF_PD3              =	8, 
	MA4_AF_PA4              =	8, 
	MA4_AF_PD4              =	8, 
	MA5_AF_PA5              =	8, 
	MA5_AF_PD5              =	8, 
	MA6_AF_PA6              =	8, 
	MA6_AF_PD6              =	8, 
	MA7_AF_PA7              =	8, 
	MA7_AF_PD7              =	8, 
	MA8_AF_PA8              =	8, 
	MA8_AF_PD8              =	8, 
	MA9_AF_PA9              =	8, 
	MA9_AF_PD9              =	8, 

	MAD0_AF_PA0             =	9, 
	MAD0_AF_PA8             =	9, 
	MAD0_AF_PB8             =	8, 
	MAD0_AF_PD7             =	9, 
	MAD1_AF_PA1             =	9, 
	MAD1_AF_PA9             =	9, 
	MAD1_AF_PB9             =	8, 
	MAD1_AF_PB10            =	9, 
	MAD1_AF_PD10            =	9, 
	MAD10_AF_PB6            =	9, 
	MAD10_AF_PB13           =	9, 
	MAD10_AF_PC3            =	8, 
	MAD10_AF_PE2            =	9, 
	MAD11_AF_PB15           =	9, 
	MAD11_AF_PC8            =	8, 
	MAD11_AF_PE8            =	9, 
	MAD12_AF_PC9            =	8, 
	MAD12_AF_PC2            =	9, 
	MAD13_AF_PC10           =	8, 
	MAD13_AF_PC8            =	9, 
	MAD14_AF_PC11           =	8, 
	MAD14_AF_PC10           =	9, 
	MAD15_AF_PC12           =	8, 
	MAD2_AF_PA2             =	9, 
	MAD2_AF_PA10            =	9, 
	MAD2_AF_PB10            =	8, 
	MAD2_AF_PB12            =	9, 
	MAD2_AF_PD9             =	9, 
	MAD3_AF_PA3             =	9, 
	MAD3_AF_PA11            =	9, 
	MAD3_AF_PB11            =	8, 
	MAD3_AF_PB14            =	9, 
	MAD3_AF_PD8             =	9, 
	MAD4_AF_PA4             =	9, 
	MAD4_AF_PA12            =	9, 
	MAD4_AF_PB12            =	8, 
	MAD4_AF_PC1             =	9, 
	MAD4_AF_PD2             =	9, 
	MAD5_AF_PA5             =	9, 
	MAD5_AF_PA13            =	9, 
	MAD5_AF_PB13            =	8, 
	MAD5_AF_PC3             =	9, 
	MAD5_AF_PD5             =	9, 
	MAD6_AF_PA6             =	9, 
	MAD6_AF_PA14            =	9, 
	MAD6_AF_PB14            =	8, 
	MAD6_AF_PC9             =	9, 
	MAD6_AF_PD4             =	9, 
	MAD7_AF_PA7             =	9, 
	MAD7_AF_PA15            =	9, 
	MAD7_AF_PB15            =	8, 
	MAD7_AF_PC11            =	9, 
	MAD7_AF_PD3             =	9, 
	MAD8_AF_PB4             =	9, 
	MAD8_AF_PB9             =	9, 
	MAD8_AF_PC1             =	8, 
	MAD8_AF_PE0             =	9, 
	MAD9_AF_PB5             =	9, 
	MAD9_AF_PB11            =	9, 
	MAD9_AF_PC2             =	8, 
	MAD9_AF_PE1             =	9, 

	MALE_AF_PB4             =	8, 
	MALE_AF_PC6             =	9, 
	MALE_AF_PE0             =	8, 
	MALE_AF_PE15            =	8, 
	MALE2_AF_PB7            =	9, 
	MALE2_AF_PD12           =	9, 
	MALE2_AF_PE14           =	8, 
	MALE2_AF_PE3            =	9, 

	MBW0_AF_PC7             =	8, 
	MBW0_AF_PE12            =	8, 
	MBW1_AF_PC6             =	8, 
	MBW1_AF_PE13            =	8, 

	MCE_AF_PB7              =	8, 
	MCE_AF_PC7              =	9, 
	MCE_AF_PD13             =	9, 
	MCE_AF_PE3              =	8, 

	MCLK_AF_PC0             =	8, 
	MCLK_AF_PD0             =	9, 

	MOE_AF_PB5              =	8, 
	MOE_AF_PD14             =	9, 
	MOE_AF_PE1              =	8, 
	MOE_AF_PE9              =	9, 

	MWE_AF_PB6              =	8, 
	MWE_AF_PC0              =	9, 
	MWE_AF_PD11             =	9, 
	MWE_AF_PE2              =	8, 

	NCO_CK0_AF_PD1          =	4, 
	NCO_CK0_AF_PD13         =	5, 
	NCO_CK0_AF_PE3          =	4, 
	NCO_P0_AF_PB12          =	2, 
	NCO_P0_AF_PB3           =	3, 
	NCO_P0_AF_PD15          =	2, 
	NCO_P0_AF_PE2           =	4, 

	OBM_I0_AF_PA14          =	2, 
	OBM_I0_AF_PD0           =	1, 
	OBM_I0_AF_PE0           =	1, 
	OBM_I0_AF_PE8           =	2, 
	OBM_I1_AF_PA15          =	2, 
	OBM_I1_AF_PD1           =	1, 
	OBM_I1_AF_PE1           =	1, 
	OBM_I1_AF_PE9           =	2, 
	OBM_P0_AF_PB8           =	10,
	OBM_P0_AF_PC2           =	3, 
	OBM_P0_AF_PD12          =	3, 
	OBM_P0_AF_PE2           =	1, 
	OBM_P1_AF_PB9           =	10,
	OBM_P1_AF_PC3           =	1, 
	OBM_P1_AF_PD13          =	3, 
	OBM_P1_AF_PE3           =	1, 

	RSTN_AF_PC6             =	1, 

	RTC_OUT_AF_PB8          =	2, 
	RTC_OUT_AF_PC7          =	2, 
	RTC_OUT_AF_PD10         =	5, 
	RTC_OUT_AF_PE14         =	1, 
	RTC_TS_AF_PB9           =	2, 
	RTC_TS_AF_PC6           =	2, 
	RTC_TS_AF_PE15          =	1, 

	SDT_I0_AF_PC12          =	9, 
	SDT_I0_AF_PA8           =	5, 
	SDT_I0_AF_PA2           =	6, 
	SDT_I0_AF_PE8           =	4, 
	SDT_I0_AF_PE10          =	9, 
	SDT_I1_AF_PC13          =	9, 
	SDT_I1_AF_PA10          =	5, 
	SDT_I1_AF_PA3           =	6, 
	SDT_I1_AF_PE9           =	4, 
	SDT_I1_AF_PE11          =	9, 
	SDT_P0_AF_PA0           =	6, 
	SDT_P0_AF_PD6           =	9, 

	SPI0_CLK_AF_PA10        =	7, 
	SPI0_CLK_AF_PB2         =	2, 
	SPI0_CLK_AF_PD12        =	5, 
	SPI0_CLK_AF_PD1         =	7, 
	SPI0_CLK_AF_PD8         =	11,
	SPI0_CLK_AF_PE3         =	5, 
	SPI0_D2_AF_PA10         =	2, 
	SPI0_D2_AF_PA7          =	7, 
	SPI0_D2_AF_PB5          =	2, 
	SPI0_D2_AF_PB9          =	7, 
	SPI0_D2_AF_PD8          =	5, 
	SPI0_D2_AF_PD4          =	7, 
	SPI0_D3_AF_PA11         =	2, 
	SPI0_D3_AF_PA6          =	7, 
	SPI0_D3_AF_PB4          =	2, 
	SPI0_D3_AF_PB8          =	7, 
	SPI0_D3_AF_PD11         =	5, 
	SPI0_D3_AF_PD3          =	7, 
	SPI0_D4_AF_PA15         =	7, 
	SPI0_D4_AF_PD7          =	7, 
	SPI0_D5_AF_PA12         =	7, 
	SPI0_D5_AF_PD10         =	7, 
	SPI0_D6_AF_PA13         =	7, 
	SPI0_D6_AF_PD9          =	7, 
	SPI0_D7_AF_PA14         =	7, 
	SPI0_D7_AF_PD8          =	7, 
	SPI0_MISO_AF_PA9        =	7, 
	SPI0_MISO_AF_PB1        =	2, 
	SPI0_MISO_AF_PD3        =	5, 
	SPI0_MISO_AF_PD7        =	5, 
	SPI0_MISO_AF_PD5        =	7, 
	SPI0_MISO_AF_PE1        =	5, 
	SPI0_MOSI_AF_PA11       =	7, 
	SPI0_MOSI_AF_PB3        =	2, 
	SPI0_MOSI_AF_PD2        =	7, 
	SPI0_MOSI_AF_PD10       =	11,
	SPI0_MOSI_AF_PE2        =	5, 
	SPI0_NSS_AF_PA8         =	7, 
	SPI0_NSS_AF_PB0         =	2, 
	SPI0_NSS_AF_PD0         =	7, 
	SPI0_NSS_AF_PD6         =	7, 
	SPI0_NSS_AF_PD11        =	7, 
	SPI0_NSS_AF_PD9         =	11,
	SPI0_NSS_AF_PE0         =	5, 
	SPI0_NSSI_AF_PB6        =	2, 
	SPI0_NSSI_AF_PB10       =	10,
	SPI0_NSSI_AF_PD6        =	5, 
	SPI0_NSSI_AF_PD9        =	5, 

	SWCLK_AF_PC4            =	1, 
	SWDIO_AF_PC5            =	1, 

	TM00_CKO_AF_PB0         =	4, 
	TM00_CKO_AF_PC0         =	2, 
	TM00_CKO_AF_PD7         =	1, 
	TM00_CKO_AF_PD2         =	2, 
	TM00_CKO_AF_PD12        =	4, 
	TM00_ETR_AF_PB13        =	2, 
	TM00_ETR_AF_PD5         =	1, 
	TM00_ETR_AF_PD10        =	2, 
	TM00_ETR_AF_PD14        =	4, 
	TM00_TRGO_AF_PB14       =	2, 
	TM00_TRGO_AF_PD4        =	1, 
	TM00_TRGO_AF_PD9        =	2, 
	TM00_TRGO_AF_PD13       =	4, 

	TM01_CKO_AF_PB4         =	1, 
	TM01_CKO_AF_PB2         =	3, 
	TM01_CKO_AF_PC1         =	2, 
	TM01_CKO_AF_PD3         =	2, 
	TM01_CKO_AF_PE12        =	4, 
	TM01_ETR_AF_PB0         =	3, 
	TM01_ETR_AF_PD7         =	2, 
	TM01_ETR_AF_PE14        =	4, 
	TM01_TRGO_AF_PB1        =	3, 
	TM01_TRGO_AF_PD4        =	2, 
	TM01_TRGO_AF_PD8        =	2, 
	TM01_TRGO_AF_PE13       =	4, 

	TM10_CKO_AF_PB1         =	4, 
	TM10_CKO_AF_PC2         =	2, 
	TM10_CKO_AF_PC14        =	5, 
	TM10_CKO_AF_PD0         =	2, 
	TM10_CKO_AF_PD12        =	2, 
	TM10_ETR_AF_PA12        =	5, 
	TM10_ETR_AF_PC13        =	5, 
	TM10_ETR_AF_PD14        =	2, 
	TM10_TRGO_AF_PA13       =	5, 
	TM10_TRGO_AF_PC12       =	5, 
	TM10_TRGO_AF_PD13       =	2, 

	TM16_CKO_AF_PB5         =	1, 
	TM16_CKO_AF_PB2         =	5, 
	TM16_CKO_AF_PC3         =	2, 
	TM16_CKO_AF_PD1         =	2, 
	TM16_CKO_AF_PE12        =	5, 
	TM16_ETR_AF_PA14        =	5, 
	TM16_ETR_AF_PB0         =	5, 
	TM16_ETR_AF_PE14        =	5, 
	TM16_TRGO_AF_PA15       =	5, 
	TM16_TRGO_AF_PB1        =	5, 
	TM16_TRGO_AF_PE13       =	5, 

	TM20_CKO_AF_PD0         =	5, 
	TM20_CKO_AF_PD2         =	5, 
	TM20_CKO_AF_PE8         =	6, 
	TM20_ETR_AF_PB6         =	5, 
	TM20_ETR_AF_PB13       =	5, 
	TM20_ETR_AF_PC6         =	5, 
	TM20_IC0_AF_PA8         =	6, 
	TM20_IC0_AF_PB4         =	5, 
	TM20_IC0_AF_PC13        =	8, 
	TM20_IC0_AF_PD14        =	6, 
	TM20_IC1_AF_PA9         =	6, 
	TM20_IC1_AF_PB5         =	5, 
	TM20_IC1_AF_PC14        =	8, 
	TM20_IC1_AF_PD15        =	6, 
	TM20_OC00_AF_PA4        =	10,
	TM20_OC00_AF_PC0        =	5, 
	TM20_OC00_AF_PE0        =	6, 
	TM20_OC01_AF_PB8        =	5, 
	TM20_OC01_AF_PE1        =	6, 
	TM20_OC02_AF_PB9        =	5, 
	TM20_OC02_AF_PE2        =	6, 
	TM20_OC0H_AF_PA6        =	10,
	TM20_OC0H_AF_PC8        =	5, 
	TM20_OC0H_AF_PD12       =	6, 
	TM20_OC0N_AF_PC1        =	5, 
	TM20_OC0N_AF_PE3        =	6, 
	TM20_OC10_AF_PA5        =	10,
	TM20_OC10_AF_PC2        =	5, 
	TM20_OC10_AF_PE12       =	6, 
	TM20_OC11_AF_PB10       =	5, 
	TM20_OC11_AF_PE13       =	6, 
	TM20_OC12_AF_PB11       =	5, 
	TM20_OC12_AF_PE14       =	6, 
	TM20_OC1H_AF_PA7        =	10,
	TM20_OC1H_AF_PC9        =	5, 
	TM20_OC1H_AF_PD13       =	6, 
	TM20_OC1N_AF_PC3        =	5, 
	TM20_OC1N_AF_PE15       =	6, 
	TM20_TRGO_AF_PB7        =	5, 
	TM20_TRGO_AF_PB14       =	5, 
	TM20_TRGO_AF_PE9        =	6, 

	TM26_CKO_AF_PD1         =	5, 
	TM26_CKO_AF_PD3         =	6, 
	TM26_CKO_AF_PE8         =	7, 
	TM26_ETR_AF_PB5         =	3, 
	TM26_ETR_AF_PC6         =	6, 
	TM26_ETR_AF_PC13        =	6, 
	TM26_IC0_AF_PA10        =	6, 
	TM26_IC0_AF_PB0         =	6, 
	TM26_IC0_AF_PD14        =	7, 
	TM26_IC1_AF_PA11        =	6, 
	TM26_IC1_AF_PB1         =	6, 
	TM26_IC1_AF_PD15        =	7, 
	TM26_OC00_AF_PA12       =	10,
	TM26_OC00_AF_PD2        =	4, 
	TM26_OC00_AF_PD4        =	6, 
	TM26_OC00_AF_PE0        =	7, 
	TM26_OC01_AF_PD5        =	6, 
	TM26_OC01_AF_PE1        =	7, 
	TM26_OC02_AF_PD6        =	6, 
	TM26_OC02_AF_PE2        =	7, 
	TM26_OC0H_AF_PA14       =	10,
	TM26_OC0H_AF_PB2        =	6, 
	TM26_OC0H_AF_PD12       =	7, 
	TM26_OC0N_AF_PD7        =	6, 
	TM26_OC0N_AF_PE3        =	7, 
	TM26_OC10_AF_PA13       =	10,
	TM26_OC10_AF_PD8        =	6, 
	TM26_OC10_AF_PE12       =	7, 
	TM26_OC11_AF_PD9        =	6, 
	TM26_OC11_AF_PE13       =	7, 
	TM26_OC12_AF_PD10       =	6, 
	TM26_OC12_AF_PE14       =	7, 
	TM26_OC1H_AF_PA15       =	10,
	TM26_OC1H_AF_PB3        =	6, 
	TM26_OC1H_AF_PD13       =	7, 
	TM26_OC1N_AF_PD0        =	4, 
	TM26_OC1N_AF_PD11       =	6, 
	TM26_OC1N_AF_PE15       =	7, 
	TM26_TRGO_AF_PB4        =	3, 
	TM26_TRGO_AF_PC14       =	6, 
	TM26_TRGO_AF_PE9        =	7, 

	TM36_BK0_AF_PA10        =	1, 
	TM36_BK0_AF_PB14        =	6, 
	TM36_BK0_AF_PE15        =	4, 
	TM36_CKO_AF_PB2         =	5, 
	TM36_CKO_AF_PD2         =	6, 
	TM36_CKO_AF_PE8         =	5, 
	TM36_CLK_AF_PC1         =	3, 
	TM36_ETR_AF_PB13        =	6, 
	TM36_ETR_AF_PB0         =	7, 
	TM36_ETR_AF_PE15        =	5, 
	TM36_IC0_AF_PA12        =	6, 
	TM36_IC0_AF_PB4         =	6, 
	TM36_IC0_AF_PD7         =	10,
	TM36_IC1_AF_PA13        =	6, 
	TM36_IC1_AF_PB5         =	6, 
	TM36_IC1_AF_PD8         =	10,
	TM36_IC2_AF_PA14        =	6, 
	TM36_IC2_AF_PB6         =	6, 
	TM36_IC2_AF_PD9         =	10,
	TM36_IC3_AF_PA15        =	6, 
	TM36_IC3_AF_PB7         =	6, 
	TM36_IC3_AF_PD10        =	10,
	TM36_OC00_AF_PA0        =	10,
	TM36_OC00_AF_PC0        =	6, 
	TM36_OC01_AF_PB8        =	6, 
	TM36_OC02_AF_PB9        =	6, 
	TM36_OC0H_AF_PA8        =	10,
	TM36_OC0H_AF_PC8        =	6, 
	TM36_OC0H_AF_PE1        =	10,
	TM36_OC0N_AF_PC1        =	6, 
	TM36_OC10_AF_PA1        =	10,
	TM36_OC10_AF_PC2        =	6, 
	TM36_OC11_AF_PB10       =	6, 
	TM36_OC12_AF_PB11       =	6, 
	TM36_OC1H_AF_PA9        =	10,
	TM36_OC1H_AF_PC9        =	6, 
	TM36_OC1H_AF_PE2        =	10,
	TM36_OC1N_AF_PC3        =	6, 
	TM36_OC2_AF_PA2         =	10,
	TM36_OC2_AF_PC4         =	6, 
	TM36_OC2_AF_PD0         =	6, 
	TM36_OC2H_AF_PA10       =	10,
	TM36_OC2H_AF_PC10       =	6, 
	TM36_OC2H_AF_PE13       =	10,
	TM36_OC2N_AF_PA3        =	10,
	TM36_OC2N_AF_PD1        =	6, 
	TM36_OC3_AF_PC5         =	6, 
	TM36_OC3_AF_PC12        =	6, 
	TM36_OC3H_AF_PA11       =	10,
	TM36_OC3H_AF_PC11       =	6, 
	TM36_OC3H_AF_PE14       =	10,
	TM36_TRGO_AF_PB1        =	7, 
	TM36_TRGO_AF_PC7        =	6, 
	TM36_TRGO_AF_PD3        =	10,
	TM36_TRGO_AF_PE9        =	5, 

	URT0_BRO_AF_PA13        =	3, 
	URT0_BRO_AF_PB6         =	3, 
	URT0_BRO_AF_PC8         =	3, 
	URT0_CLK_AF_PA6         =	11,
	URT0_CLK_AF_PB13        =	7, 
	URT0_CLK_AF_PB11        =	11,
	URT0_CLK_AF_PC0         =	3, 
	URT0_CLK_AF_PC3         =	3, 
	URT0_CLK_AF_PD0         =	3, 
	URT0_CLK_AF_PD1         =	3, 
	URT0_CTS_AF_PB13        =	3, 
	URT0_CTS_AF_PC13        =	3, 
	URT0_DE_AF_PA15         =	3, 
	URT0_DE_AF_PB11         =	3, 
	URT0_DE_AF_PC7          =	3, 
	URT0_NSS_AF_PA7         =	11,
	URT0_NSS_AF_PB10        =	3, 
	URT0_NSS_AF_PB14        =	7, 
	URT0_NSS_AF_PC6         =	3, 
	URT0_RTS_AF_PB14        =	3, 
	URT0_RTS_AF_PC14        =	3, 
	URT0_RX_AF_PA5          =	11,
	URT0_RX_AF_PB9          =	3, 
	URT0_RX_AF_PB3          =	10,
	URT0_RX_AF_PC4          =	3, 
	URT0_RX_AF_PC11         =	3, 
	URT0_RX_AF_PC1          =	10,
	URT0_RX_AF_PE1          =	3, 
	URT0_RX_AF_PE11         =	3, 
	URT0_TMO_AF_PA14        =	3, 
	URT0_TMO_AF_PB7         =	3, 
	URT0_TMO_AF_PC9         =	3, 
	URT0_TX_AF_PA4          =	11,
	URT0_TX_AF_PB8          =	3, 
	URT0_TX_AF_PB2          =	10,
	URT0_TX_AF_PC5          =	3, 
	URT0_TX_AF_PC10         =	3, 
	URT0_TX_AF_PC0          =	10,
	URT0_TX_AF_PE0          =	3, 
	URT0_TX_AF_PE10         =	3, 

	URT1_BRO_AF_PA12        =	4, 
	URT1_BRO_AF_PD10        =	3, 
	URT1_CLK_AF_PB12        =	7, 
	URT1_CLK_AF_PC1         =	4, 
	URT1_CLK_AF_PC3         =	4, 
	URT1_CLK_AF_PD2         =	3, 
	URT1_CLK_AF_PD3         =	3, 
	URT1_CTS_AF_PA14        =	4, 
	URT1_CTS_AF_PD9         =	3, 
	URT1_DE_AF_PD7          =	3, 
	URT1_NSS_AF_PB15        =	7, 
	URT1_NSS_AF_PC13        =	2, 
	URT1_NSS_AF_PD6         =	3, 
	URT1_RTS_AF_PA15        =	4, 
	URT1_RTS_AF_PD8         =	3, 
	URT1_RX_AF_PB11         =	7, 
	URT1_RX_AF_PC4          =	4, 
	URT1_RX_AF_PC9          =	4, 
	URT1_RX_AF_PC11         =	5, 
	URT1_RX_AF_PD5          =	3, 
	URT1_RX_AF_PE3          =	3, 
	URT1_TMO_AF_PA13        =	4, 
	URT1_TMO_AF_PC14        =	2, 
	URT1_TMO_AF_PD11        =	3, 
	URT1_TX_AF_PB10         =	7, 
	URT1_TX_AF_PC5          =	4, 
	URT1_TX_AF_PC8          =	4, 
	URT1_TX_AF_PC10         =	5, 
	URT1_TX_AF_PD4          =	3, 
	URT1_TX_AF_PE2          =	3, 

	URT2_BRO_AF_PA8         =	4, 
	URT2_BRO_AF_PB8         =	4, 
	URT2_CLK_AF_PB4         =	4, 
	URT2_CLK_AF_PC0         =	4, 
	URT2_CLK_AF_PC2         =	4, 
	URT2_CLK_AF_PD1         =	11,
	URT2_CTS_AF_PA10        =	4, 
	URT2_CTS_AF_PB6         =	4, 
	URT2_DE_AF_PB10         =	4, 
	URT2_NSS_AF_PB5         =	4, 
	URT2_NSS_AF_PD0         =	11,
	URT2_NSS_AF_PD6         =	11,
	URT2_RTS_AF_PA11        =	4, 
	URT2_RTS_AF_PB7         =	4, 
	URT2_RX_AF_PB3          =	4, 
	URT2_RX_AF_PB7          =	11,
	URT2_RX_AF_PC11         =	4, 
	URT2_RX_AF_PC13         =	4, 
	URT2_RX_AF_PD3          =	11,
	URT2_RX_AF_PD5          =	11,
	URT2_RX_AF_PE9          =	3, 
	URT2_TMO_AF_PA9         =	4, 
	URT2_TMO_AF_PB9         =	4, 
	URT2_TX_AF_PB2          =	4, 
	URT2_TX_AF_PB6          =	11,
	URT2_TX_AF_PC10         =	4, 
	URT2_TX_AF_PC14         =	4, 
	URT2_TX_AF_PD2          =	11,
	URT2_TX_AF_PD4          =	11,
	URT2_TX_AF_PE8          =	3, 

	URT4_RX_AF_PA1          =	11,
	URT4_RX_AF_PA10         =	11,
	URT4_RX_AF_PB9          =	11,
	URT4_RX_AF_PB13         =	11,
	URT4_RX_AF_PE11         =	4, 
	URT4_RX_AF_PE1          =	11,
	URT4_RX_AF_PE9          =	11,
	URT4_TX_AF_PA0          =	11,
	URT4_TX_AF_PA8          =	11,
	URT4_TX_AF_PB8          =	11,
	URT4_TX_AF_PB14         =	11,
	URT4_TX_AF_PE10         =	4, 
	URT4_TX_AF_PE0          =	11,
	URT4_TX_AF_PE8          =	11,

	URT5_RX_AF_PA3          =	11,
	URT5_RX_AF_PA11         =	11,
	URT5_RX_AF_PB15         =	11,
	URT5_RX_AF_PC1          =	11,
	URT5_RX_AF_PD15         =	11,
	URT5_RX_AF_PE3          =	11,
	URT5_TX_AF_PA2          =	11,
	URT5_TX_AF_PA9          =	11,
	URT5_TX_AF_PB12         =	11,
	URT5_TX_AF_PC0          =	11,
	URT5_TX_AF_PD14         =	11,
	URT5_TX_AF_PE2          =	11,

	URT6_RX_AF_PA13         =	11,
	URT6_RX_AF_PB1          =	11,
	URT6_RX_AF_PC4          =	11,
	URT6_RX_AF_PC9          =	11,
	URT6_RX_AF_PC13         =	11,
	URT6_RX_AF_PE13         =	11,
	URT6_TX_AF_PA12         =	11,
	URT6_TX_AF_PB0          =	11,
	URT6_TX_AF_PC5          =	11,
	URT6_TX_AF_PC8          =	11,
	URT6_TX_AF_PC14         =	11,
	URT6_TX_AF_PE12         =	11,

	URT7_RX_AF_PA15         =	11,
	URT7_RX_AF_PB3          =	11,
	URT7_RX_AF_PC11         =	11,
	URT7_RX_AF_PE15         =	11,
	URT7_TX_AF_PA14         =	11,
	URT7_TX_AF_PB2          =	11,
	URT7_TX_AF_PC10         =	11,
	URT7_TX_AF_PE14         =	11,

	USB_S0_AF_PA12          =	2, 
	USB_S0_AF_PB12          =	3, 
	USB_S0_AF_PD2           =	1, 
	USB_S0_AF_PE12          =	2, 
	USB_S1_AF_PA13          =	2, 
	USB_S1_AF_PB15          =	3, 
	USB_S1_AF_PD3           =	1, 
	USB_S1_AF_PE13          =	2, 

	XIN_AF_PC13             =	1, 
	XOUT_AF_PC14            =	1, 


}PINX_AF_TypeDef;
#endif


#endif
