/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			0ģʽ4 (SPIģʽ)
*			SPICLK <-->TXD	P31
*			MOSI	<-->RXD  P30
*			MISO	<-->S0MI P46
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
//#define LED_G_0		P33
//#define LED_G_1		P46

#define SPI_NSS		P33

sfr UARTSPICLK		= 0xBB;

// ѡSPICLK ʼƽ
#define SPICLK_LOW	0	// SPICLK  ʼΪ͵ƽ
#define SPICLK_HIGH	1	// SPICLK  ʼΪ͵ƽ
#define SPI_CPOL  SPICLK_LOW	

// ѡݴ˳
#define LSB	0	// λ
#define MSB	1	// λ
#define SPI_DORD	MSB

// ѡSPI Ĵٶ
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   u8 Uart0SPITransceiver(u8 ToSend)
*:   SPIͺ
*:   u8 ToSend
*ز:     
*************************************************************************************/
u8 Uart0SPITransceiver(u8 ToSend)
{
	S0BUF=ToSend;
	while(TI0==0);
	TI0=0;
	return S0BUF;
}

/***********************************************************************************
*:   void InitUart0_SPI_Master(void)
*:   Uart0ʼ SPI Master
*:   
*ز:     
*************************************************************************************/
void InitUart0_SPI_Master(void)
{
	P31=1;
	UART0_SetModeSPIMaster();			// ôSPIģʽ
	UART0_SetRxTxP30P31();				// ôSPIRXMOSI,TX(SPI_CLK)ΪP30,P31
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART0_SetSPIClock_SYSCLKDiv4();		// SPIʱΪϵͳʱӵ4Ƶ
#else
	UART0_SetSPIClock_SYSCLKDiv12();	// SPIʱΪϵͳʱӵ12Ƶ
#endif

#if (SPI_DORD==MSB)
	UART0_SetDataMSB();
#else
	UART0_SetDataLSB();
#endif

#if (SPI_CPOL==SPICLK_LOW)									
	UARTSPICLK = 0x21;					// SPICLK  ʼΪ͵ƽ
#endif

	
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD(MOSI)/TXD(SCLK),LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,MISO

	PORT_SetP3PushPull(BIT3);							// P33Ϊ(NSS)
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_SPI_Master();
}

void main()
{
	InitSystem();
	LED_R=0;
	DelayXms(1000);
	LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_R = !LED_R;	
		
		SPI_NSS=0;
		Uart0SPITransceiver(0xA5);	
		SPI_NSS=1;
	}

}


