/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			T2ΪMode6:DutyCaptureģʽ P30
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

bit bT2Captureing;
bit bT2CaptureOk;
WordTypeDef T2CaptureFirst;
WordTypeDef T2CaptureSecond;

/***********************************************************************************
*:   void INT_T2(void)
*:T2 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T2(void) interrupt INT_VECTOR_T2
{
	if(TF2)
	{
		TF2=0;
		LED_R=!LED_R;
		
	}
	if(EXF2)
	{
		EXF2=0;
		if(bT2Captureing==TRUE)
		{
			bT2Captureing=FALSE;
			bT2CaptureOk=TRUE;
			T2CaptureFirst.B.BHigh=RCAP2H;
			T2CaptureFirst.B.BLow=RCAP2L;
			T2CaptureSecond.B.BHigh=TH2;
			T2CaptureSecond.B.BLow=TL2;
		}
		LED_G_1=!LED_G_1;
	}
}

/***********************************************************************************

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*ز:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/***********************************************************************************
*:void DelayXus(u8 xUs)
*:ʱ򣬵λΪus
*:u8 Us -> *1us  (1~255)
*ز:     
*************************************************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/***********************************************************************************
*:void DelayXms(u16 xMs)
*:ʱ򣬵λΪms
*:u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitTimer2(void)
*:Timer2ʼ	
*:   
*ز:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_DutyCapture();						// T2ģʽΪDutyCaptureģʽ
	TM_SetT2Clock_SYSCLKDiv12();					// T2ʱԴΪ SYSCLK/12
	
	TM_SetT2LowByte(0);								// TL2	  			
	TM_SetT2RLLowByte(0);							// RCAP2L  
	
	TM_SetT2HighByte(0);							// TH2
	TM_SetT2RLHighByte(0);							// RCAP2H

	TM_SetT2Capture_T2EXPin();						// ʹT2ⲿжΪT2EX
	TM_SetT2CKOT2EX_P31P30();						// T2CKOΪP31,T2EXΪP30
	TM_DisableT2EX_DetectFalling();					// ֹT2EXż½
	TM_EnableT2EX_DetectRising();					// ʹT2EXż
}


/***********************************************************************************
*:   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER2();
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,LED
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	InitUart0_S0BRG();
	
	InitTimer2();			

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж


}

void StartT2CaptureDuty(void)
{
	LED_R=!LED_R;
	LED_G_1=!LED_G_1;
	bT2CaptureOk=FALSE;
	bT2Captureing=TRUE;
	TM_SetT2HighByte(0);
	TM_SetT2LowByte(0);
	TM_EnableT2();
}


void main()
{
	float duty;
	float freq;
	
    InitSystem();
	
	printf("\nHello!!");

 	LED_G_0=0;LED_R=0;LED_G_1=0;
	DelayXms(1000);
 	LED_G_0=1;LED_R=1;LED_G_1=1;

	StartT2CaptureDuty();
					
    while(1)
    {
    	DelayXms(500);
    	LED_G_0=!LED_G_0;
    	if(bT2CaptureOk)
    	{
    		duty=(float)(((double)(T2CaptureFirst.W)*100L)/(float)T2CaptureSecond.W);
    		freq=(float)(1000)/((float)(T2CaptureSecond.W)/2);
			printf("\nT2 Caputre: Duty=%f,Freq=%fKHz",duty,freq);
			StartT2CaptureDuty();
    	}
    }
}


