/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			ȡ16ֽ UID, Գ
*           ʹU1/U2 ѻ¼ϵк,жϸϵкǷȷķΧ
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

#define ISP_ADDRESS    0x1A00	 //ISPʼַ 
#define IAP_ADDRESS    0x1600	 //IAPʼַ  

#define UID_ENCRYPT_BUF_ADDRESS	0x1000
#define DEVICE_SN_BUF_ADDRESS	0x0200

#define ERR_CNT_MAX		4		// Լֵ

code u8 UIDEncryptBuf[16] _at_ UID_ENCRYPT_BUF_ADDRESS;

// ϵкţʹU1/U2 ѻ¼ϵкţʼַΪϵкűĵַ: 0x0200
// ϵк,ȷķΧ,¼ļ
code u8 DeviceSn[16] _at_ DEVICE_SN_BUF_ADDRESS;

// U1/U2 ѻ¼ϵкΪ12Ϊַ+4ֽ
// ж12λַǷǺ
code u8 DeviceSnString[]="Megawin--MCU";

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*ز:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,LED
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*:   u8 IAP_ReadPPage(u8 PsfrAddr)
*:ȡPҳ⹦
*:u8 PsfrAddr: Pҳַ   
*ز:u8: Pҳ     
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
//	CheckTrapFlag();
	SCMD = 0x46;
//	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}

/***********************************************************************************
*:void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:дPҳ⹦
*:u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ   
*ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
//	CheckTrapFlag();
	SCMD = 0x46;
//	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}

/***********************************************************************************
*:u8 IAP_ReadByte(u16 ByteAddr)
*:ַָIAP
*:u16 ByteAddr: IAPַ   
*ز:     
*************************************************************************************/
u8 IAP_ReadByte(u16 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= (u8)(ByteAddr);			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_READ;
		ISPCR = 0x80; 				//ISP/IAP
//		CheckTrapFlag();
		SCMD = 0x46;
//		CheckTrapFlag();
		SCMD = 0xB9;
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
		return IFD;
}
// ʹMOVCķʽȡIAP
#define	IAP_ReadByteByMOVC(x)	CBYTE[x]

/***********************************************************************************
*:void IAP_ErasePage(u16 ByteAddr)
*:ҳ, ַָڵҳ档
*:u8 ByteAddr: ָҳַ8λ   
*************************************************************************************/
void IAP_ErasePage(u16 ByteAddr)
{
		bit bEA=EA;
		IFADRH = (u8)(ByteAddr>>8);				//͵ַֽ
		IFADRL= (u8)(ByteAddr)&B11000000;		//͵ַֽ;
		EA = 0;									//ж
		IFMT = ISP_ERASE;
		ISPCR = 0x80; 							//ISP/IAP
//		CheckTrapFlag();
		SCMD = 0x46;
//		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;								//ISP/IAPĴֹ
		EA = bEA; 								//ָж
}

/***********************************************************************************
*:		u8 IAP_WriteBuf_With_Protect_Verify(u16 ByteAddr,u8 *pBuf,u8 Cnt)
*:		дһݵIAPַָ,У.Уʧ,д.д,򷵻ʧ.
*		 	ʹõ64ֽXDATAԭ
*:  u16 ByteAddr: ָIAPַ, u8 *pBuf: дBufַu8 Cnt: д(<64) 
*ز:u8 0ɹ,	other:ʧ     
*************************************************************************************/
u8 IAP_WriteBuf_With_Verify_Protect(u16 ByteAddr,u8 *pBuf,u8 Cnt)
{
		xdata u8 TempBuf[64];
		u16 i;
		u8 ErrCnt;
		WordTypeDef SectorAddr;
		bit bEA=EA;

		// ȡ¼ԭݵʱ
		ErrCnt=0;
		
		SectorAddr.W=ByteAddr&0xFFC0;
		for(i=0;i<64;i++)
		{
			TempBuf[i]=IAP_ReadByte(SectorAddr.W);
			SectorAddr.W++;
		}
		// д
		i=ByteAddr&0x003F;
		while(Cnt!=0)
		{
			TempBuf[i]=*pBuf;
			pBuf++;
			i++;
			Cnt--;
		}
	P_Err_Loop:
		// 
		SectorAddr.W=ByteAddr&0xFE00;
		IAP_ErasePage(SectorAddr.W);
		
		// ĺдIAP		
		EA = 0;								//ж
		
		ISPCR = 0x80;               		//ISP/IAP
		IFMT = ISP_BYTE_WRITE;				// ֽдģʽ
		
		for(i=0;i<64;i++)
		{
			IFADRH= SectorAddr.B.BHigh;		//͵ַֽ
			IFADRL= SectorAddr.B.BLow; 		//͵ַֽ;
			IFD = TempBuf[i]; 				//Ҫд 
			//		CheckTrapFlag();
			SCMD = 0x46;
			//		CheckTrapFlag();
			SCMD = 0xB9;
			nop();
			SectorAddr.W++;
		}
		IFMT = ISP_PAGE_WRITE;				// ҳдģʽ
		//CheckTrapFlag();
		SCMD = 0x46;
		//CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;							//ISP/IAPĴֹ

		EA = bEA; 							//ָж

		// УǷȷ
		SectorAddr.W=ByteAddr&0xFFC0;
		for(i=0;i<64;i++)
		{
			if(TempBuf[i]!=IAP_ReadByte(SectorAddr.W))
			{
				ErrCnt++;
				if(ErrCnt<ERR_CNT_MAX)
				{
					goto P_Err_Loop;
				}
				else
				{
					goto P_Err_Return;
				}
			}
			SectorAddr.W++;
		}
		ErrCnt=0;
	P_Err_Return:
		return ErrCnt;		
}

/***********************************************************************************
*:   void IAP_ReadUID(u8 *pUID)
*:ȡUID
*:u8 *PUID: 洢16Byte UIDĻָ   
*ز:     
*************************************************************************************/
void IAP_ReadUID(u8 *pUID)
{
	u8 i;
	ISPCR = 0x80;
	BOREV = 0x22;
	IFMT = 0x06;
	IFADRH = 0x00;
	IFADRL = 0x70;
	
	for(i = 0; i < 16; i ++)
	{
		SCMD = 0x46;
		SCMD = 0xB9;
		pUID[i] = IFD;
		IFADRL ++;
	}
	BOREV = 0x00;
	IFMT=0;
	ISPCR = 0x00;
}

/***********************************************************************************
*:   u8 UID_Encrypt()
*:ʹUID(ΨһID)мܼ
*:   
*ز:0:Pass, other:Fail   
*************************************************************************************/
u8 UID_Encrypt(void)
{
	xdata u8 UID[16]; 
	u8 i;

	IAP_ReadUID(&UID[0]);

	for(i=0;i<16;i++)
	{
		if(UIDEncryptBuf[i]!=0xFF) break;
	}
	if(i<16)
	{ // 洢мֽ, ȶǷȷ
		for(i=0;i<16;i++)
		{
			if(UID[i] != UIDEncryptBuf[i]) break;
		}
		if(i<16)
		{ // ȶԴ
			return i+1;
		}
		else
		{
			return 0;
		}
	}
	else
	{ // ȫΪFF,ʾδ洢ֽ
		IAP_WritePPage(IAPLB_P,UID_ENCRYPT_BUF_ADDRESS/256);

		IAP_WriteBuf_With_Verify_Protect(UID_ENCRYPT_BUF_ADDRESS,&UID[0],16);
		
		IAP_WritePPage(IAPLB_P,ISP_ADDRESS/256);
		return 0;
	}

	return 0;
	
	
}


/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S0BRG();	
}

void main()
{

	u8 i;
	bit bUIDEncryptFlag,bDeviceStringFlag;
	
	InitSystem();
	
	printf("\nHello!!");
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	// жΨһIDǷǺ
	if(UID_Encrypt()!=0)
	{ // 
		printf("\nUID Test Fail!!");
		bUIDEncryptFlag=FALSE;
	}
	else
	{ // 
		printf("\nUID Test Pass!!");
		bUIDEncryptFlag=TRUE;
		LED_G_0=0;
	}

	// жѻкǷǺ
	bDeviceStringFlag=TRUE;
	for(i=0;i<12;i++)
	{
		if(DeviceSnString[i] != DeviceSn[i])
		{ // 
			bDeviceStringFlag=FALSE;
		}
	}

	if(bDeviceStringFlag)
	{
		printf("\nDeviceSN Test Pass!!");
		LED_G_1=0;
	}
	else
	{
		printf("\nDeviceSN Test Fail!!");
	}
	
    while(1)
	{	
		LED_R=!LED_R;
		DelayXms(100);
	}
	
}


