/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			T0Ϊ8λʱ,8λPWMP46,ƵΪΪSysclk/12/256=8MHz/12/256=2.604KHz  	
*			T1Ϊ8λʱ,8λPWMP33,ƵΪΪSysclk/1/256=8MHz/1/256=31.250KHz   
*			*ע: ռձ޷100%,Ҫϴ
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ	
*:   
*ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_0_8BIT_PWM();				// T0ģʽ0Ϊ8λPWMģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ
	TM_SetT0CKO_P46();						// T0CKOΪ P46
	TM_EnT0CKO();							// ʹT0CKO 	
	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitTimer1(void)
*:Timer1ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_0_8BIT_PWM();				// T1ģʽ0Ϊ8λPWMģʽ
	TM_SetT1Clock_SYSCLK();					// T1ʱԴΪ SYSCLK
	TM_SetT1Gate_Disable();
	TM_SetT1LowByte(0);						// T18λ
	TM_SetT1HighByte(0);					// T18λ
	TM_SetT1CKO_P33();						// T1CKOΪ P33
	TM_EnT1CKO();							// ʹT1CKO 
	TM_EnableT1();							// ʹT1
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,LED
}


/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	
	InitTimer0();			
	InitTimer1();

}



void main()
{
	u8 i;
	
    InitSystem();
	
 	LED_R=0;
	DelayXms(1000);
 	LED_R=1;

					
    while(1)
    {
    	DelayXms(100);
    	LED_R=!LED_R;
    	i++;
    	if(i>=10)
    	{
			i=0;
    	}
    	switch(i)
    	{
			case 0:// 0% ȫߵƽ
				TH0=(0*256/100);
				TH1=(0*256/100);
				break;
			case 1:// 20% 
				TH0=(20*256/100);
				TH1=(20*256/100);
				break;
			case 2:// 40% 
				TH0=(40*256/100);
				TH1=(40*256/100);
				break;
			case 3:// 70% 
				TH0=(70*256/100);
				TH1=(70*256/100);
				break;
			case 4:// 90% 
				TH0=(90*256/100);
				TH1=(90*256/100);
				break;
			case 5:// 100% ȫ͵ƽ
				P46=0;
				TM_DisT0CKO();
				P33=0;
				TM_DisT1CKO();
				break;
			case 6:// 90% 
				TH0=(90*256/100);
				TH1=(90*256/100);
				P46=1;
				TM_EnT0CKO();
				P33=1;
				TM_EnT1CKO();
				break;
			case 7:// 70% 
				TH0=(70*256/100);
				TH1=(70*256/100);
				break;
			case 8:// 40% 
				TH0=(40*256/100);
				TH1=(40*256/100);
				break;
			case 9:// 20% 
				TH0=(20*256/100);
				TH1=(20*256/100);
				break;
			default:
				i=0;
				break;
    	}
    }
}

