/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=11.0592MHz, SysCLK=22.1184MHz
*
*			CPUCLK=SYSCLK (22.1184M)
*			PCAʱ: SYSCLK
*			CH0(P30)/CH1(P33),CH2(P31)/CH3(P46)
*			2Ի,ض,ֱΪ10bit
*			PWMƵ: 22.1184MHz/(1024)=21.6KHz
*	
*			P10ΪPWMP10=1:  P10=0: 
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		22118400
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
//#define MCU_CPUCLK		(MCU_SYSCLK)
#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

idata WordTypeDef wDuty[2];

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP4PushPull(BIT6);						//  P46Ϊ
	PORT_SetP3PushPull(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ

	P10=1;
	PORT_SetP1OpenDrainPu(BIT0);					// P10Ϊ©ڿ
}


/***********************************************************************************
*:   void InitPCA_PWM(void)
*:   PCAʼ
*:   
*ز:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_SYSCLK();							// PCAʱΪSysClk
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();

	PCA_CH0_SetPWM_10Bit();
	PCA_CH1_SetPWM_10Bit();
	PCA_CH2_SetPWM_10Bit();
	PCA_CH3_SetPWM_10Bit();

	PCA_CH01_SetPWM_EnBufferMode();					// CH0,CH1 ʹܻģʽ
	PCA_CH23_SetPWM_EnBufferMode();					// CH2,CH3 ʹܻģʽ

	PCA_SetPWM_EdgeAligned();						// ض

	// PWMռձȱȽֵ
	PCA_CH0_SetValue_10Bit(0,0);
	PCA_CH1_SetValue_10Bit(0,0);
	PCA_CH2_SetValue_10Bit(0,0);
	PCA_CH3_SetValue_10Bit(0,0);

	// ü
	PCA_SetCounter(0);
	PCA_SetCounterReload(0);

	// ֹPWM
	PCA_SetPWM0_DisOutput();					
	PCA_SetPWM1_DisOutput();
	PCA_SetPWM2_DisOutput();					
	PCA_SetPWM3_DisOutput();

	PCA_SetCEX0CEX1CEX2CEX3_P30P33P31P46();			// CEX0/CEX1/CEX2/CEX3ΪP30P33P31P46

	PCA_CF_DisInterrupt();							// ֹCFж
	
	PCA_EnPCACounter();								// ʹPCA, 
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPCA_PWM();
}


void main()
{
	u8 cnt,inx;
	bit bOutFlag;
    InitSystem();

	LED_G_0=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

	wDuty[0].W=0;
	wDuty[1].W=0;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	if(bOutFlag==TRUE)
			{
		   		inx++;
		    	if(inx>=8)
				{
					inx=0;
				}
		    	switch(inx)
				{
					case 0:
						// ռձ100% ȫߵƽ	
						wDuty[0].W=0x0000;
						wDuty[1].W=0x0000;
						break;

					case 1:
						// ռձ75% 	
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						break;

					case 2:
						// ռձ50% 	
						wDuty[0].W=0x0200;
						wDuty[1].W=0x0200;
						break;

					case 3:
						// ռձ25% 	
						wDuty[0].W=0x0300;
						wDuty[1].W=0x0300;
						break;
						
					case 4:
						// ռձ0% 	 ȫ͵ƽ
						wDuty[0].W=0x0400;
						wDuty[1].W=0x0400;
						break;

					case 5:
						// ռձ25% 	
						wDuty[0].W=0x0300;
						wDuty[1].W=0x0300;
						break;

					case 6:
						// ռձ50% 	
						wDuty[0].W=0x0200;
						wDuty[1].W=0x0200;
						break;

					case 7:
						// ռձ75% 	
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						break;
						
		    	}
				// ģʽ,CH0/CH1ֵĴΪCH1ֵ
				PCA_CH1_SetValue_10Bit(wDuty[0].B.BHigh,wDuty[0].B.BLow);
				// ģʽ,CH2/CH3ֵĴΪCH3ֵ
				PCA_CH3_SetValue_10Bit(wDuty[1].B.BHigh,wDuty[1].B.BLow);
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				// ʹPWM
				PCA_SetPWM0_EnOutput();					
				PCA_SetPWM1_EnOutput();
				PCA_SetPWM2_EnOutput();
				PCA_SetPWM3_EnOutput();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				// ֹPWM
				PCA_SetPWM0_DisOutput();					
				PCA_SetPWM1_DisOutput();
				PCA_SetPWM2_DisOutput();
				PCA_SetPWM3_DisOutput();
			}
    	}
    }
}


