/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=16MHz, SysCLK=16MHz
*
*			SPI(nSS/P46,MOSI/P44,MISO/P45,SPICLK/P33)дFlash
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		16000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32

#define SPI_nSS		P46

// SPI
#define FLASH_ID					0x00C22016L					// MX25L3206

#define Dummy_Data					0xFF
#define FLASH_BLOCK_SIZE			(64L*1024L)					// 64K Byte

#define FLASH_TEST_START_ADDRESS	0x00000000
#define FLASH_TEST_SIZE_MAX			(1024L*1024L)				// 1M Byte

#define TEST_BUF_SIZE				512
xdata u8 TestBuf[TEST_BUF_SIZE];
u16 TestBufCnt;

u8	SPIOvTime;

/***********************************************************************************
* :   void INT_T2(void)
*:T2 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T2(void) interrupt INT_VECTOR_T2
{
	if(TF2)
	{
		TF2=0;
		if(SPIOvTime!=0) SPIOvTime--;
	}
	if(EXF2)
	{
		EXF2=0;
	}
}

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:void SendByte(u8 tByte)
*:0
*: u8 tByte: ͵
*ز:     
*************************************************************************************/
void SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}



/***********************************************************************************
*:void SendStr(u8* PStr)
*:ַ
*: u8* PStr:ַʼַ
*ز:     
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
*:   void SendHex(u8 ToSend)
*:ַʽ16
*: u8 ToSend: ͵16  
*ز:     
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
//	SendByte(' ');
//	SendByte('0');
//	SendByte('x');
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/***********************************************************************************
*:   void SendDW2DEC(u8 ToSend)
*:10
*: u32 ToSend: ͵16 (4ֽ) 
*ز:     
*************************************************************************************/
void SendDW2DEC(u32 ToSend)
{
	bit bFlag;
	u8 x;
	bFlag=0;
	x=ToSend/1000000000L;
	ToSend=ToSend%1000000000L;
	if(x!=0)
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100000000L;
	ToSend=ToSend%100000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000000L;
	ToSend=ToSend%10000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000000L;
	ToSend=ToSend%1000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100000L;
	ToSend=ToSend%100000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000L;
	ToSend=ToSend%10000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000L;
	ToSend=ToSend%1000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100L;
	ToSend=ToSend%100L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend%10L;
	SendByte('0'+x);
		
}


/***********************************************************************************
*:   void ResetCounter()
*:ü
*:  
*ز:     
*************************************************************************************/
void ResetCounter()
{
	// رT0,T1
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	TM_SetT0HighByte(0);
	TM_SetT0LowByte(0);
	TM_SetT1HighByte(0);
	TM_SetT1LowByte(0);
	// ʹT0,T1
	TM_GlobalStart(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
}
/***********************************************************************************
*:   void SendCounter()
*:
*:  
*ز:     
*************************************************************************************/
void SendCounter()
{
	DWordTypeDef dwTime;
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	dwTime.B.BHigh=TH0;
	dwTime.B.BMHigh=TL0;
	dwTime.B.BMLow=TH1;
	dwTime.B.BLow=TL1;
	dwTime.DW=dwTime.DW<<2;
	SendStr("\nTIME: ");
	SendDW2DEC(dwTime.DW);
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_16000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_T1OF();					// T0ʱԴΪ T1OF
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ
	//TM_EnableT0();						// ʹT0
}

/***********************************************************************************
*:   void InitTimer1(void)
*:Timer1ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_1_16BIT_TIMER();			// T1ģʽΪ16λģʽ
	TM_SetT1Clock_SYSCLKDiv48();			// T1ʱԴΪ SYSCLK/48
	TM_SetT1Gate_Disable();
	TM_SetT1LowByte(0);						// T18λ
	TM_SetT1HighByte(0);					// T18λ
	//TM_EnableT1();						// ʹT1
}

/***********************************************************************************
* :   void InitTimer2(void)
*:Timer2ʼ	
*:   
*ز:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_AutoRLandExI();			// T2ģʽ0Ϊ16λԶغⲿжģʽ
	TM_SetT2Clock_SYSCLKDiv12();			// T2ʱԴΪ SYSCLK/12
	
	TM_SetT2LowByte(TIMER_12T_10ms_TL);		// T28λ
	TM_SetT2HighByte(TIMER_12T_10ms_TH);		// T28λ
	TM_SetT2RLHighByte(TIMER_12T_10ms_TH);	// ֵ8λ
	TM_SetT2RLLowByte(TIMER_12T_10ms_TL);	// ֵ8λ
	TM_EnableT2();							// ʹT2
}


/***********************************************************************************
*:   void EnP44P45GPIO(void)
*:   P44P45GPIO, ֹOCD
*		ע: ú,P44/P45޷OCD-ICE, 
*:   
*ز:     
*************************************************************************************/
void EnP44P45GPIO(void)
{
	u8 x;
	bit bEA=EA;
	ISPCR=0x80;
	IFADRH=0x00;
	IFADRL=DCON0_P;
	IFMT=ISP_READ_P;
	SCMD=0x46;
	SCMD=0xB9;
	_nop_();
	x=IFD;
	x=x&(~OCDE_P);
	IFD=x;
	IFMT=ISP_WRITE_P;
	SCMD=0x46;
	SCMD=0xB9;
	_nop_();
	ISPCR=0x00;
	IFMT=ISP_STANBY;
	
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2);				//  P30,P31,P32Ϊ˫,RXD/TXD,LED
	
	PORT_SetP3PushPull(BIT3);						// P33(SPICLK)Ϊ 
	PORT_SetP4OpenDrainPu(BIT5);					// P45(MISO)Ϊ׼˫
	PORT_SetP4PushPull(BIT4|BIT6);					// P46(nSS),P44(MOSI)Ϊ
	PORT_P3_EnFastDrive(BIT3);
	PORT_P4_EnFastDrive(BIT4|BIT6);
}

/***********************************************************************************
*:   void InitSPI_Master(void)
*:   SPIʼ
*:   
*ز:     
*************************************************************************************/
void InitSPI_Master(void)
{
	SPI_Enable();									// ʹSPI
	SPI_SelectMASTERByMSTRbit();					// MASTER
	SPI_SetClock(SPI_CLK_SYSCLK_4);					// SPIʱ SYSCLK/4 16M/4=4M
	SPI_SetCPOL_0();								// SPICLKʼƽ CPOL=0 ͵ƽ
	SPI_SetDataMSB();								// ݴλ MSB λǰ
	SPI_SetCPHA_0();								// ò͸ıģʽ CPHA=1 ǰظı,ز
	SPI_SetUseP46P44P45P33();						// IO nSS/P46,MOSI/P44,MISO/P45,SPICLK/P33
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*:   u8 SPITransceiver(u8 ToSend)
*:   SPIģʽշ
*:   u8 SPI_DATA: ͵
*ز:   u8 :յ  
*************************************************************************************/
u8 SPITransceiver(u8 SPI_DATA)
{
	SPI_SendData(SPI_DATA);							// SPI 
	while(SPI_ChkCompleteFlag()==0);				// ȴSPI
	SPI_ClearCompleteFlag();						// SPI ɱ־
	return SPI_GetData();							// ؽյ
}

/*
*************************************************************************************
*  SPI FLASH
*
*************************************************************************************
*/

/***********************************************************************************
*:	u8 SPI_Flash_1ByteRead (u32 Address)
*:	ȡFlashַָһBYTE 
*:	uint32_t Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
*ز: uint8_t ȡ	  
*************************************************************************************/
u8 SPI_Flash_1ByteRead (u32 Address)
{ 
	u8 x;
	SPI_nSS = 0;
    
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    x=SPITransceiver(Dummy_Data);

	SPI_nSS = 1;

    return  x;
}


/***********************************************************************************
*:	void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u32 Length)
*:	ȡFlashַָĶBYTE 
*:	  u32 Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
*		  u8 *BufferAddreass: 洢ȡݵĻַ
*		  u16 Length: ȡݵĳ
*ز: 
*************************************************************************************/
void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u16 Length)
{
	SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    while(Length !=0)
	{
		*BufferAddreass=SPITransceiver(Dummy_Data);
        BufferAddreass ++;
        Length--;
	}
	SPI_nSS = 1;
}

/***********************************************************************************
*:	u32 SPI_Flash_Read_ID (void)
*:	ȡFlash ID 
*:	
*ز: uint32_t ȡID 
*************************************************************************************/
u32 SPI_Flash_Read_ID (void)
{
	DWordTypeDef RDAT;
    
    SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x9F);
    
    /* Read ID */
    RDAT.B.BMHigh=SPITransceiver(Dummy_Data);
    RDAT.B.BMLow=SPITransceiver(Dummy_Data);
    RDAT.B.BLow=SPITransceiver(Dummy_Data);
	SPI_nSS  = 1;
    
    return RDAT.DW;
}

/***********************************************************************************
*:	void SPI_Flash_Write_Enable (void)
*: ʹдFlash
*:	
*ز: 
*************************************************************************************/
u8 SPI_Flash_Write_Enable(void)
{
	u8 RDAT;

	// óʱʱ 2*10=20ms
    SPIOvTime=2;
  Re_Flash_Write_Enable:
    /* Write enable */
	SPI_nSS  = 0;
	SPITransceiver(0x06);
	SPI_nSS  = 1;

	nop();
	nop();
	nop();
	
    /* Read status register */
	SPI_nSS  = 0;
	SPITransceiver(0x05);			//RDSR
   
	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data

	SPI_nSS  = 1;
	
    /* Check WEL == 1 */
	if((RDAT & 0x02) == 0x00)
	{
		if(SPIOvTime!=0)
		{
			goto Re_Flash_Write_Enable;
		}
		else
		{ // ʱ
			return 1;
		}
	}
	else
	{
		return 0;
	}
}


/***********************************************************************************
*:	void SPI_Flash_Check_Busy(void)
*:	FlashǷæ
*:	
*ز: 
*************************************************************************************/
u8 SPI_Flash_Check_Busy(void)
{
	u8 RDAT;
    
    
    /* Read status register */
	SPI_nSS  = 0;
	SPITransceiver(0x05);							//RDSR

	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data
	
    /* Check erase or write complete */
	SPI_nSS  = 1;
	if((RDAT & 0x01) == 0x01)			//WIP, write in progress
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/***********************************************************************************
*:		void SPI_Flash_Write_Status(u8 uStatus)
*:	Write status

*:			u8 uStatus:status

*ز: 
*************************************************************************************/ 
void SPI_Flash_Write_Status(u8 uStatus)
{
    SPI_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver(0x01);                           // д״̬Ĵ(WRSR)  
                
	
    /* Write Status */
    SPITransceiver(uStatus);
	
	SPI_nSS  = 1;
}

/***********************************************************************************
*:	void SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
*:	Flash д
*:	u32 Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
*		  u8 *DataSource: дݻʼַ. 
*		  u16 Length: дݳ, 256ֽ
*ز: 
*************************************************************************************/ 
u8 SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
{
    if(SPI_Flash_Write_Enable()==1)
    {
		return 1;
    }
    
	SPI_nSS  = 0;
	SPITransceiver( 0x02);                               // Write command 
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	while(Length!=0)                                            // Write Data
	{
		SPITransceiver(*DataSource);
        DataSource++;
		Length--;
	}
	
	SPI_nSS  = 1;
	
	// óʱʱ 2*10=20ms
    SPIOvTime=2;
  	while(SPIOvTime!=0)
  	{
		if(SPI_Flash_Check_Busy()==0)                                       // Wait program complete
		{
			return 0;
		}
	}
	return 2;
}



/***********************************************************************************
*:	void SPI_Flash_Block_Erase(u32 Addr)
*:	Flash 
*:	u32 Addr: ҪBlock ĵַ.
*ز: 
*************************************************************************************/ 
u8 SPI_Flash_Block_Erase(u32 Addr)
{
    if(SPI_Flash_Write_Enable()==1)
    {
		return 1;
    }
    
	SPI_nSS  = 0;
	SPITransceiver(0xD8);                               			// Block Erase command 
                
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	SPI_nSS  = 1;
   
	// óʱʱ 210*10=2.1s
    SPIOvTime=210;
  	while(SPIOvTime!=0)
  	{
		if(SPI_Flash_Check_Busy()==0)                                // Wait Block Erase complete
		{
			return 0;
		}
	}
	return 2;
}


/*
*************************************************************************************
*/ 


/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitSPI_Master();
	InitUart0_S0BRG();
	InitTimer0();
	InitTimer1();
	InitTimer2();
}


void main()
{
	u32 i;
	bit bOK;
	DWordTypeDef dwTemp;
	
    InitSystem();
	
	SendStr("\nHello!");
	LED_R=0;
	DelayXms(1000);
	LED_R=1;

	// ʹܷP44/P45ͨIO, ֹ湦
	EnP44P45GPIO();
	DelayXms(1);
	
	dwTemp.DW=SPI_Flash_Read_ID();
	SendStr("\nFlash ID: ");
	SendHex(dwTemp.B.BMHigh);
	SendHex(dwTemp.B.BMLow);
	SendHex(dwTemp.B.BLow);

	// Clear д
	SPI_Flash_Write_Status(0x00);

	if(dwTemp.DW == FLASH_ID)
	{
		bOK=TRUE;
		// 
		SendStr("\nFlash Erase...");
		i=FLASH_TEST_SIZE_MAX/FLASH_BLOCK_SIZE;
		// Flash
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_R = !LED_R;
			if(SPI_Flash_Block_Erase(dwTemp.DW)!=0)
			{
				bOK=FALSE;
				break;
			}
			dwTemp.DW=dwTemp.DW+FLASH_BLOCK_SIZE;
			i--;
		}
		SendCounter();
		for(i=0;i<256;i++)
		{
			TestBuf[i]=i;
		}
		// дFlash
		SendStr("\nFlash Write 1M");
		i=FLASH_TEST_SIZE_MAX/256;		
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_R = !LED_R;
			if(SPI_Flash_Page_Program(dwTemp.DW,&TestBuf[0],256)!=0)
			{
				bOK=FALSE;
				break;
			}
			dwTemp.DW=dwTemp.DW+256;
			i--;
		}
		SendCounter();
		// Flash
		SendStr("\nFlash Read 1M");
		i=FLASH_TEST_SIZE_MAX/512;		
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_R = !LED_R;
			SPI_Flash_MultiBytesRead(dwTemp.DW,&TestBuf[0],512);
			dwTemp.DW=dwTemp.DW+512;
			i--;
		}
		SendCounter();
	}
	else
	{
		SendStr("\nFlash isn't MX25L3206! ");
		bOK=FALSE;
	}
    while(1)
    {
    	DelayXms(100);
		LED_R = !LED_R;
    }
}


