/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			ʹTWSI0 (SCL/P33, SDA/P46)ģʽжϴ
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
//#define LED_G_0		P33
//#define LED_G_1		P46

#define TWI0_SCL		P33
#define TWI0_SDA		P46

#define I2C_SLAVE_ADDR		0xA0

bit bES0;
u8 LedTime;
u8 Cnt100;

u8 TWI0TestTime;

u8 TWI0OvTime;

enum{
	EE_IDLE=0,
	EE_SEND_START,
	EE_SEND_SLA,
	EE_WRITE_ADDR_H,
	EE_WRITE_ADDR_L,
	EE_SEND_RESTART,
	EE_WRITE_DATA,
	EE_READ_DATA,
	EE_SEND_STOP
}EE_STATUS;

#define EE_SUCCESS		0x00

#define DATA_LENGTH          16
WordTypeDef TWI0TestAddr;

xdata u8 TWI0WriteBuf[DATA_LENGTH];
xdata u8 TWI0ReadBuf[DATA_LENGTH];

#define TWI0_TEST_INTERVAL_TIME	(400/100)			// *100ms	TWI0Լʱ

#define IIC_OVTIME_MAX		20						// *1ms IICʱʱ


#define EE_MODE_WRITE		0
#define EE_MODE_READ		1

typedef struct 
{
	u8 EEMode;
	u8 EEStatus;
	u8 EEDeviceAddr;
	u16 EEDataAddr;
	u8 *EEDataBuf;
	u8 EEFlag;
	u8 EEDataInx;
	u8 EEDataLength;
}EEPROM_PROC_STRUCT;

idata EEPROM_PROC_STRUCT EE_TWI0;


u8 rand;

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;
	if(LedTime!=0) LedTime--;
	if(TWI0OvTime!=0) TWI0OvTime--;
	Cnt100++;
	if(Cnt100>=100)
	{
		Cnt100=0;
		if(TWI0TestTime!=0) TWI0TestTime--;
	}
}

/***********************************************************************************
*:   void INT_TWSI(void)
*:TWI0 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_TWI0() interrupt INT_VECTOR_TWI0
{
	_push_(SFRPI);
	SFR_SetPage(0);

	if(SISTA==0x08)
	{ // Tx:Start
		SICON=SICON&(~STA);
		SIDAT=EE_TWI0.EEDeviceAddr&0xFE;
		EE_TWI0.EEStatus=EE_SEND_SLA;
	}
	else if(SISTA==0x18)
    { // Tx:SLA+W Rx:ACK
    	// To send RegAddr high
		SICON=SICON|(AA);
    	SIDAT=(u8)(EE_TWI0.EEDataAddr>>8);
		EE_TWI0.EEStatus=EE_WRITE_ADDR_H;
    }
    else if(SISTA==0x20)
    { // Tx:SLA+W Rx:NACK
		EE_TWI0.EEFlag=EE_TWI0.EEStatus+0x80;
		EE_TWI0.EEStatus=EE_SEND_STOP;
		SICON=SICON|(STO);
    }
    else if(SISTA==0x28)
    { // Tx:DAT Rx:ACK
		if(EE_TWI0.EEStatus==EE_WRITE_ADDR_H)
		{
			// To send RegAddr LOW
			SICON=SICON|(AA);
			SIDAT=(u8)(EE_TWI0.EEDataAddr);
			EE_TWI0.EEStatus=EE_WRITE_ADDR_L;
		}
		else if(EE_TWI0.EEStatus==EE_WRITE_ADDR_L)
		{
			// Send RegAddr Done
			if(EE_TWI0.EEMode==EE_MODE_READ)
			{
				// Read mode: To Tx ReStart;
				SICON=SICON|(STA);
				EE_TWI0.EEStatus=EE_SEND_RESTART;
			}
			else
			{
				// Write mode: To Tx Data;
				SICON=SICON|(AA);
				EE_TWI0.EEStatus=EE_WRITE_DATA;
				EE_TWI0.EEDataInx=0;
				SIDAT=EE_TWI0.EEDataBuf[EE_TWI0.EEDataInx];
				EE_TWI0.EEDataInx++;
			}
		}
		else if(EE_TWI0.EEStatus==EE_WRITE_DATA)
		{
			if(EE_TWI0.EEDataInx>=EE_TWI0.EEDataLength)
			{
				SICON=SICON|(STO);
				EE_TWI0.EEFlag= EE_SUCCESS;
				EE_TWI0.EEStatus=EE_SEND_STOP;
			}
			else
			{
				SICON=SICON|(AA);
				SIDAT=EE_TWI0.EEDataBuf[EE_TWI0.EEDataInx];
				EE_TWI0.EEDataInx++;
			}
		}
		else
		{
			SICON=SICON|(STO);
			EE_TWI0.EEFlag=EE_TWI0.EEStatus+0x80;
			EE_TWI0.EEStatus=EE_SEND_STOP;
		}
    }
    else if(SISTA==0x30)
    { // Tx:DAT Rx:NACK
		EE_TWI0.EEFlag= EE_TWI0.EEStatus+0x80;
		if(EE_TWI0.EEStatus==EE_WRITE_DATA)
		{
			if(EE_TWI0.EEDataInx==EE_TWI0.EEDataLength)
			{
				EE_TWI0.EEFlag= EE_SUCCESS;
			}
		}
		SICON=SICON|(STO);
		EE_TWI0.EEStatus=EE_SEND_STOP;
    }
	else if(SISTA==0x10)
	{ // Tx:ReStart
		SICON=SICON&(~STA);
		SIDAT=EE_TWI0.EEDeviceAddr|0x01;
		EE_TWI0.EEStatus=EE_SEND_SLA;
	}
    else if(SISTA==0x40)
    { // Tx:SLA+R Rx:ACK
		SICON=SICON|(AA);
		EE_TWI0.EEDataInx=0;
		EE_TWI0.EEStatus=EE_READ_DATA;
    }
    else if(SISTA==0x48)
    { // Tx:SLA+R Rx:NACK
		EE_TWI0.EEFlag=EE_TWI0.EEStatus+0x80;
		EE_TWI0.EEStatus=EE_SEND_STOP;
		SICON=SICON|(STO);
    }
    else if(SISTA==0x50)
    { // Rx:DAT Tx:ACK
		if(EE_TWI0.EEStatus==EE_READ_DATA)
		{
			if(EE_TWI0.EEDataInx>=EE_TWI0.EEDataLength)
			{
				SICON=SICON|(STO);
				EE_TWI0.EEFlag= EE_SUCCESS;
				EE_TWI0.EEStatus=EE_SEND_STOP;
			}
			else
			{
				EE_TWI0.EEDataBuf[EE_TWI0.EEDataInx]=SIDAT;
				EE_TWI0.EEDataInx++;
				if(EE_TWI0.EEDataInx>=EE_TWI0.EEDataLength-1)
				{
					SICON=SICON&(~AA);
				}
				else
				{
					SICON=SICON|(AA);
				}
			}
		}
		else
		{
			EE_TWI0.EEFlag=EE_TWI0.EEStatus+0x80;
			EE_TWI0.EEStatus=EE_SEND_STOP;
			SICON=SICON|(STO);
		}
    }
    else if(SISTA==0x58)
    { // Rx:DAT Tx:NACK
		EE_TWI0.EEFlag= EE_TWI0.EEStatus+0x80;
		if(EE_TWI0.EEStatus==EE_READ_DATA)
		{
			EE_TWI0.EEDataBuf[EE_TWI0.EEDataInx]=SIDAT;
			EE_TWI0.EEDataInx++;
			if(EE_TWI0.EEDataInx==EE_TWI0.EEDataLength)
			{
				EE_TWI0.EEFlag= EE_SUCCESS;
			}
		}
		SICON=SICON|(STO);
		EE_TWI0.EEStatus=EE_SEND_STOP;
    }
	TWI0OvTime=IIC_OVTIME_MAX;
	SICON=SICON&(~SI);
	_pop_(SFRPI);
}

/***********************************************************************************
*:   void SendByte(u8 tByte)
*:ͨUARTһֽ
*:u8 tByte: ͵ 
*ز:
*************************************************************************************/
void SendByte(u8 tByte)
{
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
*:   void SendStr(u8* PStr)
*:ͨUARTַ
*:u8* PStr: ַַ   
*ز:
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
*:   void SendHex(u8 ToSend)
*:ͨUARTASCII뷢16Ƶ
*:u8 ToSend: ͵16  
*ز:
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);						// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);					// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED,TWI0_SCL
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,TWI0:SDA
}

/***********************************************************************************
*:   void InitTWI0(void)
*:TWI0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTWI0()
{
	TWI0_Clear();
	TWI0_SetClock(TWI0_CLK_SYSCLK_32);
	TWI0_SetSCLSDAP33P46();
	TWI0_Enable();
}


/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();						// ʹT0ж
	INT_EnTWI0();						// ʹTWI0ж
	INT_EnAll();						// ʹȫж
}	

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTWI0();
	InitTimer0();
	InitUart0_S0BRG();
	InitInterrupt();
}

/***********************************************************************************
*:   void TWI0_StartWriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pByte)
*:ͨTWI0ݷ͵ӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻݵʼַ
*		u8 *pBuf: ݵĻַ
*		u8 Len: ͵ݸ
*ز:
*************************************************************************************/
void TWI0_StartWriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	
	EE_TWI0.EEMode=EE_MODE_WRITE;
	EE_TWI0.EEDataBuf=pBuf;
	EE_TWI0.EEDeviceAddr=DevAddr;
	EE_TWI0.EEDataAddr=RegStartAddr;
	EE_TWI0.EEDataLength=Len;
	EE_TWI0.EEStatus=EE_SEND_START;
	// start TWI0
	TWI0OvTime=IIC_OVTIME_MAX;
	TWI0_SendSTART();	
}


/***********************************************************************************
*:   void TWI0_StartReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pByte)
*:ͨTWI0ȡӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻȡݵʼַ
*		u8 *pBuf: ȡݵĻַ
*		u8 Len: ȡݸ
*ز:
*************************************************************************************/
void TWI0_StartReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	EE_TWI0.EEMode=EE_MODE_READ;
	EE_TWI0.EEDataBuf=pBuf;
	EE_TWI0.EEDeviceAddr=DevAddr;
	EE_TWI0.EEDataAddr=RegStartAddr;
	EE_TWI0.EEDataLength=Len;
	EE_TWI0.EEStatus=EE_SEND_START;
	// start TWI0
	TWI0OvTime=IIC_OVTIME_MAX;
	TWI0_SendSTART();	
}

void TWI0_TestProc(void)
{
	u8 i;
	
	if(EE_TWI0.EEStatus==EE_IDLE)
	{
		if(TWI0TestTime==0)
		{
			LED_R=0;
			if(EE_TWI0.EEMode!=EE_MODE_WRITE)
			{ // ʼд
				SendStr("\nTWI0 Write EEPROM Start...");
				SendHex(TWI0TestAddr.B.BHigh);
				SendHex(TWI0TestAddr.B.BLow);
				i=0;
				for(i=0;i<DATA_LENGTH;i++)
				{
					TWI0WriteBuf[i]=i+rand;
					i++;
				}
				TWI0_StartWriteBuf(I2C_SLAVE_ADDR, TWI0TestAddr.W, &TWI0WriteBuf[0],DATA_LENGTH);
			}
			else
			{
				SendStr("\nTWI0 Read EEPROM Start...");
				SendHex(TWI0TestAddr.B.BHigh);
				SendHex(TWI0TestAddr.B.BLow);
				TWI0_StartReadBuf(I2C_SLAVE_ADDR, TWI0TestAddr.W, &TWI0ReadBuf[0],DATA_LENGTH);
				TWI0TestAddr.W=TWI0TestAddr.W+DATA_LENGTH;
				if(TWI0TestAddr.W>=0x1000)
				{
					TWI0TestAddr.W=0;
				}
			}
		}
	}
	else if(EE_TWI0.EEStatus==EE_SEND_STOP)
	{ // IIC
		LED_R=1;
		TWI0TestTime=TWI0_TEST_INTERVAL_TIME;
		if(EE_TWI0.EEFlag != EE_SUCCESS)
		{
			SendStr("\nTWI0 Err: 0x");
			SendHex(EE_TWI0.EEFlag);
		}
		else
		{
			if(EE_TWI0.EEMode==EE_MODE_READ)
			{
				for(i=0;i<DATA_LENGTH;i++)
				{
					if(TWI0WriteBuf[i]!=TWI0ReadBuf[i]) break;
				}
				if(i>=DATA_LENGTH)
				{// Уɹ
					SendStr("\nTWI0 WR Success!!");
					for(i=0;i<6;i++)
					{
						LED_R=!LED_R;
						DelayXms(30);
					
					}
				}
				else
				{// Уʧ
					SendStr("\nTWI0 Verify Fail!! 0x");
					SendHex(i);
				}
			}	
			else
			{
				SendStr("\nTWI0 Wrtie Done!");
				DelayXms(5);
				TWI0TestTime=0;
			}
		}
		EE_TWI0.EEStatus=EE_IDLE;
	}
	else
	{
		if(TWI0OvTime==0)
		{ // IICʱ
			LED_R=1;
			SendStr("\nTWI0 Fail-->TWI0_Reset..");
			InitTWI0();
			EE_TWI0.EEStatus=EE_IDLE;
			EE_TWI0.EEMode=EE_MODE_READ;
			TWI0TestTime=TWI0_TEST_INTERVAL_TIME;
		}
	}
}

void main()
{
    InitSystem();
	
 	SendStr("\nStart");
	LED_R=0;
	DelayXms(1000);
	LED_R=1;

	rand = 0x80;

	TWI0TestAddr.W=0x0000;
	EE_TWI0.EEStatus=EE_IDLE;
	EE_TWI0.EEMode=EE_MODE_READ;
	TWI0TestTime=TWI0_TEST_INTERVAL_TIME;

	
    while(1)
    {
		rand++;
		TWI0_TestProc();
    }
}


