/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			UART1жϷͼ
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27


#define UART1_RX_BUFF_SIZE   32   		 //ֽ
#define UART1_TX_BUFF_SIZE   32   		 //ֽ
xdata u8 RcvBuf[UART1_RX_BUFF_SIZE];
u8 Uart1RxIn =0;
u8 Uart1RxOut =0;
xdata u8 TxBuf[UART1_TX_BUFF_SIZE];
u8 Uart1TxIn =0;
u8 Uart1TxOut =0;
bit bUart1TxFlag;

u8 LedTime;

/***********************************************************************************
*:   void INT_UART1(void)
*:UART1 жϷ
		 
*:   
*:     
*************************************************************************************/
void INT_UART1(void) interrupt INT_VECTOR_UART1
{
	_push_(SFRPI);		   //SFRPIĴֵ

	SFR_SetPage(1);		   /*1ҳĴ*/  //S1CON1ҳ
	if(TI1)					//ж
	{
	   TI1 = 0;	   
		if(Uart1TxIn==Uart1TxOut)
		{
			bUart1TxFlag=FALSE;
		}
		else
		{
			S1BUF=TxBuf[Uart1TxOut];
			bUart1TxFlag=TRUE;
			Uart1TxOut++;
			if(Uart1TxOut>=UART1_TX_BUFF_SIZE)
			{
				Uart1TxOut=0;
			}
		}
	}
	if(RI1)					//ж
	{
		RI1 = 0;				//жϱ־
		RcvBuf[Uart1RxIn] = S1BUF;
		Uart1RxIn++;
		if(Uart1RxIn >=UART1_RX_BUFF_SIZE)
		{
			Uart1RxIn =0;
		}
		
	}
	_pop_(SFRPI);		   //ָSFRPIĴֵ
}

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;

	if(LedTime!=0) LedTime--;
}

/***********************************************************************************
*:void Uart1SendByte(u8 tByte)
*:Uart1
*:u8 tByte: ͵
*:     
*************************************************************************************/
void Uart1SendByte(u8 tByte)
{
	u8 i;
	
	if(bUart1TxFlag==FALSE)
	{
		Uart1TxOut=0;
		Uart1TxIn=1;
		TxBuf[0]=tByte;
		SFR_SetPage(1);
        TI1=1;
        SFR_SetPage(0);
	}
	else
	{
		i=Uart1TxIn;
		TxBuf[i]=tByte;
		i++;
		if(i>=UART1_TX_BUFF_SIZE)
		{
			i=0;
		}
		while(i==Uart1TxOut)
		{
		}
		INT_DisUART1();
		Uart1TxIn=i;
		INT_EnUART1();
	}
}

/***********************************************************************************
*:void Uart1SendStr(BYTE* PStr)
*:Uart1ַ
*: u8* PStr:ַʼַ
*:     
*************************************************************************************/
void Uart1SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		Uart1SendByte(*PStr);
		PStr ++;
	}
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);				//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();			// ʹ P24,P25,P26,P27 
	PORT_SetP1OpenDrain(BIT2|BIT3);			// P12,P13Ϊ©ģʽ
	PORT_EnP10P11P12P13PullHigh();			// ʹP10~P13
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();			//	ʹT0ж
	INT_EnUART1();			//	ʹܴж
	
}	

/***********************************************************************************
*:   void InitUart1(void)
*:   Uart1ʼ(115200)RX:P34 TX:P35
*:   
*:     
*************************************************************************************/
void InitUart1(void)
{
	UART1_SetMode8bitUARTVar();								// 8λ ɱ䲨

	UART1_EnS1BRG();										//ʹS1BRGʷ
	UART1_SetBaudRateX2();									//ʹ˫
	UART1_SetRxTxP12P13();									//ôʹţRX:P12 TX:P13
	UART1_EnReception();									//ʹܴڽչ
	UART1_SetS1BRGSelSYSCLK();								//S1BRGʱԴΪϵͳʱӣ1T

	UART1_SetS1BRGValue(S1BRG_BRGRL_9600_2X_12000000_1T);	//S1BRGֵֵ
	
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();	
				
	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitTimer0();
	InitUart1();
	InitInterrupt();
}

void main()
{
	InitSystem();

	
	Uart1RxIn=0;
	Uart1RxOut=0;
	Uart1TxIn=0;
	Uart1TxOut=0;
	bUart1TxFlag=0;
	
	INT_EnAll();			//  ʹȫж
	
	LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;
	DelayXms(500);
	
	Uart1SendStr("Start!\n");


	while(1)
	{
		if(LedTime==0)
		{
			LedTime=100;
		     LED_G_0 = !LED_G_0;
		}
		if(Uart1RxIn != Uart1RxOut)
		{
			Uart1SendByte(RcvBuf[Uart1RxOut]);
			Uart1RxOut++;
			if(Uart1RxOut>=UART1_RX_BUFF_SIZE)
			{
				Uart1RxOut=0;
			}
		}

	}

}


