/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			0ģʽ4 (SPIģʽ)
*			SPICLK <-->TXD	P31
*			MOSI   <-->RXD  P30
*			MISO   <-->S0MI P32
*			NSS	   <-->     P33
*	ע
*
*    ʱ:
*    ޸־:
*    
**********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define SPI_NSS		P33


// ѡSPICLK ʼƽ
#define SPICLK_LOW	0	// SPICLK  ʼΪ͵ƽ
#define SPICLK_HIGH	1	// SPICLK  ʼΪ͵ƽ
#define SPI_CPOL  SPICLK_LOW	

// ѡݴ˳
#define LSB	0	// λ
#define MSB	1	// λ
#define SPI_DORD	MSB

// ѡSPI Ĵٶ
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);				//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();			// ʹ P24,P25,P26,P27 
	PORT_SetP3PushPull(BIT0|BIT1|BIT3);		// P30,P31,P33Ϊ,P31(SPICLK),P30(MOSI),P33(nSS)
	PORT_SetP3QuasiBi(BIT2);				// P32Ϊ˫,MISO
}

/***********************************************************************************
*:   BYTE Uart0SPITransceiver(BYTE ToSend)
*:   SPIͺ
*:   BYTE ToSend
*:     
*************************************************************************************/
BYTE Uart0SPITransceiver(BYTE ToSend)
{
#if (SPI_CPOL==SPICLK_LOW)									
	P31 = 0;					// SPICLK  ʼΪ͵ƽ
#else	
	P31 = 1;					// SPICLK  ʼΪߵƽ
#endif
	S0BUF=ToSend;
	while(TI0==0);
	TI0=0;
	return S0BUF;
}

/***********************************************************************************
*:   void InitUart0_SPI_Master(void)
*:   Uart0ʼ SPI Master
*:   
*:     
*************************************************************************************/
void InitUart0_SPI_Master(void)
{
#if (SPI_CPOL==SPICLK_LOW)									
	P31 = 0;					// SPICLK  ʼΪ͵ƽ
#else	
	P31 = 1;					// SPICLK  ʼΪߵƽ
#endif
	UART0_SetModeSPIMaster();			// ôSPIģʽ
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART0_SetSPIClock_SYSCLKDiv4();		// SPIʱΪϵͳʱӵ4Ƶ
#else
	UART0_SetSPIClock_SYSCLKDiv12();	// SPIʱΪϵͳʱӵ12Ƶ
#endif

#if (SPI_DORD==MSB)
	UART0_SetDataMSB();
#else
	UART0_SetDataLSB();
#endif

	
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart0_SPI_Master();
}

void main()
{
	InitSystem();
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;	
		SPI_NSS=0;
		Uart0SPITransceiver(0x05);	
		SPI_NSS=1;
	}

}


