/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=24MHz, SysCLK=48MHz
*	
*			ѡXTALSysClk,CpuClk
*	ע
*	
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		48000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
//#define MCU_CPUCLK		(MCU_SYSCLK)
#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define _ENABLE_CKM_		// ʹܱƵ

u8 LedTime;

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TF0 = 0;
	TR0 = 0;
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;
	TR0 = 1;
	
	if(LedTime!=0) LedTime--;

}

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

#ifndef _ENABLE_CKM_
/***********************************************************************************
*:   void InitClock_Xtal(void)
*:   ʱӳʼ,ʹⲿ	
*:   
*:     
*************************************************************************************/
void InitClock_Xtal(void)
{
	// Enable XTAL,Enable IHRCO, MCK=OSCin, OSCin=IHRCO
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|ENABLE_IHRCO|MCK_OSCin|OSCIn_IHRCO);
	DelayXms(2);
	// Wait for XTAL stanby
	while((CKCON1&XTOR)==0);
	DelayXms(2);
	PCON1=MCDF;		// MCDF
	// Enable XTAL,Enable IHRCO, MCK=OSCin, OSCin=XTAL
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|ENABLE_IHRCO|MCK_OSCin|OSCIn_XTAL);
	DelayXms(2);
	// Enable XTAL,Disable IHRCO, MCK=OSCin, OSCin=XTAL
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|DISABLE_IHRCO|MCK_OSCin|OSCIn_XTAL);

}

#else
/***********************************************************************************
*:   void InitClock_Xtal_CKM(void)
*:   ʱӳʼ,ʹⲿ,ʹܱƵ
*:   
*:     
*************************************************************************************/
void InitClock_Xtal_CKM(void)
{
	// CpuCLK=SysCLK/2,  SysCLK=MCKDO, Enable CKM, CKMI=OSCin/2	
	CLK_SetCKCON0(CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);

	// Enable XTAL,Enable IHRCO, MCK=OSCin, OSCin=IHRCO
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|ENABLE_IHRCO|MCK_OSCin|OSCIn_IHRCO);
	DelayXms(2);
	// Wait for XTAL stanby
	while((CKCON1&XTOR)==0);
	DelayXms(2);
	PCON1=MCDF;		// MCDF
	// Enable XTAL,Enable IHRCO, MCK=OSCin, OSCin=XTAL
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|ENABLE_IHRCO|MCK_OSCin|OSCIn_XTAL);
	DelayXms(2);
	// Enable XTAL,Disable IHRCO, MCK=CKMIx8, OSCin=XTAL
	CLK_SetCKCON2(GAIN_FOR_2M_25M|ENABLE_XTAL|DISABLE_IHRCO|MCK_CKMI_X8|OSCIn_XTAL);
}

#endif

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(BIT4|BIT5|BIT6|BIT7);			// P24,P25,P26,P27 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 

	PORT_SetP2PushPull(BIT2);							// P22 Ϊ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ	
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitUart0_S1BRG(void)
*:   Uart0ʼ ,ʹS1BRGΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1
	UART0_SetBRGFromS1BRG();			// òԴΪ S1BRG
	UART0_SetS1BRGBaudRateX1();			// 2x
	UART1_SetS1BRGSelSYSCLK();			// S1BRGʱΪSysclk

    // ò
	UART1_SetS1BRGValue(S1BRG_BRGRL_9600_1X_48000000_1T);
	
	UART1_EnS1BRG();					// S1BRGʱ
}

/***********************************************************************************
*:   void InitPCA_PWM(void)
*:   PCAʼ
*:   
*:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_SYSCLK();							// PCAʱΪSysClk
	
	PCA_CH0_SetMode_PWM();

	PCA_CH0_SetPWM_8Bit();

	PCA_SetPWM_EdgeAligned();						// ض

	// PWMռձȱȽֵ
	PCA_CH0_SetValue_L(0x80); 				
	PCA_CH0_SetValue_9thBit_L_0();					// 9λ
	PCA_CH0_SetValue_H(0x80);						// ֵ
	PCA_CH0_SetValue_9thBit_H_0();					// 9λ


	// ü
	PCA_SetCounter(0);
	PCA_SetCounterReload(0);

	PCA_EnPCACounter();								// ʹPCA
	
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	IE=0;EIE1=0;								// жʹ
	INT_EnTIMER0();								// ʹܶʱ0ж

	SFIE=0x00;									// SFIE
	INT_EnSF_MCD();								// ʹMCDFʱӶʧ
	
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
#ifndef _ENABLE_CKM_
	InitClock_Xtal();
#else
	InitClock_Xtal_CKM();
#endif
	InitUart0_S1BRG();
	InitPCA_PWM();
	InitTimer0();
	InitInterrupt();
}

void main()
{

    InitSystem();
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
	printf("\nHello...Clock Xtal...");

	LedTime=200;
	
	INT_EnAll();

    while(1)
    {
		if(LedTime==0)
		{
			LedTime=200;
			LED_G_0=!LED_G_0;
			printf("\nSysTik 200ms");
		}
		
		if((PCON1&MCDF)!=0)
		{
			if((CKCON1&XTOR)!=0)
			{
				#ifndef _ENABLE_CKM_
					InitClock_Xtal();
				#else
					InitClock_Xtal_CKM();
				#endif
				
				PWMCR=PWMCR&(~PFCF);	// PFCF,ָPWM
			}
		}
    }
}
