/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=24MHz, SysCLK=48MHz
*	
*			SPI(nSS/P14,MOSI/P15,MISO/P16,SPICLK/P17) дFlash
*			SPIΪ12MHz
*	ע
*
*    ʱ:
*    ޸־:
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		48000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
//#define MCU_CPUCLK		(MCU_SYSCLK)
#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26

#define SPI_nSS		P14


// SPI
#define FLASH_ID					0x00C22016L					// MX25L3206

#define Dummy_Data					0xFF
#define FLASH_BLOCK_SIZE			(64L*1024L)					// 64K Byte

#define FLASH_TEST_START_ADDRESS	0x00000000
#define FLASH_TEST_SIZE_MAX			(1024L*1024L)				// 1M Byte

#define TEST_BUF_SIZE				512
xdata u8 TestBuf[TEST_BUF_SIZE];
u16 TestBufCnt;

u8	SPIOvTime;

/***********************************************************************************
* :   void INT_T2(void)
*:T2 жϷ
*		 10ms
*:   
*ز:     
*************************************************************************************/
void INT_T2(void) interrupt INT_VECTOR_T2
{
	if(TF2)
	{
		TF2=0;
		if(SPIOvTime!=0) SPIOvTime--;
	}
	if(EXF2)
	{
		EXF2=0;
	}
}


/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
* :void SendByte(u8 tByte)
*:0
*: u8 tByte: ͵
*ز:     
*************************************************************************************/
void SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}



/***********************************************************************************
* :void SendStr(BYTE* PStr)
*:ַ
*: u8* PStr:ַʼַ
*ز:     
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
* :   void SendHex(u8 ToSend)
*:ַʽ16
*: u8 ToSend: ͵16  
*ز:     
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
//	SendByte(' ');
//	SendByte('0');
//	SendByte('x');
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/***********************************************************************************
* :   void SendDW2DEC(u8 ToSend)
*:10
*: u32 ToSend: ͵16 (4ֽ) 
*ز:     
*************************************************************************************/
void SendDW2DEC(u32 ToSend)
{
	bit bFlag;
	u8 x;
	bFlag=0;
	x=ToSend/1000000000L;
	ToSend=ToSend%1000000000L;
	if(x!=0)
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100000000L;
	ToSend=ToSend%100000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000000L;
	ToSend=ToSend%10000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000000L;
	ToSend=ToSend%1000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100000L;
	ToSend=ToSend%100000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000L;
	ToSend=ToSend%10000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000L;
	ToSend=ToSend%1000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
		SendByte(',');
	}
	
	x=ToSend/100L;
	ToSend=ToSend%100L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend%10L;
	SendByte('0'+x);
		
}

/***********************************************************************************
* :   void ResetCounter()
*:ü
*:  
*ز:     
*************************************************************************************/
void ResetCounter()
{
	// رT0,T1
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	TM_SetT0HighByte(0);
	TM_SetT0LowByte(0);
	TM_SetT1HighByte(0);
	TM_SetT1LowByte(0);
	// ʹT0,T1
	TM_GlobalStart(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
}
/***********************************************************************************
* :   void SendCounter()
*:
*:  
*ز:     
*************************************************************************************/
void SendCounter()
{
	DWordTypeDef dwTime;
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	dwTime.B.BHigh=TH0;
	dwTime.B.BMHigh=TL0;
	dwTime.B.BMLow=TH1;
	dwTime.B.BLow=TL1;
	SendStr("\nTIME: ");
	SendDW2DEC(dwTime.DW);
	SendStr("us");
}

/***********************************************************************************
* :   void InitUart0_S0BRG(void)
*:   Uart0ʼ ,ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART0
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLKdiv12();		// S0BRGʱΪSysclk/12

    // ò
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_48000000_12T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
* :   void InitTimer0(void)
*:Timer0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_T1OF();					// T0ʱԴΪ T1OF
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ
	//TM_EnableT0();						// ʹT0
}

/***********************************************************************************
* :   void InitTimer1(void)
*:Timer1ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_1_16BIT_TIMER();			// T1ģʽΪ16λģʽ
	TM_SetT1Clock_SYSCLKDiv48();			// T1ʱԴΪ SYSCLK/48
	TM_SetT1Gate_Disable();
	TM_SetT1LowByte(0);						// T18λ
	TM_SetT1HighByte(0);					// T18λ
	//TM_EnableT1();						// ʹT1
}

/***********************************************************************************
* :   void InitTimer2(void)
*:Timer2ʼ	
*:   
*ز:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_AutoRLandExI();			// T2ģʽ0Ϊ16λԶغⲿжģʽ
	TM_SetT2Clock_SYSCLKDiv12();			// T2ʱԴΪ SYSCLK/12
	
	TM_SetT2LowByte(TIMER_12T_10ms_TL);		// T28λ
	TM_SetT2HighByte(TIMER_12T_10ms_TH);		// T28λ
	TM_SetT2RLHighByte(TIMER_12T_10ms_TH);	// ֵ8λ
	TM_SetT2RLLowByte(TIMER_12T_10ms_TL);	// ֵ8λ
	TM_EnableT2();							// ʹT2

	
}

/***********************************************************************************
* :   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER2();
	
}

/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);		//  P22,P24,P26 Ϊ LED
	
	PORT_SetP3PushPull(BIT3);			//  P33 Ϊ nSS
	PORT_SetP1PushPull(BIT4|BIT5|BIT7);	// P14(nSS),P15(MOSI),P17(SPICLK)Ϊ׼˫
	PORT_SetP1OpenDrainPu(BIT6);	// P16(MISO)Ϊ׼˫
}


/***********************************************************************************
* :   void InitClock(void)
*:  
*		ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}


/***********************************************************************************
* :   void InitSPI_Master(void)
*:   SPIʼ
*:   
*ز:     
*************************************************************************************/
void InitSPI_Master(void)
{
	SPI_Enable();										// ʹSPI
	SPI_SelectMASTERByMSTRbit();						// MASTER
	SPI_SetClock(SPI_CLK_SYSCLK_4);						// SPIʱ SYSCLK/8 48M/4=12M
	SPI_SetCPOL_0();									// SPICLKʼƽ CPOL=0 ͵ƽ
	SPI_SetDataMSB();									// ݴλ MSB λǰ
	SPI_SetCPHA_0();									// ò͸ıģʽ CPHA=0 ǰز,ظı
	SPI_SetUseP14P15P16P17();							// IO nSS/P14,MOSI/P15,MISO/P16,SPICLK/P17
}

/***********************************************************************************
* :   u8 SPITransceiver(u8 ToSend)
*:   SPIģʽշ
*:   u8 SPI_DATA: ͵
*ز:   u8 :յ  
*************************************************************************************/
u8 SPITransceiver(u8 SPI_DATA)
{
	SPI_SendData(SPI_DATA);							// SPI 
	while(SPI_ChkCompleteFlag()==0);				// ȴSPI
	SPI_ClearCompleteFlag();						// SPI ɱ־
	return SPI_GetData();							// ؽյ
}

/*
*************************************************************************************
*  SPI FLASH
*
*************************************************************************************
*/


/***********************************************************************************
* :	void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u32 Length)
*:	ȡFlashַָĶBYTE 
*
*:	  u32 Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
*		  u8 *BufferAddreass: 洢ȡݵĻַ
*		  u16 Length: ȡݵĳ
*ز: 
*************************************************************************************/
void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u16 Length)
{
	SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    while(Length !=0)
	{
		*BufferAddreass=SPITransceiver(Dummy_Data);
        BufferAddreass ++;
        Length--;
	}
	SPI_nSS = 1;
}

/***********************************************************************************
* :	u32 SPI_Flash_Read_ID (void)
*:	ȡFlash ID 

*:	
*ز: uint32_t ȡID 
*************************************************************************************/
u32 SPI_Flash_Read_ID (void)
{
	DWordTypeDef RDAT;
    
    SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x9F);
    
    /* Read ID */
    RDAT.B.BMHigh=SPITransceiver(Dummy_Data);
    RDAT.B.BMLow=SPITransceiver(Dummy_Data);
    RDAT.B.BLow=SPITransceiver(Dummy_Data);
	SPI_nSS  = 1;
    
    return RDAT.DW;
}

/***********************************************************************************
* :	u8 SPI_Flash_Write_Enable (void)
*: ʹдFlash

*:	
*ز: 0: ɹ  other:ʧ
*************************************************************************************/
u8 SPI_Flash_Write_Enable(void)
{
	u8 RDAT;

	// óʱʱ 2*10=20ms
    SPIOvTime=2;
  Re_Flash_Write_Enable:
    /* Write enable */
	SPI_nSS  = 0;
	SPITransceiver(0x06);
	SPI_nSS  = 1;

	nop();
	nop();
	nop();
	
    /* Read status register */
	SPI_nSS  = 0;
	SPITransceiver(0x05);			//RDSR
   
	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data

	SPI_nSS  = 1;
	
    /* Check WEL == 1 */
	if((RDAT & 0x02) == 0x00)
	{
		if(SPIOvTime!=0)
		{
			goto Re_Flash_Write_Enable;
		}
		else
		{ // ʱ
			return 1;
		}
	}
	else
	{
		return 0;
	}
}

/***********************************************************************************
* :	u8 SPI_Flash_Check_Busy(void)
*:	FlashǷæ

*:	
*ز: 0: Free  1:busy
*************************************************************************************/
u8 SPI_Flash_Check_Busy(void)
{
	u8 RDAT;
    
    
    /* Read status register */
	SPI_nSS  = 0;
	SPITransceiver(0x05);							//RDSR

	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data
	
    /* Check erase or write complete */
	SPI_nSS  = 1;
	if((RDAT & 0x01) == 0x01)			//WIP, write in progress
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/***********************************************************************************
*:		void SPI_Flash_Write_Status(u8 uStatus)
*:	Write status

*:			u8 uStatus:status

*ز: 
*************************************************************************************/ 
void SPI_Flash_Write_Status(u8 uStatus)
{
    SPI_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver(0x01);                           // д״̬Ĵ(WRSR)  
                
	
    /* Write Status */
    SPITransceiver(uStatus);
	
	SPI_nSS  = 1;
}


/***********************************************************************************
* :	u8 SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
*:	Flash д

*:	u32 Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
*		  u8 *DataSource: дݻʼַ. 
*		  u16 Length: дݳ, 256ֽ
*ز: 0: ɹ  other:ʧ
*************************************************************************************/ 
u8 SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
{
    if(SPI_Flash_Write_Enable()==1)
    {
		return 1;
    }
    
	SPI_nSS  = 0;
	SPITransceiver( 0x02);                               // Write command 
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	while(Length!=0)                                            // Write Data
	{
		SPITransceiver(*DataSource);
        DataSource++;
		Length--;
	}
	
	SPI_nSS  = 1;
	
	// óʱʱ 2*10=20ms
    SPIOvTime=2;
  	while(SPIOvTime!=0)
  	{
		if(SPI_Flash_Check_Busy()==0)                                       // Wait program complete
		{
			return 0;
		}
	}
	return 2;
}

/***********************************************************************************
* :	u8 SPI_Flash_Block_Erase(u32 Addr)
*:	Flash 

*:	u32 Addr: ҪBlock ĵַ.
*ز: 0: ɹ  other:ʧ
*************************************************************************************/ 
u8 SPI_Flash_Block_Erase(u32 Addr)
{
    if(SPI_Flash_Write_Enable()==1)
    {
		return 1;
    }
    
	SPI_nSS  = 0;
	SPITransceiver(0xD8);                               			// Block Erase command 
                
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	SPI_nSS  = 1;
   
	// óʱʱ 210*10=2.1s
    SPIOvTime=210;
  	while(SPIOvTime!=0)
  	{
		if(SPI_Flash_Check_Busy()==0)                                // Wait Block Erase complete
		{
			return 0;
		}
	}
	return 2;
}


/*
*************************************************************************************
*/ 


/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitSPI_Master();
	InitUart0_S0BRG();
	InitTimer0();
	InitTimer1();
	InitTimer2();
	InitInterrupt();
}


void main()
{
	u32 i;
	bit bOK;
	DWordTypeDef dwTemp;
	
    InitSystem();

    INT_EnAll();
	
	SendStr("\nHello!");
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=0;LED_G_1=1;LED_R=1;

	
	
	dwTemp.DW=SPI_Flash_Read_ID();
	SendStr("\nFlash ID: ");
	SendHex(dwTemp.B.BMHigh);
	SendHex(dwTemp.B.BMLow);
	SendHex(dwTemp.B.BLow);

	// Clear д
	SPI_Flash_Write_Status(0x00);

	if(dwTemp.DW == FLASH_ID)
	{
		bOK=TRUE;
		// 
		SendStr("\nFlash Erase...");
		i=FLASH_TEST_SIZE_MAX/FLASH_BLOCK_SIZE;
		// Flash
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_G_1 = !LED_G_1;
			if(SPI_Flash_Block_Erase(dwTemp.DW)!=0)
			{
				bOK=FALSE;
				break;
			}
			dwTemp.DW=dwTemp.DW+FLASH_BLOCK_SIZE;
			i--;
		}
		SendCounter();
		for(i=0;i<256;i++)
		{
			TestBuf[i]=i;
		}
		// дFlash
		SendStr("\nFlash Write 1M");
		i=FLASH_TEST_SIZE_MAX/256;		
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_G_1 = !LED_G_1;
			if(SPI_Flash_Page_Program(dwTemp.DW,&TestBuf[0],256)!=0)
			{
				bOK=FALSE;
				break;
			}
			dwTemp.DW=dwTemp.DW+256;
			i--;
		}
		SendCounter();
		// Flash
		SendStr("\nFlash Read 1M");
		i=FLASH_TEST_SIZE_MAX/512;		
		dwTemp.DW=FLASH_TEST_START_ADDRESS;
		ResetCounter();
		while(i!=0)
		{
			LED_G_1 = !LED_G_1;
			SPI_Flash_MultiBytesRead(dwTemp.DW,&TestBuf[0],512);
			dwTemp.DW=dwTemp.DW+512;
			i--;
		}
		SendCounter();
	}
	else
	{
		SendStr("\nFlash isn't MX25L3206! ");
		bOK=FALSE;
	}
	while(1)
	{
		DelayXms(100);
		if(bOK)
		{
			LED_G_0 = !LED_G_0;
		}
		else
		{
			LED_R = !LED_R;
		}
	}
	
}


