/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			CPUCLK=SYSCLK (12M)
*			PCAʱ: SYSCLK
*			CH0(P22)/CH1(P33),CH2(P24)/CH3(P34),CH4(P26)/CH5(P35)
*			6·,ض,ֱΪ8bit 256
*			PWMƵ: PCAClk/(256)=12MHz/256=46.875KHz
*
*			P10ΪPWMP10=1:  P10=0: 
*	ע
*
*    ʱ:
*    ޸־:
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26

idata WordTypeDef wDuty[6];

/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);				// P22(CEX0),P24(CEX2),P26(CEX4)Ϊ
	PORT_SetP3PushPull(BIT3|BIT4|BIT5);				// P33(CEX1),P34(CEX3),P35(CEX5)Ϊ

	P10=1;
	PORT_SetP1OpenDrainPu(BIT0);					// P10Ϊ©,ڿ
}


/***********************************************************************************
* :   void InitPCA_PWM(void)
*:   PCAʼ
*:   
*ز:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_SYSCLK();			// PCAʱΪSysClk = 12MHz
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();
	PCA_CH4_SetMode_PWM();
	PCA_CH5_SetMode_PWM();

	PCA_CH0_SetPWM_8Bit();
	PCA_CH1_SetPWM_8Bit();
	PCA_CH2_SetPWM_8Bit();
	PCA_CH3_SetPWM_8Bit();
	PCA_CH4_SetPWM_8Bit();
	PCA_CH5_SetPWM_8Bit();

	// PWMռձȱȽֵ
	PCA_CH0_SetValue_L(0); 				
	PCA_CH0_SetValue_9thBit_L_0();		// 9λ
	PCA_CH0_SetValue_H(0);				// ֵ
	PCA_CH0_SetValue_9thBit_H_0();		// 9λ

	PCA_CH1_SetValue_L(0); 				
	PCA_CH1_SetValue_9thBit_L_0();		// 9λ
	PCA_CH1_SetValue_H(0);				// ֵ
	PCA_CH1_SetValue_9thBit_H_0();		// 9λ

	PCA_CH2_SetValue_L(0); 				
	PCA_CH2_SetValue_9thBit_L_0();		// 9λ
	PCA_CH2_SetValue_H(0);				// ֵ
	PCA_CH2_SetValue_9thBit_H_0();		// 9λ

	PCA_CH3_SetValue_L(0); 				
	PCA_CH3_SetValue_9thBit_L_0();		// 9λ
	PCA_CH3_SetValue_H(0);				// ֵ
	PCA_CH3_SetValue_9thBit_H_0();		// 9λ

	PCA_CH4_SetValue_L(0); 				
	PCA_CH4_SetValue_9thBit_L_0();		// 9λ
	PCA_CH4_SetValue_H(0);				// ֵ
	PCA_CH4_SetValue_9thBit_H_0();		// 9λ

	PCA_CH5_SetValue_L(0); 				
	PCA_CH5_SetValue_9thBit_L_0();		// 9λ
	PCA_CH5_SetValue_H(0);				// ֵ
	PCA_CH5_SetValue_9thBit_H_0();		// 9λ
	
	// ü
	PCA_SetCounter(0);
	PCA_SetCounterReload(0);

	// ֹPWM
	PCA_SetPWM0_DisOutput();					
	PCA_SetPWM1_DisOutput();
	PCA_SetPWM2_DisOutput();
	PCA_SetPWM3_DisOutput();
	PCA_SetPWM4_DisOutput();
	PCA_SetPWM5_DisOutput();

	PCA_SetCEX0CEX2CEX4_P22P24P26();	// CEX0:P22,CEX2:P24,CEX4:P26

	PCA_CF_DisInterrupt();				// ֹCFж

	PCA_EnPCACounter();					// ʹPCA, 
}

/***********************************************************************************
* :   void InitClock(void)
*:  
*		ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}




/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPCA_PWM();

}


void main()
{
	u8 cnt,inx;
	bit bOutFlag;

    InitSystem();

	LED_G_0=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

	wDuty[0].W=0x0000;
	wDuty[1].W=0x0000;
	wDuty[2].W=0x0000;
	wDuty[3].W=0x0000;
	wDuty[4].W=0x0000;
	wDuty[5].W=0x0000;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	if(bOutFlag==TRUE)
			{
		   		inx++;
		    	if(inx>=8)
				{
					inx=0;
				}
		    	switch(inx)
				{
					case 0:
						// ռձ100% ȫߵƽ	
						wDuty[0].W=0x0000;
						wDuty[1].W=0x0000;
						wDuty[2].W=0x0000;
						wDuty[3].W=0x0000;
						wDuty[4].W=0x0000;
						wDuty[5].W=0x0000;
						break;

					case 1:
						// ռձ75% 	
						wDuty[0].W=0x0040;
						wDuty[1].W=0x0040;
						wDuty[2].W=0x0040;
						wDuty[3].W=0x0040;
						wDuty[4].W=0x0040;
						wDuty[5].W=0x0040;
						break;

					case 2:
						// ռձ50% 	
						wDuty[0].W=0x0080;
						wDuty[1].W=0x0080;
						wDuty[2].W=0x0080;
						wDuty[3].W=0x0080;
						wDuty[4].W=0x0080;
						wDuty[5].W=0x0080;
						break;

					case 3:
						// ռձ25% 	
						wDuty[0].W=0x00C0;
						wDuty[1].W=0x00C0;
						wDuty[2].W=0x00C0;
						wDuty[3].W=0x00C0;
						wDuty[4].W=0x00C0;
						wDuty[5].W=0x00C0;
						break;
						
					case 4:
						// ռձ0% 	 ȫ͵ƽ
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						wDuty[2].W=0x0100;
						wDuty[3].W=0x0100;
						wDuty[4].W=0x0100;
						wDuty[5].W=0x0100;
						break;

					case 5:
						// ռձ25% 	
						wDuty[0].W=0x00C0;
						wDuty[1].W=0x00C0;
						wDuty[2].W=0x00C0;
						wDuty[3].W=0x00C0;
						wDuty[4].W=0x00C0;
						wDuty[5].W=0x00C0;
						break;

					case 6:
						// ռձ50% 	
						wDuty[0].W=0x0080;
						wDuty[1].W=0x0080;
						wDuty[2].W=0x0080;
						wDuty[3].W=0x0080;
						wDuty[4].W=0x0080;
						wDuty[5].W=0x0080;
						break;

					case 7:
						// ռձ75% 	
						wDuty[0].W=0x0040;
						wDuty[1].W=0x0040;
						wDuty[2].W=0x0040;
						wDuty[3].W=0x0040;
						wDuty[4].W=0x0040;
						wDuty[5].W=0x0040;
						break;
						
		    	}
				PCA_CH0_SetValue_8Bit(wDuty[0].B.BHigh,wDuty[0].B.BLow);
				PCA_CH1_SetValue_8Bit(wDuty[1].B.BHigh,wDuty[1].B.BLow);
				PCA_CH2_SetValue_8Bit(wDuty[2].B.BHigh,wDuty[2].B.BLow);
				PCA_CH3_SetValue_8Bit(wDuty[3].B.BHigh,wDuty[3].B.BLow);
				PCA_CH4_SetValue_8Bit(wDuty[4].B.BHigh,wDuty[4].B.BLow);
				PCA_CH5_SetValue_8Bit(wDuty[5].B.BHigh,wDuty[5].B.BLow);
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				// ʹPWM
				PCA_SetPWM0_EnOutput();					
				PCA_SetPWM1_EnOutput();
				PCA_SetPWM2_EnOutput();
				PCA_SetPWM3_EnOutput();
				PCA_SetPWM4_EnOutput();
				PCA_SetPWM5_EnOutput();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				// ֹPWM
				PCA_SetPWM0_DisOutput();					
				PCA_SetPWM1_DisOutput();
				PCA_SetPWM2_DisOutput();
				PCA_SetPWM3_DisOutput();
				PCA_SetPWM4_DisOutput();
				PCA_SetPWM5_DisOutput();
			}
    	}
    }
}


