/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			RTCʱΪXTAL 32KHz
*			RTC Clock ԤƵ 32768
*			RTC ֵ (64-1)=63
*			RTCƵΪ 32000/32768/1 ~ 1Hz
*			ģʽ, RTC
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

#define IO_WAKE_KEY_0	P10
#define IO_WAKE_KEY_1	P30

u8 RtcCnt;

u8 WakeUpSorce;
enum{
	WAKE_BY_nINT0=0,
	WAKE_BY_nINT1,
	WAKE_BY_RTC,
};

/***********************************************************************************
*:   void INT_INT0(void)	
*:INT0жϷ
*:   
*ز:     
*************************************************************************************/
void INT_INT0(void)		interrupt INT_VECTOR_INT0
{
	WakeUpSorce=WAKE_BY_nINT0;
}

/***********************************************************************************
*:   void INT_INT1(void)	
*:INT1жϷ
*:   
*ز:     
*************************************************************************************/
void INT_INT1(void)		interrupt INT_VECTOR_INT1
{
	WakeUpSorce=WAKE_BY_nINT1;
}

/***********************************************************************************
*:   void INT_SF(void)
*:SF(ϵͳ־λ)жϷ
		 RTC,WDTF,BOD0F,BOD1F
*:   
*ز:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;
		RtcCnt++;
		WakeUpSorce=WAKE_BY_RTC;
	}
}


/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitINT0(void)
*:   INT0ʼ
*:   
*ز:     
*************************************************************************************/
void InitINT0(void)
{
	INT_SetINT0P30();						//INT0P10
	INT_SetINT0_DetectFallingEdge();		//INT0ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪƽ
	INT_SetINT0Filter_SysclkDiv6_x3();		//INT0˲Ϊsysclk/6*3
}

/***********************************************************************************
*:   void InitINT1(void)
*:   INT1ʼ
*:   
*ز:     
*************************************************************************************/
void InitINT1(void)
{
	INT_SetINT1P10();						//INT1P10
	INT_SetINT1_DetectFallingEdge();		//INT1ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪƽ
	INT_SetINT1Filter_SysclkDiv6_x3();		//INT1˲Ϊsysclk/6*3
}

/***********************************************************************************
*:   void InitRTC(void)
*:RTC ʼ	
*		RTCʱΪILRCO 32KHz
*		RTC Clock ԤƵ 32
*		RTC ֵ (64-1)=63
*		RTCƵΪ 32K/32768/1~=1Hz
*:   
*ز:     
*************************************************************************************/
void InitRTC(void)
{	
	RTC_Disable();
	RTC_SetClock_ILRCO();		// ѡRTCʱΪ ILRCO 32KHz
	RTC_SetClock_Div_32768();	// ѡRTC Clock ԤƵ 32768
	RTC_SetReload(64-1);		// RTC ֵ (64-1)=63
	RTC_SetCounter(64-1);

	RTC_ClearRTCF();			// RTCF
	RTC_Enable();				// ʹRTC
	
}


/***********************************************************************************
*:   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// ʹRTCж,ʹϵͳ־ж
	INT_EnSF();				// ʹϵͳ־ж

	
}


/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,LED
	PORT_SetP1OpenDrainPu(BIT0);				//  P10Ϊ©
	P10=1;
	P30=1;
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitRTC();		
	InitINT0();
	InitINT1();
	InitInterrupt();		// жϳʼ
	INT_EnAll();			// ʹȫж

}

/***********************************************************************************
*:   void McuPowerDownProc(void)
*:   ϵͳģʽ
*:   
*ز:     
*************************************************************************************/
void McuPowerDownProc(void)
{
	// ȴIOΪߵƽ
	while((IO_WAKE_KEY_0==0)||(IO_WAKE_KEY_1==0))
	{
		CLRWDT();
		DelayXus(100);
	}
	INT_EnINT0();							//	ʹINT0ж
	INT_EnINT1();							//	ʹINT1ж
	INT_EnAll();				// ж
PD_LOOP:
	POW_SetMode_PD();											// ʹMCUģʽ
	// Ѻ,ȽRTCжϴ,֮ٷش˴
	_nop_();
	if(WakeUpSorce==WAKE_BY_RTC)
	{
		goto PD_LOOP;
	}
	else
	{
		INT_DisINT0();							//	ֹINT0ж
		INT_DisINT1();							//	ֹINT1ж
	}
}


void main()
{
	u8 i;
	
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
		LED_G_0=1;LED_G_1=1;LED_R=1;
		McuPowerDownProc();
		for(i=0;i<50;i++)
		{
			DelayXms(100);
			if(WakeUpSorce==WAKE_BY_nINT0)
			{
				LED_G_0=!LED_G_0;
			}
			else
			{
				LED_G_1=!LED_G_1;
			}
		}
    }
}

