/**
  ******************************************************************************
 *
 * @file        Sample_MID_IWDT_Period.c
 *
 * @brief       The sample code of IWDT period into interrupt
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_IWDT_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Sample_MID_IWDT_Period(void);

/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       IWDT period into interrupt.
 * @details     1.Initial IWDT
 *    \n        2.Initial clock.
 *    \n        3.ENABLE SYS_INT_IEA
 * @return      None
 *******************************************************************************
 */
void Sample_MID_IWDT_Period(void)
{
    IWDT_HandleTypeDef mIWDT;
    
    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //CK_LS clock can from ILRCO or external XTAL
    //Please open "Manage Run Time Environment",then enable IWDT IRQ in MG32_IRQ_Handler.
    //===ENABLE SYS_INT_IEA===
    //Enable SYS_IEA
    // ------------------------------------------------------------------------
    // 1.Initial IWDT. 
    // ------------------------------------------------------------------------
    mIWDT.Instance = IWDT;                                                        //Mapping IWDT base address
    mIWDT.Init.Interrupt = (IWDT_IT_EW1|IWDT_IT_EW0|IWDT_IT_TIE);                 //ENABLE IWDT
    mIWDT.Init.Prescaler = IWDT_PRESCALER_256;
    if (MID_IWDT_Init(&mIWDT) != MID_OK)
    {
        IWDT_Error_Handler(&mIWDT);
    }
}

