/**
  ******************************************************************************
 *
 * @file        Sample_WWDT_WakeUp_Init.c
 *
 * @brief       WWDT Wake Up sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2024/06/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_WWDT_WakeUp_Init (void);
void WWDT_IRQ (void);
void WWDT_IRQHandler(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief  	    Sample WWDT Wake Up init
 * @details     1. Enable CSC to WWDT clock
 *      \n      2. WWDT module clock divider select
 *      \n      3. WWDT module wake up enable
 *      \n      4. WWDT module counter setting
 *      \n      5. WWDT module function enable
 *      \n      6. Refresh WWDT Counter
 * @return	    None	
 * @note        
 * @par         Example
 * @code
    Sample_WWDT_WakeUp_Init();
 * @endcode
 *******************************************************************************
 */
void Sample_WWDT_WakeUp_Init(void)
{
    UnProtectModuleReg(WWDTprotect);
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12Mz
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->IWDT = Enable

    /*=== 1. Enable CSC to IWDT clock ===*/
//    UnProtectModuleReg(CSCprotect);                                 // Unprotect CSC module
//    CSC_PeriphOnModeClock_Config(CSC_ON_WWDT, ENABLE);              // Enable IWDT module clock
//    CSC_PeriphSTOPModeClock_Config(CSC_SLP_WWDT, ENABLE);           // IWDT SLEEP mode module clock enable.
//    ProtectModuleReg(CSCprotect);                                   // protect CSC module
    
    /*=== 2. WWDT module clock divider select. ===*/
    WWDT_CLK_Select(WWDT_CK_UT);
    WWDT_DIV_Select(WWDT_DIV_1);
    WWDT_PDIV_Select(WWDT_PDIV_1);
    
    /*=== 3. WWDT module wake up enable. ===*/
    WWDT_IT_Config(WWDT_INT_TF, ENABLE);
    #if !defined(MG32_WWDT_IRQ_)
        NVIC_EnableIRQ(WWDT_IRQn);
        NVIC_SetPriority(WWDT_IRQn,0);
    #endif
    
    /*=== 4. WWDT module counter setting. ===*/
    WWDT_SetReloadReg(0x3FF);
    WWDT_SetWindowThreshold(0x10);
    WWDT_SetWarningThreshold(0x0FF);
    
    /*=== 5. WWDT module function enable. ===*/
    WWDT_Cmd(ENABLE);
    
    /*=== 6. Refresh WWDT Counter. ===*/
    WWDT_RefreshCounter();
    
    ProtectModuleReg(WWDTprotect);
    
    SLEEP_WFI();
}

/**
 *******************************************************************************
 * @brief       WWDT IRQ Handler
 * @details     
 *      \n      
 * @return	    None	
 * @note        
 * @par         Example
 * @code
            WWDT_IRQHandler();
 * @endcode
 *******************************************************************************
 */
void WWDT_IRQHandler(void)
{
    
    WWDT_IRQ();
    
}

/**
 *******************************************************************************
 * @brief  	    Sample WWDT Wake Up init
 * @details     1. Enable CSC to IWDT clock
 *      \n      2. IWDT module clock divider select
 *      \n      3. Enable IWDT module
 *      \n      4. IWDT Wake Up Enable
 *      \n      5. IWDT Interrupt Enable
 * @return	    None	
 * @note        
 * @par         Example
 * @code
    Sample_WWDT_WakeUp_Init();
 * @endcode
 *******************************************************************************
 */
__weak void WWDT_IRQ(void)
{
    if(WWDT_GetSingleFlagStatus(WWDT_WRNF)==DRV_Happened)
    {
        WWDT_ClearFlag(WWDT_WRNF);
    }
    if(WWDT_GetSingleFlagStatus(WWDT_WINF)==DRV_Happened)
    {
        WWDT_ClearFlag(WWDT_WINF);
    }
    if(WWDT_GetSingleFlagStatus(WWDT_TF)==DRV_Happened)
    {
        WWDT_ClearFlag(WWDT_TF);
    }
}




