/**
  ******************************************************************************
 *
 * @file        Sample_APB_NCO.c
 *
 * @brief       Control NCO peripheral output.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/25
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_APB_DRV.h"


/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***

// ----------------------------------------------------------------------------
//  <o0> NCO input clock source select. 
//      <0=> CK_IHRCO 
//      <1=> CL_PLL 
//      <2=> CK_APB
//      <3=> CK_LS
//      <4=> TM00_TRGO
//      <5=> NCO_CK0 (input pin)
#define NCOClock        0

// ----------------------------------------------------------------------------
//  <o0> NCO output mode <0=>FDC mode <1=>PFM mode  
#define NCOOutputMode   0  

// ----------------------------------------------------------------------------
//  <o0> Inverse NCO output <1=>ENABLE <0=>DISABLE
#define InverseNCO      0    

// ----------------------------------------------------------------------------
//  <o0> input range from 0 to 1048575 (2^20 - 1)
#define NCOINCVal       1000

// ----------------------------------------------------------------------------
//  <o0> APB NCO PFM width select (only support PFM mode)
//      <0=> 1 CK_NCOn clock period 
//      <1=> 2 CK_NCOn clock period 
//      <2=> 4 CK_NCOn clock period 
//      <3=> 8 CK_NCOn clock period 
//      <4=> 16 CK_NCOn clock period 
//      <5=> 32 CK_NCOn clock period 
//      <6=> 64 CK_NCOn clock period 
//      <7=> 128 CK_NCOn clock period
#define NCO_PFMWidth    7

//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_APB_NCO(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    Initial NCO peripheral.
 * @details     Initial NCO with start it.
 * @return		None
 *******************************************************************************
 */
void Sample_APB_NCO(void)
{  
    
    // make sure :
	
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->APB = Enable
	
    //==Set GPIO init 
    //NCO_P0 pin config:
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOB->PB3
    //GPIO port initial is 0xFFFF
    //PB3 mode is PPO
    //PB3 function NCO_P0


    // ------------------------------------------------------------------------
    // initial NCO
    APB_NCOClockSource_Select((APB_NCOInputClockSrcDef) NCOClock);
    APB_NCOOutputMode_Select((APB_NCOOutputMode) NCOOutputMode);
    APB_NCOInverseOutput_Cmd((FunctionalState) InverseNCO);
    
    APB_NCOPFMWidth_Select((APB_NCOPFMWidtrhSelDef) NCO_PFMWidth);
    
    APB_NCOSetINC(NCOINCVal);
    APB_NCOSetACC(999);
    
    APB_NCO_Cmd(ENABLE);
        
    return;
}




