



/**
 ******************************************************************************
 *
 * @file        Sample_URT0_SPIFlash.h
 * @brief       Use URT of MG32 to control MX25R512F (SPI Flash) standard read / write. 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/08/18
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



#ifndef _TST_FLASH_H
#define _TST_FLASH_H


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_GPIO_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
#define FLASH_SECTOR_ERASE          0x20          /*!< 1 sector = 4K bytes*/
#define FLASH_BLOCK32K_ERASE        0x52
#define FLASH_BLOCK64K_ERASE        0xD8
#define FLASH_CHIP_ERASE            0x60

/**
 * @name	============== Flash control parameter ==============
 *   		
 */ 
///@{
/*! @enum   Flash_ERASE_TypeDef
    @brief  The Flash Erase type.
*/
typedef enum
{
    FLASH_ERASE_SECTOR   = FLASH_SECTOR_ERASE,    /*!< Erase type = Sector(4K byte) erase..*/
    FLASH_ERASE_BLOCK32K = FLASH_BLOCK32K_ERASE,  /*!< Erase type = 32K byte block erase.*/
    FLASH_ERASE_BLOCK64K = FLASH_BLOCK64K_ERASE,  /*!< Erase type = 64K byte block erase.*/
    FLASH_ERASE_CHIP     = FLASH_CHIP_ERASE,      /*!< Erase type = Chip erase.*/
}Flash_ERASE_TypeDef; 
    
    
/*! @struct FlashCTR_TypeDef  
    @brief  Flash data control. 
*/  
typedef struct  
{ 
    uint8_t               *pBuffer;               /*!< Pointer of program data buffer*/
    uint8_t               *rBuffer;               /*!< Pointer of recevie buffer.*/
    ctype                 Address;                /*!< Control Flash address.*/
    uint32_t              Total_Length;           /*!< To control Flash read and write total address.*/
    uint32_t              BLen;                   /*!< To control Flash write bytes in a time.*/
    uint32_t              DataCnt;                /*!< Use for Flash read and write operation parameter.*/
}FlashCTR_TypeDef;
///@}

/* Private define ------------------------------------------------------------*/
/**
 * @name	========MG32 Peripheral Define ==============
 *   		
 */ 
///@{
#define Flash_nCS                   PD0           /*!< Define software nCS Pin. */
#define URTX                        URT0          /*!< Use the URTX's SPI mode to control SPI flash . */
///@}

/**
 * @name	============== MX25R512F Command ==============
 *   		
 */ 
///@{
#define FLASH_NORMAL_READ           0x03
#define FLASH_FAST_READ             0x0B

#define FLASH_2IO_READ              0xBB
#define FLASH_1I_2O_READ            0x3B
#define FLASH_4IO_READ              0xEB
#define FLASH_1I_4O_Read            0x6B

#define FLASH_PAGE_PROGRAM          0x02
#define FLASH_QUADPAGE_PROGRAM      0x38

#define FLASH_SFDP_READ             0x5A
#define FLASH_WRITE_ENABLE          0x06
#define FLASH_WRITE_DISABLE         0x04
#define FLASH_READ_STATUS           0x05
#define FLASH_READ_CONFIGURATION    0x15
#define FLASH_WRITE_STATUS          0x01
#define FLASH_SUSPEND_PROGRAM       0x75
#define FLASH_SUSPEND_ERASE         0xB0
#define FLASH_RESUMES_PROGRAM       0x7A
#define FLASH_RESUMES_REASE         0xB0
#define FLASH_DEEP_POWER_DOWN       0xB9
#define FLASH_SET_BURST_LENGTH      0xC0
#define FLASH_READ_IDENTIFICATION   0x9F          /*!< Read Manufacturer ID + Memory type + Memory density.*/
#define FLASH_READ_ELECTRONIC_ID    0xAB          /*!< Read Electronic ID. */
#define FLASH_READ_REMS             0x90          /*!< Read Manufacturer & Device ID. */
#define FLASH_ENTER_SECURED_OTP     0xB1
#define FLASH_EXIT_SECURED_OTP      0xC1
#define FLASH_READ_SECURITY_REG     0x2B
#define FLASH_WRITE_SECURITY_REG    0x2F
#define FLASH_NOP                   0x00
#define FLASH_RESET_ENABLE          0x66
#define FLAHS_RESET_MEMORY          0x99
///@}
    
#define FLASH_nCS_ACTIVE            0             /*!< Define polarity (nCS = Active).*/
#define FLASH_nCS_NoACTIVE          1             /*!< Define polarity (nCS = No Active).*/ 
            
#define FLASH_MAXSIZE               64*1024       /*!< Flash max size. */                                                                    
#define FLASH_PROGRAM_MAX           256           /*!< Define Flash program max bytes  in one write enable.*/ 
            
#define Flash_Dummy_Data            0xFFFFFFFF    /*!< Define DUMMY Data. */
            
            
#define FLASH_RDID_CMP              0x1028C2      /*!< Manufacturer ID  + Memory type + Memory density.*/
#define FLASH_RES_CMP               0x10          /*!< Electronic ID.*/
#define FLASH_REMS_CMP              0xC210        /*!< Manufacturer ID + Device ID.*/
    

/* Private macro -------------------------------------------------------------*/
#define Sample_Flash_ReadData()                   Sample_URT_ReadData()
#define Sample_Flash_SetData(DATALEN, FLAHSDATA)  Sample_URT_SetData(DATALEN,FLAHSDATA)
        
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/**
 * @name	============== Flash sample function ==============
 *   		
 */ 
///@{
void Sample_URT_SetData(uint8_t DataLen , uint32_t FlashData);  /*!< URT SPI mode send data.*/
uint8_t Sample_URT_ReadData(void);                              /*!< URT SPI mode read data.*/
void Sample_URT_WriteFlash_Cmd(FunctionalState WREN);           /*!< Flash write control.*/
void Sample_URT_CheckFlashBusy(void);                           /*!< Check flash busy.*/
    
void Sample_URT_SPIMode_Init(void);                             /*!< URT inital*/
uint32_t Sample_URT_ReadFlashRDID(void);                        /*!< Read Flash ID.*/
uint16_t Sample_URT_ReadFlashRDCR(void);                        /*!< Control Flash register.*/
void Sample_URT_EraseFlash (Flash_ERASE_TypeDef  , uint32_t);   /*!< Control flash to erase .*/   
void Sample_URT_ReadFlash(FlashCTR_TypeDef*);                   /*!< Read Flash data.*/
void Sample_URT_ProgramFlash(FlashCTR_TypeDef*);                /*!< Program data to flash.*/
    
void Sample_URT_MX25R512FFlash(void);                           /*!< Flash sample code.*/
///@}

/* External vairables --------------------------------------------------------*/
extern FlashCTR_TypeDef Flash0;
extern uint8_t Sample_URT_ProgramFlashBuffer[10];
extern uint8_t Sample_URT_ReadFlashBuffer[10];


#endif



