/**
 ******************************************************************************
 *
 * @file        Sample_RTC_PerpetualCalendar.h
 *
 * @brief       This file contains all the functions prototypes for the RTC  
 *              perpetual calendar firmware library.
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2025/06/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_PerpetualCalendar_H

/*!< _MG32_ADC_DRV_H */ 
#define _MG32_PerpetualCalendar_H


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32__Common_DRV.h"
#include "MG32_RTC_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/** 
 * @enum		SMP_MonthDef
 * @brief		declare month 
 */        
typedef enum
{
    January     = 1,
    February    = 2,
    March       = 3,
    April       = 4,
    May         = 5,
    June        = 6,
    July        = 7,
    August      = 8,
    September   = 9,
    October     = 10,
    November    = 11,
    December    = 12
    
} SMP_MonthDef;

/** 
 * @enum		SMP_WeekendDef
 * @brief		declare weekend 
 */        
typedef enum
{
    Sunday      ,
    Monday      ,
    Tuesday     ,
    Wednesday   ,
    Thursday    ,
    Friday      ,
    Saturday    ,
} SMP_WeekendDef;

/** 
 * @enum		SMP_isLeapYearDef
 * @brief		check this year for leap year 
 */        
typedef enum
{
    LeapYear,
    NotLeapYear,
} SMP_isLeapYearDef;


/** 
 * @struct  SMP_PerpetualCalendarDef
 * @brief   declare struct for Perpetual Calendar 
 */        
typedef struct __attribute__((packed))
{ 
    uint32_t year;          /*!< Specifies the year */
    
    SMP_MonthDef month;        /*!< Specifies the month. Please reference SMP_MonthDef enum.*/                         
                                              
    SMP_WeekendDef weekend;    /*!< Specifies weekend. Please reference SMP_WeekendDef enum. */   
    
    uint8_t day;            /*!< Specifies the day number of month. */    
    
    uint8_t hour;           /*!< Specifies the hour of 24 hours a day */
    
    uint8_t minute;         /*!< Specifies minute */
                                                                                                    
    uint8_t second;         /*!< Specifies second */   
    
} SMP_PerpetualCalendarDef;   

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/**
 * @name	Function announce
 *   		
 */ 
///@{  
SMP_isLeapYearDef CAL_isLeapYear ( SMP_PerpetualCalendarDef *RTC_Calendar);
void CAL_FillYMD ( SMP_PerpetualCalendarDef *RTC_Calendar, uint32_t days );
void CAL_getWeekday(SMP_PerpetualCalendarDef *RTC_Calendar);
DRV_Return Sample_RTC_PerpetualCalendar_Init(SMP_PerpetualCalendarDef *RTC_Calendar);
DRV_Return Sample_RTC_CaptureConvert(SMP_PerpetualCalendarDef *RTC_Calendar);

///@}

/* External vairables --------------------------------------------------------*/

#endif
