

/**
 ******************************************************************************
 *
 * @file        TH222x_17_2ColorDotMatrixLED.c
 * @brief       This is to test TH222x 2 color dot matrix LED C file.
                
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_17_2ColorDotMatrixLED.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_2ColorMatrixLED_UpdateFlag;

static uint8_t  TH222x_2ColorMatrixLED_Table[8][8];
static uint8_t  TH222x_DotMatrixLED_DramaAct;
static uint8_t  TH222x_DotMatrixLED_DramaActMax;
static uint16_t TH222x_DotMatrixLED_DramaTime;
static uint16_t TH222x_DotMatrixLED_DramaTimeMax;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	 TH222x 2 color dot matrix LED parameter default initial. 
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_2ColorDotMatrixParameter_DeInit(void)
{
    uint8_t *TH222x_2ColorDotMatrix_clrBuf;
    uint8_t TH222x_2ColorDotMatrix_clrTmp;
    
    TH222x_2ColorMatrixLED_UpdateFlag = 0;
    TH222x_DotMatrixLED_DramaAct      = 0;
    TH222x_DotMatrixLED_DramaActMax   = 16;
    TH222x_DotMatrixLED_DramaTime     = 0;
    TH222x_DotMatrixLED_DramaTimeMax  = 500;
    

    TH222x_2ColorDotMatrix_clrBuf = &TH222x_2ColorMatrixLED_Table[0][0];
    
    for(TH222x_2ColorDotMatrix_clrTmp=0;TH222x_2ColorDotMatrix_clrTmp<64;TH222x_2ColorDotMatrix_clrTmp++)
    {
        TH222x_2ColorDotMatrix_clrBuf[TH222x_2ColorDotMatrix_clrTmp] = 0;
    }
}
/**
 *******************************************************************************
 * @brief	 TH222x 2 color dot matrix LED main function.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_2ColorDotMatrix(void)
{
    if( TH222x_2ColorMatrixLED_UpdateFlag == 0)
    {
        return;
    }
    TH222x_2ColorMatrixLED_UpdateFlag = 0;
    

    BSP_2ColorDotMatrixLED_main();

    
    /*Refresh Frame*/
    if( TH222x_DotMatrixLED_DramaTime < TH222x_DotMatrixLED_DramaTimeMax)
    {
        TH222x_DotMatrixLED_DramaTime = TH222x_DotMatrixLED_DramaTime + 1;
        return;
    }
    TH222x_DotMatrixLED_DramaTime = 0;
    
    switch(TH222x_DotMatrixLED_DramaAct)
    {
        case 0:
                TH222x_2ColorMatrixLED_Table[0][0] = 1;
                TH222x_2ColorMatrixLED_Table[7][0] = 1;
                TH222x_2ColorMatrixLED_Table[0][7] = 2;
                TH222x_2ColorMatrixLED_Table[7][7] = 2;
                break;
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:     
                TH222x_2ColorMatrixLED_Table[0][TH222x_DotMatrixLED_DramaAct] = 1;
                TH222x_2ColorMatrixLED_Table[7][TH222x_DotMatrixLED_DramaAct] = 1;            
                TH222x_2ColorMatrixLED_Table[0][(TH222x_DotMatrixLED_DramaAct-1)] = 0;
                TH222x_2ColorMatrixLED_Table[7][(TH222x_DotMatrixLED_DramaAct-1)] = 0;
        
                TH222x_2ColorMatrixLED_Table[0][(7-TH222x_DotMatrixLED_DramaAct)] = 2;
                TH222x_2ColorMatrixLED_Table[7][(7-TH222x_DotMatrixLED_DramaAct)] = 2;
                TH222x_2ColorMatrixLED_Table[0][(8-TH222x_DotMatrixLED_DramaAct)] = 0;
                TH222x_2ColorMatrixLED_Table[7][(8-TH222x_DotMatrixLED_DramaAct)] = 0;
                break;
        case 8:
                TH222x_2ColorMatrixLED_Table[7][0] = 0;        
                TH222x_2ColorMatrixLED_Table[7][7] = 0;
                TH222x_2ColorMatrixLED_Table[0][0] = 1;
                TH222x_2ColorMatrixLED_Table[0][7] = 2;
                break;
        case 9:
        case 10:
        case 11:
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][0] = 0;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][7] = 0;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][0] = 1;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][7] = 2;
                break;
        case 12:
        case 13:
        case 14:
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][0] = 0;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-9)][7] = 0;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][0] = 2;
                TH222x_2ColorMatrixLED_Table[(TH222x_DotMatrixLED_DramaAct-8)][7] = 1;
                break;
        case 15:
        default:  
                TH222x_2ColorMatrixLED_Table[6][0] = 0;
                TH222x_2ColorMatrixLED_Table[6][7] = 0;            
                TH222x_2ColorMatrixLED_Table[7][0] = 2;
                TH222x_2ColorMatrixLED_Table[7][7] = 1;
                TH222x_DotMatrixLED_DramaAct = 0;
                break;
 
    }
    
    BSP_2ColorDotMatrixLED_RefreshFrame(&TH222x_2ColorMatrixLED_Table[0][0]);
    
    TH222x_DotMatrixLED_DramaAct = TH222x_DotMatrixLED_DramaAct + 1;
    if( TH222x_DotMatrixLED_DramaAct < TH222x_DotMatrixLED_DramaActMax)
    {
        return;
    }
    TH222x_DotMatrixLED_DramaAct = 0;
    
}

