

/**
 ******************************************************************************
 *
 * @file        TH222x_15_4x4Keyboard.c
 * @brief       This is to test TH222x 4x4 Keyboard C file.
                
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/05/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
 /* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_15_4x4Keyboard.h"
#if BSP_12_BLE == 1
    #if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_MG126
        #include "BSP_12_BLE_MG126.h"
    #endif
    #if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_HC06
        #include "BSP_12_BLE_HC06.h"
    #endif
    #if BSP_12_BLE_MODULE == BSP_12_BLE_MODULE_HC42
        #include "BSP_12_BLE_HC42.h"
    #endif
#endif

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_4x4Keyboard_UpdateFlag; 

static uint8_t TH222x_4x4Keyboard_StatusCmp[KEY_BUFFER_MAX];

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	 TH222x 4x4 Keyboard main function. 
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_4x4KeyboardParameter_DeInit(void)
{    
    uint8_t TH222x_4x4KB_DeInitTmp;
    
    TH222x_4x4Keyboard_UpdateFlag = 0;
    
    for(TH222x_4x4KB_DeInitTmp=0;TH222x_4x4KB_DeInitTmp < KEY_BUFFER_MAX;TH222x_4x4KB_DeInitTmp++)
    {
        TH222x_4x4Keyboard_StatusCmp[TH222x_4x4KB_DeInitTmp] = 0;
    }
}
/**
 *******************************************************************************
 * @brief	 TH222x 4x4 Keyboard main function. 
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_4x4Keyboard(void)
{
    uint8_t TH222x_4x4KB_Tmp;
    uint8_t TH222x_4x4KB_Tmp2;
    
    if(TH222x_4x4Keyboard_UpdateFlag==0)
    {
        return;
    }
    TH222x_4x4Keyboard_UpdateFlag = 0;
    
    BSP_4X4Keyboard_main();
    
    if( KB_CTR.KeybufferChangeFlag == 0)
    {
        return;
    }
    KB_CTR.KeybufferChangeFlag = 0;
    TH222x_4x4KB_Tmp2          = 0;
    
    for( TH222x_4x4KB_Tmp = 0; TH222x_4x4KB_Tmp < KEY_BUFFER_MAX; TH222x_4x4KB_Tmp++)
    {
        if( TH222x_4x4Keyboard_StatusCmp[TH222x_4x4KB_Tmp] !=
            KB_CTR.Keybuffer[TH222x_4x4KB_Tmp])
        {
            if( TH222x_4x4Keyboard_StatusCmp[TH222x_4x4KB_Tmp]==0)
            {
                TH222x_4x4KB_Tmp2 = 1;
                //If BLE module enable update to BLE.
                #if BSP_12_BLE == 1
                    TH222x_BLE_WriteTxBuffer(&KB_CTR.Keybuffer[TH222x_4x4KB_Tmp], 1);
                #endif
            }
            TH222x_4x4Keyboard_StatusCmp[TH222x_4x4KB_Tmp] = KB_CTR.Keybuffer[TH222x_4x4KB_Tmp];
        }         
    }
    
    TH222x_CTR.RLED_Count = TH222x_CTR.LED_CountMax;
    TH222x_CTR.GLED_Count = TH222x_CTR.LED_CountMax;
    
    if(TH222x_4x4KB_Tmp2==1)
    {
        TH222x_CTR.YLED_Lock  = 1;
        TH222x_CTR.YLED_Count = 0;
    }
    else
    {
        TH222x_CTR.YLED_Count = TH222x_CTR.LED_CountMax;
    }
}










