/**
 ******************************************************************************
 *
 * @file        onIRAM1.c
 * @brief       MG32 demo onIRAM1 c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/11/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "onIRAM1.h"

/* External vairables --------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void onIRAM1_Func1(void);    // Normal in IRAM1
void onIRAM1_Func2(void);    // Normal in IRAM1
void onIRAM1_Func3(void);    // Normal in IRAM1


/* Private user code ---------------------------------------------------------*/


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIRAM1.
  * @retval None
  *******************************************************************************
  */
void onIRAM1(void)
{
    printf("    onIRAM1\n\r");

    onIRAM1_Func1();
    onIRAM1_Func2();
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIRAM1 Func1.
  * @retval None
  *******************************************************************************
  */
void onIRAM1_Func1(void)
{
    __NOP();
    printf("      onIRAM1_Func1\n\r");

}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIRAM1 Func2.
  * @retval None
  *******************************************************************************
  */
void onIRAM1_Func2(void)
{
    __NOP();
    printf("      onIRAM1_Func2\n\r");
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIRAM1 Func3.
  * @retval None
  *******************************************************************************
  */
void onIRAM1_Func3(void)
{
    __NOP();
    printf("      onIRAM1_Func3\n\r");
}


