

/**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/11/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


//                                                                                                                                                
//                                  Physical            Relocated Boot      AP Flash            IAP Flash           IAP Flash           ISP Flash
//                                  Flash Memory        Memory Space                            IAP Size 62KB       IAP Size 126KB                
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------
//  |                           |   0x0001FFFF                                                                                          0x1C0007FF
//  |  ISP Flash 2KByte         |                                                                                                                 
//  |                           |   0x0001F800                                                                                          0x1C000000
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------
//  |                           |   0x0001F7FF          0x0001F7FF          0x1801F7FF          0x1A01F7FF          0x1A01F7FF                    
//  |  IAP Flash 4KByte         |                                                                                                                 
//  |                           |   0x0001E800          0x0001E800          0x1801E800          0x1A01E800          0x1A01E800                    
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------
//  |                           |   0x0001E7FF          0x0001E7FF          0x1801E7FF          0x1A01E7FF          0x1A01E7FF                    
//  |                           |                                                                                                                 
//  |  IAP Flash 58KByte        |                                                                                                                 
//  |                           |                                                                                                                 
//  |                           |   0x00010000          0x00010000          0x18010000          0x1A010000          0x1A010000                    
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------
//  |                           |   0x0000FFFF          0x0000FFFF          0x1800FFFF                              0x1A00FFFF                    
//  |  AP Flash 6KByte(IROM2)   |                                                                                                                 
//  |                           |   0x0000E800          0x0000E800          0x1800E800                              0x1A00E800                    
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------
//  |                           |   0x0000E7FF          0x0000E7FF          0x1800E7FF                              0x1A00E7FF                    
//  |                           |                                                                                                                 
//  |  AP Flash 58KByte(IROM1)  |                                                                                                                 
//  |                           |                                                                                                                 
//  |                           |   0x00000000          0x0000E7FF          0x1800E7FF                              0x1A000000                    
//  -----------------------------   -----------------------------------------------------------------------------------------------------------------


//                                    
//                          SRAM
//  ----------------------------------
//  |                   |   0x20003FFF
//  |   2KByte(IRAM2)   |             
//  |                   |   0x20003800
//  ----------------------------------
//  |                   |   0x200037FF
//  |                   |             
//  |  14KByte(IRAM1)   |     
//  |                   |             
//  |                   |   0x20000000
//  ----------------------------------


/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "MG32_ChipInit.h"

/* External vairables --------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Xmain(void)__attribute__((section(".ARM. __at_0x00003800")));
void main_Ext(void);

/* Private user code ---------------------------------------------------------*/
/**
  *******************************************************************************
  * @brief  This function is executed in case of main.
  * @retval None
  *******************************************************************************
  */
int main(void)
{
  // --------------------------------------------------------------------------
  // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
  // --------------------------------------------------------------------------
    ChipInit();

  //---------------------------------------------------------------------------
    printf("%c[2J",27);
    printf("%c[H",27);
    printf("CPU Clock 48MHz\n\r");
    printf("Baud Rate 480000Hz\n\r");
    printf("Initial Ready \n\r");

  //---------------------------------------------------------------------------
    onIROM1();          // Normal in IROM1

    onIROM2();          // Normal in IROM2

  //---------------------------------------------------------------------------
    onIRAM1();          // Normal in IRAM1

    onIRAM2();          // Normal in IRAM2

  //---------------------------------------------------------------------------
    Function();         // Function Addess by __attribute__ Assign

    while(1)
    {
        //To do......
        Error_Handler();
    }
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of main_Ext.
  * @retval None
  *******************************************************************************
  */
void main_Ext(void)
{
    __NOP();
    printf("    main Ext\n\r");
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  *******************************************************************************
  */
void Error_Handler(void)
{
    /* USER CODE BEGIN Error_Handler_Debug */
    /* User can add his own implementation to report the HAL error return state */
    __disable_irq();
    while (1)
    {
    }
    /* USER CODE END Error_Handler_Debug */
}


