/**
 ******************************************************************************
 *
 * @file        Function.c
 * @brief       MG32 demo Function c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/11/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "Function.h"

/* External vairables --------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Function(void);         // Normal

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Function_Func1(void)__attribute__((section(".ARM.__at_0x00003800"))); // Assign to IROM1 0x03800
void Function_Func2(void)__attribute__((section(".ARM.__at_0x0001C000"))); // Assign to IROM1 0x1C000
void Function_Func3(void)__attribute__((section(".ARM.__at_0x20000000"))); // Assign to IRMA1 Space
void Function_Func4(void)__attribute__((section(".ARM.__at_0x20003800"))); // Assign to IRMA2 Space

/* Private user code ---------------------------------------------------------*/
/**
  *******************************************************************************
  * @brief  This function is executed in case of Function.
  * @retval None
  *******************************************************************************
  */
void Function(void)
{
    uint32_t lTemp32 = 0;
    printf("    Function\n\r");

    lTemp32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTemp32 --;
    }while(lTemp32 != 0);

    Function_Func1();
    Function_Func2();
    Function_Func3();
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of Function Func1.
  * @retval None
  *******************************************************************************
  */
void Function_Func1(void)
{
    uint32_t lTempZ32 = 0;
    printf("      Function_Func1\n\r");

    lTempZ32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempZ32 --;
    }while(lTempZ32 != 0);
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of Function Func2.
  * @retval None
  *******************************************************************************
  */
void Function_Func2(void)
{
    uint32_t lTempY32 = 0;
    printf("      Function_Func2\n\r");

    lTempY32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempY32 --;
    }while(lTempY32 != 0);
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of Function Func3.
  * @retval None
  *******************************************************************************
  */
void Function_Func3(void)
{
    uint32_t lTempX32 = 0;
    printf("      Function_Func3\n\r");

    lTempX32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempX32 --;
    }while(lTempX32 != 0);
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of Function Func4.
  * @retval None
  *******************************************************************************
  */
void Function_Func4(void)
{
    uint32_t lTempX32 = 0;
    printf("      Function_Func4\n\r");

    lTempX32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempX32 --;
    }while(lTempX32 != 0);
}


