
/**
 ******************************************************************************
 *
 * @file        MG32_ARGB_WS2812.h
 * @brief      The code is Using URT of MG32 to control ARGB 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef __MG32_ARGB_H
#define __MG32_ARGB_H
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32.h" 
#include "MG32_ChipInit.h"
#include "MG32_APX.h"
 
/* Wizard menu ---------------------------------------------------------------*/
/* Typedef -------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define SMP_ARGB_PIECE            14                   /*!< Sample 14 pieces ARGB (The define can not to equal 1 )*/
#define SMP_ARGB_COLLOR_MAX       50                   /*!< The ARGB sample code max color.*/ 
                                                       
#define SMP_ARGB_DATASIZE         3                    
#define SMP_ARGB_G                0                    /*!< ARGB green color data shift.*/
#define SMP_ARGB_R                1                    /*!< ARGB red color data shift.*/
#define SMP_ARGB_B                2                    /*!< ARGB bule color data shift.*/
                                                       
#define SMP_ARGB_DEFAULT_COLOR    6                    /*!< Total Color setting.*/



/**
 * @name ARGB state information
 *   		
 */ 
///@{
#define ARGB_RESET                0x00  /*!< ARGB handle status is reset.*/
#define ARGB_READY                0x10  /*!< ARGB handle status is ready.*/
#define ARGB_BUSY                 0x11  /*!< ARGB handle status is busy.*/
#define ARGB_FAIL                 0x80  /*!< ARGB initial fail.*/
///@}


/* Macro ---------------------------------------------------------------------*/
/* Variables -----------------------------------------------------------------*/
/* Function prototypes -------------------------------------------------------*/
void MG32_ARGB_Main(void);

/* Exported variables --------------------------------------------------------*/
extern uint8_t  SMP_ARGBDefault_TABLE[SMP_ARGB_DEFAULT_COLOR][3];

/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/



#endif


