/**
 ******************************************************************************
 *
 * @file        MG32_SPI.h
 *
 * @brief       MG32 SPI Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:38 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_SPI_H
#define _MG32_SPI_H
#define _MG32_SPI_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_SPI_H_VER)
    #error "_MG32_SPI_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      SPI_Struct
 *              SPI  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BUSYF         :1;     //[0] SPI data transfer busy flag.
            __I  uint8_t                :2;     //[2..1] 
            __IO uint8_t  IDLF          :1;     //[3] SPI slave mode NSS idle detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TCF           :1;     //[4] SPI transmission complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  RXDF          :1;     //[5] SPI received data byte number is different from previous received data byte number fo
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXF           :1;     //[6] SPI receive data register not empty
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXF           :1;     //[7] SPI transmit data register empty flag 
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  MODF          :1;     //[8] SPI mode detect fault flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WEF           :1;     //[9] SPI slave mode write error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ROVRF         :1;     //[10] SPI receive overrun flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TUDRF         :1;     //[11] SPI slave mode transmit underrun flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[12] 
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t  RX_LVL        :3;     //[18..16] SPI data buffer received level indications.
                                        //0x0 = 0 (0-byte,empty)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t  TX_LVL        :3;     //[22..20] SPI data buffer transmission remained level indications.
                                        //0x0 = 0 (0-byte,empty)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  RNUM          :3;     //[26..24] SPI received data byte number when data shadow buffer last transfer to SPI_RDAT regi
                                        //0x0 = 0 (0-byte)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :4;     //[30..27] 
            __I  uint8_t  IDL_STA       :1;     //[31] SPI idle state detect status for Slave with NSS mode.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  SPI status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] SPI interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[2..1] 
            __IO uint8_t  IDL_IE        :1;     //[3] SPI slave mode NSS idle detect interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TC_IE         :1;     //[4] SPI transmission complete interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  RX_IE         :1;     //[6] SPI Receive data register not empty interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_IE         :1;     //[7] SPI TX buffer underflow the threshold SPI_TX_TH Interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MODF_IE       :1;     //[8] SPI mode detect fault interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WE_IE         :1;     //[9] SPI slave mode write error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ROVR_IE       :1;     //[10] SPI RX buffer receive overrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TUDR_IE       :1;     //[11] SPI TX buffer transmit underrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[12] 
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :2;     //[15..14] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  SPI interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __IO uint8_t  CK_SEL        :2;     //[3..2] SPI internal clock CK_SPI source select.
                                        //0x0 = PROC : CK_SPI_PR process clock from CSC
                                        //0x1 = Reserved
                                        //0x2 = TM00_TRGO
                                        //0x3 = Reserved
            __IO uint8_t  CK_DIV        :2;     //[5..4] SPI internal clock CK_SPI_INT input divider.
                                        //0x0 = DIV2 : divided by 2
                                        //0x1 = DIV4 : divided by 4
                                        //0x2 = DIV8 : divided by 8
                                        //0x3 = DIV16 : divided by 16
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  CK_PSC        :3;     //[10..8] SPI internal clock CK_SPI_INT prescaler
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  CK_PDIV       :2;     //[13..12] SPI process clock CK_SPI_PR input divider. 
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[15..14] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  SPI clock source register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x0C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] SPI function enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CPOL          :1;     //[1] SPI clock polarity select. It is used to select the SPI clock level in idle state.
                                        //0 = Low
                                        //1 = High
            __IO uint8_t  CPHA          :1;     //[2] SPI clock phase select
                                        //0 = Leading edge
                                        //1 = Trailing edge
            __IO uint8_t  LSB_EN        :1;     //[3] SPI data order Lsb first enable. When disables , the Msb bit will be the first bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MDS           :2;     //[5..4] SPI operation mode select.
                                        //0x0 = Slave
                                        //0x1 = Master
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __IO uint8_t  IO_SWP2       :1;     //[6] SPI IO SPI_D0~3 and SPI_D4~7 signals swap enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IO_SWP        :1;     //[7] SPI I/O SPI_MOSI,SPI_MISO signals swap enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSO_EN       :1;     //[8] SPI_NSS signal output function enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSI_EN       :1;     //[9] SPI_NSS signal input function enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSI_SEL      :1;     //[10] SPI pin select for NSS input signal.
                                        //0 = NSS (SPI_NSS pin)
                                        //1 = NSSI (SPI_NSSI pin)
            __IO uint8_t  NSS_SWEN      :1;     //[11] SPI NSS signal output use software control bit enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSO_INV      :1;     //[12] SPI NSS output signal inverse enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSI_INV      :1;     //[13] SPI NSS input signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSS_PEN       :1;     //[14] SPI single master mode NSS pulse enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MODF_SEL      :1;     //[15] SPI function select when master mode fault detect. 
                                        //0 = SPI disable
                                        //1 = Switch to slave
            __I  uint8_t                :2;     //[17..16] 
            __IO uint8_t  RX_CTL        :1;     //[18] SPI master mode data receive sampling edge control bit
                                        //0 = Normal : SPI_CPHA selected clock edge
                                        //1 = Next : Next clock edge of SPI_CPHA selected edge
            __IO uint8_t  LBM_EN        :1;     //[19] Loop back mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSI_SWEN     :1;     //[20] SPI NSS input signal use software control bit enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DOUT_MDS      :1;     //[21] SPI master standard mode idle state data output mode select
                                        //0 = Disable : Output with tristate
                                        //1 = Enable : Output with driving
            __IO uint8_t  DOUT_IDL      :2;     //[23..22] SPI idle state data output value
                                        //0x0 = LBIT (Last data bit)
                                        //0x1 = Reserved
                                        //0x2 = 0 (Output 0)
                                        //0x3 = 1 (Output 1)
            __IO uint8_t  ADPX_EN       :1;     //[24] SPI slave mode auto full duplex data mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  HS_EN         :1;     //[25] SPI slave mode high speed function enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ASYNC_EN      :1;     //[26] SPI standard slave mode clock input asynchronous function enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SDT_EN        :1;     //[27] 
            __I  uint8_t                :1;     //[28] 
            __IO uint8_t  DMA_MDS       :1;     //[29] Direct memory access enable to do pre-catch one data for receive mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_RXEN      :1;     //[30] Direct memory access enable to receive
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_TXEN      :1;     //[31] Direct memory access enable to transmit
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  SPI control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __O  uint8_t  RDAT_CLR      :1;     //[0] SPI received data clear enable
                                        //0 = Disable
                                        //1 = Enable
            __O  uint8_t  TDAT_CLR      :1;     //[1] SPI transmitted data clear enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[7..2] 
            __I  uint8_t                :4;     //[11..8] 
            __I  uint8_t                :3;     //[14..12] 
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  NSS_IDT       :1;     //[16] SPI master mode idle cycle hardware NSS pulse time select.
                                        //0x0 = 1T
                                        //0x1 = 2T
            __I  uint8_t                :3;     //[19..17] 
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :2;     //[25..24] 
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  SPI control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RSB_TRG       :1;     //[0] SPI slave mode data read shadow buffer trigger to upload enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DTR_EN        :1;     //[1] Dual transfer rate mode enable bit for SPI master mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BDIR_OE       :1;     //[2] SPI data line Bidirectional output enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  COPY_EN       :1;     //[3] SPI data transfer copy mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DAT_LINE      :3;     //[6..4] SPI data line number select.
                                        //0x0 = SPI : 2-lines separated~ standard SPI mode)
                                        //0x1 = 1 : 1-line Bidirectional~ SPI_MOSI
                                        //0x2 = 2 : 2-lines Bidirectional~ SPI_D0(MOSI), SPI_D1(MISO)
                                        //0x3 = 4 : 4-lines Bidirectional~ SPI_D0 ~ SPI_D3
                                        //0x4 = 4D : 8-lines TX~ SPI_D0 ~ SPI_D3 with duplicate SPI_D4 ~ SPI_D7
                                        //0x5 = 8 : 8-lines Bidirectional~ SPI_D0 ~ SPI_D7
            __IO uint8_t  TX_DIS        :1;     //[7] SPI data line output disable
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  RX_TH         :2;     //[9..8] SPI received data buffer high threshold for slave mode
                                        //0x0 = 1-byte
                                        //0x1 = 2-byte (default)
                                        //0x2 = 3-byte
                                        //0x3 = 4-byte
            __I  uint8_t                :2;     //[11..10] 
            __I  uint8_t                :2;     //[13..12] 
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  DSIZE         :5;     //[20..16] SPI transfer data frame bit size from 4-bit to 32-bit
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  NSS_SWO       :1;     //[24] SPI NSS signal software output control bit when SPI_NSS_SWEN is enable
            __IO uint8_t  NSS_SWI       :1;     //[25] SPI NSS signal input control and status bit
            __IO uint8_t  TXUPD_EN      :1;     //[26] SPI slave mode transmitted data directly update enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CKO_TOG       :1;     //[27] SPI master mode clock output signal toggle enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CKO_MUX       :3;     //[30..28] SPI_CLK output signal select.
                                        //0x0 = SPI : SPI clock
                                        //0x1 = WE : EMB MWE signal
                                        //0x2 = OE : EMB MOE signal
                                        //0x3 = TM10 : TM10_CKO
                                        //0x4 = TM16 : TM16_CKO
                                        //0x5 = TM20 : TM20_CKO
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  SPI control register 2 */

    __I uint32_t  RESERVED1[5];         /*!< RESERVED1  ~ Offset[0x1C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t RDAT          :32;    //[31..0] SPI received data register
        }MBIT;
    }RDAT;                              /*!< RDAT       ~ Offset[0x30]  SPI data receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t TDAT          :32;    //[31..0] SPI transmitted data register
        }MBIT;
    }TDAT;                              /*!< TDAT       ~ Offset[0x34]  SPI data transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __O  uint32_t TDAT3         :24;    //[23..0] SPI transmitted data register for 3-byte data write only
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }TDAT3;                             /*!< TDAT3      ~ Offset[0x38]  SPI TX data 3-byte register */

} SPI_Struct;

/**
 ******************************************************************************
 *
 * @name        SPI  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define SPI0_Base                       ((uint32_t)0x53000000)              /*!< SPI Control  Module-0 */
#define SPI0                            ((SPI_Struct*) SPI0_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        SPI  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        SPI_STA  [register's definitions]
 *              Offset[0x00]  SPI status register
 ******************************************************************************
 */
///@{
#define SPI_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_STA */
#define SPI_STA_IDL_STA_mask_w                      ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define SPI_STA_IDL_STA_mask_h1                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define SPI_STA_IDL_STA_mask_b3                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_STA_IDL_STA_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_IDL_STA_normal_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_IDL_STA_normal_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_IDL_STA_happened_w                  ((uint32_t)0x80000000)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_IDL_STA_happened_h1                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_IDL_STA_happened_b3                 ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_RNUM_mask_w                         ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define SPI_STA_RNUM_mask_h1                        ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define SPI_STA_RNUM_mask_b3                        ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define SPI_STA_RNUM_0_w                            ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define SPI_STA_RNUM_0_h1                           ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define SPI_STA_RNUM_0_b3                           ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define SPI_STA_RNUM_1_w                            ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):1 of 32bit */
#define SPI_STA_RNUM_1_h1                           ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1 of 16bit */
#define SPI_STA_RNUM_1_b3                           ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */
#define SPI_STA_RNUM_2_w                            ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):2 of 32bit */
#define SPI_STA_RNUM_2_h1                           ((uint16_t)0x0200)      /*!< Bit Value =(0x2):2 of 16bit */
#define SPI_STA_RNUM_2_b3                           ((uint8_t )0x02)        /*!< Bit Value =(0x2):2 of 8bit */
#define SPI_STA_RNUM_3_w                            ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):3 of 32bit */
#define SPI_STA_RNUM_3_h1                           ((uint16_t)0x0300)      /*!< Bit Value =(0x3):3 of 16bit */
#define SPI_STA_RNUM_3_b3                           ((uint8_t )0x03)        /*!< Bit Value =(0x3):3 of 8bit */
#define SPI_STA_RNUM_4_w                            ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):4 of 32bit */
#define SPI_STA_RNUM_4_h1                           ((uint16_t)0x0400)      /*!< Bit Value =(0x4):4 of 16bit */
#define SPI_STA_RNUM_4_b3                           ((uint8_t )0x04)        /*!< Bit Value =(0x4):4 of 8bit */

#define SPI_STA_TX_LVL_mask_w                       ((uint32_t)0x00700000)  /*!< Bit Mask of 32bit */
#define SPI_STA_TX_LVL_mask_h1                      ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define SPI_STA_TX_LVL_mask_b2                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define SPI_STA_TX_LVL_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define SPI_STA_TX_LVL_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define SPI_STA_TX_LVL_0_b2                         ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define SPI_STA_TX_LVL_1_w                          ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):1 of 32bit */
#define SPI_STA_TX_LVL_1_h1                         ((uint16_t)0x0010)      /*!< Bit Value =(0x1):1 of 16bit */
#define SPI_STA_TX_LVL_1_b2                         ((uint8_t )0x10)        /*!< Bit Value =(0x1):1 of 8bit */
#define SPI_STA_TX_LVL_2_w                          ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):2 of 32bit */
#define SPI_STA_TX_LVL_2_h1                         ((uint16_t)0x0020)      /*!< Bit Value =(0x2):2 of 16bit */
#define SPI_STA_TX_LVL_2_b2                         ((uint8_t )0x20)        /*!< Bit Value =(0x2):2 of 8bit */
#define SPI_STA_TX_LVL_3_w                          ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):3 of 32bit */
#define SPI_STA_TX_LVL_3_h1                         ((uint16_t)0x0030)      /*!< Bit Value =(0x3):3 of 16bit */
#define SPI_STA_TX_LVL_3_b2                         ((uint8_t )0x30)        /*!< Bit Value =(0x3):3 of 8bit */
#define SPI_STA_TX_LVL_4_w                          ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):4 of 32bit */
#define SPI_STA_TX_LVL_4_h1                         ((uint16_t)0x0040)      /*!< Bit Value =(0x4):4 of 16bit */
#define SPI_STA_TX_LVL_4_b2                         ((uint8_t )0x40)        /*!< Bit Value =(0x4):4 of 8bit */

#define SPI_STA_RX_LVL_mask_w                       ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define SPI_STA_RX_LVL_mask_h1                      ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define SPI_STA_RX_LVL_mask_b2                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define SPI_STA_RX_LVL_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define SPI_STA_RX_LVL_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define SPI_STA_RX_LVL_0_b2                         ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define SPI_STA_RX_LVL_1_w                          ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):1 of 32bit */
#define SPI_STA_RX_LVL_1_h1                         ((uint16_t)0x0001)      /*!< Bit Value =(0x1):1 of 16bit */
#define SPI_STA_RX_LVL_1_b2                         ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */
#define SPI_STA_RX_LVL_2_w                          ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):2 of 32bit */
#define SPI_STA_RX_LVL_2_h1                         ((uint16_t)0x0002)      /*!< Bit Value =(0x2):2 of 16bit */
#define SPI_STA_RX_LVL_2_b2                         ((uint8_t )0x02)        /*!< Bit Value =(0x2):2 of 8bit */
#define SPI_STA_RX_LVL_3_w                          ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):3 of 32bit */
#define SPI_STA_RX_LVL_3_h1                         ((uint16_t)0x0003)      /*!< Bit Value =(0x3):3 of 16bit */
#define SPI_STA_RX_LVL_3_b2                         ((uint8_t )0x03)        /*!< Bit Value =(0x3):3 of 8bit */
#define SPI_STA_RX_LVL_4_w                          ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):4 of 32bit */
#define SPI_STA_RX_LVL_4_h1                         ((uint16_t)0x0004)      /*!< Bit Value =(0x4):4 of 16bit */
#define SPI_STA_RX_LVL_4_b2                         ((uint8_t )0x04)        /*!< Bit Value =(0x4):4 of 8bit */

#define SPI_STA_TUDRF_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define SPI_STA_TUDRF_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define SPI_STA_TUDRF_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_STA_TUDRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_TUDRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_TUDRF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_TUDRF_happened_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_TUDRF_happened_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_TUDRF_happened_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_ROVRF_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define SPI_STA_ROVRF_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define SPI_STA_ROVRF_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_STA_ROVRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_ROVRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_ROVRF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_ROVRF_happened_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_ROVRF_happened_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_ROVRF_happened_b1                   ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_WEF_mask_w                          ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define SPI_STA_WEF_mask_h0                         ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define SPI_STA_WEF_mask_b1                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_STA_WEF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_WEF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_WEF_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_WEF_happened_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_WEF_happened_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_WEF_happened_b1                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_MODF_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define SPI_STA_MODF_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define SPI_STA_MODF_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_STA_MODF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_MODF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_MODF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_MODF_happened_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_MODF_happened_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_MODF_happened_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_TXF_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define SPI_STA_TXF_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define SPI_STA_TXF_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_STA_TXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_TXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_TXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_TXF_happened_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_TXF_happened_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_TXF_happened_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_RXF_mask_w                          ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define SPI_STA_RXF_mask_h0                         ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define SPI_STA_RXF_mask_b0                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SPI_STA_RXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_RXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_RXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_RXF_happened_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_RXF_happened_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_RXF_happened_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_RXDF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define SPI_STA_RXDF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define SPI_STA_RXDF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define SPI_STA_RXDF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_RXDF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_RXDF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_RXDF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_RXDF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_RXDF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_TCF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define SPI_STA_TCF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define SPI_STA_TCF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define SPI_STA_TCF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_TCF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_TCF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_TCF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_TCF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_TCF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_IDLF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define SPI_STA_IDLF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define SPI_STA_IDLF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_STA_IDLF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_STA_IDLF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_STA_IDLF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_STA_IDLF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define SPI_STA_IDLF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define SPI_STA_IDLF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define SPI_STA_BUSYF_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SPI_STA_BUSYF_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_STA_BUSYF_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_STA_BUSYF_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define SPI_STA_BUSYF_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define SPI_STA_BUSYF_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_INT  [register's definitions]
 *              Offset[0x04]  SPI interrupt enable register
 ******************************************************************************
 */
///@{
#define SPI_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_INT */
#define SPI_INT_TUDR_IE_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define SPI_INT_TUDR_IE_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define SPI_INT_TUDR_IE_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_INT_TUDR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_TUDR_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_TUDR_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_TUDR_IE_enable_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_TUDR_IE_enable_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_TUDR_IE_enable_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_ROVR_IE_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define SPI_INT_ROVR_IE_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define SPI_INT_ROVR_IE_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_INT_ROVR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_ROVR_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_ROVR_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_ROVR_IE_enable_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_ROVR_IE_enable_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_ROVR_IE_enable_b1                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_WE_IE_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define SPI_INT_WE_IE_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define SPI_INT_WE_IE_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_INT_WE_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_WE_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_WE_IE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_WE_IE_enable_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_WE_IE_enable_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_WE_IE_enable_b1                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_MODF_IE_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define SPI_INT_MODF_IE_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define SPI_INT_MODF_IE_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_INT_MODF_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_MODF_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_MODF_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_MODF_IE_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_MODF_IE_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_MODF_IE_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_TX_IE_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define SPI_INT_TX_IE_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define SPI_INT_TX_IE_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_INT_TX_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_TX_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_TX_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_TX_IE_enable_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_TX_IE_enable_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_TX_IE_enable_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_RX_IE_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define SPI_INT_RX_IE_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define SPI_INT_RX_IE_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SPI_INT_RX_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_RX_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_RX_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_RX_IE_enable_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_RX_IE_enable_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_RX_IE_enable_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_TC_IE_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define SPI_INT_TC_IE_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define SPI_INT_TC_IE_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define SPI_INT_TC_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_TC_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_TC_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_TC_IE_enable_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_TC_IE_enable_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_TC_IE_enable_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_IDL_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define SPI_INT_IDL_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define SPI_INT_IDL_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_INT_IDL_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_IDL_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_IDL_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_IDL_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_IDL_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_IDL_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SPI_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_CLK  [register's definitions]
 *              Offset[0x08]  SPI clock source register
 ******************************************************************************
 */
///@{
#define SPI_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_CLK */
#define SPI_CLK_CK_PDIV_mask_w                      ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define SPI_CLK_CK_PDIV_mask_h0                     ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define SPI_CLK_CK_PDIV_mask_b1                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define SPI_CLK_CK_PDIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define SPI_CLK_CK_PDIV_div1_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define SPI_CLK_CK_PDIV_div1_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define SPI_CLK_CK_PDIV_div2_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define SPI_CLK_CK_PDIV_div2_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define SPI_CLK_CK_PDIV_div2_b1                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define SPI_CLK_CK_PDIV_div4_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define SPI_CLK_CK_PDIV_div4_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define SPI_CLK_CK_PDIV_div4_b1                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define SPI_CLK_CK_PDIV_div8_w                      ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define SPI_CLK_CK_PDIV_div8_h0                     ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define SPI_CLK_CK_PDIV_div8_b1                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define SPI_CLK_CK_PSC_mask_w                       ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define SPI_CLK_CK_PSC_mask_h0                      ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define SPI_CLK_CK_PSC_mask_b1                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define SPI_CLK_CK_PSC_shift_w                      (8)                     /*!< Bit Shift of 32bit */
#define SPI_CLK_CK_PSC_shift_h0                     (8)                     /*!< Bit Shift of 16bit */
#define SPI_CLK_CK_PSC_shift_b1                     (0)                     /*!< Bit Shift of 8bit */

#define SPI_CLK_CK_DIV_mask_w                       ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define SPI_CLK_CK_DIV_mask_h0                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define SPI_CLK_CK_DIV_mask_b0                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define SPI_CLK_CK_DIV_div2_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV2 of 32bit */
#define SPI_CLK_CK_DIV_div2_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV2 of 16bit */
#define SPI_CLK_CK_DIV_div2_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV2 of 8bit */
#define SPI_CLK_CK_DIV_div4_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV4 of 32bit */
#define SPI_CLK_CK_DIV_div4_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV4 of 16bit */
#define SPI_CLK_CK_DIV_div4_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV4 of 8bit */
#define SPI_CLK_CK_DIV_div8_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV8 of 32bit */
#define SPI_CLK_CK_DIV_div8_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV8 of 16bit */
#define SPI_CLK_CK_DIV_div8_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV8 of 8bit */
#define SPI_CLK_CK_DIV_div16_w                      ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV16 of 32bit */
#define SPI_CLK_CK_DIV_div16_h0                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV16 of 16bit */
#define SPI_CLK_CK_DIV_div16_b0                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV16 of 8bit */

#define SPI_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define SPI_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define SPI_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define SPI_CLK_CK_SEL_proc_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PROC of 32bit */
#define SPI_CLK_CK_SEL_proc_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PROC of 16bit */
#define SPI_CLK_CK_SEL_proc_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):PROC of 8bit */
#define SPI_CLK_CK_SEL_tm00_trgo_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):TM00_TRGO of 32bit */
#define SPI_CLK_CK_SEL_tm00_trgo_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(0x2):TM00_TRGO of 16bit */
#define SPI_CLK_CK_SEL_tm00_trgo_b0                 ((uint8_t )0x08)        /*!< Bit Value =(0x2):TM00_TRGO of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_CR0  [register's definitions]
 *              Offset[0x10]  SPI control register 0
 ******************************************************************************
 */
///@{
#define SPI_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_CR0 */
#define SPI_CR0_DMA_TXEN_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_DMA_TXEN_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_DMA_TXEN_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_CR0_DMA_TXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_DMA_TXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_DMA_TXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_DMA_TXEN_enable_w                   ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_DMA_TXEN_enable_h1                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_DMA_TXEN_enable_b3                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_DMA_RXEN_mask_w                     ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_DMA_RXEN_mask_h1                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_DMA_RXEN_mask_b3                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SPI_CR0_DMA_RXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_DMA_RXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_DMA_RXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_DMA_RXEN_enable_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_DMA_RXEN_enable_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_DMA_RXEN_enable_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_DMA_MDS_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_DMA_MDS_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_DMA_MDS_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define SPI_CR0_DMA_MDS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_DMA_MDS_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_DMA_MDS_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_DMA_MDS_enable_w                    ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_DMA_MDS_enable_h1                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_DMA_MDS_enable_b3                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_SDT_EN_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_SDT_EN_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define SPI_CR0_SDT_EN_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR0_SDT_EN_disable_w                    ((uint32_t)0x00000000)
#define SPI_CR0_SDT_EN_disable_h1                   ((uint16_t)0x0000)
#define SPI_CR0_SDT_EN_disable_b3                   ((uint8_t )0x00)
#define SPI_CR0_SDT_EN_enable_w                     ((uint32_t)0x08000000)
#define SPI_CR0_SDT_EN_enable_h1                    ((uint16_t)0x0800)
#define SPI_CR0_SDT_EN_enable_b3                    ((uint8_t )0x08)

#define SPI_CR0_ASYNC_EN_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_ASYNC_EN_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define SPI_CR0_ASYNC_EN_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR0_ASYNC_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_ASYNC_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_ASYNC_EN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_ASYNC_EN_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_ASYNC_EN_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_ASYNC_EN_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_HS_EN_mask_w                        ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_HS_EN_mask_h1                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define SPI_CR0_HS_EN_mask_b3                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR0_HS_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_HS_EN_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_HS_EN_disable_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_HS_EN_enable_w                      ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_HS_EN_enable_h1                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_HS_EN_enable_b3                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_ADPX_EN_mask_w                      ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_ADPX_EN_mask_h1                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define SPI_CR0_ADPX_EN_mask_b3                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR0_ADPX_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_ADPX_EN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_ADPX_EN_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_ADPX_EN_enable_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_ADPX_EN_enable_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_ADPX_EN_enable_b3                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_DOUT_IDL_mask_w                     ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_DOUT_IDL_mask_h1                    ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define SPI_CR0_DOUT_IDL_mask_b2                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define SPI_CR0_DOUT_IDL_lbit_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LBIT of 32bit */
#define SPI_CR0_DOUT_IDL_lbit_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LBIT of 16bit */
#define SPI_CR0_DOUT_IDL_lbit_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):LBIT of 8bit */
#define SPI_CR0_DOUT_IDL_0_w                        ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):0 of 32bit */
#define SPI_CR0_DOUT_IDL_0_h1                       ((uint16_t)0x0080)      /*!< Bit Value =(0x2):0 of 16bit */
#define SPI_CR0_DOUT_IDL_0_b2                       ((uint8_t )0x80)        /*!< Bit Value =(0x2):0 of 8bit */
#define SPI_CR0_DOUT_IDL_1_w                        ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):1 of 32bit */
#define SPI_CR0_DOUT_IDL_1_h1                       ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):1 of 16bit */
#define SPI_CR0_DOUT_IDL_1_b2                       ((uint8_t )0xC0)        /*!< Bit Value =(0x3):1 of 8bit */

#define SPI_CR0_DOUT_MDS_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_DOUT_MDS_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define SPI_CR0_DOUT_MDS_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define SPI_CR0_DOUT_MDS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_DOUT_MDS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_DOUT_MDS_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_DOUT_MDS_enable_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_DOUT_MDS_enable_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_DOUT_MDS_enable_b2                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSSI_SWEN_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSI_SWEN_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSI_SWEN_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSI_SWEN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSSI_SWEN_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSSI_SWEN_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSSI_SWEN_enable_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSSI_SWEN_enable_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSSI_SWEN_enable_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_LBM_EN_mask_w                       ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_LBM_EN_mask_h1                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define SPI_CR0_LBM_EN_mask_b2                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR0_LBM_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_LBM_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_LBM_EN_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_LBM_EN_enable_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_LBM_EN_enable_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_LBM_EN_enable_b2                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_RX_CTL_mask_w                       ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_RX_CTL_mask_h1                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define SPI_CR0_RX_CTL_mask_b2                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR0_RX_CTL_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define SPI_CR0_RX_CTL_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define SPI_CR0_RX_CTL_normal_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define SPI_CR0_RX_CTL_next_w                       ((uint32_t)0x00040000)  /*!< Bit Value =(1):Next of 32bit */
#define SPI_CR0_RX_CTL_next_h1                      ((uint16_t)0x0004)      /*!< Bit Value =(1):Next of 16bit */
#define SPI_CR0_RX_CTL_next_b2                      ((uint8_t )0x04)        /*!< Bit Value =(1):Next of 8bit */

#define SPI_CR0_MODF_SEL_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_MODF_SEL_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_MODF_SEL_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_CR0_MODF_SEL_spi_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):SPI disable of 32bit */
#define SPI_CR0_MODF_SEL_spi_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):SPI disable of 16bit */
#define SPI_CR0_MODF_SEL_spi_disable_b1             ((uint8_t )0x00)        /*!< Bit Value =(0):SPI disable of 8bit */
#define SPI_CR0_MODF_SEL_switch_to_slave_w          ((uint32_t)0x00008000)  /*!< Bit Value =(1):Switch to slave of 32bit */
#define SPI_CR0_MODF_SEL_switch_to_slave_h0         ((uint16_t)0x8000)      /*!< Bit Value =(1):Switch to slave of 16bit */
#define SPI_CR0_MODF_SEL_switch_to_slave_b1         ((uint8_t )0x80)        /*!< Bit Value =(1):Switch to slave of 8bit */

#define SPI_CR0_NSS_PEN_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSS_PEN_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSS_PEN_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSS_PEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSS_PEN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSS_PEN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSS_PEN_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSS_PEN_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSS_PEN_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSSI_INV_mask_w                     ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSI_INV_mask_h0                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSI_INV_mask_b1                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSI_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSSI_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSSI_INV_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSSI_INV_enable_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSSI_INV_enable_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSSI_INV_enable_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSSO_INV_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSO_INV_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSO_INV_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSO_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSSO_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSSO_INV_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSSO_INV_enable_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSSO_INV_enable_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSSO_INV_enable_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSS_SWEN_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSS_SWEN_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSS_SWEN_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSS_SWEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSS_SWEN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSS_SWEN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSS_SWEN_enable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSS_SWEN_enable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSS_SWEN_enable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSSI_SEL_mask_w                     ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSI_SEL_mask_h0                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSI_SEL_mask_b1                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSI_SEL_nss_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):NSS of 32bit */
#define SPI_CR0_NSSI_SEL_nss_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):NSS of 16bit */
#define SPI_CR0_NSSI_SEL_nss_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):NSS of 8bit */
#define SPI_CR0_NSSI_SEL_nssi_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):NSSI of 32bit */
#define SPI_CR0_NSSI_SEL_nssi_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):NSSI of 16bit */
#define SPI_CR0_NSSI_SEL_nssi_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):NSSI of 8bit */

#define SPI_CR0_NSSI_EN_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSI_EN_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSI_EN_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSI_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSSI_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSSI_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSSI_EN_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSSI_EN_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSSI_EN_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_NSSO_EN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define SPI_CR0_NSSO_EN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define SPI_CR0_NSSO_EN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR0_NSSO_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_NSSO_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_NSSO_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_NSSO_EN_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_NSSO_EN_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_NSSO_EN_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_IO_SWP_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define SPI_CR0_IO_SWP_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define SPI_CR0_IO_SWP_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_CR0_IO_SWP_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_IO_SWP_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_IO_SWP_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_IO_SWP_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_IO_SWP_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_IO_SWP_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_IO_SWP2_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define SPI_CR0_IO_SWP2_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define SPI_CR0_IO_SWP2_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define SPI_CR0_IO_SWP2_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_IO_SWP2_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_IO_SWP2_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_IO_SWP2_enable_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_IO_SWP2_enable_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_IO_SWP2_enable_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_MDS_mask_w                          ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define SPI_CR0_MDS_mask_h0                         ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define SPI_CR0_MDS_mask_b0                         ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define SPI_CR0_MDS_slave_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Slave of 32bit */
#define SPI_CR0_MDS_slave_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Slave of 16bit */
#define SPI_CR0_MDS_slave_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):Slave of 8bit */
#define SPI_CR0_MDS_master_w                        ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Master of 32bit */
#define SPI_CR0_MDS_master_h0                       ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Master of 16bit */
#define SPI_CR0_MDS_master_b0                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):Master of 8bit */

#define SPI_CR0_LSB_EN_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define SPI_CR0_LSB_EN_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define SPI_CR0_LSB_EN_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR0_LSB_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_LSB_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_LSB_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_LSB_EN_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_LSB_EN_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_LSB_EN_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR0_CPHA_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define SPI_CR0_CPHA_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define SPI_CR0_CPHA_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR0_CPHA_leading_edge_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Leading edge of 32bit */
#define SPI_CR0_CPHA_leading_edge_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Leading edge of 16bit */
#define SPI_CR0_CPHA_leading_edge_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Leading edge of 8bit */
#define SPI_CR0_CPHA_trailing_edge_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Trailing edge of 32bit */
#define SPI_CR0_CPHA_trailing_edge_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Trailing edge of 16bit */
#define SPI_CR0_CPHA_trailing_edge_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Trailing edge of 8bit */

#define SPI_CR0_CPOL_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define SPI_CR0_CPOL_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define SPI_CR0_CPOL_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR0_CPOL_low_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Low of 32bit */
#define SPI_CR0_CPOL_low_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Low of 16bit */
#define SPI_CR0_CPOL_low_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):Low of 8bit */
#define SPI_CR0_CPOL_high_w                         ((uint32_t)0x00000002)  /*!< Bit Value =(1):High of 32bit */
#define SPI_CR0_CPOL_high_h0                        ((uint16_t)0x0002)      /*!< Bit Value =(1):High of 16bit */
#define SPI_CR0_CPOL_high_b0                        ((uint8_t )0x02)        /*!< Bit Value =(1):High of 8bit */

#define SPI_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SPI_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_CR1  [register's definitions]
 *              Offset[0x14]  SPI control register 1
 ******************************************************************************
 */
///@{
#define SPI_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_CR1 */
#define SPI_CR1_NSS_IDT_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define SPI_CR1_NSS_IDT_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_CR1_NSS_IDT_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR1_NSS_IDT_1t_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1T of 32bit */
#define SPI_CR1_NSS_IDT_1t_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1T of 16bit */
#define SPI_CR1_NSS_IDT_1t_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):1T of 8bit */
#define SPI_CR1_NSS_IDT_2t_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):2T of 32bit */
#define SPI_CR1_NSS_IDT_2t_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):2T of 16bit */
#define SPI_CR1_NSS_IDT_2t_b2                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):2T of 8bit */

#define SPI_CR1_TDAT_CLR_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define SPI_CR1_TDAT_CLR_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define SPI_CR1_TDAT_CLR_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR1_TDAT_CLR_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR1_TDAT_CLR_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR1_TDAT_CLR_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR1_TDAT_CLR_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR1_TDAT_CLR_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR1_TDAT_CLR_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR1_RDAT_CLR_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SPI_CR1_RDAT_CLR_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_CR1_RDAT_CLR_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR1_RDAT_CLR_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR1_RDAT_CLR_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR1_RDAT_CLR_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR1_RDAT_CLR_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR1_RDAT_CLR_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR1_RDAT_CLR_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_CR2  [register's definitions]
 *              Offset[0x18]  SPI control register 2
 ******************************************************************************
 */
///@{
#define SPI_CR2_default                             ((uint32_t)0x03000100)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_CR2 */
#define SPI_CR2_CKO_MUX_mask_w                      ((uint32_t)0x70000000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_CKO_MUX_mask_h1                     ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define SPI_CR2_CKO_MUX_mask_b3                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define SPI_CR2_CKO_MUX_spi_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SPI of 32bit */
#define SPI_CR2_CKO_MUX_spi_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SPI of 16bit */
#define SPI_CR2_CKO_MUX_spi_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):SPI of 8bit */
#define SPI_CR2_CKO_MUX_we_w                        ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):WE of 32bit */
#define SPI_CR2_CKO_MUX_we_h1                       ((uint16_t)0x1000)      /*!< Bit Value =(0x1):WE of 16bit */
#define SPI_CR2_CKO_MUX_we_b3                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):WE of 8bit */
#define SPI_CR2_CKO_MUX_oe_w                        ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):OE of 32bit */
#define SPI_CR2_CKO_MUX_oe_h1                       ((uint16_t)0x2000)      /*!< Bit Value =(0x2):OE of 16bit */
#define SPI_CR2_CKO_MUX_oe_b3                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):OE of 8bit */
#define SPI_CR2_CKO_MUX_tm10_w                      ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):TM10 of 32bit */
#define SPI_CR2_CKO_MUX_tm10_h1                     ((uint16_t)0x3000)      /*!< Bit Value =(0x3):TM10 of 16bit */
#define SPI_CR2_CKO_MUX_tm10_b3                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):TM10 of 8bit */
#define SPI_CR2_CKO_MUX_tm16_w                      ((uint32_t)0x40000000)  /*!< Bit Value =(0x4):TM16 of 32bit */
#define SPI_CR2_CKO_MUX_tm16_h1                     ((uint16_t)0x4000)      /*!< Bit Value =(0x4):TM16 of 16bit */
#define SPI_CR2_CKO_MUX_tm16_b3                     ((uint8_t )0x40)        /*!< Bit Value =(0x4):TM16 of 8bit */
#define SPI_CR2_CKO_MUX_tm20_w                      ((uint32_t)0x50000000)  /*!< Bit Value =(0x5):TM20 of 32bit */
#define SPI_CR2_CKO_MUX_tm20_h1                     ((uint16_t)0x5000)      /*!< Bit Value =(0x5):TM20 of 16bit */
#define SPI_CR2_CKO_MUX_tm20_b3                     ((uint8_t )0x50)        /*!< Bit Value =(0x5):TM20 of 8bit */

#define SPI_CR2_CKO_TOG_mask_w                      ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_CKO_TOG_mask_h1                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define SPI_CR2_CKO_TOG_mask_b3                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR2_CKO_TOG_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_CKO_TOG_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_CKO_TOG_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_CKO_TOG_enable_w                    ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_CKO_TOG_enable_h1                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_CKO_TOG_enable_b3                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR2_TXUPD_EN_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_TXUPD_EN_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define SPI_CR2_TXUPD_EN_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR2_TXUPD_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_TXUPD_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_TXUPD_EN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_TXUPD_EN_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_TXUPD_EN_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_TXUPD_EN_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR2_NSS_SWI_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_NSS_SWI_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define SPI_CR2_NSS_SWI_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR2_NSS_SWI_shift_w                     (25)                    /*!< Bit Shift of 32bit */
#define SPI_CR2_NSS_SWI_shift_h1                    (9)                     /*!< Bit Shift of 16bit */
#define SPI_CR2_NSS_SWI_shift_b3                    (1)                     /*!< Bit Shift of 8bit */

#define SPI_CR2_NSS_SWO_mask_w                      ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_NSS_SWO_mask_h1                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define SPI_CR2_NSS_SWO_mask_b3                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR2_NSS_SWO_shift_w                     (24)                    /*!< Bit Shift of 32bit */
#define SPI_CR2_NSS_SWO_shift_h1                    (8)                     /*!< Bit Shift of 16bit */
#define SPI_CR2_NSS_SWO_shift_b3                    (0)                     /*!< Bit Shift of 8bit */

#define SPI_CR2_DSIZE_mask_w                        ((uint32_t)0x001F0000)  /*!< Bit Mask of 32bit */
#define SPI_CR2_DSIZE_mask_h1                       ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define SPI_CR2_DSIZE_mask_b2                       ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define SPI_CR2_DSIZE_shift_w                       (16)                    /*!< Bit Shift of 32bit */
#define SPI_CR2_DSIZE_shift_h1                      (0)                     /*!< Bit Shift of 16bit */
#define SPI_CR2_DSIZE_shift_b2                      (0)                     /*!< Bit Shift of 8bit */

#define SPI_CR2_RX_TH_mask_w                        ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define SPI_CR2_RX_TH_mask_h0                       ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define SPI_CR2_RX_TH_mask_b1                       ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define SPI_CR2_RX_TH_1_byte_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1-byte of 32bit */
#define SPI_CR2_RX_TH_1_byte_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1-byte of 16bit */
#define SPI_CR2_RX_TH_1_byte_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):1-byte of 8bit */
#define SPI_CR2_RX_TH_2_byte_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):2-byte of 32bit */
#define SPI_CR2_RX_TH_2_byte_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):2-byte of 16bit */
#define SPI_CR2_RX_TH_2_byte_b1                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):2-byte of 8bit */
#define SPI_CR2_RX_TH_3_byte_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):3-byte of 32bit */
#define SPI_CR2_RX_TH_3_byte_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):3-byte of 16bit */
#define SPI_CR2_RX_TH_3_byte_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):3-byte of 8bit */
#define SPI_CR2_RX_TH_4_byte_w                      ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):4-byte of 32bit */
#define SPI_CR2_RX_TH_4_byte_h0                     ((uint16_t)0x0300)      /*!< Bit Value =(0x3):4-byte of 16bit */
#define SPI_CR2_RX_TH_4_byte_b1                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):4-byte of 8bit */

#define SPI_CR2_TX_DIS_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define SPI_CR2_TX_DIS_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define SPI_CR2_TX_DIS_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define SPI_CR2_TX_DIS_enable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define SPI_CR2_TX_DIS_enable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define SPI_CR2_TX_DIS_enable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define SPI_CR2_TX_DIS_disable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Disable of 32bit */
#define SPI_CR2_TX_DIS_disable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Disable of 16bit */
#define SPI_CR2_TX_DIS_disable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Disable of 8bit */

#define SPI_CR2_DAT_LINE_mask_w                     ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define SPI_CR2_DAT_LINE_mask_h0                    ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define SPI_CR2_DAT_LINE_mask_b0                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define SPI_CR2_DAT_LINE_spi_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SPI of 32bit */
#define SPI_CR2_DAT_LINE_spi_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SPI of 16bit */
#define SPI_CR2_DAT_LINE_spi_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):SPI of 8bit */
#define SPI_CR2_DAT_LINE_1_w                        ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):1 of 32bit */
#define SPI_CR2_DAT_LINE_1_h0                       ((uint16_t)0x0010)      /*!< Bit Value =(0x1):1 of 16bit */
#define SPI_CR2_DAT_LINE_1_b0                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):1 of 8bit */
#define SPI_CR2_DAT_LINE_2_w                        ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):2 of 32bit */
#define SPI_CR2_DAT_LINE_2_h0                       ((uint16_t)0x0020)      /*!< Bit Value =(0x2):2 of 16bit */
#define SPI_CR2_DAT_LINE_2_b0                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):2 of 8bit */
#define SPI_CR2_DAT_LINE_4_w                        ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):4 of 32bit */
#define SPI_CR2_DAT_LINE_4_h0                       ((uint16_t)0x0030)      /*!< Bit Value =(0x3):4 of 16bit */
#define SPI_CR2_DAT_LINE_4_b0                       ((uint8_t )0x30)        /*!< Bit Value =(0x3):4 of 8bit */
#define SPI_CR2_DAT_LINE_4d_w                       ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):4D of 32bit */
#define SPI_CR2_DAT_LINE_4d_h0                      ((uint16_t)0x0040)      /*!< Bit Value =(0x4):4D of 16bit */
#define SPI_CR2_DAT_LINE_4d_b0                      ((uint8_t )0x40)        /*!< Bit Value =(0x4):4D of 8bit */
#define SPI_CR2_DAT_LINE_8_w                        ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):8 of 32bit */
#define SPI_CR2_DAT_LINE_8_h0                       ((uint16_t)0x0050)      /*!< Bit Value =(0x5):8 of 16bit */
#define SPI_CR2_DAT_LINE_8_b0                       ((uint8_t )0x50)        /*!< Bit Value =(0x5):8 of 8bit */

#define SPI_CR2_COPY_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define SPI_CR2_COPY_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define SPI_CR2_COPY_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define SPI_CR2_COPY_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_COPY_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_COPY_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_COPY_EN_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_COPY_EN_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_COPY_EN_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR2_BDIR_OE_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define SPI_CR2_BDIR_OE_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define SPI_CR2_BDIR_OE_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SPI_CR2_BDIR_OE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_BDIR_OE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_BDIR_OE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_BDIR_OE_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_BDIR_OE_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_BDIR_OE_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR2_DTR_EN_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define SPI_CR2_DTR_EN_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define SPI_CR2_DTR_EN_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SPI_CR2_DTR_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_DTR_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_DTR_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_DTR_EN_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_DTR_EN_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_DTR_EN_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define SPI_CR2_RSB_TRG_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SPI_CR2_RSB_TRG_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SPI_CR2_RSB_TRG_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SPI_CR2_RSB_TRG_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SPI_CR2_RSB_TRG_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SPI_CR2_RSB_TRG_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SPI_CR2_RSB_TRG_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SPI_CR2_RSB_TRG_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SPI_CR2_RSB_TRG_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_RDAT  [register's definitions]
 *              Offset[0x30]  SPI data receive register
 ******************************************************************************
 */
///@{
#define SPI_RDAT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_RDAT */
#define SPI_RDAT_RDAT_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SPI_RDAT_RDAT_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define SPI_RDAT_RDAT_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define SPI_RDAT_RDAT_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT  [register's definitions]
 *              Offset[0x34]  SPI data transmit register
 ******************************************************************************
 */
///@{
#define SPI_TDAT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_TDAT */
#define SPI_TDAT_TDAT_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SPI_TDAT_TDAT_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define SPI_TDAT_TDAT_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define SPI_TDAT_TDAT_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT3  [register's definitions]
 *              Offset[0x38]  SPI TX data 3-byte register
 ******************************************************************************
 */
///@{
#define SPI_TDAT3_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SPI_TDAT3 */
#define SPI_TDAT3_TDAT3_mask_w                      ((uint32_t)0x00FFFFFF)  /*!< Bit Mask of 32bit */
#define SPI_TDAT3_TDAT3_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define SPI_TDAT3_TDAT3_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define SPI_TDAT3_TDAT3_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_SPI_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_SPI.h                           */
/*----------------------------------------------------------------------------*/
