/**
 ******************************************************************************
 *
 * @file        MG32_DAC.h
 *
 * @brief       MG32 DAC Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:38 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_DAC_H
#define _MG32_DAC_H
#define _MG32_DAC_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_DAC_H_VER)
    #error "_MG32_DAC_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      DAC_Struct
 *              DAC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  RDY0F         :1;     //[1] DAC-0 ready flag to update new data to data register
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :4;     //[6..3] 
            __IO uint8_t  UDR0F         :1;     //[7] DAC-0 conversion underrun event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :8;     //[15..8] 
            __I  uint8_t                :1;     //[16] 
            __I  uint8_t                :7;     //[23..17] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  DAC status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] DAC interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RDY0_IE       :1;     //[1] DAC-0 ready to update new data to data register interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :4;     //[6..3] 
            __IO uint8_t  UDR0_IE       :1;     //[7] DAC-0 conversion underrun event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :8;     //[15..8] 
            __I  uint8_t                :1;     //[16] 
            __I  uint8_t                :7;     //[23..17] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  DAC interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  DA0_EN        :1;     //[0] DAC-0 power-on enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BUF0_EN       :1;     //[1] DAC-0 output buffer enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  ALIGN0_SEL    :1;     //[4] DAC-0 data alignment select.
                                        //0 = Right (Right alignment)
                                        //1 = Left (Left alignment)
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  RES0_SEL      :2;     //[7..6] DAC-0 data resolution select
                                        //0x0 = 12-bit
                                        //0x1 = 10-bit
                                        //0x2 = 8-bit
            __IO uint8_t  START0_SEL    :3;     //[10..8] DAC-0 start trigger control source select
                                        //0x0 = WDAT : DAC_DAT0 register written
                                        //0x1 = PIN : DAC_TRG external trigger pin
                                        //0x2 = CMP0 : CMP0_OUT
                                        //0x3 = TM00 : TM00_TRGO
                                        //0x4 = TM01 : TM01_TRGO
                                        //0x5 = TM10 : TM10_TRGO
                                        //0x6 = ITR6 : APB_ITR6
                                        //0x7 = ITR7 : APB_ITR7
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  TRG0_SEL      :2;     //[13..12] DAC-0 start trigger selection
                                        //0x0 = Disable
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t                :1;     //[16] 
            __I  uint8_t                :7;     //[23..17] 
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  DMA_EN        :1;     //[31] Direct memory access enable to transmit
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  DAC control register 0 */

    __I uint32_t  RESERVED1[3];         /*!< RESERVED1  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t DAT0          :16;    //[15..0] DAC-0 conversion data register
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }DAT0;                              /*!< DAT0       ~ Offset[0x20]  DAC conversion data register 0 */

    __I uint32_t  RESERVED2;            /*!< RESERVED2  ~ Offset[0x24]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t DOR0          :16;    //[15..0] DAC-0 conversion output register
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }DOR0;                              /*!< DOR0       ~ Offset[0x28]  DAC conversion output register 0 */

} DAC_Struct;

/**
 ******************************************************************************
 *
 * @name        DAC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define DAC_Base                        ((uint32_t)0x5C080000)              /*!< Digital-to-Analog Converter Control */
#define DAC                             ((DAC_Struct*) DAC_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        DAC  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        DAC_STA  [register's definitions]
 *              Offset[0x00]  DAC status register (0x5C080000)
 ******************************************************************************
 */
///@{
#define DAC_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DAC_STA */
#define DAC_STA_UDR0F_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define DAC_STA_UDR0F_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define DAC_STA_UDR0F_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DAC_STA_UDR0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DAC_STA_UDR0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DAC_STA_UDR0F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DAC_STA_UDR0F_happened_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define DAC_STA_UDR0F_happened_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define DAC_STA_UDR0F_happened_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define DAC_STA_RDY0F_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DAC_STA_RDY0F_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DAC_STA_RDY0F_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DAC_STA_RDY0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DAC_STA_RDY0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DAC_STA_RDY0F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DAC_STA_RDY0F_happened_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define DAC_STA_RDY0F_happened_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define DAC_STA_RDY0F_happened_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DAC_INT  [register's definitions]
 *              Offset[0x04]  DAC interrupt enable register (0x5C080004)
 ******************************************************************************
 */
///@{
#define DAC_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DAC_INT */
#define DAC_INT_UDR0_IE_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define DAC_INT_UDR0_IE_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define DAC_INT_UDR0_IE_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DAC_INT_UDR0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_INT_UDR0_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_INT_UDR0_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_INT_UDR0_IE_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_INT_UDR0_IE_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_INT_UDR0_IE_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DAC_INT_RDY0_IE_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DAC_INT_RDY0_IE_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DAC_INT_RDY0_IE_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DAC_INT_RDY0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_INT_RDY0_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_INT_RDY0_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_INT_RDY0_IE_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_INT_RDY0_IE_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_INT_RDY0_IE_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DAC_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DAC_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DAC_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DAC_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DAC_CR0  [register's definitions]
 *              Offset[0x10]  DAC control register 0 (0x5C080010)
 ******************************************************************************
 */
///@{
#define DAC_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DAC_CR0 */
#define DAC_CR0_DMA_EN_mask_w                       ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define DAC_CR0_DMA_EN_mask_h1                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DAC_CR0_DMA_EN_mask_b3                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DAC_CR0_DMA_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_CR0_DMA_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_CR0_DMA_EN_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_CR0_DMA_EN_enable_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_CR0_DMA_EN_enable_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_CR0_DMA_EN_enable_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DAC_CR0_TRG0_SEL_mask_w                     ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DAC_CR0_TRG0_SEL_mask_h0                    ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DAC_CR0_TRG0_SEL_mask_b1                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DAC_CR0_TRG0_SEL_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DAC_CR0_TRG0_SEL_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DAC_CR0_TRG0_SEL_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DAC_CR0_TRG0_SEL_rising_edge_w              ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define DAC_CR0_TRG0_SEL_rising_edge_h0             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define DAC_CR0_TRG0_SEL_rising_edge_b1             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define DAC_CR0_TRG0_SEL_falling_edge_w             ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define DAC_CR0_TRG0_SEL_falling_edge_h0            ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define DAC_CR0_TRG0_SEL_falling_edge_b1            ((uint8_t )0x20)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define DAC_CR0_TRG0_SEL_dual_edge_w                ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define DAC_CR0_TRG0_SEL_dual_edge_h0               ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define DAC_CR0_TRG0_SEL_dual_edge_b1               ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define DAC_CR0_START0_SEL_mask_w                   ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define DAC_CR0_START0_SEL_mask_h0                  ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define DAC_CR0_START0_SEL_mask_b1                  ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DAC_CR0_START0_SEL_wdat_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):WDAT of 32bit */
#define DAC_CR0_START0_SEL_wdat_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):WDAT of 16bit */
#define DAC_CR0_START0_SEL_wdat_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):WDAT of 8bit */
#define DAC_CR0_START0_SEL_pin_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):PIN of 32bit */
#define DAC_CR0_START0_SEL_pin_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):PIN of 16bit */
#define DAC_CR0_START0_SEL_pin_b1                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):PIN of 8bit */
#define DAC_CR0_START0_SEL_cmp0_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):CMP0 of 32bit */
#define DAC_CR0_START0_SEL_cmp0_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CMP0 of 16bit */
#define DAC_CR0_START0_SEL_cmp0_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):CMP0 of 8bit */
#define DAC_CR0_START0_SEL_tm00_w                   ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):TM00 of 32bit */
#define DAC_CR0_START0_SEL_tm00_h0                  ((uint16_t)0x0300)      /*!< Bit Value =(0x3):TM00 of 16bit */
#define DAC_CR0_START0_SEL_tm00_b1                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):TM00 of 8bit */
#define DAC_CR0_START0_SEL_tm01_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):TM01 of 32bit */
#define DAC_CR0_START0_SEL_tm01_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):TM01 of 16bit */
#define DAC_CR0_START0_SEL_tm01_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):TM01 of 8bit */
#define DAC_CR0_START0_SEL_tm10_w                   ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):TM10 of 32bit */
#define DAC_CR0_START0_SEL_tm10_h0                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):TM10 of 16bit */
#define DAC_CR0_START0_SEL_tm10_b1                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):TM10 of 8bit */
#define DAC_CR0_START0_SEL_itr6_w                   ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):ITR6 of 32bit */
#define DAC_CR0_START0_SEL_itr6_h0                  ((uint16_t)0x0600)      /*!< Bit Value =(0x6):ITR6 of 16bit */
#define DAC_CR0_START0_SEL_itr6_b1                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):ITR6 of 8bit */
#define DAC_CR0_START0_SEL_itr7_w                   ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):ITR7 of 32bit */
#define DAC_CR0_START0_SEL_itr7_h0                  ((uint16_t)0x0700)      /*!< Bit Value =(0x7):ITR7 of 16bit */
#define DAC_CR0_START0_SEL_itr7_b1                  ((uint8_t )0x07)        /*!< Bit Value =(0x7):ITR7 of 8bit */

#define DAC_CR0_RES0_SEL_mask_w                     ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define DAC_CR0_RES0_SEL_mask_h0                    ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define DAC_CR0_RES0_SEL_mask_b0                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define DAC_CR0_RES0_SEL_12_bit_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):12-bit of 32bit */
#define DAC_CR0_RES0_SEL_12_bit_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):12-bit of 16bit */
#define DAC_CR0_RES0_SEL_12_bit_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):12-bit of 8bit */
#define DAC_CR0_RES0_SEL_10_bit_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):10-bit of 32bit */
#define DAC_CR0_RES0_SEL_10_bit_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(0x1):10-bit of 16bit */
#define DAC_CR0_RES0_SEL_10_bit_b0                  ((uint8_t )0x40)        /*!< Bit Value =(0x1):10-bit of 8bit */
#define DAC_CR0_RES0_SEL_8_bit_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):8-bit of 32bit */
#define DAC_CR0_RES0_SEL_8_bit_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(0x2):8-bit of 16bit */
#define DAC_CR0_RES0_SEL_8_bit_b0                   ((uint8_t )0x80)        /*!< Bit Value =(0x2):8-bit of 8bit */

#define DAC_CR0_ALIGN0_SEL_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define DAC_CR0_ALIGN0_SEL_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define DAC_CR0_ALIGN0_SEL_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define DAC_CR0_ALIGN0_SEL_right_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Right of 32bit */
#define DAC_CR0_ALIGN0_SEL_right_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Right of 16bit */
#define DAC_CR0_ALIGN0_SEL_right_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Right of 8bit */
#define DAC_CR0_ALIGN0_SEL_left_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Left of 32bit */
#define DAC_CR0_ALIGN0_SEL_left_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Left of 16bit */
#define DAC_CR0_ALIGN0_SEL_left_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Left of 8bit */

#define DAC_CR0_BUF0_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DAC_CR0_BUF0_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DAC_CR0_BUF0_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DAC_CR0_BUF0_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_CR0_BUF0_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_CR0_BUF0_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_CR0_BUF0_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_CR0_BUF0_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_CR0_BUF0_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DAC_CR0_DA0_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DAC_CR0_DA0_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DAC_CR0_DA0_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DAC_CR0_DA0_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DAC_CR0_DA0_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DAC_CR0_DA0_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DAC_CR0_DA0_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DAC_CR0_DA0_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DAC_CR0_DA0_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DAC_DAT0  [register's definitions]
 *              Offset[0x20]  DAC conversion data register 0 (0x5C080020)
 ******************************************************************************
 */
///@{
#define DAC_DAT0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DAC_DAT0 */
#define DAC_DAT0_DAT0_mask_w                        ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DAC_DAT0_DAT0_mask_h0                       ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DAC_DAT0_DAT0_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define DAC_DAT0_DAT0_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define DAC_DAT0_DAT0_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DAC_DOR0  [register's definitions]
 *              Offset[0x28]  DAC conversion output register 0 (0x5C080028)
 ******************************************************************************
 */
///@{
#define DAC_DOR0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DAC_DOR0 */
#define DAC_DOR0_DOR0_mask_w                        ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DAC_DOR0_DOR0_mask_h0                       ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DAC_DOR0_DOR0_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define DAC_DOR0_DOR0_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define DAC_DOR0_DOR0_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_DAC_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_DAC.h                           */
/*----------------------------------------------------------------------------*/
